<?php
/**
 * @file    /adm/eyoom_admin/core/board/newrecover.php
 */
if (!defined('_EYOOM_IS_ADMIN_')) exit;

$sub_menu = "300910";

check_demo();

auth_check_menu($auth, $sub_menu, 'w');

if ($is_admin != 'super')
    alert('최고관리자만 접근 가능합니다.');

$new_del = preg_replace('/[^0-9]/', '', $_POST['new_del']);

if(!$new_del)
    alert('복구할 최근 게시물 삭제일을 입력해 주십시오.');

// clean the output buffer
ob_end_clean();

function new_recover_sql_query($sql, $error=G5_DISPLAY_SQL_ERROR, $link=null) {
    global $g5;

    if(!$link)
        $link = $g5['connect_db'];

    $sql = trim($sql);
    if(function_exists('mysqli_query') && G5_MYSQLI_USE) {
        if ($error) {
            $result = @mysqli_query($link, $sql) or die("<p>$sql<p>" . mysqli_errno($link) . " : " .  mysqli_error($link) . "<p>error file : {$_SERVER['SCRIPT_NAME']}");
        } else {
            $result = @mysqli_query($link, $sql);
        }
    } else {
        if ($error) {
            $result = @mysql_query($sql, $link) or die("<p>$sql<p>" . mysql_errno() . " : " .  mysql_error() . "<p>error file : {$_SERVER['SCRIPT_NAME']}");
        } else {
            $result = @mysql_query($sql, $link);
        }
    }

    return $result;
}

// 자료가 많을 경우 대비 설정변경
@ini_set('memory_limit', '-1');

// 한 번에 1000개씩 처리
$rows = 1000;

if(!$page) $page = 1;

// 첫페이지
if($page > 1) {
	$cnt = sql_fetch(" select count(*) as cnt from {$g5['board_new_table']} ", false);
	$total_count = $cnt['cnt']; //총 등록수
} else {
	// 새글 DB 전체 지우기
	sql_query(" delete from {$g5['board_new_table']} ");

	// 최근글 삭제일 체크
	$sql_where = "";
	if(isset($_POST['new_del']) && $_POST['new_del'] > 0) {
		$recover_date = date('Y-m-d H:i:s', (G5_SERVER_TIME - $_POST['new_del'] * 86400));
		$sql_where = "where wr_datetime >= '{$recover_date}' ";
	}

	// 보드그룹
	$sql = '';
	$result1 = sql_query(" select bo_table from {$g5['board_table']} where (1) ", false);
	for ($i=0; $row1=sql_fetch_array($result1); $i++) {

		if(!$row1['bo_table']) continue;

		$tmp_write_table = $g5['write_prefix'] . $row1['bo_table'];

		$tmp_sql = $tmp_write_table.'.wr_id, ';
		$tmp_sql .= $tmp_write_table.'.wr_parent, ';
		$tmp_sql .= $tmp_write_table.'.mb_id, ';
		$tmp_sql .= $tmp_write_table.'.wr_datetime';

		$sql .= " select '{$row1['bo_table']}' as bo_table, wr_id, wr_datetime from $tmp_write_table $sql_where UNION ALL ";

	}

	$sql = substr($sql,0,-10);
	$sql = " select * from (".$sql.") as a order by wr_datetime ";
	$result2 = new_recover_sql_query($sql);
	for ($i=0; $row2=sql_fetch_array($result2); $i++) {
		// 새글 등록
		sql_query("insert into {$g5['board_new_table']} (bo_table, wr_id, bn_datetime) values ('{$row2['bo_table']}','{$row2['wr_id']}','{$row2['wr_datetime']}')");
	}

	sql_free_result($result1);
	sql_free_result($result2);

	//게시물 페이지 계산
	$total_count = $i; //총 등록수
}

$total_page  = ceil($total_count / $rows);

if($page <= $total_page) {

	$start_rows = ($page - 1) * $rows;

	$result3 = sql_query(" select bn_id, bo_table, wr_id from {$g5['board_new_table']} limit $start_rows, $rows ", false);
	while($row3=sql_fetch_array($result3)) {

		$start_rows++;

		$bo_table = $row3['bo_table'];
		$bn_id = $row3['bn_id'];
		$wr_id = $row3['wr_id'];

		if(!$bo_table || !$bn_id || !$wr_id) continue;

		$tmp_write_table = $g5['write_prefix'] . $bo_table;

		$row = sql_fetch(" select * from {$tmp_write_table} where wr_id = '{$wr_id}' ", false);

		$as_secret = (strstr($row['wr_option'], 'secret')) ? 1 : 0;

		if($row['wr_is_comment']) { //댓글
			$sql = " update {$g5['board_new_table']}
						set wr_parent = '{$row['wr_parent']}',
							mb_id = '{$row['mb_id']}'
						where bn_id = '{$bn_id}' ";

		} else { //글
			$sql = " update {$g5['board_new_table']}
						set wr_parent = '{$row['wr_parent']}',
							mb_id = '{$row['mb_id']}'
						where bn_id = '{$bn_id}' ";
		}

		sql_query($sql, false);
	}

	sql_free_result($result3);

}

alert('총 '.number_format($total_count).'건의 새글을 복구하였습니다.', G5_ADMIN_URL . '/?dir=board&pid=newrecover&recover='.$total_count);
