<?php
/**
 * Eyoom Admin Skin File
 * @file    ~/theme/basic/skin/board/newrecover.html.php
 */
if (!defined('_EYOOM_IS_ADMIN_')) exit;

add_stylesheet('<link rel="stylesheet" href="'.EYOOM_ADMIN_THEME_URL.'/plugins/jsgrid/jsgrid.min.css" type="text/css" media="screen">',0);
add_stylesheet('<link rel="stylesheet" href="'.EYOOM_ADMIN_THEME_URL.'/plugins/jsgrid/jsgrid-theme.min.css" type="text/css" media="screen">',0);
?>

<div class="admin-visit-delete">
    <form name="fvisitdelete" method="post" action="<?php echo $action_url1; ?>" onsubmit="return form_submit(this);" class="eyoom-form">

    <div class="adm-headline">
        <h3>새글DB 복구</h3>
    </div>

    <div class="cont-text-bg">
        <p class="bg-info font-size-12"><i class="fas fa-info-circle"></i> 기본환경설정의 최근글 삭제일 변경 등에 따른 새글DB 재생성 실행합니다.</p>
    </div>
    <div class="margin-bottom-20"></div>


    <div class="adm-form-wrap margin-bottom-30">
        <header><strong><i class="fas fa-caret-right"></i> 새글DB 복구</strong></header>
        <fieldset>
            <p>
                [주의] 반드시 DB 백업을 먼저 하신 이후 실행해 주시기 바랍니다.<br>
                환경설정 > 기본환경설정 > 최근 게시물 삭제일(<b><?php echo $config['cf_new_del'];?>일</b>) 기준으로 새글DB 자료를 복구합니다.<br>
            </p>
        </fieldset>
    </div>

    <div class="adm-table-form-wrap adm-search-box">
        <div class="table-list-eb">
            <?php if (!G5_IS_MOBILE) { ?>
            <div class="table-responsive">
            <?php } ?>
            <table class="table">
                <tbody>
                    <tr>
                        <th class="table-form-th">
                            <label class="label">새글</label>
                        </th>
                        <td>
                            <?php echo $total_count; ?>건
                        </td>
                    <?php if (G5_IS_MOBILE) { ?>
                    </tr>
                    <tr>
                    <?php } ?>
                        <th class="table-form-th border-left-th">
                            <label for="method" class="label">복구</label>
                        </th>
                        <td>
                            <?php echo number_format($recover); ?>건
                        </td>
                    </tr>
                    <tr>
                        <td colspan="4">
                            <div class="inline-group">
								<span>최근 게시물 삭제일</span>
								<span>
									<label class="input"><input type="text" name="new_del" id="new_del" value="<?php echo (int) $config['cf_new_del']; ?>" class="text-right" style="width:60px;"></label>
								</span>
								<span>일 기준으로 새글DB 자료를 복구</span>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <?php if (!G5_IS_MOBILE) { ?>
            </div>
            <?php } ?>
        </div>
    </div>

	<?php if($recover){ ?>
	<div class="margin-bottom-20"></div>
    <div class="margin-bottom-15">
        <strong class="font-size-14 color-red">
            <span class="fa-stack fa-lg">
                <i class="fas fa-circle fa-stack-2x"></i>
                <i class="fas fa-check fa-stack-1x fa-inverse"></i>
            </span>
            <span class="color-black">새글 <span class="color-red"><?php echo $recover; ?></span> 건 복구 완료됐습니다.</span>
        </strong>
    </div>
	<?php } ?>

    <?php echo $frm_submit; ?>

    </form>
</div>

<script>
function form_submit(f) {

	var new_del = $("#new_del").val();

    if(!new_del) {
        alert("복구할 최근 게시물 삭제일을 입력해 주십시오.");
        return false;
    }

    var msg = new_del+"일";
    msg += " 기준으로 새글DB 자료를 복구하시겠습니까?";

    return confirm(msg);
}
</script>