<?php
  if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
  include_once(G5_LIB_PATH.'/thumbnail.lib.php');

  // fontawesome CSS
  add_stylesheet('<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />', 9);

  //스킨 CSS,JS 인클루드
  //add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
  add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/css/style.css?'.time().'" />', 11);
  if(G5_IS_MOBILE) {
    add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/css/style_mobile.css?'.time().'" media="all and (max-width: 768px)" />', 12);
  }

  //썸네일 사이즈 등 설정
  if(!$thumb_width) $thumb_width = 132;
  if(!$thumb_height) $thumb_height = 90;
  if(G5_IS_MOBILE){
    //
  }
  $list_count = (is_array($list) && $list) ? count($list) : 0;
?>


<div class="xns_gnuboard_latest_naver_webzine_style1">
  <div class="header_title">
    <a href="<?php echo get_pretty_url($bo_table); ?>">
      <div class="title">
        <i class="far fa-clone"></i>
        <?php echo $bo_subject ?>
        <?php echo $GLOBALS['skin_subtitle'] ?>
      </div>
      <span class="icon_more">
        <i class="fas fa-chevron-right"></i>
      </span>
    </a>
  </div>

  <div class="webzine_list">
    <ul>
      <?php for ($i=0; $i<$list_count; $i++) { ?>
        <?php
          $wr_href = get_pretty_url($bo_table, $list[$i]['wr_id']);
          $thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);
    	    //유튜브 ID 설정
    	    if($list[$i]['wr_link1']){
            $youtube_url = $list[$i]['wr_link1'];
            $youtube_id = str_replace('http://youtu.be/','',$youtube_url);
            $youtube_id = str_replace('https://youtu.be/','',$youtube_id);
            $youtube_thumb = "https://img.youtube.com/vi/".$youtube_id."/hqdefault.jpg";
    	    }
        ?>
        <?php if($i==0) { ?>
        <li>
          <a href="<?php echo $wr_href ?>">
            <div class="thumbnail_area">
              <?php if(isset($thumb['src']) && $thumb['src']) { ?>
                <img class="thumb" src="<?php echo $thumb['src'] ?>" />
              <?php } else if(isset($youtube_thumb)) { ?>
                <img class="thumb" src="<?php echo $youtube_thumb ?>" />
              <?php } ?>
            </div>
            <div class="content_area"<?php if($thumb['src'] || $youtube_thumb) { ?> style="margin-left:142px;"<?php } ?>>
              <div class="title">
  	  		      <?php if($list[$i]['icon_new']) { ?>
	  	  	        <span class="icon_new">N</span>
		  	        <?php } ?>
                <strong>
                  <?php echo $list[$i]['subject']; ?>
                </strong>
              </div>
              <div class="summary">
                <?php
              		//본문내용 텍스트만 가져오기
            	  	$wr_summary = strip_tags($list[$i]['wr_content']);
  	              $wr_summary = cut_str($wr_summary,300);
  	              echo $wr_summary;
 		            ?>
              </div>
              <div class="user_area">
                <?php echo $list[$i]['name'] ?>
                <?php if($list[$i]['wr_comment']) { ?>
                  <span class="madi">|</span>
                  <span class="comment">
                    <i class="far fa-comment-dots"></i>
                    <?php echo $list[$i]['wr_comment']; ?>
                  </span>
                  <!--span class="date">
                    <?php
                      $wr_datetime_array = explode(' ',$list[$i]['wr_datetime']);
                    ?>
                    <i class="far fa-clock"></i>
                    <?php echo $wr_datetime_array[0] ?>
                  </span-->
                <?php } ?>
              </div>
            </div>
          </a>
        </li>
        <?php } ?>
      <?php } ?>
    </ul>

    <ul class="docu_list">
      <?php for ($i=0; $i<$list_count; $i++) { ?>
        <?php
          $wr_href = get_pretty_url($bo_table, $list[$i]['wr_id']);
          $thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);
        ?>
        <?php if($i>0) { ?>
        <li>
          <a href="<?php echo $wr_href ?>">
            <div class="title">
	  		      <?php if($list[$i]['icon_new']) { ?>
   	  	        <span class="icon_new">N</span>
	  	        <?php } ?>
              <strong><?php echo $list[$i]['subject']; ?></strong>
              <?php echo $list[$i]['name'] ?>
              <?php if($list[$i]['wr_comment']) { ?>
                <span class="madi">|</span>
                <span class="comment">
                  <i class="far fa-comment-dots"></i>
                  <?php echo $list[$i]['wr_comment']; ?>
                </span>
              <?php } ?>
            </div>
          </a>
        </li>
        <?php } ?>
      <?php } ?>
    </ul>
  </div>
</div>
