
<style>
#containermap {width:100%;overflow:hidden;height:300px;position:relative;}
#btnRoadview,  #btnMap {position:absolute;top:0;left:0;padding:7px 12px;font-size:14px;border: 1px solid #dbdbdb;background-color: #fff;border-radius: 2px;box-shadow: 0 1px 1px rgba(0,0,0,.04);z-index:1;cursor:pointer;}
#btnRoadview:hover,  #btnMap:hover{background-color: #fcfcfc;border: 1px solid #c1c1c1;}
#containermap.view_map #mapWrapper {z-index: 10;}
#containermap.view_map #btnMap {display: none;}
#containermap.view_roadview #mapWrapper {z-index: 0;}
#containermap.view_roadview #btnRoadview {display: none;}
#rvWrapper {width:100%;height:300px;position:absolute;top:5px;left:0;}

.map_wrap {width:100%;height:300px;position:relative;}
.map_wrap .map_div {width:100%;height:100%;}
.map_wrap .toggle_div {width:100%;height:300px;position:absolute;top:0;left:0;}

@media (max-width:1200px) {
    #containermap {width:100%;overflow:hidden;height:250px;position:relative;}
    #rvWrapper {width:100%;height:250px;position:absolute;top:5px;left:0;}
    .map_wrap {width:100%;height:250px;position:relative;}

}

@media (max-width:768px) {
    #containermap {width:100%;overflow:hidden;height:200px;position:relative;}
    #rvWrapper {width:100%;height:200px;position:absolute;top:5px;left:0;}
    .map_wrap {width:100%;height:200px;position:relative;}

}
</style>


<div id="containermap" class="view_map">
    <div id="mapWrapper" class="map_wrap">
        <div id="map" class="map_div"></div> <!-- 지도를 표시할 div 입니다 -->
        <input type="button" id="btnRoadview" onclick="toggleMap(false)" title="로드뷰 보기" value="로드뷰">
    </div>
    <div id="rvWrapper">
        <div id="roadview" style="height:100%"></div> <!-- 로드뷰를 표시할 div 입니다 -->
        <input type="button" id="btnMap" onclick="toggleMap(true)" title="지도 보기" value="지도">
    </div>
</div>

<!-- <script type="text/javascript" src="//dapi.kakao.com/v2/maps/sdk.js?appkey=JavaScript 키를 넣어주세요&libraries"></script> -->
<script type="text/javascript" src="//dapi.kakao.com/v2/maps/sdk.js?appkey=JavaScript 키를 넣어주세요&libraries"></script>
<script>
var container = document.getElementById('containermap'), // 지도와 로드뷰를 감싸고 있는 div 입니다
    mapWrapper = document.getElementById('mapWrapper'), // 지도를 감싸고 있는 div 입니다
    btnRoadview = document.getElementById('btnRoadview'), // 지도 위의 로드뷰 버튼, 클릭하면 지도는 감춰지고 로드뷰가 보입니다 
    btnMap = document.getElementById('btnMap'), // 로드뷰 위의 지도 버튼, 클릭하면 로드뷰는 감춰지고 지도가 보입니다 
    rvContainer = document.getElementById('roadview'), // 로드뷰를 표시할 div 입니다
    mapContainer = document.getElementById('map'); // 지도를 표시할 div 입니다

// 지도와 로드뷰 위에 마커로 표시할 특정 장소의 좌표입니다 
var placePosition = new kakao.maps.LatLng(<?php echo $view['wr_14']; ?>, <?php echo $view['wr_15']; ?>);

// 지도 옵션입니다 
var mapOption = {
    center: placePosition, // 지도의 중심좌표 
    level: 3 // 지도의 확대 레벨
};

// 지도를 표시할 div와 지도 옵션으로 지도를 생성합니다
var map = new kakao.maps.Map(mapContainer, mapOption);

//--------------------------------------------------------------------------------------------
// 일반 지도와 스카이뷰로 지도 타입을 전환할 수 있는 지도타입 컨트롤을 생성합니다
var mapTypeControl = new daum.maps.MapTypeControl();
// daum.maps.ControlPosition은 컨트롤이 표시될 위치를 정의하는데 TOPRIGHT는 오른쪽 위를 의미합니다
map.addControl(mapTypeControl, daum.maps.ControlPosition.TOPRIGHT);
// 지도 확대 축소를 제어할 수 있는  줌 컨트롤을 생성합니다
var zoomControl = new daum.maps.ZoomControl();
map.addControl(zoomControl, daum.maps.ControlPosition.RIGHT);
//----------------------------------------------------------------------------------------

// 로드뷰 객체를 생성합니다 
var roadview = new kakao.maps.Roadview(rvContainer);

var roadviewClient = new kakao.maps.RoadviewClient(); //좌표로부터 로드뷰 파노ID를 가져올 로드뷰 helper객체
var position = new kakao.maps.LatLng(<?php echo $view['wr_14']; ?>, <?php echo $view['wr_15']; ?>);

// 특정 위치의 좌표와 가까운 로드뷰의 panoId를 추출하여 로드뷰를 띄운다.
roadviewClient.getNearestPanoId(position, 50, function(panoId) {
    roadview.setPanoId(panoId, position); //panoId와 중심좌표를 통해 로드뷰 실행
});


// 로드뷰의 위치를 특정 장소를 포함하는 파노라마 ID로 설정합니다
// 로드뷰의 파노라마 ID는 Wizard를 사용하면 쉽게 얻을수 있습니다 
//roadview.setPanoId(1023434522, placePosition);

// 특정 장소가 잘보이도록 로드뷰의 적절한 시점(ViewPoint)을 설정합니다 
// Wizard를 사용하면 적절한 로드뷰 시점(ViewPoint)값을 쉽게 확인할 수 있습니다
roadview.setViewpoint({
    pan: 321,
    tilt: 0,
    zoom: 0
});

// // 지도 중심을 표시할 마커를 생성하고 특정 장소 위에 표시합니다  - 일반마커
// var mapMarker = new kakao.maps.Marker({
//     position: placePosition,
//     map: map
// });

// 새로운 마커 사용----------------------------------------------------------------------------------------------------------------
var imageSrc = '<?php echo $board_skin_url;?>/img/marker_red.png', // 마커이미지의 주소입니다    
    imageSize = new kakao.maps.Size(64, 69), // 마커이미지의 크기입니다
    imageOption = {offset: new kakao.maps.Point(27, 69)}; // 마커이미지의 옵션입니다. 마커의 좌표와 일치시킬 이미지 안에서의 좌표를 설정합니다.
      
// 마커의 이미지정보를 가지고 있는 마커이미지를 생성합니다
var markerImage = new kakao.maps.MarkerImage(imageSrc, imageSize, imageOption),
    markerPosition = new kakao.maps.LatLng(<?php echo $view['wr_14']; ?>, <?php echo $view['wr_15']; ?>); // 마커가 표시될 위치입니다

// 마커를 생성합니다
var marker = new kakao.maps.Marker({
    position: markerPosition, 
    image: markerImage // 마커이미지 설정 
});

// 마커가 지도 위에 표시되도록 설정합니다
marker.setMap(map);  

// 새로운 마커 사용 끝----------------------------------------------------------------------------------------------------------------

// 로드뷰 초기화가 완료되면 
kakao.maps.event.addListener(roadview, 'init', function() {

    // 로드뷰에 특정 장소를 표시할 마커를 생성하고 로드뷰 위에 표시합니다 
    var rvMarker = new kakao.maps.Marker({
        position: placePosition,
        map: roadview
    });
});

// 지도와 로드뷰를 감싸고 있는 div의 class를 변경하여 지도를 숨기거나 보이게 하는 함수입니다 
function toggleMap(active) {
    if (active) {

        // 지도가 보이도록 지도와 로드뷰를 감싸고 있는 div의 class를 변경합니다
        container.className = "view_map"
    } else {

        // 지도가 숨겨지도록 지도와 로드뷰를 감싸고 있는 div의 class를 변경합니다
        container.className = "view_roadview"   
    }
}
</script>
