<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/style.css">', 0);
$thumb_width = 210;
$thumb_height = 210;
$list_count = (is_array($list) && $list) ? count($list) : 0;

// 제목줄수 설정
$subject_line = 1;
$subject_height = 20 * $subject_line + 6;

// 글내용길이 설정
$content_txt = 200;

// 배경색상 랜덤
$btn_bg = array("bg-red", "bg-orangered", "bg-green", "bg-blue", "bg-purple", "bg-yellow", "bg-navy");
?>

<div class="pic_challenge_lt">
	<h2 class="lat_title"><a href="<?php echo get_pretty_url($bo_table); ?>"><?php echo $bo_subject ?></a></h2>
    <div class="main">
        <ul class="cards">
			<?php
			for ($i=0; $i<$list_count; $i++) {
			$thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

			if($thumb['src']) {
				$img = $thumb['src'];
			} else {
				$img = G5_IMG_URL.'/no_img.png';
				$thumb['alt'] = '이미지가 없습니다.';
			}
			$img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
			if($list[$i]['ca_name']){
				$ca_wr_href = get_pretty_url($bo_table, '','sca='.urlencode($list[$i]['ca_name']));
			}

			$wr_href = get_pretty_url($bo_table, $list[$i]['wr_id']);
			?>
            <li class="cards_item">

                <div class="card">
                    <div class="card_image">
						<?php if($list[$i]['ca_name']){ ?>
						<a href="<?php echo $ca_wr_href; ?>"><span class="cate <?php echo $btn_bg[rand(0, 6)];?>"><?php echo $list[$i]['ca_name'];?></span></a>
						<?php } ?>
						<a href="<?php echo $wr_href; ?>"><?php echo run_replace('thumb_image_tag', $img_content, $thumb); ?></a>
						<?php if($list[$i]['icon_hot']){ ?>
                        <span class="card_hot bg_red"><i class="fa fa-heart"></i></span>
						<?php } ?>
                    </div>
                    <div class="card_content">
                        <h2 class="card_title" style="height:<?php echo $subject_height;?>px;">
							<a href="<?php echo $wr_href; ?>"><?php echo $list[$i]['subject'];?></a>
							<?php if ($list[$i]['icon_new']) echo "<span class=\"new_icon\">N<span class=\"sound_only\">새글</span></span>"; ?>
							<?php if ($list[$i]['icon_hot']) echo "<span class=\"hot_icon\">H<span class=\"sound_only\">인기글</span></span>"; ?>
						</h2>
                        <div class="card_text">
                            <p><?php echo cut_str(strip_tags($list[$i]['wr_content']), $content_txt);?></p>
                        </div>
                    </div>
                </div>

            </li>
			<?php } ?>
			<?php if ($list_count == 0) { //게시물이 없을 때  ?>
			<li class="cards_item">

				게시물이 없습니다.

			</li>
			<?php } ?>
        </ul>
    </div>
	<a href="<?php echo get_pretty_url($bo_table); ?>" class="lt_more"><span class="sound_only"><?php echo $bo_subject ?></span>더보기</a>
</div>









