<?php
$sub_menu = "910100";
include_once('./_common.php');

auth_check($auth[$sub_menu], 'r');

$g5['title'] = "DB 관리";
include_once ('./admin.head.php');

//설정 관련 테이블이 없을 경우 생성
if(!sql_query("DESC {$g5['adm_backup_table']}",false)){
	sql_query("CREATE TABLE `{$g5['adm_backup_table']}` (
	`no` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
	`name` VARCHAR( 50 ) NOT NULL ,
	`type` VARCHAR( 11 ) NOT NULL ,
	`tbl` TEXT NOT NULL ,
	`restore_date` INT( 11 ) NOT NULL ,
	`backup_date` INT( 11 ) NOT NULL ,
	PRIMARY KEY ( `no` ) 
	)"); 
}

$tables=array();

$sub_btn_group=array(
	"<div class='sb-btn' data-title='백업하기' data-target='.btn-backup'><i class='fa fa-cubes'></i></div>",
	"<div class='sb-btn' data-title='선택삭제' data-target='.btn-select-del'><i class='fa fa-share-square-o'></i></div>"
);
?>
<link rel="stylesheet" type='text/css' href="<?=G5_ADMIN_URL?>/css/bootstrap/css/bootstrap.css">
<link rel="stylesheet" type='text/css' href="<?=G5_ADMIN_URL?>/css/style.css">
<div class='conn-box'>
	<div class="panel panel-default">
		<div class="panel-heading"><i class='fa fa-star'></i> DB 백업</div>
		<div class="panel-body">
			<div class="alert alert-info" role="alert">
				현재의 데이터베이스를 백업합니다.<br />
				관리자에서 본 기능을 사용하기 위해서는 <code>PHP Data Objects (PDO)</code> 사용이 가능해야 합니다.<br />
				백업이 진행되지 않을 시 서버 관리자에게 문의 하시기 바랍니다.<br />
				백업시 SQL 문서로 저장되며, 저장된 파일은 다운로드하여 별도로 관리하시고 서버내에서는 삭제하시는것을 권장 합니다.<br />
				백업 파일은 <?=G5_BACKUP_URL?>에 저장됩니다.
			</div>

			<form name="backup_form" method="post" id="backup_form" action="./db_backup_update.php" onsubmit="return backup_form_submit();" class='form-horizontal' role='form'>
			<input type='hidden' name='mode' id='mode' value='db_backup'>
			<input type="hidden" name="token" value="" id="token">

				<div class='form-group'>
					<label class="col-sm-2 control-label">백업 할 TABLE</label>
					<div class="col-sm-4">
					<div class='input-group'>
					<select name='select_tbl' class='form-control input-sm'>
					<option value='all'>전체 테이블</option>
					<?
					$res = sql_query('SHOW TABLES');
					while($row = sql_fetch_array($res)){
						$key=array_keys($row);
						$key=$key[0];
						echo "<option value='{$row[$key]}'>{$row[$key]}</option>";
					}
					?>
					</select>
					<span class='input-group-btn'>
						<button type='button' class='btn btn-sm btn-primary btn-add'>추가</button>
					</span>
					</div>
					</div>
				</div>

				<div class='form-group'>
					<label class="col-sm-2 control-label">선택 TABLE</label>
					<div class="col-sm-4">
						<div class='select_tbl_list'></div>
					</div>
				</div>

				<div class='form-group'>
					<label class="col-sm-2 control-label">백업파일명</label>
					<div class="col-sm-4">
						<div class='input-group'>
							<input type="text" name="bk_file_name" id="bk_file_name" class="form-control input-sm">
							<span class='input-group-addon'>.sql</span>
						</div>
					</div>
				</div>

				<div class='btn-box resize-btn'>
					<button type='submit' class='btn-sm btn btn-success btn-backup'>백업 하기</button>
				</div>
			</form>
		</div>
	</div>

	<div class="panel panel-default">
		<div class="panel-heading"><i class='fa fa-star'></i> DB 백업 파일 관리</div>
		<div class="panel-body">
			<form name="backup_list_form" method="post" id="backup_list_form" action="./db_backup_list.php" class='form-horizontal' role='form'>
			<input type='hidden' name='mode' id='mode' value='db_list'>
			<input type='hidden' name='page' id='page' value='1'>
			<input type='hidden' name='del_idx' id='del_idx' value=''>
			<div class='backup-list'></div>
			</form>
		</div>
	</div>
</div>



<script type='text/javascript'>
var form=$("#backup_form");
var lform=$("#backup_list_form");

$(document).ready(function(){
	get_data_list();

	$(".btn-add").on("click",function(){
		var add_tbl=true;
		var data=form.find("select[name='select_tbl']").val();
		var tbl_list=form.find("input[name='chk_tbl[]']");

		if(tbl_list.length==0) $(".select_tbl_list").html("");
		
		if(data=='all'){
			var html="<div class='chk-tbl all-tbl'>";
			html+="전체 테이블";
			html+="<a href='#delete_item' class='del-tbl'><i class='fa fa-times'></i></a>";
			html+="</div>";

			if(tbl_list.length>0){
				if(confirm("선택하신 테이블이 존재합니다.\n전체 테이블을 선택하시면 추가한 테이블 목록이 초기화 됩니다.\n전체 테이블로 선택하시겠습니까?")){
					$(".select_tbl_list").html(html);
				}
			}else{
				$(".select_tbl_list").html(html);
			}
		}else{
			$(".select_tbl_list").find(".all-tbl").remove();

			$.each(tbl_list,function(){
				var chk_tbl=$(this).val();

				if(data==chk_tbl){
					add_tbl=false;
					return false;
				}
			});

			if(add_tbl){
				var html="<div class='chk-tbl'>";
				html+="<input type='hidden' name='chk_tbl[]' value='"+data+"'>";
				html+=data;
				html+="<a href='#delete_item' class='del-tbl'><i class='fa fa-times'></i></a>";
				html+="</div>";

				$(".select_tbl_list").append(html);
			}
		}
	});

	$(document).on("click","#chkall",function(){
		if($(this).is(":checked")){
			$("input[name='chk[]']").prop("checked",true);
		}else{
			$("input[name='chk[]']").prop("checked",false);
		}
	});

	$(document).on("click",".db-list-page .pagination-board li a",function(){
		if($(this).data("page")){
			lform.find("input[name='page']").val($(this).data("page"));

			get_data_list();
		}
	});

	$(document).on("click",".btn-chk-del",function(){
		if (!is_checked("chk[]")) {
			alert("삭제 하실 항목을 하나 이상 선택하세요.");
			return false;
		}

		if(!confirm("선택한 자료를 정말 삭제하시겠습니까?")) {
			return false;
		}

		data_delete('list');
	});

	$(document).on("click",".btn-delete",function(){
		var idx=$(this).data("idx");

		if(confirm("이 파일을 삭제하시겠습니까?")){
			data_delete(idx);
		}
	});
});

function get_data_list(m){
	lform.find("#mode").val("db_list");

	if(m=='reset'){
		lform.find("#page").val(1);
	}

	$.ajax({
		type:"POST",
		dataType:"HTML",
		url:lform.attr("action"),
		data:lform.serialize(),
		success:function(data){
			$(".backup-list").html(data);
			$(".backup-list").find(".footable").footable();
		}
	});
}

function backup_form_submit(){
	var tbl_list=form.find(".chk-tbl");
	var msg='';
	var filename=form.find("#bk_file_name").val();

	if(tbl_list.length==0){
		alert("선택된 테이블이 없습니다. 전체 백업을 원하시면 [전체 테이블]을 추가해 주세요.");
		return false;
	}

	if(!trim(filename)){
		msg+="백업파일명이 비어있습니다. 자동으로 백업파일명을 설정하여 진행됩니다.\n";
	}

	if(confirm(msg+"FTP 서버의 용량이 부족하면 백업이 되지 않을 수 있습니다.\n백업을 진행하시겠습니까?")){
		$(".btn-backup").attr("disabled",true);
		$(".btn-backup").html("<i class='fa fa-cog fa-spin fa-fw'></i> 백업 중...");

		$.ajax({
			type:"POST",
			dataType:"HTML",
			url:form.attr("action"),
			data:form.serialize(),
			success:function(data){
				var result=$.parseJSON(data);

				$(".btn-backup").attr("disabled",false);

				if(result.status=='500'){
					$(".btn-backup").html("<i class='fa fa-times'></i> 백업 실패");

					$(".select_tbl_list").html("<div class='bk-msg'>백업에 실패하였습니다.</div>");

					alert(result.data);
				}else{
					var filename=result.data;

					$(".btn-backup").html("<i class='fa fa-check'></i> 백업 완료");

					$(".select_tbl_list").html("<div class='bk-msg'>백업이 완료 되었습니다. (백업 파일명 : "+filename+")</div>");
				}


				get_data_list("reset");

				setTimeout(function(){
					$(".btn-backup").html("백업 하기");
				},500);

				form.find("select[name='select_tbl']").find('option:first').attr('selected', 'selected');
			}
		});
	}

	return false;
}

function data_delete(del_idx){
	lform.find("#mode").val("db_del");

	lform.find("#del_idx").val(del_idx);

	$.ajax({
		type:"POST",
		dataType:"HTML",
		url:lform.attr("action"),
		data:lform.serialize(),
		success:function(data){
			var result=$.parseJSON(data);

			if(result.status=='500'){
				alert(result.data);
			}else{
				get_data_list();
			}
		}
	});
}
</script>

<?php
include_once ('./admin.tail.php');
?>

