var visit_types='hour';
var chart_visit_valueAxes=[{
	"axisAlpha": 0,
	"position": "left"
}];
var chart_visit_startDuration=1;
var chart_visit_graphs=[{
	"alphaField": "alpha",
	"balloonText": "",
	"fillAlphas": 1,
	"title": "",
	"type": "column",
	"valueField": "to",
	"dashLengthField": "dashLengthColumn"
 },{
	"id": "graph2",
	"balloonText": "",
	"bullet": "round",
	"lineThickness": 3,
	"bulletSize": 7,
	"bulletBorderAlpha": 1,
	"bulletColor": "#FFFFFF",
	"useLineColorForBulletBorder": true,
	"bulletBorderThickness": 3,
	"fillAlphas": 0,
	"lineAlpha": 1,
	"title": "",
	"valueField": "fr",
	"dashLengthField": "dashLengthLine"
}];

var chart_visit_opstions={
	"type": "serial",
	"addClassNames": true,
	"theme":"custom2",
	"autoMargins": false,
	"marginLeft": 50,
	"marginRight": 0,
	"marginTop": 10,
	"marginBottom": 26,
	"balloon": {
		"adjustBorderColor": false,
		"horizontalPadding": 10,
		"verticalPadding": 8,
		"color": "#ffffff"
	},
	"dataProvider":[],
	"valueAxes":chart_visit_valueAxes,
	"graphs":chart_visit_graphs,
	"startDuration":0.5,
	"categoryField":"kind",
	"categoryAxis":{
		"gridPosition":"start",
		"axisAlpha":0,
		"tickLength":0
	},
	"export":{
		"enabled":false
	}
};

//방문자 집계 차트 실행
var chart_visit=AmCharts.makeChart("chart-visit",chart_visit_opstions);

//브라우저별 동향 관련 차트 옵션
var chart_browser_options={
	"type":"pie",
	"theme":"custom2",
	"pullOutOnlyOne":true,
	"labelsEnabled":false,
	"addClassNames":true,
	"startDuration":0.5,
	"startEffect":"easeOutSine",
	"pullOutEffect":"easeOutSine",
	"pullOutDuration":"0.5",
	"radius":"40%",
	"legend":{
		"position":"bottom",
		"marginRight":0,
		"autoMargins":false
	},
	"innerRadius":"30%",
	"dataProvider":[],
	"valueField":"data",
	"titleField":"title"
};

var chart_browser=AmCharts.makeChart("chart-browser",chart_browser_options);

//글/댓글 현황 관련 차트 옵션
var chart_new_valueAxes=[{
	"axisAlpha": 0,
	"position": "left"
}];
var chart_new_startDuration=1;
var chart_new_graphs=[{
	"alphaField": "alpha",
	"balloonText": "",
	"fillAlphas": 1,
	"title": "",
	"type": "column",
	"valueField": "to",
	"dashLengthField": "dashLengthColumn"
 },{
	"id": "graph2",
	"balloonText": "",
	"bullet": "round",
	"lineThickness": 3,
	"bulletSize": 7,
	"bulletBorderAlpha": 1,
	"bulletColor": "#FFFFFF",
	"useLineColorForBulletBorder": true,
	"bulletBorderThickness": 3,
	"fillAlphas": 0,
	"lineAlpha": 1,
	"title": "",
	"valueField": "fr",
	"dashLengthField": "dashLengthLine"
}];

var chart_new_options={
	"type": "serial",
	"addClassNames": true,
	"theme":"custom",
	"autoMargins": false,
	"marginLeft": 30,
	"marginRight": 8,
	"marginTop": 10,
	"marginBottom": 26,
	"balloon": {
		"adjustBorderColor": false,
		"horizontalPadding": 10,
		"verticalPadding": 8,
		"color": "#ffffff"
	},
	"dataProvider":[],
	"valueAxes":chart_new_valueAxes,
	"graphs":chart_new_graphs,
	"startDuration":0.5,
	"categoryField":"kind",
	"categoryAxis":{
		"gridPosition":"start",
		"axisAlpha":0,
		"tickLength":0
	},
	"export":{
		"enabled":false
	}
};

var chart_new=AmCharts.makeChart("chart-new",chart_new_options);

//메인 - 방문자 집계
function chart_visit_view(){
	$.ajax({
		type:"POST",
		dataType:"HTML",
		timeout:10000,
		url:'./chart.ajax.php',
		data:'mode=visit&types='+visit_types,
		beforeSend:function(){
			var ajax_loader="<div class='ajax_loader'>";
			ajax_loader+="<div class='loader'><i class='fa fa-spinner fa-pulse fa-5x fa-fw'></i></div>";
			ajax_loader+="</div>";

			$(".chart-visit").append(ajax_loader);
		},
		success:function(data){
			$(".chart-visit").find(".ajax_loader").remove();

			var result=$.parseJSON(data);
			var data_provider=[];

			for(i=0; i<result.to_data.kind.length; i++){
				if(result.fr_data){
					data_provider.push({
						"kind":result.to_data.kind[i],
						"to":result.to_data.count[i],
						"fr":result.fr_data.count[i]
					});
				}else{
					data_provider.push({
						"kind":result.to_data.kind[i],
						"to":result.to_data.count[i]
					});
				}
			}

			if(visit_types=='hour'){
				var fr_text="<span style='font-size:12px;'>";
				fr_text+="[[title]] [[category]]시<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				fr_text+="</span>";

				var to_text="<span style='font-size:12px;'>";
				to_text+="[[title]] [[category]]시<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				to_text+="</span>";

				
				chart_visit.graphs[0].title="오늘";
				chart_visit.graphs[1].title="어제";
			}else if(visit_types=='week'){
				var fr_text="<span style='font-size:12px;'>";
				fr_text+="[[title]] [[category]]요일<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				fr_text+="</span>";

				var to_text="<span style='font-size:12px;'>";
				to_text+="[[title]] [[category]]요일<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				to_text+="</span>";

				chart_visit.graphs[0].title="이번주";
				chart_visit.graphs[1].title="지난주";
			}else if(visit_types=='day'){
				var fr_text="<span style='font-size:12px;'>";
				fr_text+="[[title]] [[category]]일<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				fr_text+="</span>";

				var to_text="<span style='font-size:12px;'>";
				to_text+="[[title]] [[category]]일<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				to_text+="</span>";

				chart_visit.graphs[0].title="이달";
				chart_visit.graphs[1].title="지난달";
			}else if(visit_types=='month'){
				var fr_text="<span style='font-size:12px;'>";
				fr_text+="[[title]] [[category]]월<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				fr_text+="</span>";

				var to_text="<span style='font-size:12px;'>";
				to_text+="[[title]] [[category]]월<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				to_text+="</span>";

				chart_visit.graphs[0].title="올해";
				chart_visit.graphs[1].title="지난해";
			}else if(visit_types=='year'){
				var fr_text="";

				var to_text="<span style='font-size:12px;'>";
				to_text+="[[category]]년<br><span style='font-size:20px;'>[[value]]</span> [[additional]]명";
				to_text+="</span>";

				chart_visit.graphs[0].title="";
			}

			chart_visit.graphs[0].balloonText=to_text;
			chart_visit.graphs[1].balloonText=fr_text;
			chart_visit.processDelay=5000;
			chart_visit.dataProvider=data_provider;
			chart_visit.validateData();
			chart_visit.animateAgain();
		}
	});
}

//메인 - 브라우저별 동향
function chart_browser_view(){
	$.ajax({
		type:"POST",
		dataType:"HTML",
		timeout:10000,
		url:'./chart.ajax.php',
		data:'mode=browser',
		beforeSend:function(){
			var ajax_loader="<div class='ajax_loader'>";
			ajax_loader+="<div class='loader'><i class='fa fa-spinner fa-pulse fa-5x fa-fw'></i></div>";
			ajax_loader+="</div>";

			$(".chart-browser").append(ajax_loader);
		},
		success:function(data){
			$(".chart-browser").find(".ajax_loader").remove();

			var result=$.parseJSON(data);
			var data_provider=[];

			for(i=0; i<result.data.title.length; i++){
				data_provider.push({
					"title":result.data.title[i],
					"data":result.data.rate[i]
				});
			}

			chart_browser.dataProvider=data_provider;
			chart_browser.validateData();
			//chart_browser.animateAgain();
		}
	});
}

//글-댓글 현황 그래프
function chart_new_view(){
	var bo_table=$("select[name='bo_table']").val();
	var period=encodeURIComponent($("select[name='period']").val());

	$.ajax({
		type:"POST",
		dataType:"HTML",
		timeout:10000,
		url:'./chart.ajax.php',
		data:'mode=new&bo_table='+bo_table+'&period='+period,
		beforeSend:function(){
			var ajax_loader="<div class='ajax_loader'>";
			ajax_loader+="<div class='loader'><i class='fa fa-spinner fa-pulse fa-5x fa-fw'></i></div>";
			ajax_loader+="</div>";

			$(".chart-new").append(ajax_loader);
		},
		success:function(data){
			$(".chart-new").find(".ajax_loader").remove();

			var result=$.parseJSON(data);
			var data_provider=[];
			
			if(result.to_data.kind.length){
				for(i=0; i<result.to_data.kind.length; i++){
					data_provider.push({
						"kind":result.to_data.kind[i],
						"fr":result.to_data.count[i],
						"to":result.fr_data.count[i]
					});
				}

				var fr_text="<span style='font-size:12px;'>";
				fr_text+="[[title]] [[category]]<br><span style='font-size:20px;'>[[value]]</span> [[additional]]건";
				fr_text+="</span>";

				var to_text="<span style='font-size:12px;'>";
				to_text+="[[title]] [[category]]<br><span style='font-size:20px;'>[[value]]</span> [[additional]]건";
				to_text+="</span>";

				chart_new.graphs[0].title="글";
				chart_new.graphs[1].title="댓글";

				chart_new.graphs[0].balloonText=to_text;
				chart_new.graphs[1].balloonText=fr_text;
				chart_new.processDelay=5000;
				chart_new.dataProvider=data_provider;
				chart_new.validateData();
				chart_new.animateAgain();
			}else{
				chart_new.dataProvider=[];
				chart_new.validateData();

				$("#chart-new").html("<div class='ajax_loader'>표시할 데이터가 없습니다.</div>");
			}
		}
	});
}

