<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/style.css">', 0);
$thumb_width = 210;
$thumb_height = 150;
$list_count = (is_array($list) && $list) ? count($list) : 0;

$is_random = false;
$quote_inserted = false;

$msg = array();
$msg = [
	'이별의 아픔 속에서만 사랑의 깊이를 알게 된다. - 조지 앨리엇',
	'잘 있거라! 우리가 언제 다시 만날지는 아무도 모른다. - 윌리엄 셰익스피어',
	'당신을 만나는 모든 사람이 당신과 헤어질 때는 더 나아지고 더 행복해질 수 있도록 하라. - 마더 테레사',
	'인간의 감정은 누군가를 만날 때와 헤어질 때 가장 순수하며 가장 빛난다. - 장 폴 리히터',
	'떠났네 훨훨 / 밤에게서 별을 / 낮에게서 해를 가져갔네 / 떠났네, 이제 내 마음에는 구름만이 남았네. - 알프레드 테니슨',
	'작별 인사에 낙담하지 말라. 재회에 앞서 작별은 필요하다. 그리고 친구라면 잠시 혹은 오랜 뒤라도 꼭 재회하게 될 터이니. - 리처드 바크',
	'떠날 때가 되었으니, 이제 각자의 길을 가자. 나는 죽기 위해서, 당신들은 살기 위해. 어느 편이 더 좋은 지는 오직 신만이 알 뿐이다. - 소크라테스',
	'우리가 다시 만날 그 날까지 행복한 여정이 되기를. / 어떤 길은 기쁘고 / 또 어떤 길은 우울하니 / 그것이 의미있는 길을 가는 법이지 / 이제 기쁜 길을 떠나길. - 데일 에반스',
	'떠날 때가 되었으니, 이제 각자의 길을 가자. 나는 죽기 위해서, 당신들은 살기 위해. 어느 편이 더 좋은 지는 오직 신만이 알 뿐이다. - 소크라테스'
];
$msg_cnt = count($msg);
if($msg_cnt) {
	shuffle($msg); // 섞기
	$msgtxt = explode('-', $msg[0]);
}

$positions = [
    1 => '<blockquote class="quote spacer">
            <span>'.$msgtxt[0].'</span>
            <cite>&mdash;'.$msgtxt[1].'</cite>
          </blockquote>',
    6 => '<div class="spacer"></div>',
    10 => '<div class="spacer"></div>',
    11 => '<div class="spacer"></div>',
    15 => '<div class="spacer"></div>'
];


?>
<div class="pic_lt">
	<div class="gallery">
		<?php
		for ($i=0; $i<$list_count; $i++) {
			$thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

			if($thumb['src']) {
				$img = $thumb['src'];
			} else {
				$img = G5_IMG_URL.'/no_img.png';
				$thumb['alt'] = '이미지가 없습니다.';
			}
			$img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
			$wr_href = get_pretty_url($bo_table, $list[$i]['wr_id']);

			if($is_random){
				if (rand(0, $list_count) == $i) {
					echo '<div class="spacer"></div>';
				}
				if (!$quote_inserted && rand(0, $list_count) == $i) {
					echo '<blockquote class="quote spacer">
						<span>'.$msgtxt[0].'</span>
						<cite>&mdash;'.$msgtxt[1].'</cite>
					</blockquote>';
					$quote_inserted = true;
				}
			}else{
				if (array_key_exists($i, $positions)) {
					echo $positions[$i];
				}
			}

			echo '<a href="'.$wr_href.'">'.$img_content.'</a>';

		}
		if ($is_random && !$quote_inserted) {
			echo '<blockquote class="quote spacer">
				<span>'.$msgtxt[0].'</span>
				<cite>&mdash;'.$msgtxt[1].'</cite>
			</blockquote>';
		}
		?>
	</div>
</div>
