<?php if (!defined('_GNUBOARD_')) exit; ?>

<link href=https://fonts.googleapis.com/css2?family=Nanum+Gothic&family=Righteous&display=swap rel=stylesheet>
<style>
#hymnHeadTable, #hymnTailTable, #hymnSearchTable { width:100%; table-layout:fixed; }
.hymn-head-left-right { font-family:Righteous; width:20%; font-size:20px; text-align:center; }
.hymn-input { width:100%; padding:10px 0px 10px 0px; text-align:center; border:1px solid #cccccc; border-radius:5px; outline:none; box-sizing:border-box; }
#hymnTitleTd { font-family:'Nanum Gothic'; font-weight:bold; font-size:16px; background-color:#ffffff; text-align:center; border:1px solid #cccccc; border-radius:5px; }
#hymnNumberTable { width:100%; table-layout:fixed; }
.hymn-number-td { font-family:Righteous; font-size:20px; padding:10px 0px 10px 0px; text-align:center; cursor:pointer; background:linear-gradient(#ffffff 50%, #cccccc 50%); border:1px solid #cccccc; border-radius:5px; }
.hymn-tail-left-right { font-family:Righteous; width:20%; font-size:20px; color:#003152; padding:12px 0px 12px 0px; text-align:center; cursor:pointer; background-color:#d5e6f9; border:1px solid #cccccc; border-radius:5px; }
.hymn-tail-center { font-family:'Nanum Gothic'; font-weight:bold; font-size:16px; color:#003152; cursor:pointer; text-align:center; border:1px solid #cccccc; border-radius:5px; }
</style>

<table id=hymnHeadTable cellpadding=0 cellspacing=0>
	<td class=hymn-head-left-right><input id=hymnNumberInput class=hymn-input style=font-family:Righteous;font-size:20px;color:#000000;background-color:#f4e3d5 disabled></td>
	<td style=width:1px></td>
	<td id=hymnTitleTd></td>
	<td style=width:1px></td>
	<td id=hymnPlay class=hymn-head-left-right style="cursor:pointer;background-color:#f4e3d5;border:1px solid #cccccc;border-radius:5px">play</td>
</table>
<table id=hymnNumberTable cellpadding=0 cellspacing=0 style="margin:5px 0px 5px 0px">
	<td class=hymn-number-td>1</td><td style=width:1px></td>
	<td class=hymn-number-td>2</td><td style=width:1px></td>
	<td class=hymn-number-td>3</td><td style=width:1px></td>
	<td class=hymn-number-td>4</td><td style=width:1px></td>
	<td class=hymn-number-td>5</td><td style=width:1px></td>
	<td class=hymn-number-td>6</td><td style=width:1px></td>
	<td class=hymn-number-td>7</td><td style=width:1px></td>
	<td class=hymn-number-td>8</td><td style=width:1px></td>
	<td class=hymn-number-td>9</td><td style=width:1px></td>
	<td class=hymn-number-td>0</td><td style=width:1px></td>
	<td class=hymn-number-td style=color:#c00000>X</td>
</table>
<div id=ytDiv><iframe id=ytPlayer style=width:100%;height:100%;display:block frameborder=0 allowfullscreen></iframe></div>
<table id=hymnTailTable cellpadding=0 cellspacing=0 style="margin:5px 0px 5px 0px">
	<td id=prevButton class=hymn-tail-left-right><span style=font-size:15px>◀</span> prev</td>
	<td style=width:1px></td>
	<td class=hymn-tail-center onmousedown=loopMode='yes'>한곡반복</td>
	<td style=width:1px></td>
	<td class=hymn-tail-center onmousedown=loopMode='loop'>전곡연속</td>
	<td style=width:1px></td>
	<td class=hymn-tail-center onmousedown=loopMode='no'>한곡재생</td>
	<td style=width:1px></td>
	<td id=nextButton class=hymn-tail-left-right>next <span style=font-size:15px>▶</span></td>
</table>
<table id=hymnSearchTable cellpadding=0 cellspacing=0>
	<td><input id=hymnSearchBeforeInput class=hymn-input style="font-family:'Nanum Gothic';font-weight:bold;font-size:16px;color:#580ca3;background-color:#eeeeee" placeholder=가사검색></td>
	<td style=width:1px></td>
	<td style=width:60%><input id=hymnSearchAfterInput class=hymn-input style="font-family:'Nanum Gothic';font-weight:bold;font-size:16px;color:#580ca3;background-color:#d9eccc;cursor:pointer" readonly></td>
</table>

<script src=https://www.youtube.com/iframe_api></script>
<script src="<?php echo $board_skin_url.'/michael.js'; ?>"></script>
<script>
hymnThis = this;
goMode = hymnPlayMode = 1;
loopMode = "loop"; 
ytPlayer.src = "https://www.youtube.com/embed/?autoplay=1&enablejsapi=1";
function onYouTubeIframeAPIReady() {
	ytDiv = new YT.Player("ytPlayer", {
		events: {
			"onReady": onPlayerReady,
			"onStateChange": onPlayerStateChange
		}
	} );
}
function onPlayerReady(event) {
	event.target.playVideo();
	ytDiv.loadVideoById(hymnThis["numberList_" + hymnOrder][1]);
}
function onPlayerStateChange(event) {
	if (event.data == YT.PlayerState.ENDED) loopChoice();
}
function hymnMode() {
	hymnNumberInput.value = hymnOrder;
	hymnTitleTd.innerText = hymnThis["numberList_" + hymnOrder][0];
}
function loopChoice() {
	if (hymnNumberInput.value == "" || hymnNumberInput.value == 0) hymnOrder = Math.floor(Math.random() * 1550 + 1);
	if (loopMode == "no") ytDiv.pauseVideo();
	else {
		if (loopMode == "yes") hymnOrder = hymnOrder;
		else hymnOrder = goMode ? (hymnOrder == 1550 ? 1 : Number(hymnOrder) + 1) : (hymnOrder == 1 ? 1550 : Number(hymnOrder) - 1);
		ytDiv.loadVideoById(hymnThis["numberList_" + hymnOrder][1]);
		hymnMode();
	}
	hymnPlayMode = 1;
	hymnNumberInput.style.color = hymnTitleTd.style.color = "#000000";
}
for (hymn_number_td of hymnNumberTable.getElementsByClassName("hymn-number-td")) {
	hymn_number_td.onclick = function() {
		hymnNumberInput.value = this.innerText == "X" ? "" : Number((hymnNumberInput.value + this.innerText).slice(-4));
		if ((hymnNumberInput.value == "") || (Number(hymnNumberInput.value) < 1 || Number(hymnNumberInput.value) > 1550)) {
			hymnNumberInput.value = hymnTitleTd.innerText = "";
			hymnPlayMode = 0;
		}
		else {
			hymnOrder = hymnNumberInput.value; 
			hymnMode();
			hymnPlayMode = 1;
		}
	}
	hymn_number_td.onmouseover = function() {
		this.style.background = "linear-gradient(#cccccc 50%,#ffffff 50%)";
	}
	hymn_number_td.onmouseout = function() {
		this.style.background = "linear-gradient(#ffffff 50%,#cccccc 50%)";
	}
}
hymnOrder = Math.floor(Math.random() * 1550 + 1);
hymnMode();
hymnPlay.onclick = function() {
	if (hymnPlayMode) ytDiv.loadVideoById(hymnThis["numberList_" + hymnOrder][1]);
}
nextButton.onclick = function() {
	if (hymnPlayMode) {
		goMode = 1;
		hymnOrder = hymnOrder == 1550 ? 1 : Number(hymnOrder) + 1;
		ytDiv.loadVideoById(hymnThis["numberList_" + hymnOrder][1]);
		hymnMode();
	}
}
prevButton.onclick = function() {
	if (hymnPlayMode) {
		goMode = 0;
		hymnOrder = hymnOrder == 1 ? 1550 : Number(hymnOrder) - 1;
		ytDiv.loadVideoById(hymnThis["numberList_" + hymnOrder][1]);
		hymnMode();
	}
}
for (hymn_tail_center of hymnTailTable.getElementsByClassName("hymn-tail-center")) {
	hymn_tail_center.onclick = function() {
		for (hymn_tail_center of hymnTailTable.getElementsByClassName("hymn-tail-center")) hymn_tail_center.style.backgroundColor = "#ffffff";
		this.style.backgroundColor = "#f7d7e4";
	}
}
hymnSearchBeforeInput.onkeyup = function() {
	if (hymnSearchBeforeInput.value.trim() == "") hymnSearchAfterInput.value = "";
	else {
		hymnSearchBeforeInput.value = hymnSearchBeforeInput.value.replaceAll(" ", "");
		for (hymn_lyrics = 1; hymn_lyrics <= 1550; hymn_lyrics++) {
			hymnReplace = hymnThis["numberList_" + hymn_lyrics][0].replaceAll(" ", "");
			if (hymnReplace.indexOf(hymnSearchBeforeInput.value) < 0) hymnSearchAfterInput.value = "";
			else {
				hymnSearchAfterInput.value = hymn_lyrics + " : " + hymnThis["numberList_" + hymn_lyrics][0];
				if (hymnSearchAfterInput.value != "") break;
			}
		}
	}
}
hymnSearchAfterInput.onclick = function() {
	if (this.value != "") {
		hymnOrder = hymnNumberInput.value = this.value.split(":")[0].trim();
		hymnTitleTd.innerText = this.value.split(":")[1].trim();
		ytDiv.loadVideoById(hymnThis["numberList_" + hymnOrder][1]);
		hymnNumberInput.style.color = hymnTitleTd.style.color = "#000000"; 
		this.value = hymnSearchBeforeInput.value = "";
		hymnPlayMode = 1;
	}
}
hymnTailTable.getElementsByClassName("hymn-tail-center")[1].onclick();
onresize = function() {
	ytDiv.style.height = ytDiv.offsetWidth * 9 / 16 + "px";
}
onresize();
</script>