<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<?php if ($bo_table == 'notice') { ?>
<div id="subTop" data-aos="zoom-out" data-aos-easing="ease-in-out" anchorplacement="bottom-top">
    <div class="sub-visual">
        <div class="subbg_04"></div>
        <div class="sub_text">
            <h2 class="init animate" data-aos="fade-down">커뮤니티</h2>
            <p class="init animate" data-aos="fade-up">코리아피트 정보공유센터</p>
        </div>
        <div class="sub-tab" data-aos="slide-up">
            <ul>
                <li class="active"><a href="/bbs/board.php?bo_table=notice">공지사항</a></li>
                <li><a href="/bbs/board.php?bo_table=event">이벤트 행사</a></li>
                <li><a href="/bbs/board.php?bo_table=gallery">홍보갤러리</a></li>
                <li><a href="/bbs/board.php?bo_table=inquiry">고객문의</a></li>
            </ul>
        </div>
    </div>
</div>
<?php } ?>


<div id="subContents" data-aos="fade-up">
    <div class="sub-contents">
        <?php if ($bo_table == 'notice') { ?>
            <h2 class="title_h2 init animate" data-aos="fade-left">공지사항</h2>
        <?php } ?>
        <div class="content-wrap">
            <div class="bo_sch_flex">
                <fieldset class="bo_sch">
                    <h3>검색</h3>
                    <form name="fsearch" method="get">
                        <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                        <input type="hidden" name="sca" value="<?php echo $sca ?>">
                        <input type="hidden" name="sop" value="and">
                        <label for="sfl" class="sound_only">검색대상</label>
                        <select name="sfl" id="sfl">
                            <?php echo get_board_sfl_select_options($sfl); ?>
                        </select>
                        <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
                        <div class="sch_bar">
                            <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="sch_input" size="25" maxlength="20" placeholder=" 검색어를 입력해주세요">
                            <button type="submit" value="검색" class="sch_btn"><i class="fa fa-search" aria-hidden="true"></i><span class="sound_only">검색</span></button>
                        </div>
                        <button type="button" class="bo_sch_cls" title="닫기"><i class="fa fa-times" aria-hidden="true"></i><span class="sound_only">닫기</span></button>
                    </form>
                </fieldset>
                <div class="bo_sch_bg"></div>
            </div>
            <form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
                <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
                <input type="hidden" name="stx" value="<?php echo $stx ?>">
                <input type="hidden" name="spt" value="<?php echo $spt ?>">
                <input type="hidden" name="sca" value="<?php echo $sca ?>">
                <input type="hidden" name="sst" value="<?php echo $sst ?>">
                <input type="hidden" name="sod" value="<?php echo $sod ?>">
                <input type="hidden" name="page" value="<?php echo $page ?>">
                <input type="hidden" name="sw" value="">

                <div class="brd-top">
                    <p class="brd-top__total">총 <b><?php echo number_format($total_count) ?></b>건</p>
                </div>
                <?php if ($list_href || $is_checkbox || $write_href) { ?>
                <div class="brd-button">
                    <ul>
                        <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin btn" title="관리자"><i class="fa fa-cog fa-spin fa-fw"></i><span class="sound_only">관리자</span></a></li><?php } ?>
                        <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01 btn" title="RSS"><i class="fa fa-rss" aria-hidden="true"></i><span class="sound_only">RSS</span></a></li><?php } ?>
                        <!--<li>
                            <button type="button" class="btn_bo_sch btn_b01 btn" title="게시판 검색"><i class="fa fa-search" aria-hidden="true"></i><span class="sound_only">게시판 검색</span></button>
                        </li>
                        -->
                        <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b01 btn" title="글쓰기"><i class="fa fa-pencil" aria-hidden="true"></i><span class="sound_only">글쓰기</span></a></li><?php } ?>
                        <?php if ($is_admin == 'super' || $is_auth) {  ?>
                            <li>
                                <button type="button" class="btn_more_opt is_list_btn btn_b01 btn" title="게시판 리스트 옵션"><i class="fa fa-ellipsis-v" aria-hidden="true"></i><span class="sound_only">게시판 리스트 옵션</span></button>
                                <?php if ($is_checkbox) { ?>
                                    <ul class="more_opt is_list_btn">
                                        <li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"><i class="fa fa-trash-o" aria-hidden="true"></i> 선택삭제</button></li>
                                        <li><button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value"><i class="fa fa-files-o" aria-hidden="true"></i> 선택복사</button></li>
                                        <li><button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value"><i class="fa fa-arrows" aria-hidden="true"></i> 선택이동</button></li>
                                    </ul>
                                <?php } ?>
                            </li>
                        <?php }  ?>
                    </ul>
                </div>
                <?php }  ?>
                <div class="tbl_head01 tbl_wrap">
                    <table>
                        <caption><?php echo $board['bo_subject'] ?> 목록</caption>
                        <thead>
                        <tr data-aos="fade-left">
                            <?php if ($is_checkbox) { ?>
                                <th scope="col" class="all_chk chk_box">
                                    <input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);" class="selec_chk">
                                    <label for="chkall">
                                        <span></span>
                                        <b class="sound_only">현재 페이지 게시물  전체선택</b>
                                    </label>
                                </th>
                            <?php } ?>
                            <th scope="col" style="width:60px;">번호</th>
                            <th scope="col" style="*">제목</th>
                            <th scope="col" style="width:100px;">글쓴이</th>
                            <th scope="col" style="width:60px;"><?php echo subject_sort_link('wr_hit', $qstr2, 1) ?>조회 </th>
                            <?php if ($is_good) { ?><th scope="col"><?php echo subject_sort_link('wr_good', $qstr2, 1) ?>추천 </th><?php } ?>
                            <?php if ($is_nogood) { ?><th scope="col"><?php echo subject_sort_link('wr_nogood', $qstr2, 1) ?>비추천 </th><?php } ?>
                            <th scope="col"><?php echo subject_sort_link('wr_datetime', $qstr2, 1) ?>날짜  </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        for ($i=0; $i<count($list); $i++) {
                            if ($i%2==0) $lt_class = "even";
                            else $lt_class = "";
                            ?>
                            <tr class="<?php if ($list[$i]['is_notice']) echo "bo_notice"; ?> <?php echo $lt_class ?>">
                                <?php if ($is_checkbox) { ?>
                                    <td class="td_chk chk_box">
                                        <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>" class="selec_chk">
                                        <label for="chk_wr_id_<?php echo $i ?>">
                                            <span></span>
                                            <b class="sound_only"><?php echo $list[$i]['subject'] ?></b>
                                        </label>
                                    </td>
                                <?php } ?>
                                <td class="td_num2 tac">
                                    <?php
                                    if ($list[$i]['is_notice']) // 공지사항
                                        echo '<strong class="notice_icon">공지</strong>';
                                    else if ($wr_id == $list[$i]['wr_id'])
                                        echo "<span class=\"bo_current\">열람중</span>";
                                    else
                                        echo $list[$i]['num'];
                                    ?>
                                </td>

                                <td class="td_subject" style="padding-left:<?php echo $list[$i]['reply'] ? (strlen($list[$i]['wr_reply'])*10) : '0'; ?>px">
                                    <?php
                                    if ($is_category && $list[$i]['ca_name']) {
                                        ?>
                                        <a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a>
                                    <?php } ?>
                                    <div class="bo_tit">
                                        <a href="<?php echo $list[$i]['href'] ?>">
                                            <?php echo $list[$i]['icon_reply'] ?>
                                            <?php
                                            if (isset($list[$i]['icon_secret'])) echo rtrim($list[$i]['icon_secret']);
                                            ?>
                                            <?php echo $list[$i]['subject'] ?>
                                        </a>
                                        <?php
                                        if ($list[$i]['icon_new']) echo "<span class=\"new_icon\">N<span class=\"sound_only\">새글</span></span>";
                                        // if ($list[$i]['file']['count']) { echo '<'.$list[$i]['file']['count'].'>'; }
                                        if (isset($list[$i]['icon_hot'])) echo rtrim($list[$i]['icon_hot']);
                                        if (isset($list[$i]['icon_file'])) echo rtrim($list[$i]['icon_file']);
                                        if (isset($list[$i]['icon_link'])) echo rtrim($list[$i]['icon_link']);
                                        ?>
                                        <?php if ($list[$i]['comment_cnt']) { ?><span class="sound_only">댓글</span><span class="cnt_cmt"><?php echo $list[$i]['wr_comment']; ?></span><span class="sound_only">개</span><?php } ?>
                                    </div>
                                </td>
                                <td class="td_name sv_use"><?php echo $list[$i]['name'] ?></td>
                                <td class="td_num"><?php echo $list[$i]['wr_hit'] ?></td>
                                <?php if ($is_good) { ?><td class="td_num"><?php echo $list[$i]['wr_good'] ?></td><?php } ?>
                                <?php if ($is_nogood) { ?><td class="td_num"><?php echo $list[$i]['wr_nogood'] ?></td><?php } ?>
                                <td class="td_datetime"><?php echo $list[$i]['datetime2'] ?></td>

                            </tr>
                        <?php } ?>
                        <?php if (count($list) == 0) { echo '<tr><td colspan="'.$colspan.'" class="empty_table">게시물이 없습니다.</td></tr>'; } ?>
                        </tbody>
                    </table>
                </div>
                <?php /*
                <div class="cpgn-list">
                    <?php for ($i=0; $i<count($list); $i++) {
                        if ($i%2==0) $lt_class = "even";
                        else $lt_class = "";
                        ?>
                        <div class="cpgn-item">
                            <a href="<?php echo $list[$i]['href'] ?>">
                                <dl>
                                    <dt>
                                        <?php
                                        if ($list[$i]['is_notice']) { // 공지사항  ?>
                                            <span class="is_notice" style="<?php echo $line_height_style; ?>">공지</span>
                                        <?php } else {
                                            $thumb = get_list_thumbnail($board['bo_table'], $list[$i]['wr_id'], $board['bo_gallery_width'], $board['bo_gallery_height'], false, true);

                                            if($thumb['src']) {
                                                $img_content = '<img src="'.$thumb['src'].'" alt="'.$thumb['alt'].'" >';
                                            } else {
                                                $img_content = '<span class="no_image" style="'.$line_height_style.'">no image</span>';
                                            }

                                            echo run_replace('thumb_image_tag', $img_content, $thumb);
                                        }
                                        ?>
                                    </dt>
                                    <dd>
                                        <h5>
                                            <strong><?php echo $list[$i]['subject'] ?></strong>
                                            <?php if ($list[$i]['comment_cnt']) { ?><span class="comment_number">(<?php echo $list[$i]['wr_comment']; ?>)</span><?php } ?>
                                            <?php
                                            if (isset($list[$i]['icon_hot'])) echo '<img src="/assets/images/icon_hot.gif" alt="HOT" align="absmiddle">';
                                            if (isset($list[$i]['icon_file'])) echo '<img src="/assets/images/icon_file.gif" alt="FILE" align="absmiddle">';
                                            ?>
                                        </h5>
                                        <p><?php echo $list[$i]['content'] ?></p>
                                        <ul>
                                            <li><?php echo $list[$i]['name'] ?></li>
                                            <li><?php echo $list[$i]['datetime2'] ?></li>
                                            <li>조회 <?php echo $list[$i]['wr_hit'] ?></li>
                                        </ul>
                                    </dd>
                                </dl>
                            </a>
                        </div>
                    <?php } ?>
                    <?php if (count($list) == 0) { echo '<div class="cpgn-item none">게시물이 존재하지 않습니다.</div>'; } ?>
                </div>
                */ ?>
                <?php if ($list_href || $is_checkbox || $write_href) { ?>
                <div class="brd-button">
                    <?php if ($list_href || $write_href) { ?>
                        <ul>
                            <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin btn" title="관리자"><i class="fa fa-cog fa-spin fa-fw"></i><span class="sound_only">관리자</span></a></li><?php } ?>
                            <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01 btn" title="RSS"><i class="fa fa-rss" aria-hidden="true"></i><span class="sound_only">RSS</span></a></li><?php } ?>
                            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b01 btn" title="글쓰기"><i class="fa fa-pencil" aria-hidden="true"></i><span class="sound_only">글쓰기</span></a></li><?php } ?>
                        </ul>
                    <?php } ?>
                </div>
                <?php } ?>
            </form>
            <div class="paginate_regular">
                <?php echo $write_pages; ?>
            </div>
        </div>
    </div>
</div>
<script>
jQuery(function($){
    // 게시판 검색
    $(".btn_bo_sch").on("click", function() {
        $(".bo_sch_wrap").toggle();
    })
    $('.bo_sch_bg, .bo_sch_cls').click(function(){
        $('.bo_sch_wrap').hide();
    });
});
</script>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}

// 게시판 리스트 관리자 옵션
jQuery(function($){
    $(".btn_more_opt.is_list_btn").on("click", function(e) {
        e.stopPropagation();
        $(".more_opt.is_list_btn").toggle();
    });
    $(document).on("click", function (e) {
        if(!$(e.target).closest('.is_list_btn').length) {
            $(".more_opt.is_list_btn").hide();
        }
    });
});
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
