<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>
<?php if ($bo_table == 'notice') { ?>
    <div id="subTop" data-aos="zoom-out" data-aos-easing="ease-in-out" anchorplacement="bottom-top">
    <div class="sub-visual">
        <div class="subbg_04"></div>
        <div class="sub_text">
            <h2 class="init animate" data-aos="fade-down">커뮤니티</h2>
            <p class="init animate" data-aos="fade-up">코리아피트 정보공유센터</p>
        </div>
        <div class="sub-tab" data-aos="slide-up">
            <ul>
                <li class="active"><a href="/bbs/board.php?bo_table=notice">공지사항</a></li>
                <li><a href="/bbs/board.php?bo_table=event">이벤트 행사</a></li>
                <li><a href="/bbs/board.php?bo_table=gallery">홍보갤러리</a></li>
                <li><a href="/bbs/board.php?bo_table=inquiry">고객문의</a></li>
            </ul>
        </div>
    </div>
</div>
<?php } ?>



<div id="subContents" data-aos="fade-up">
    <div class="sub-contents">
        <?php if ($bo_table == 'notice') { ?>
            <h2 class="title_h2 init animate" data-aos="fade-left">공지사항</h2>
        <?php } ?>
        <div class="content-wrap">
            <div class="contents_sub">
                <div class="whois-board-view">


                    <div class="board-header line-b">
                        <div class="board-title">
                            <?php if ($category_name) { ?>
                            <span><?php echo $view['ca_name']; // 분류 출력 끝 ?></span>
                            <?php } ?>
                            <h3> <?php echo cut_str(get_text($view['wr_subject']), 70); ?></h3>
                        </div>
                        <div class="board-info">
						<span class="user">
							<img src="/assets/images/user.png"><?php echo $view['name'] ?></span>
                            <span><?php echo date("y-m-d H:i", strtotime($view['wr_datetime'])) ?></span>
                            <span>조회 <?php echo number_format($view['wr_hit']) ?></span>
                        </div>

                    </div>

					<div>
						<ul class="btn_bo_user bo_v_com">
							<li><a href="<?php echo $list_href ?>" class="btn_b01 btn" title="목록"><i class="fa fa-list" aria-hidden="true"></i><span class="sound_only">목록</span></a></li>
							<?php if ($reply_href) { ?><li><a href="<?php echo $reply_href ?>" class="btn_b01 btn" title="답변"><i class="fa fa-reply" aria-hidden="true"></i><span class="sound_only">답변</span></a></li><?php } ?>
							<?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b01 btn" title="글쓰기"><i class="fa fa-pencil" aria-hidden="true"></i><span class="sound_only">글쓰기</span></a></li><?php } ?>
							<?php if($update_href || $delete_href || $copy_href || $move_href || $search_href) { ?>
							<li>
								<button type="button" class="btn_more_opt is_view_btn btn_b01 btn"><i class="fa fa-ellipsis-v" aria-hidden="true"></i><span class="sound_only">게시판 리스트 옵션</span></button>
								<ul class="more_opt is_view_btn"> 
									<?php if ($update_href) { ?><li><a href="<?php echo $update_href ?>">수정<i class="fa fa-pencil-square-o" aria-hidden="true"></i></a></li><?php } ?>
									<?php if ($delete_href) { ?><li><a href="<?php echo $delete_href ?>" onclick="del(this.href); return false;">삭제<i class="fa fa-trash-o" aria-hidden="true"></i></a></li><?php } ?>
									<?php if ($copy_href) { ?><li><a href="<?php echo $copy_href ?>" onclick="board_move(this.href); return false;">복사<i class="fa fa-files-o" aria-hidden="true"></i></a></li><?php } ?>
									<?php if ($move_href) { ?><li><a href="<?php echo $move_href ?>" onclick="board_move(this.href); return false;">이동<i class="fa fa-arrows" aria-hidden="true"></i></a></li><?php } ?>
									<?php if ($search_href) { ?><li><a href="<?php echo $search_href ?>">검색<i class="fa fa-search" aria-hidden="true"></i></a></li><?php } ?>
								</ul> 
							</li>
							<?php } ?>
						</ul>

						<script>

						jQuery(function($){
							// 게시판 보기 버튼 옵션
							$(".btn_more_opt.is_view_btn").on("click", function(e) {
								e.stopPropagation();
								$(".more_opt.is_view_btn").toggle();
							})
			;
							$(document).on("click", function (e) {
								if(!$(e.target).closest('.is_view_btn').length) {
									$(".more_opt.is_view_btn").hide();
								}
							});
						});
						</script>	        
					</div>


                    <div class="board-content-wrap">
                        <div class="board-content line-b">
                            <?php
                            // 파일 출력
                            $v_img_count = count($view['file']);
                            if($v_img_count) {
                                echo "<div id=\"bo_v_img\">\n";

                                foreach($view['file'] as $view_file) {
                                    echo get_file_thumbnail($view_file);
                                }

                                echo "</div>\n";
                            }
                            ?>
                            <?php echo get_view_thumbnail($view['content']); ?>
                        </div>
                        <?php
                        $cnt = 0;
                        if ($view['file']['count']) {
                            for ($i=0; $i<count($view['file']); $i++) {
                                if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view'])
                                    $cnt++;
                            }
                        }
                        ?>
                        <?php if($cnt) { ?>
                        <div class="file-wrap line-b">
                            <div class="file-th">
                                <span>첨부파일</span>
                            </div>
                            <div class="file-td">
                                <ol class="file-list">
                                    <?php
                                    // 가변 파일
                                    for ($i=0; $i<count($view['file']); $i++) {
                                        if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view']) {
                                            ?>
                                            <li>
                                                <a href="<?php echo $view['file'][$i]['href'];  ?>" class="view_file_download">
                                                    <strong><?php echo $view['file'][$i]['source'] ?></strong> <?php echo $view['file'][$i]['content'] ?> (<?php echo $view['file'][$i]['size'] ?>)
                                                </a>
                                                <span class="file-download-cnt"><font class="fs_11">다운로드횟수[<?php echo $view['file'][$i]['download'] ?>]</font></span>
                                            </li>
                                            <?php
                                        }
                                    }
                                    ?>
                                </ol>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 btn_area">
                            <div class="align_left">
                                <a href="<?php echo $list_href ?>" class="btn btn-default">목록</a>
                            </div>
                            <div class="align_right">
                            </div>
                        </div>
                    </div>
                </div>
                <?php if ($prev_href || $next_href) { ?>
                <div>

                    <?php if ($prev_href) { ?>
                    <a href="<?php echo $prev_href ?>" class="next_data_area">
                        <span class="b">다음글 | </span>
                        <?php echo $prev_wr_subject;?>
                    </a>
                    <?php } ?>
                    <?php if ($next_href) { ?>
                    <a href="<?php echo $next_href ?>" class="prev_data_area">
                        <span class="b">이전글 | </span>
                        <?php echo $next_wr_subject;?>
                    </a>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
            <script>
            <?php if ($board['bo_download_point'] < 0) { ?>
            $(function() {
                $("a.view_file_download").click(function() {
                    if(!g5_is_member) {
                        alert("다운로드 권한이 없습니다.\n회원이시라면 로그인 후 이용해 보십시오.");
                        return false;
                    }

                    var msg = "파일을 다운로드 하시면 포인트가 차감(<?php echo number_format($board['bo_download_point']) ?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?";

                    if(confirm(msg)) {
                        var href = $(this).attr("href")+"&js=on";
                        $(this).attr("href", href);

                        return true;
                    } else {
                        return false;
                    }
                });
            });
            <?php } ?>

            function board_move(href)
            {
                window.open(href, "boardmove", "left=50, top=50, width=500, height=550, scrollbars=1");
            }
            </script>

            <script>
            $(function() {
                $("a.view_image").click(function() {
                    window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
                    return false;
                });

                // 추천, 비추천
                $("#good_button, #nogood_button").click(function() {
                    var $tx;
                    if(this.id == "good_button")
                        $tx = $("#bo_v_act_good");
                    else
                        $tx = $("#bo_v_act_nogood");

                    excute_good(this.href, $(this), $tx);
                    return false;
                });

                // 이미지 리사이즈
                $("#bo_v_atc").viewimageresize();
            });

            function excute_good(href, $el, $tx)
            {
                $.post(
                    href,
                    { js: "on" },
                    function(data) {
                        if(data.error) {
                            alert(data.error);
                            return false;
                        }

                        if(data.count) {
                            $el.find("strong").text(number_format(String(data.count)));
                            if($tx.attr("id").search("nogood") > -1) {
                                $tx.text("이 글을 비추천하셨습니다.");
                                $tx.fadeIn(200).delay(2500).fadeOut(200);
                            } else {
                                $tx.text("이 글을 추천하셨습니다.");
                                $tx.fadeIn(200).delay(2500).fadeOut(200);
                            }
                        }
                    }, "json"
                );
            }
            </script>
            <!-- } 게시글 읽기 끝 -->
        </div>
    </div>
</div>