<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

if(!$wset['slider']) {
	$wset['slider'] = 5;
	for($i=1; $i <= 5; $i++) {
		$wset['use'.$i] = 1;
		$wset['img'.$i] = $widget_url.'/img/noimg.jpg';
	}
}

// 추출하기
$list = array();

// 슬라이더
$k=0;
for ($i=1; $i <= $wset['slider']; $i++) {

	if(!$wset['use'.$i]) continue; // 사용하지 않으면 건너뜀

	$list[$k]['img'] = $wset['img'.$i];
	$list[$k]['link'] = ($wset['link'.$i]) ? $wset['link'.$i] : 'javascript:;';
	$list[$k]['target'] = ($wset['target'.$i]) ? ' target="'.$wset['target'.$i].'"' : '';

	$k++;
}

$list_cnt = count($list);

// 랜덤
if($wset['rdm'] && $list_cnt) shuffle($list);

// 스타일
$is_center = (isset($wset['center']) && $wset['center']) ? ' text-center' : '';
$is_bold = (isset($wset['bold']) && $wset['bold']) ? true : false;

// 그림자
$shadow_in = '';
$shadow_out = (isset($wset['shadow']) && $wset['shadow']) ? apms_shadow($wset['shadow']) : '';
if($shadow_out && isset($wset['inshadow']) && $wset['inshadow']) {
	$shadow_in = '<div class="in-shadow">'.$shadow_out.'</div>';
	$shadow_out = '';
}

// owl-hide : 모양유지용 프레임
if($list_cnt) {
?>
	<div class="owl-show">
		<div class="owl-container">
			<div class="owl-carousel">
			<?php
			for ($i=0; $i < $list_cnt; $i++) {

				// Lazy
				$img_src = ($is_lazy) ? 'data-src="'.$list[$i]['img'].'" class="lazyOwl"' : 'src="'.$list[$i]['img'].'"';

			?>
				<div class="item">
					<div class="item-list">
						<div class="post-image">
							<a href="<?php echo $list[$i]['link'];?>"<?php echo $list[$i]['target'];?>>
								<div class="img-wrap">
									<?php echo $shadow_in;?>
									<div class="img-item">
										<img <?php echo $img_src;?> alt="<?php echo $list[$i]['img']['alt'];?>">
									</div>
								</div>
							</a>
							<?php echo $shadow_out;?>
						</div>
					</div>
				</div>
			<?php } ?>
			</div>
		</div>
	</div>
	<div class="owl-hide">
		<div class="item">
			<div class="item-list">
				<div class="post-image">
					<div class="img-wrap">
						<div class="img-item">&nbsp;</div>
					</div>
					<?php echo $shadow_out;?>
				</div>
				<div class="post-content<?php echo $is_center;?>">
					<div class="post-subject">&nbsp;</div>
					<div class="post-text post-ko txt-short ellipsis<?php echo $is_details;?>">&nbsp;</div>
				</div>
			</div>
		</div>
	</div>
<?php } else { ?>
	<div class="post-none">
		등록된 배너가 없습니다.
	</div>
<?php } ?>