<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

$img_w = 300; // 이미지($img) 가로 크기
$img_h = 300; // 이미지($img) 세로 크기
?>

<style type="text/css">

body {min-width: 100%; min-height: 100%;}
.container{margin: 0 auto; max-width: 1220px;}

h2{color: #fff; float: left; width: 100%; font-size: 24px; font-weight: 400; text-align: center; padding: 50px 0 40px; position: relative; z-index: 50;}

*{margin: 0; padding: 0; box-sizing: border-box;}
img{max-width: 100%; vertical-align: middle;}

.container ul{margin: 0 -1.5%;}
.container li{float: left; width: 23%; margin: 10px 1%; list-style: none;}

h3{font-size: 20px; margin: 5px 0 10px;}
p{font-weight: 300; line-height: 20px; font-size: 14px; margin-bottom: 15px;}
.btn1{display: inline-block; padding: 5px 10px; font-size: 14px; color: #fff; border: 2px solid #4d92d9; background-color: #4d92d9; text-decoration: none; transition: 0.4s;}
.btn1:hover{background-color: transparent; color: #4d92d9; transition: 0.4s;}
.text-desc{position: absolute; left: 0; top: 0; background-color: #fff; height: 100%; opacity: 0; width: 100%; padding: 20px;}
.port-3{float: left; width: 100%; position: relative; overflow: hidden; text-align: center; border: 4px solid rgba(255, 255, 255, 0.9); perspective: 500px;}
.port-3 img{transition: 0.5s;}
.port-3.effect-3 .text-desc{z-index: -1; transition: 0.5s; transform: rotateX(80deg); transform-origin: center top 0; padding: 45px 20px 20px;}
.port-3.effect-3:hover .text-desc{transform: none; opacity: 1;}
.port-3.effect-3:hover img{transform: translateY(100%)}

</style>

<div class="full-length">
	<div class="container">
		<ul>
		<?php
			for($i=0; $i<count($list); $i++){
				$thumbs = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $img_w, $img_h, false, false);
			if($thumbs['src']) {
				$img = $thumbs['src'];
			}?>	
			<li>
				<div class="port-3 effect-3">
				<a href="<?php echo $list[$i]['href'];?>" target="_self">
					<div class="image-box">
						<img src="<?php echo $img?>" alt="<?php echo $list[$i]['subject']?>">
					</div>
					<div class="text-desc">
						<h3><?php echo mb_strimwidth($list[$i]['subject'], '0', '15', '', 'utf-8');?></h3>
						<p><?php echo mb_strimwidth($list[$i]['wr_content'], '0', '145', '', 'utf-8');?></p>
						<a href="<?php echo $list[$i]['href'];?>" class="btn1">Read More</a>
					</div></a>
				</div>
			</li>
		<?}?>
		</ul>
	</div>
</div>
