

CREATE TABLE `g5_auth` (
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `au_menu` varchar(20) NOT NULL DEFAULT '',
  `au_auth` set('r','w','d') NOT NULL DEFAULT '',
  PRIMARY KEY (`mb_id`,`au_menu`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_autosave` (
  `as_id` int(11) NOT NULL AUTO_INCREMENT,
  `mb_id` varchar(20) NOT NULL,
  `as_uid` bigint(20) unsigned NOT NULL,
  `as_subject` varchar(255) NOT NULL,
  `as_content` text NOT NULL,
  `as_datetime` datetime NOT NULL,
  PRIMARY KEY (`as_id`),
  UNIQUE KEY `as_uid` (`as_uid`),
  KEY `mb_id` (`mb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_board` (
  `bo_table` varchar(20) NOT NULL DEFAULT '',
  `gr_id` varchar(255) NOT NULL DEFAULT '',
  `bo_subject` varchar(255) NOT NULL DEFAULT '',
  `bo_mobile_subject` varchar(255) NOT NULL DEFAULT '',
  `bo_device` enum('both','pc','mobile') NOT NULL DEFAULT 'both',
  `bo_admin` varchar(255) NOT NULL DEFAULT '',
  `bo_list_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_read_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_write_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_reply_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_comment_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_upload_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_download_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_html_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_link_level` tinyint(4) NOT NULL DEFAULT '0',
  `bo_count_delete` tinyint(4) NOT NULL DEFAULT '0',
  `bo_count_modify` tinyint(4) NOT NULL DEFAULT '0',
  `bo_read_point` int(11) NOT NULL DEFAULT '0',
  `bo_write_point` int(11) NOT NULL DEFAULT '0',
  `bo_comment_point` int(11) NOT NULL DEFAULT '0',
  `bo_download_point` int(11) NOT NULL DEFAULT '0',
  `bo_use_category` tinyint(4) NOT NULL DEFAULT '0',
  `bo_category_list` text NOT NULL,
  `bo_use_sideview` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_file_content` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_secret` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_dhtml_editor` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_rss_view` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_good` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_nogood` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_name` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_signature` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_ip_view` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_list_view` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_list_file` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_list_content` tinyint(4) NOT NULL DEFAULT '0',
  `bo_table_width` int(11) NOT NULL DEFAULT '0',
  `bo_subject_len` int(11) NOT NULL DEFAULT '0',
  `bo_mobile_subject_len` int(11) NOT NULL DEFAULT '0',
  `bo_page_rows` int(11) NOT NULL DEFAULT '0',
  `bo_mobile_page_rows` int(11) NOT NULL DEFAULT '0',
  `bo_new` int(11) NOT NULL DEFAULT '0',
  `bo_hot` int(11) NOT NULL DEFAULT '0',
  `bo_image_width` int(11) NOT NULL DEFAULT '0',
  `bo_skin` varchar(255) NOT NULL DEFAULT '',
  `bo_mobile_skin` varchar(255) NOT NULL DEFAULT '',
  `bo_include_head` varchar(255) NOT NULL DEFAULT '',
  `bo_include_tail` varchar(255) NOT NULL DEFAULT '',
  `bo_content_head` text NOT NULL,
  `bo_mobile_content_head` text NOT NULL,
  `bo_content_tail` text NOT NULL,
  `bo_mobile_content_tail` text NOT NULL,
  `bo_insert_content` text NOT NULL,
  `bo_gallery_cols` int(11) NOT NULL DEFAULT '0',
  `bo_gallery_width` int(11) NOT NULL DEFAULT '0',
  `bo_gallery_height` int(11) NOT NULL DEFAULT '0',
  `bo_mobile_gallery_width` int(11) NOT NULL DEFAULT '0',
  `bo_mobile_gallery_height` int(11) NOT NULL DEFAULT '0',
  `bo_upload_size` int(11) NOT NULL DEFAULT '0',
  `bo_reply_order` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_search` tinyint(4) NOT NULL DEFAULT '0',
  `bo_order` int(11) NOT NULL DEFAULT '0',
  `bo_count_write` int(11) NOT NULL DEFAULT '0',
  `bo_count_comment` int(11) NOT NULL DEFAULT '0',
  `bo_write_min` int(11) NOT NULL DEFAULT '0',
  `bo_write_max` int(11) NOT NULL DEFAULT '0',
  `bo_comment_min` int(11) NOT NULL DEFAULT '0',
  `bo_comment_max` int(11) NOT NULL DEFAULT '0',
  `bo_notice` text NOT NULL,
  `bo_upload_count` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_email` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_cert` enum('','cert','adult','hp-cert','hp-adult') NOT NULL DEFAULT '',
  `bo_use_sns` tinyint(4) NOT NULL DEFAULT '0',
  `bo_use_captcha` tinyint(4) NOT NULL DEFAULT '0',
  `bo_sort_field` varchar(255) NOT NULL DEFAULT '',
  `bo_1_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_2_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_3_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_4_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_5_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_6_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_7_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_8_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_9_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_10_subj` varchar(255) NOT NULL DEFAULT '',
  `bo_1` varchar(255) NOT NULL DEFAULT '',
  `bo_2` varchar(255) NOT NULL DEFAULT '',
  `bo_3` varchar(255) NOT NULL DEFAULT '',
  `bo_4` varchar(255) NOT NULL DEFAULT '',
  `bo_5` varchar(255) NOT NULL DEFAULT '',
  `bo_6` varchar(255) NOT NULL DEFAULT '',
  `bo_7` varchar(255) NOT NULL DEFAULT '',
  `bo_8` varchar(255) NOT NULL DEFAULT '',
  `bo_9` varchar(255) NOT NULL DEFAULT '',
  `bo_10` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`bo_table`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_board VALUES("notice","community","????","","both","","1","1","1","1","1","1","1","1","1","1","1","-1","5","1","-20","0","","0","0","0","1","0","0","0","0","0","0","0","0","0","100","60","30","15","15","24","100","835","theme/basic","theme/basic","_head.php","_tail.php","","","","","","4","202","150","125","100","1048576","1","0","0","2","0","0","0","0","0","","2","0","","0","0","","","","","","","","","","","","","","","","","","","","","");
INSERT INTO g5_board VALUES("qa","community","????","","both","","1","1","1","1","1","1","1","1","1","1","1","-1","5","1","-20","0","","0","0","0","1","0","0","0","0","0","0","0","0","0","100","60","30","15","15","24","100","835","theme/basic_KIN","theme/basic","_head.php","_tail.php","","","","","","4","202","150","125","100","1048576","1","0","0","1","1","0","0","0","0","","2","0","","0","0","","","","","","","","","","","","","","","","","","","","","");
INSERT INTO g5_board VALUES("free","community","?????","","both","","1","1","1","1","1","1","1","1","1","1","1","-1","5","1","-20","0","","0","0","0","1","0","0","0","0","0","0","0","0","0","100","60","30","15","15","24","100","835","theme/tax","theme/basic","_head.php","_tail.php","","","","","","4","202","150","125","100","50048576","1","0","0","1","0","0","0","0","0","","2","0","","0","0","","","","","","","","","","","","","","","","","","","","","");
INSERT INTO g5_board VALUES("gallery","community","???","","both","","1","1","1","1","1","1","1","1","1","1","1","-1","5","1","-20","0","","0","0","0","1","0","0","0","0","0","0","0","0","0","100","60","30","15","15","24","100","835","theme/181206gallery","theme/gallery","_head.php","_tail.php","","","","","","4","202","150","125","100","1048576","1","0","0","9","0","0","0","0","0","","2","0","","0","0","","","","","","","","","","","","","","","","","","","","","");
INSERT INTO g5_board VALUES("pdfv","community","pdf view","","both","","1","1","1","1","1","1","1","1","1","1","1","-1","5","1","-20","0","","0","0","0","1","0","0","0","0","0","0","0","0","0","100","60","30","15","15","24","100","835","theme/pdfv","theme/pdfv","_head.php","_tail.php","","","","","","4","202","150","125","100","30048576","1","0","0","1","0","0","0","0","0","","1","0","","0","0","","","","","","","","","","","","","","","","","","","","","");
INSERT INTO g5_board VALUES("cert","community","???????","","both","","1","1","1","1","1","1","1","1","1","1","1","-1","5","1","-20","0","","0","0","0","1","0","0","0","0","0","0","0","0","0","100","60","30","15","15","24","100","835","theme/cert","theme/basic","_head.php","_tail.php","","","","","","4","202","150","125","100","50048576","1","0","0","2","0","0","0","0","0","","2","0","","0","0","","","","","","","","","","","","","","","","","","","","","");
INSERT INTO g5_board VALUES("slideout_title","community","SlideOut-title","","both","","1","1","1","1","1","1","1","1","1","1","1","-1","5","1","-20","0","","0","0","0","1","0","0","0","0","0","0","0","0","0","100","60","30","15","15","24","100","835","theme/slideout-title","theme/gallery","_head.php","_tail.php","","","","","","4","202","150","125","100","1048576","1","0","0","9","0","0","0","0","0","","2","0","","0","0","","","","","","","","","","","","","","","","","","","","","");





CREATE TABLE `g5_board_file` (
  `bo_table` varchar(20) NOT NULL DEFAULT '',
  `wr_id` int(11) NOT NULL DEFAULT '0',
  `bf_no` int(11) NOT NULL DEFAULT '0',
  `bf_source` varchar(255) NOT NULL DEFAULT '',
  `bf_file` varchar(255) NOT NULL DEFAULT '',
  `bf_download` int(11) NOT NULL,
  `bf_content` text NOT NULL,
  `bf_filesize` int(11) NOT NULL DEFAULT '0',
  `bf_width` int(11) NOT NULL DEFAULT '0',
  `bf_height` smallint(6) NOT NULL DEFAULT '0',
  `bf_type` tinyint(4) NOT NULL DEFAULT '0',
  `bf_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`bo_table`,`wr_id`,`bf_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_board_file VALUES("gallery","3","0","bread-breakfast-delicious-916904.jpg","2130706433_1e6rxOqi_93b934137398f7f0278a0d015c466c393d9a0df4.jpg","0","","540222","2305","1537","2","2019-01-25 23:45:10");
INSERT INTO g5_board_file VALUES("gallery","4","0","breakfast-snack.jpg","2130706433_V4yr29ju_ade84cde387c387c159ba040dacfc520e6a10df1.jpg","0","","1148159","3000","1999","2","2019-01-25 23:45:24");
INSERT INTO g5_board_file VALUES("gallery","5","0","close-up-cook-cooking-970106.jpg","2130706433_hxPal3NH_57a1c6f2914604ab33a6ee6531971040b8e41891.jpg","0","","1269719","2608","1738","2","2019-01-26 00:26:23");
INSERT INTO g5_board_file VALUES("gallery","6","0","mozzarella-salad.jpg","2130706433_liqcRYCd_b72f41d9d885f3686d5b385e25a2d87e4012225a.jpg","0","","244073","1000","666","2","2019-01-26 00:26:32");
INSERT INTO g5_board_file VALUES("gallery","7","0","pasta-plate.jpg","2130706433_aNhyCBx9_22c29428a57d4361db16e5d95845af54521989f4.jpg","0","","402175","1032","688","2","2019-01-26 00:27:19");
INSERT INTO g5_board_file VALUES("gallery","8","0","spicy-korean.jpg","2130706433_S8PjImJC_210d999e828963ee3766a2965a2a2bcdac821381.jpg","0","","287585","1000","666","2","2019-01-26 00:27:26");
INSERT INTO g5_board_file VALUES("gallery","9","0","pasta-fork.jpg","2130706433_wlbyhqUf_e099d8470b9a08406eb4302cb2ddbee0c198c029.jpg","0","","613031","1802","1201","2","2019-01-26 00:27:34");
INSERT INTO g5_board_file VALUES("pdfv","1","0","sample.pdf","2130706433_UTmbE6tp_aa458eac25dc7d333723d0a3fe847cf313afd883.pdf","0","","433994","0","0","0","2019-01-26 21:38:09");
INSERT INTO g5_board_file VALUES("gallery","10","0","sushi-red-plate.jpg","2130706433_NpuByfeD_b8a583147910305596bd2065871651d284ad282d.jpg","0","","654694","1549","1032","2","2019-01-27 15:16:50");
INSERT INTO g5_board_file VALUES("gallery","11","0","Dessert_13.jpg","2130706433_a7TIRq1G_85f53e691da8716ae4298ef404af716299f4f91c.jpg","0","","120467","800","600","2","2019-01-27 15:17:41");
INSERT INTO g5_board_file VALUES("slideout_title","3","0","bread-breakfast-delicious-916904.jpg","2130706433_1e6rxOqi_93b934137398f7f0278a0d015c466c393d9a0df4.jpg","0","","540222","2305","1537","2","2019-01-25 23:45:10");
INSERT INTO g5_board_file VALUES("slideout_title","4","0","breakfast-snack.jpg","2130706433_V4yr29ju_ade84cde387c387c159ba040dacfc520e6a10df1.jpg","0","","1148159","3000","1999","2","2019-01-25 23:45:24");
INSERT INTO g5_board_file VALUES("slideout_title","5","0","close-up-cook-cooking-970106.jpg","2130706433_hxPal3NH_57a1c6f2914604ab33a6ee6531971040b8e41891.jpg","0","","1269719","2608","1738","2","2019-01-26 00:26:23");
INSERT INTO g5_board_file VALUES("slideout_title","6","0","mozzarella-salad.jpg","2130706433_liqcRYCd_b72f41d9d885f3686d5b385e25a2d87e4012225a.jpg","0","","244073","1000","666","2","2019-01-26 00:26:32");
INSERT INTO g5_board_file VALUES("slideout_title","7","0","pasta-plate.jpg","2130706433_aNhyCBx9_22c29428a57d4361db16e5d95845af54521989f4.jpg","0","","402175","1032","688","2","2019-01-26 00:27:19");
INSERT INTO g5_board_file VALUES("slideout_title","8","0","spicy-korean.jpg","2130706433_S8PjImJC_210d999e828963ee3766a2965a2a2bcdac821381.jpg","0","","287585","1000","666","2","2019-01-26 00:27:26");
INSERT INTO g5_board_file VALUES("slideout_title","9","0","pasta-fork.jpg","2130706433_wlbyhqUf_e099d8470b9a08406eb4302cb2ddbee0c198c029.jpg","0","","613031","1802","1201","2","2019-01-26 00:27:34");
INSERT INTO g5_board_file VALUES("slideout_title","10","0","sushi-red-plate.jpg","2130706433_NpuByfeD_b8a583147910305596bd2065871651d284ad282d.jpg","0","","654694","1549","1032","2","2019-01-27 15:16:50");
INSERT INTO g5_board_file VALUES("slideout_title","11","0","Dessert_13.jpg","2130706433_a7TIRq1G_85f53e691da8716ae4298ef404af716299f4f91c.jpg","0","","120467","800","600","2","2019-01-27 15:17:41");





CREATE TABLE `g5_board_good` (
  `bg_id` int(11) NOT NULL AUTO_INCREMENT,
  `bo_table` varchar(20) NOT NULL DEFAULT '',
  `wr_id` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `bg_flag` varchar(255) NOT NULL DEFAULT '',
  `bg_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`bg_id`),
  UNIQUE KEY `fkey1` (`bo_table`,`wr_id`,`mb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_board_new` (
  `bn_id` int(11) NOT NULL AUTO_INCREMENT,
  `bo_table` varchar(20) NOT NULL DEFAULT '',
  `wr_id` int(11) NOT NULL DEFAULT '0',
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `bn_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`bn_id`),
  KEY `mb_id` (`mb_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;






CREATE TABLE `g5_cert_history` (
  `cr_id` int(11) NOT NULL AUTO_INCREMENT,
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `cr_company` varchar(255) NOT NULL DEFAULT '',
  `cr_method` varchar(255) NOT NULL DEFAULT '',
  `cr_ip` varchar(255) NOT NULL DEFAULT '',
  `cr_date` date NOT NULL DEFAULT '0000-00-00',
  `cr_time` time NOT NULL DEFAULT '00:00:00',
  PRIMARY KEY (`cr_id`),
  KEY `mb_id` (`mb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_config` (
  `cf_title` varchar(255) NOT NULL DEFAULT '',
  `cf_theme` varchar(255) NOT NULL DEFAULT '',
  `cf_admin` varchar(255) NOT NULL DEFAULT '',
  `cf_admin_email` varchar(255) NOT NULL DEFAULT '',
  `cf_admin_email_name` varchar(255) NOT NULL DEFAULT '',
  `cf_add_script` text NOT NULL,
  `cf_use_point` tinyint(4) NOT NULL DEFAULT '0',
  `cf_point_term` int(11) NOT NULL DEFAULT '0',
  `cf_use_copy_log` tinyint(4) NOT NULL DEFAULT '0',
  `cf_use_email_certify` tinyint(4) NOT NULL DEFAULT '0',
  `cf_login_point` int(11) NOT NULL DEFAULT '0',
  `cf_cut_name` tinyint(4) NOT NULL DEFAULT '0',
  `cf_nick_modify` int(11) NOT NULL DEFAULT '0',
  `cf_new_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_new_rows` int(11) NOT NULL DEFAULT '0',
  `cf_search_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_connect_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_faq_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_read_point` int(11) NOT NULL DEFAULT '0',
  `cf_write_point` int(11) NOT NULL DEFAULT '0',
  `cf_comment_point` int(11) NOT NULL DEFAULT '0',
  `cf_download_point` int(11) NOT NULL DEFAULT '0',
  `cf_write_pages` int(11) NOT NULL DEFAULT '0',
  `cf_mobile_pages` int(11) NOT NULL DEFAULT '0',
  `cf_link_target` varchar(255) NOT NULL DEFAULT '',
  `cf_delay_sec` int(11) NOT NULL DEFAULT '0',
  `cf_filter` text NOT NULL,
  `cf_possible_ip` text NOT NULL,
  `cf_intercept_ip` text NOT NULL,
  `cf_analytics` text NOT NULL,
  `cf_add_meta` text NOT NULL,
  `cf_syndi_token` varchar(255) NOT NULL,
  `cf_syndi_except` text NOT NULL,
  `cf_member_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_use_homepage` tinyint(4) NOT NULL DEFAULT '0',
  `cf_req_homepage` tinyint(4) NOT NULL DEFAULT '0',
  `cf_use_tel` tinyint(4) NOT NULL DEFAULT '0',
  `cf_req_tel` tinyint(4) NOT NULL DEFAULT '0',
  `cf_use_hp` tinyint(4) NOT NULL DEFAULT '0',
  `cf_req_hp` tinyint(4) NOT NULL DEFAULT '0',
  `cf_use_addr` tinyint(4) NOT NULL DEFAULT '0',
  `cf_req_addr` tinyint(4) NOT NULL DEFAULT '0',
  `cf_use_signature` tinyint(4) NOT NULL DEFAULT '0',
  `cf_req_signature` tinyint(4) NOT NULL DEFAULT '0',
  `cf_use_profile` tinyint(4) NOT NULL DEFAULT '0',
  `cf_req_profile` tinyint(4) NOT NULL DEFAULT '0',
  `cf_register_level` tinyint(4) NOT NULL DEFAULT '0',
  `cf_register_point` int(11) NOT NULL DEFAULT '0',
  `cf_icon_level` tinyint(4) NOT NULL DEFAULT '0',
  `cf_use_recommend` tinyint(4) NOT NULL DEFAULT '0',
  `cf_recommend_point` int(11) NOT NULL DEFAULT '0',
  `cf_leave_day` int(11) NOT NULL DEFAULT '0',
  `cf_search_part` int(11) NOT NULL DEFAULT '0',
  `cf_email_use` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_wr_super_admin` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_wr_group_admin` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_wr_board_admin` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_wr_write` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_wr_comment_all` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_mb_super_admin` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_mb_member` tinyint(4) NOT NULL DEFAULT '0',
  `cf_email_po_super_admin` tinyint(4) NOT NULL DEFAULT '0',
  `cf_prohibit_id` text NOT NULL,
  `cf_prohibit_email` text NOT NULL,
  `cf_new_del` int(11) NOT NULL DEFAULT '0',
  `cf_memo_del` int(11) NOT NULL DEFAULT '0',
  `cf_visit_del` int(11) NOT NULL DEFAULT '0',
  `cf_popular_del` int(11) NOT NULL DEFAULT '0',
  `cf_optimize_date` date NOT NULL DEFAULT '0000-00-00',
  `cf_use_member_icon` tinyint(4) NOT NULL DEFAULT '0',
  `cf_member_icon_size` int(11) NOT NULL DEFAULT '0',
  `cf_member_icon_width` int(11) NOT NULL DEFAULT '0',
  `cf_member_icon_height` int(11) NOT NULL DEFAULT '0',
  `cf_member_img_size` int(11) NOT NULL DEFAULT '0',
  `cf_member_img_width` int(11) NOT NULL DEFAULT '0',
  `cf_member_img_height` int(11) NOT NULL DEFAULT '0',
  `cf_login_minutes` int(11) NOT NULL DEFAULT '0',
  `cf_image_extension` varchar(255) NOT NULL DEFAULT '',
  `cf_flash_extension` varchar(255) NOT NULL DEFAULT '',
  `cf_movie_extension` varchar(255) NOT NULL DEFAULT '',
  `cf_formmail_is_member` tinyint(4) NOT NULL DEFAULT '0',
  `cf_page_rows` int(11) NOT NULL DEFAULT '0',
  `cf_mobile_page_rows` int(11) NOT NULL DEFAULT '0',
  `cf_visit` varchar(255) NOT NULL DEFAULT '',
  `cf_max_po_id` int(11) NOT NULL DEFAULT '0',
  `cf_stipulation` text NOT NULL,
  `cf_privacy` text NOT NULL,
  `cf_open_modify` int(11) NOT NULL DEFAULT '0',
  `cf_memo_send_point` int(11) NOT NULL DEFAULT '0',
  `cf_mobile_new_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_mobile_search_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_mobile_connect_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_mobile_faq_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_mobile_member_skin` varchar(255) NOT NULL DEFAULT '',
  `cf_captcha_mp3` varchar(255) NOT NULL DEFAULT '',
  `cf_editor` varchar(255) NOT NULL DEFAULT '',
  `cf_cert_use` tinyint(4) NOT NULL DEFAULT '0',
  `cf_cert_ipin` varchar(255) NOT NULL DEFAULT '',
  `cf_cert_hp` varchar(255) NOT NULL DEFAULT '',
  `cf_cert_kcb_cd` varchar(255) NOT NULL DEFAULT '',
  `cf_cert_kcp_cd` varchar(255) NOT NULL DEFAULT '',
  `cf_lg_mid` varchar(255) NOT NULL DEFAULT '',
  `cf_lg_mert_key` varchar(255) NOT NULL DEFAULT '',
  `cf_cert_limit` int(11) NOT NULL DEFAULT '0',
  `cf_cert_req` tinyint(4) NOT NULL DEFAULT '0',
  `cf_sms_use` varchar(255) NOT NULL DEFAULT '',
  `cf_sms_type` varchar(10) NOT NULL DEFAULT '',
  `cf_icode_id` varchar(255) NOT NULL DEFAULT '',
  `cf_icode_pw` varchar(255) NOT NULL DEFAULT '',
  `cf_icode_server_ip` varchar(255) NOT NULL DEFAULT '',
  `cf_icode_server_port` varchar(255) NOT NULL DEFAULT '',
  `cf_googl_shorturl_apikey` varchar(255) NOT NULL DEFAULT '',
  `cf_social_login_use` tinyint(4) NOT NULL DEFAULT '0',
  `cf_social_servicelist` varchar(255) NOT NULL DEFAULT '',
  `cf_payco_clientid` varchar(100) NOT NULL DEFAULT '',
  `cf_payco_secret` varchar(100) NOT NULL DEFAULT '',
  `cf_facebook_appid` varchar(255) NOT NULL,
  `cf_facebook_secret` varchar(255) NOT NULL,
  `cf_twitter_key` varchar(255) NOT NULL,
  `cf_twitter_secret` varchar(255) NOT NULL,
  `cf_google_clientid` varchar(100) NOT NULL DEFAULT '',
  `cf_google_secret` varchar(100) NOT NULL DEFAULT '',
  `cf_naver_clientid` varchar(100) NOT NULL DEFAULT '',
  `cf_naver_secret` varchar(100) NOT NULL DEFAULT '',
  `cf_kakao_rest_key` varchar(100) NOT NULL DEFAULT '',
  `cf_kakao_client_secret` varchar(100) NOT NULL DEFAULT '',
  `cf_kakao_js_apikey` varchar(255) NOT NULL,
  `cf_captcha` varchar(100) NOT NULL DEFAULT '',
  `cf_recaptcha_site_key` varchar(100) NOT NULL DEFAULT '',
  `cf_recaptcha_secret_key` varchar(100) NOT NULL DEFAULT '',
  `cf_1_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_2_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_3_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_4_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_5_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_6_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_7_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_8_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_9_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_10_subj` varchar(255) NOT NULL DEFAULT '',
  `cf_1` varchar(255) NOT NULL DEFAULT '',
  `cf_2` varchar(255) NOT NULL DEFAULT '',
  `cf_3` varchar(255) NOT NULL DEFAULT '',
  `cf_4` varchar(255) NOT NULL DEFAULT '',
  `cf_5` varchar(255) NOT NULL DEFAULT '',
  `cf_6` varchar(255) NOT NULL DEFAULT '',
  `cf_7` varchar(255) NOT NULL DEFAULT '',
  `cf_8` varchar(255) NOT NULL DEFAULT '',
  `cf_9` varchar(255) NOT NULL DEFAULT '',
  `cf_10` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_config VALUES("????","basic","admin","admin@domain.com","???","","1","0","1","0","100","15","60","theme/basic","15","theme/basic","theme/basic","theme/basic","0","0","0","0","10","5","_blank","30","18?,18?,18??,18?,18?,18?,18?,??,??,??,??,???,???,???,???,??,??,???,???,??,???,???,??,?,??,???,???,???,??,??,???,???,???,???,???,???,??,??,??,??,??,???,??,??,??,??,??,???,??,??,???,???,???,??,???,??,??,??,??,?8,??,??,??,??,??,??,??,?,??,???,??,??,??,??,??,??,?8,??,??,??,??,???,???,???,???,???,??,???,??,??,???,??,??,??,?,???,???,??,??,??,??,???,??,??,???,???,???,???,??,??,??,??,?,?,?,??,??,??,??,??,??,???,??,?,??,??,??,????","","","","","","","theme/basic","0","0","0","0","0","0","0","0","0","0","0","0","2","1000","2","0","0","30","10000","1","0","0","0","0","0","0","0","0","admin,administrator,???,???,???,???,webmaster,????,sysop,??,??,manager,???,???,root,??,su,guest,???","","30","180","180","180","2019-05-03","2","5000","22","22","50000","60","60","10","gif|jpg|jpeg|png","swf","asx|asf|wmv|wma|mpg|mpeg|mov|avi|mp3","1","15","15","??:4,??:5,??:12,??:73","0","?? ????? ?? ??????? ?????.","?? ????? ?? ????????? ?????.","0","500","theme/basic","theme/basic","theme/basic","theme/basic","theme/basic","basic","smarteditor2","0","","","","","","","2","0","","","","","211.172.232.124","7295","","0","","","","","","","","","","","","","","","kcaptcha","","","","","","","","","","","","","","","","","","","","","","");





CREATE TABLE `g5_content` (
  `co_id` varchar(20) NOT NULL DEFAULT '',
  `co_html` tinyint(4) NOT NULL DEFAULT '0',
  `co_subject` varchar(255) NOT NULL DEFAULT '',
  `co_content` longtext NOT NULL,
  `co_mobile_content` longtext NOT NULL,
  `co_skin` varchar(255) NOT NULL DEFAULT '',
  `co_mobile_skin` varchar(255) NOT NULL DEFAULT '',
  `co_tag_filter_use` tinyint(4) NOT NULL DEFAULT '0',
  `co_hit` int(11) NOT NULL DEFAULT '0',
  `co_include_head` varchar(255) NOT NULL,
  `co_include_tail` varchar(255) NOT NULL,
  PRIMARY KEY (`co_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_content VALUES("company","1","????","<p align=center><b>????? ?? ??? ??????.</b></p>","","","","0","0","","");
INSERT INTO g5_content VALUES("privacy","1","???? ????","<p align=center><b>???? ????? ?? ??? ??????.</b></p>","","","","0","0","","");
INSERT INTO g5_content VALUES("provision","1","??? ????","<p align=center><b>??? ????? ?? ??? ??????.</b></p>","","","","0","0","","");





CREATE TABLE `g5_faq` (
  `fa_id` int(11) NOT NULL AUTO_INCREMENT,
  `fm_id` int(11) NOT NULL DEFAULT '0',
  `fa_subject` text NOT NULL,
  `fa_content` text NOT NULL,
  `fa_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fa_id`),
  KEY `fm_id` (`fm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_faq_master` (
  `fm_id` int(11) NOT NULL AUTO_INCREMENT,
  `fm_subject` varchar(255) NOT NULL DEFAULT '',
  `fm_head_html` text NOT NULL,
  `fm_tail_html` text NOT NULL,
  `fm_mobile_head_html` text NOT NULL,
  `fm_mobile_tail_html` text NOT NULL,
  `fm_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fm_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO g5_faq_master VALUES("1","????? ??","","","","","0");





CREATE TABLE `g5_group` (
  `gr_id` varchar(10) NOT NULL DEFAULT '',
  `gr_subject` varchar(255) NOT NULL DEFAULT '',
  `gr_device` enum('both','pc','mobile') NOT NULL DEFAULT 'both',
  `gr_admin` varchar(255) NOT NULL DEFAULT '',
  `gr_use_access` tinyint(4) NOT NULL DEFAULT '0',
  `gr_order` int(11) NOT NULL DEFAULT '0',
  `gr_1_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_2_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_3_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_4_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_5_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_6_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_7_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_8_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_9_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_10_subj` varchar(255) NOT NULL DEFAULT '',
  `gr_1` varchar(255) NOT NULL DEFAULT '',
  `gr_2` varchar(255) NOT NULL DEFAULT '',
  `gr_3` varchar(255) NOT NULL DEFAULT '',
  `gr_4` varchar(255) NOT NULL DEFAULT '',
  `gr_5` varchar(255) NOT NULL DEFAULT '',
  `gr_6` varchar(255) NOT NULL DEFAULT '',
  `gr_7` varchar(255) NOT NULL DEFAULT '',
  `gr_8` varchar(255) NOT NULL DEFAULT '',
  `gr_9` varchar(255) NOT NULL DEFAULT '',
  `gr_10` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`gr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_group VALUES("community","????","both","","0","0","","","","","","","","","","","","","","","","","","","","");





CREATE TABLE `g5_group_member` (
  `gm_id` int(11) NOT NULL AUTO_INCREMENT,
  `gr_id` varchar(255) NOT NULL DEFAULT '',
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `gm_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`gm_id`),
  KEY `gr_id` (`gr_id`),
  KEY `mb_id` (`mb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_login` (
  `lo_ip` varchar(255) NOT NULL DEFAULT '',
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `lo_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lo_location` text NOT NULL,
  `lo_url` text NOT NULL,
  PRIMARY KEY (`lo_ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_login VALUES("127.0.0.1","admin","2019-05-03 21:03:22","DB ????","");





CREATE TABLE `g5_mail` (
  `ma_id` int(11) NOT NULL AUTO_INCREMENT,
  `ma_subject` varchar(255) NOT NULL DEFAULT '',
  `ma_content` mediumtext NOT NULL,
  `ma_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ma_ip` varchar(255) NOT NULL DEFAULT '',
  `ma_last_option` text NOT NULL,
  PRIMARY KEY (`ma_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_member` (
  `mb_no` int(11) NOT NULL AUTO_INCREMENT,
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `mb_password` varchar(255) NOT NULL DEFAULT '',
  `mb_name` varchar(255) NOT NULL DEFAULT '',
  `mb_nick` varchar(255) NOT NULL DEFAULT '',
  `mb_nick_date` date NOT NULL DEFAULT '0000-00-00',
  `mb_email` varchar(255) NOT NULL DEFAULT '',
  `mb_homepage` varchar(255) NOT NULL DEFAULT '',
  `mb_level` tinyint(4) NOT NULL DEFAULT '0',
  `mb_sex` char(1) NOT NULL DEFAULT '',
  `mb_birth` varchar(255) NOT NULL DEFAULT '',
  `mb_tel` varchar(255) NOT NULL DEFAULT '',
  `mb_hp` varchar(255) NOT NULL DEFAULT '',
  `mb_certify` varchar(20) NOT NULL DEFAULT '',
  `mb_adult` tinyint(4) NOT NULL DEFAULT '0',
  `mb_dupinfo` varchar(255) NOT NULL DEFAULT '',
  `mb_zip1` char(3) NOT NULL DEFAULT '',
  `mb_zip2` char(3) NOT NULL DEFAULT '',
  `mb_addr1` varchar(255) NOT NULL DEFAULT '',
  `mb_addr2` varchar(255) NOT NULL DEFAULT '',
  `mb_addr3` varchar(255) NOT NULL DEFAULT '',
  `mb_addr_jibeon` varchar(255) NOT NULL DEFAULT '',
  `mb_signature` text NOT NULL,
  `mb_recommend` varchar(255) NOT NULL DEFAULT '',
  `mb_point` int(11) NOT NULL DEFAULT '0',
  `mb_today_login` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mb_login_ip` varchar(255) NOT NULL DEFAULT '',
  `mb_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mb_ip` varchar(255) NOT NULL DEFAULT '',
  `mb_leave_date` varchar(8) NOT NULL DEFAULT '',
  `mb_intercept_date` varchar(8) NOT NULL DEFAULT '',
  `mb_email_certify` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mb_email_certify2` varchar(255) NOT NULL DEFAULT '',
  `mb_memo` text NOT NULL,
  `mb_lost_certify` varchar(255) NOT NULL,
  `mb_mailling` tinyint(4) NOT NULL DEFAULT '0',
  `mb_sms` tinyint(4) NOT NULL DEFAULT '0',
  `mb_open` tinyint(4) NOT NULL DEFAULT '0',
  `mb_open_date` date NOT NULL DEFAULT '0000-00-00',
  `mb_profile` text NOT NULL,
  `mb_memo_call` varchar(255) NOT NULL DEFAULT '',
  `mb_1` varchar(255) NOT NULL DEFAULT '',
  `mb_2` varchar(255) NOT NULL DEFAULT '',
  `mb_3` varchar(255) NOT NULL DEFAULT '',
  `mb_4` varchar(255) NOT NULL DEFAULT '',
  `mb_5` varchar(255) NOT NULL DEFAULT '',
  `mb_6` varchar(255) NOT NULL DEFAULT '',
  `mb_7` varchar(255) NOT NULL DEFAULT '',
  `mb_8` varchar(255) NOT NULL DEFAULT '',
  `mb_9` varchar(255) NOT NULL DEFAULT '',
  `mb_10` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`mb_no`),
  UNIQUE KEY `mb_id` (`mb_id`),
  KEY `mb_today_login` (`mb_today_login`),
  KEY `mb_datetime` (`mb_datetime`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO g5_member VALUES("1","admin","*91F57D7E4A62AC56F0BD70E85619EB0BC576459F","?????","?????","0000-00-00","admin@domain.com","","10","","","","","","0","","","","","","","","","","781","2019-05-03 16:22:28","127.0.0.1","2019-01-25 02:09:01","127.0.0.1","","","2019-01-25 02:09:01","","","","1","0","1","0000-00-00","","","","","","","","","","","","");





CREATE TABLE `g5_member_social_profiles` (
  `mp_no` int(11) NOT NULL AUTO_INCREMENT,
  `mb_id` varchar(255) NOT NULL DEFAULT '',
  `provider` varchar(50) NOT NULL DEFAULT '',
  `object_sha` varchar(45) NOT NULL DEFAULT '',
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `profileurl` varchar(255) NOT NULL DEFAULT '',
  `photourl` varchar(255) NOT NULL DEFAULT '',
  `displayname` varchar(150) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `mp_register_day` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mp_latest_day` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `mp_no` (`mp_no`),
  KEY `mb_id` (`mb_id`),
  KEY `provider` (`provider`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_memo` (
  `me_id` int(11) NOT NULL DEFAULT '0',
  `me_recv_mb_id` varchar(20) NOT NULL DEFAULT '',
  `me_send_mb_id` varchar(20) NOT NULL DEFAULT '',
  `me_send_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `me_read_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `me_memo` text NOT NULL,
  PRIMARY KEY (`me_id`),
  KEY `me_recv_mb_id` (`me_recv_mb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_menu` (
  `me_id` int(11) NOT NULL AUTO_INCREMENT,
  `me_code` varchar(255) NOT NULL DEFAULT '',
  `me_name` varchar(255) NOT NULL DEFAULT '',
  `me_link` varchar(255) NOT NULL DEFAULT '',
  `me_target` varchar(255) NOT NULL DEFAULT '',
  `me_order` int(11) NOT NULL DEFAULT '0',
  `me_use` tinyint(4) NOT NULL DEFAULT '0',
  `me_mobile_use` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`me_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO g5_menu VALUES("8","10","????","http://localhost/demo/bbs/content.php?co_id=company","self","1","1","1");
INSERT INTO g5_menu VALUES("9","20","????","http://localhost/demo/bbs/board.php?bo_table=notice","self","0","1","1");
INSERT INTO g5_menu VALUES("10","30","???","http://localhost/demo/bbs/board.php?bo_table=gallery","self","0","1","1");





CREATE TABLE `g5_new_win` (
  `nw_id` int(11) NOT NULL AUTO_INCREMENT,
  `nw_device` varchar(10) NOT NULL DEFAULT 'both',
  `nw_begin_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `nw_end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `nw_disable_hours` int(11) NOT NULL DEFAULT '0',
  `nw_left` int(11) NOT NULL DEFAULT '0',
  `nw_top` int(11) NOT NULL DEFAULT '0',
  `nw_height` int(11) NOT NULL DEFAULT '0',
  `nw_width` int(11) NOT NULL DEFAULT '0',
  `nw_subject` text NOT NULL,
  `nw_content` text NOT NULL,
  `nw_content_html` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nw_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_point` (
  `po_id` int(11) NOT NULL AUTO_INCREMENT,
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `po_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `po_content` varchar(255) NOT NULL DEFAULT '',
  `po_point` int(11) NOT NULL DEFAULT '0',
  `po_use_point` int(11) NOT NULL DEFAULT '0',
  `po_expired` tinyint(4) NOT NULL DEFAULT '0',
  `po_expire_date` date NOT NULL DEFAULT '0000-00-00',
  `po_mb_point` int(11) NOT NULL DEFAULT '0',
  `po_rel_table` varchar(20) NOT NULL DEFAULT '',
  `po_rel_id` varchar(20) NOT NULL DEFAULT '',
  `po_rel_action` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`po_id`),
  KEY `index1` (`mb_id`,`po_rel_table`,`po_rel_id`,`po_rel_action`),
  KEY `index2` (`po_expire_date`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

INSERT INTO g5_point VALUES("1","admin","2019-01-25 02:09:44","2019-01-25 ????","100","0","0","9999-12-31","100","@login","admin","2019-01-25");
INSERT INTO g5_point VALUES("2","admin","2019-01-25 10:57:36","???? 1 ???","5","0","0","9999-12-31","105","notice","1","??");
INSERT INTO g5_point VALUES("3","admin","2019-01-25 10:58:17","???? 2 ???","5","0","0","9999-12-31","110","notice","2","??");
INSERT INTO g5_point VALUES("5","admin","2019-01-25 23:45:10","??? 3 ???","5","0","0","9999-12-31","115","gallery","3","??");
INSERT INTO g5_point VALUES("6","admin","2019-01-25 23:45:24","??? 4 ???","5","0","0","9999-12-31","120","gallery","4","??");
INSERT INTO g5_point VALUES("7","admin","2019-01-25 23:53:41","???? 1 ???","5","0","0","9999-12-31","125","qa","1","??");
INSERT INTO g5_point VALUES("8","admin","2019-01-25 23:57:01","???? 1-2 ????","1","0","0","9999-12-31","126","qa","2","??");
INSERT INTO g5_point VALUES("9","admin","2019-01-26 00:01:33","2019-01-26 ????","100","0","0","9999-12-31","226","@login","admin","2019-01-26");
INSERT INTO g5_point VALUES("10","admin","2019-01-26 00:02:35","????? 1 ???","5","0","0","9999-12-31","231","free","1","??");
INSERT INTO g5_point VALUES("11","admin","2019-01-26 00:26:23","??? 5 ???","5","0","0","9999-12-31","236","gallery","5","??");
INSERT INTO g5_point VALUES("12","admin","2019-01-26 00:26:32","??? 6 ???","5","0","0","9999-12-31","241","gallery","6","??");
INSERT INTO g5_point VALUES("13","admin","2019-01-26 00:27:19","??? 7 ???","5","0","0","9999-12-31","246","gallery","7","??");
INSERT INTO g5_point VALUES("14","admin","2019-01-26 00:27:26","??? 8 ???","5","0","0","9999-12-31","251","gallery","8","??");
INSERT INTO g5_point VALUES("15","admin","2019-01-26 00:27:34","??? 9 ???","5","0","0","9999-12-31","256","gallery","9","??");
INSERT INTO g5_point VALUES("16","admin","2019-01-26 21:38:09","pdf view 1 ???","5","0","0","9999-12-31","261","pdfv","1","??");
INSERT INTO g5_point VALUES("17","admin","2019-01-27 11:36:33","2019-01-27 ????","100","0","0","9999-12-31","361","@login","admin","2019-01-27");
INSERT INTO g5_point VALUES("18","admin","2019-01-27 15:16:50","??? 10 ???","5","0","0","9999-12-31","366","gallery","10","??");
INSERT INTO g5_point VALUES("19","admin","2019-01-27 15:17:41","??? 11 ???","5","0","0","9999-12-31","371","gallery","11","??");
INSERT INTO g5_point VALUES("20","admin","2019-01-29 15:19:46","2019-01-29 ????","100","0","0","9999-12-31","471","@login","admin","2019-01-29");
INSERT INTO g5_point VALUES("21","admin","2019-01-29 15:36:00","??????? 1 ???","5","0","0","9999-12-31","476","cert","1","??");
INSERT INTO g5_point VALUES("22","admin","2019-01-29 17:12:13","??????? 2 ???","5","0","0","9999-12-31","481","cert","2","??");
INSERT INTO g5_point VALUES("23","admin","2019-04-22 21:10:07","2019-04-22 ????","100","0","0","9999-12-31","581","@login","admin","2019-04-22");
INSERT INTO g5_point VALUES("24","admin","2019-04-24 15:28:15","2019-04-24 ????","100","0","0","9999-12-31","681","@login","admin","2019-04-24");
INSERT INTO g5_point VALUES("25","admin","2019-05-03 16:22:28","2019-05-03 ????","100","0","0","9999-12-31","781","@login","admin","2019-05-03");





CREATE TABLE `g5_poll` (
  `po_id` int(11) NOT NULL AUTO_INCREMENT,
  `po_subject` varchar(255) NOT NULL DEFAULT '',
  `po_poll1` varchar(255) NOT NULL DEFAULT '',
  `po_poll2` varchar(255) NOT NULL DEFAULT '',
  `po_poll3` varchar(255) NOT NULL DEFAULT '',
  `po_poll4` varchar(255) NOT NULL DEFAULT '',
  `po_poll5` varchar(255) NOT NULL DEFAULT '',
  `po_poll6` varchar(255) NOT NULL DEFAULT '',
  `po_poll7` varchar(255) NOT NULL DEFAULT '',
  `po_poll8` varchar(255) NOT NULL DEFAULT '',
  `po_poll9` varchar(255) NOT NULL DEFAULT '',
  `po_cnt1` int(11) NOT NULL DEFAULT '0',
  `po_cnt2` int(11) NOT NULL DEFAULT '0',
  `po_cnt3` int(11) NOT NULL DEFAULT '0',
  `po_cnt4` int(11) NOT NULL DEFAULT '0',
  `po_cnt5` int(11) NOT NULL DEFAULT '0',
  `po_cnt6` int(11) NOT NULL DEFAULT '0',
  `po_cnt7` int(11) NOT NULL DEFAULT '0',
  `po_cnt8` int(11) NOT NULL DEFAULT '0',
  `po_cnt9` int(11) NOT NULL DEFAULT '0',
  `po_etc` varchar(255) NOT NULL DEFAULT '',
  `po_level` tinyint(4) NOT NULL DEFAULT '0',
  `po_point` int(11) NOT NULL DEFAULT '0',
  `po_date` date NOT NULL DEFAULT '0000-00-00',
  `po_ips` mediumtext NOT NULL,
  `mb_ids` text NOT NULL,
  PRIMARY KEY (`po_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_poll_etc` (
  `pc_id` int(11) NOT NULL DEFAULT '0',
  `po_id` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `pc_name` varchar(255) NOT NULL DEFAULT '',
  `pc_idea` varchar(255) NOT NULL DEFAULT '',
  `pc_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`pc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_popular` (
  `pp_id` int(11) NOT NULL AUTO_INCREMENT,
  `pp_word` varchar(50) NOT NULL DEFAULT '',
  `pp_date` date NOT NULL DEFAULT '0000-00-00',
  `pp_ip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`pp_id`),
  UNIQUE KEY `index1` (`pp_date`,`pp_word`,`pp_ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_qa_config` (
  `qa_title` varchar(255) NOT NULL DEFAULT '',
  `qa_category` varchar(255) NOT NULL DEFAULT '',
  `qa_skin` varchar(255) NOT NULL DEFAULT '',
  `qa_mobile_skin` varchar(255) NOT NULL DEFAULT '',
  `qa_use_email` tinyint(4) NOT NULL DEFAULT '0',
  `qa_req_email` tinyint(4) NOT NULL DEFAULT '0',
  `qa_use_hp` tinyint(4) NOT NULL DEFAULT '0',
  `qa_req_hp` tinyint(4) NOT NULL DEFAULT '0',
  `qa_use_sms` tinyint(4) NOT NULL DEFAULT '0',
  `qa_send_number` varchar(255) NOT NULL DEFAULT '0',
  `qa_admin_hp` varchar(255) NOT NULL DEFAULT '',
  `qa_admin_email` varchar(255) NOT NULL DEFAULT '',
  `qa_use_editor` tinyint(4) NOT NULL DEFAULT '0',
  `qa_subject_len` int(11) NOT NULL DEFAULT '0',
  `qa_mobile_subject_len` int(11) NOT NULL DEFAULT '0',
  `qa_page_rows` int(11) NOT NULL DEFAULT '0',
  `qa_mobile_page_rows` int(11) NOT NULL DEFAULT '0',
  `qa_image_width` int(11) NOT NULL DEFAULT '0',
  `qa_upload_size` int(11) NOT NULL DEFAULT '0',
  `qa_insert_content` text NOT NULL,
  `qa_include_head` varchar(255) NOT NULL DEFAULT '',
  `qa_include_tail` varchar(255) NOT NULL DEFAULT '',
  `qa_content_head` text NOT NULL,
  `qa_content_tail` text NOT NULL,
  `qa_mobile_content_head` text NOT NULL,
  `qa_mobile_content_tail` text NOT NULL,
  `qa_1_subj` varchar(255) NOT NULL DEFAULT '',
  `qa_2_subj` varchar(255) NOT NULL DEFAULT '',
  `qa_3_subj` varchar(255) NOT NULL DEFAULT '',
  `qa_4_subj` varchar(255) NOT NULL DEFAULT '',
  `qa_5_subj` varchar(255) NOT NULL DEFAULT '',
  `qa_1` varchar(255) NOT NULL DEFAULT '',
  `qa_2` varchar(255) NOT NULL DEFAULT '',
  `qa_3` varchar(255) NOT NULL DEFAULT '',
  `qa_4` varchar(255) NOT NULL DEFAULT '',
  `qa_5` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_qa_config VALUES("1:1??","??|???","theme/basic","theme/basic","1","0","1","0","0","0","","","1","60","30","15","15","600","1048576","","","","","","","","","","","","","","","","","");





CREATE TABLE `g5_qa_content` (
  `qa_id` int(11) NOT NULL AUTO_INCREMENT,
  `qa_num` int(11) NOT NULL DEFAULT '0',
  `qa_parent` int(11) NOT NULL DEFAULT '0',
  `qa_related` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `qa_name` varchar(255) NOT NULL DEFAULT '',
  `qa_email` varchar(255) NOT NULL DEFAULT '',
  `qa_hp` varchar(255) NOT NULL DEFAULT '',
  `qa_type` tinyint(4) NOT NULL DEFAULT '0',
  `qa_category` varchar(255) NOT NULL DEFAULT '',
  `qa_email_recv` tinyint(4) NOT NULL DEFAULT '0',
  `qa_sms_recv` tinyint(4) NOT NULL DEFAULT '0',
  `qa_html` tinyint(4) NOT NULL DEFAULT '0',
  `qa_subject` varchar(255) NOT NULL DEFAULT '',
  `qa_content` text NOT NULL,
  `qa_status` tinyint(4) NOT NULL DEFAULT '0',
  `qa_file1` varchar(255) NOT NULL DEFAULT '',
  `qa_source1` varchar(255) NOT NULL DEFAULT '',
  `qa_file2` varchar(255) NOT NULL DEFAULT '',
  `qa_source2` varchar(255) NOT NULL DEFAULT '',
  `qa_ip` varchar(255) NOT NULL DEFAULT '',
  `qa_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `qa_1` varchar(255) NOT NULL DEFAULT '',
  `qa_2` varchar(255) NOT NULL DEFAULT '',
  `qa_3` varchar(255) NOT NULL DEFAULT '',
  `qa_4` varchar(255) NOT NULL DEFAULT '',
  `qa_5` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`qa_id`),
  KEY `qa_num_parent` (`qa_num`,`qa_parent`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_scrap` (
  `ms_id` int(11) NOT NULL AUTO_INCREMENT,
  `mb_id` varchar(20) NOT NULL DEFAULT '',
  `bo_table` varchar(20) NOT NULL DEFAULT '',
  `wr_id` varchar(15) NOT NULL DEFAULT '',
  `ms_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ms_id`),
  KEY `mb_id` (`mb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_uniqid` (
  `uq_id` bigint(20) unsigned NOT NULL,
  `uq_ip` varchar(255) NOT NULL,
  PRIMARY KEY (`uq_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_uniqid VALUES("2019012523532565","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012523573699","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600022905","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600024875","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600073517","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600080241","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600094032","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600121030","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600261443","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600262581","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600271359","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600272109","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600272803","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600355777","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600360434","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600411466","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600415106","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600481184","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012600492272","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012617495454","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012621365709","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012621373168","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012715162640","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012715170841","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012915195221","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012915291638","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012915301047","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012915351102","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019012917113404","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019042221152288","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019042415283319","127.0.0.1");
INSERT INTO g5_uniqid VALUES("2019042614151362","59.17.50.96");
INSERT INTO g5_uniqid VALUES("2019042614151968","59.17.50.96");
INSERT INTO g5_uniqid VALUES("2019042912383253","58.239.85.3");
INSERT INTO g5_uniqid VALUES("2019042917181152","59.23.2.19");





CREATE TABLE `g5_visit` (
  `vi_id` int(11) NOT NULL DEFAULT '0',
  `vi_ip` varchar(255) NOT NULL DEFAULT '',
  `vi_date` date NOT NULL DEFAULT '0000-00-00',
  `vi_time` time NOT NULL DEFAULT '00:00:00',
  `vi_referer` text NOT NULL,
  `vi_agent` varchar(255) NOT NULL DEFAULT '',
  `vi_browser` varchar(255) NOT NULL DEFAULT '',
  `vi_os` varchar(255) NOT NULL DEFAULT '',
  `vi_device` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`vi_id`),
  UNIQUE KEY `index1` (`vi_ip`,`vi_date`),
  KEY `index2` (`vi_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_visit VALUES("1","127.0.0.1","2019-01-26","17:27:14","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("2","127.0.0.1","2019-01-27","10:45:01","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("3","127.0.0.1","2019-01-29","15:19:24","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("4","175.223.39.253","2019-04-03","11:06:41","","Mozilla/5.0 (Linux; Android 5.0.1; SAMSUNG SM-N916K/KTU1BOG6 Build/LRX22C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/2.1 Chrome/34.0.1847.76 Mobile Safari/537.36","","","");
INSERT INTO g5_visit VALUES("5","175.223.39.152","2019-04-03","17:57:48","","Mozilla/5.0 (Linux; Android 5.0.1; SAMSUNG SM-N916K/KTU1BOG6 Build/LRX22C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/2.1 Chrome/34.0.1847.76 Mobile Safari/537.36","","","");
INSERT INTO g5_visit VALUES("6","39.7.59.186","2019-04-03","19:56:14","","Mozilla/5.0 (Linux; Android 5.0.1; SAMSUNG SM-N916K/KTU1BOG6 Build/LRX22C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/2.1 Chrome/34.0.1847.76 Mobile Safari/537.36","","","");
INSERT INTO g5_visit VALUES("7","61.97.222.236","2019-04-22","22:36:41","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("8","211.108.211.104","2019-04-22","22:50:51","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("9","180.71.212.215","2019-04-22","22:57:10","","Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; SMJB; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("10","180.230.168.86","2019-04-22","23:00:48","","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("11","112.221.228.28","2019-04-23","09:14:34","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("12","106.242.173.149","2019-04-23","09:46:45","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("13","1.228.120.173","2019-04-23","10:47:44","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("14","112.162.233.181","2019-04-23","11:28:19","","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Safari/605.1.15","","","");
INSERT INTO g5_visit VALUES("15","222.108.137.118","2019-04-23","11:50:17","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("16","183.101.189.154","2019-04-23","12:19:30","","Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("17","210.95.187.171","2019-04-23","13:59:08","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("18","180.68.93.22","2019-04-23","16:04:23","","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("19","222.102.185.196","2019-04-23","20:49:42","","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","","","");
INSERT INTO g5_visit VALUES("20","175.127.83.166","2019-04-23","21:01:08","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("21","39.117.128.150","2019-04-23","22:01:06","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("22","121.173.47.118","2019-04-23","23:02:38","","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("23","111.118.12.182","2019-04-24","11:04:26","https://sir.kr/g5_skin/29196","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36 Edge/17.17134","","","");
INSERT INTO g5_visit VALUES("24","210.99.111.198","2019-04-24","12:40:14","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Whale/1.5.71.12 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("25","66.249.82.185","2019-04-24","12:58:24","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("26","112.168.184.240","2019-04-24","14:16:24","","Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("27","183.98.152.233","2019-04-24","15:59:09","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("28","211.107.116.173","2019-04-24","16:28:30","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("29","211.62.126.169","2019-04-24","16:42:58","","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Whale/1.5.71.12 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("30","180.67.64.114","2019-04-24","16:58:14","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("31","211.178.11.70","2019-04-24","17:34:44","","Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("32","59.19.114.185","2019-04-24","17:46:28","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("33","14.32.121.137","2019-04-24","20:22:31","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("34","14.37.208.10","2019-04-24","21:43:36","","Mozilla/5.0 (Linux; Android 8.1.0; SAMSUNG SM-G610K/KKU2CSB1 Build/M1AJQ) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/9.2 Chrome/67.0.3396.87 Mobile Safari/537.36","","","");
INSERT INTO g5_visit VALUES("35","61.40.50.178","2019-04-25","10:54:34","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("36","211.218.204.118","2019-04-25","14:07:11","","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("37","222.238.187.41","2019-04-25","19:28:47","","Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("38","104.247.136.142","2019-04-25","21:32:50","","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","","","");
INSERT INTO g5_visit VALUES("39","111.118.12.182","2019-04-25","23:54:37","https://sir.kr/g5_skin/29196","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36 Edge/17.17134","","","");
INSERT INTO g5_visit VALUES("40","106.248.76.147","2019-04-26","10:21:43","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("41","115.90.179.170","2019-04-26","10:41:51","","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("42","121.160.188.246","2019-04-26","11:46:29","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.108 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("43","110.15.111.208","2019-04-26","13:34:05","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.108 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("44","59.17.50.96","2019-04-26","14:14:40","","Mozilla/5.0 (Windows NT 6.1; rv:66.0) Gecko/20100101 Firefox/66.0","","","");
INSERT INTO g5_visit VALUES("45","1.226.185.33","2019-04-26","15:58:46","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("46","61.105.56.6","2019-04-26","17:31:01","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("47","116.33.131.143","2019-04-26","23:19:57","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("48","218.209.136.39","2019-04-29","08:56:56","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("49","112.221.228.28","2019-04-29","10:35:13","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("50","210.123.227.88","2019-04-29","10:39:37","","Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Mobile/15E148 Safari/604.1","","","");
INSERT INTO g5_visit VALUES("51","211.62.126.169","2019-04-29","11:29:50","","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Whale/1.5.71.15 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("52","58.239.85.3","2019-04-29","12:38:12","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.108 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("53","125.130.87.177","2019-04-29","14:29:42","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("54","221.146.208.7","2019-04-29","15:03:16","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("55","59.23.2.19","2019-04-29","17:17:42","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; MASMJS; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("56","112.164.20.99","2019-04-29","17:19:54","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("57","116.33.117.236","2019-04-29","22:06:06","","Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("58","115.143.188.183","2019-04-30","11:55:35","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("59","218.50.237.58","2019-04-30","12:59:16","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("60","1.223.31.234","2019-04-30","14:24:58","","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Whale/1.5.71.15 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("61","123.139.134.150","2019-04-30","15:14:04","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("62","220.117.226.39","2019-04-30","16:39:44","","Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("63","122.128.194.227","2019-05-01","14:39:03","","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("64","118.103.192.6","2019-05-01","16:39:33","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("65","59.86.253.30","2019-05-02","00:42:05","","Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("66","220.126.181.54","2019-05-02","08:46:23","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("67","1.249.35.217","2019-05-02","09:30:45","","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0) Swing/4.2.4.0","","","");
INSERT INTO g5_visit VALUES("68","59.7.139.134","2019-05-02","11:53:01","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("69","211.169.73.200","2019-05-02","13:16:48","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36","","","");
INSERT INTO g5_visit VALUES("70","1.249.35.217","2019-05-03","10:03:44","","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0) Swing/4.2.4.0","","","");
INSERT INTO g5_visit VALUES("71","112.152.83.32","2019-05-03","10:03:48","","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("72","118.34.113.63","2019-05-03","11:55:54","","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko","","","");
INSERT INTO g5_visit VALUES("73","127.0.0.1","2019-05-03","16:22:23","","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36","","","");





CREATE TABLE `g5_visit_sum` (
  `vs_date` date NOT NULL DEFAULT '0000-00-00',
  `vs_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`vs_date`),
  KEY `index1` (`vs_count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO g5_visit_sum VALUES("2019-01-26","1");
INSERT INTO g5_visit_sum VALUES("2019-01-27","1");
INSERT INTO g5_visit_sum VALUES("2019-01-29","1");
INSERT INTO g5_visit_sum VALUES("2019-04-03","3");
INSERT INTO g5_visit_sum VALUES("2019-04-22","4");
INSERT INTO g5_visit_sum VALUES("2019-04-23","12");
INSERT INTO g5_visit_sum VALUES("2019-04-24","12");
INSERT INTO g5_visit_sum VALUES("2019-04-25","5");
INSERT INTO g5_visit_sum VALUES("2019-04-26","8");
INSERT INTO g5_visit_sum VALUES("2019-04-29","10");
INSERT INTO g5_visit_sum VALUES("2019-04-30","5");
INSERT INTO g5_visit_sum VALUES("2019-05-01","2");
INSERT INTO g5_visit_sum VALUES("2019-05-02","5");
INSERT INTO g5_visit_sum VALUES("2019-05-03","4");





CREATE TABLE `g5_write_cert` (
  `wr_id` int(11) NOT NULL AUTO_INCREMENT,
  `wr_num` int(11) NOT NULL DEFAULT '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `wr_is_comment` tinyint(4) NOT NULL DEFAULT '0',
  `wr_comment` int(11) NOT NULL DEFAULT '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL DEFAULT '0',
  `wr_link2_hit` int(11) NOT NULL DEFAULT '0',
  `wr_hit` int(11) NOT NULL DEFAULT '0',
  `wr_good` int(11) NOT NULL DEFAULT '0',
  `wr_nogood` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wr_file` tinyint(4) NOT NULL DEFAULT '0',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_facebook_user` varchar(255) NOT NULL,
  `wr_twitter_user` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO g5_write_cert VALUES("1","-1","","1","0","0","","","html1","????????","<p>2019.01.29 \'????????\'?? ???.</p>","","","0","0","1","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-29 15:36:00","0","2019-01-29 15:36:00","127.0.0.1","","","???","2019-01-29","99000","","","","","","","");
INSERT INTO g5_write_cert VALUES("2","-2","","2","0","0","","","html1","????????","<p>???? ??? ???</p>","","","0","0","1","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-29 17:12:13","0","2019-01-29 17:12:13","127.0.0.1","","","???","2019-01-29","99000","","","","","","","");





CREATE TABLE `g5_write_free` (
  `wr_id` int(11) NOT NULL AUTO_INCREMENT,
  `wr_num` int(11) NOT NULL DEFAULT '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `wr_is_comment` tinyint(4) NOT NULL DEFAULT '0',
  `wr_comment` int(11) NOT NULL DEFAULT '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL DEFAULT '0',
  `wr_link2_hit` int(11) NOT NULL DEFAULT '0',
  `wr_hit` int(11) NOT NULL DEFAULT '0',
  `wr_good` int(11) NOT NULL DEFAULT '0',
  `wr_nogood` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wr_file` tinyint(4) NOT NULL DEFAULT '0',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_facebook_user` varchar(255) NOT NULL,
  `wr_twitter_user` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO g5_write_free VALUES("1","-1","","1","0","0","","","html1","??????","<p>??????????</p>","","","0","0","3","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:02:35","0","2019-01-26 00:02:35","127.0.0.1","","","","","","","","","","","","");





CREATE TABLE `g5_write_gallery` (
  `wr_id` int(11) NOT NULL AUTO_INCREMENT,
  `wr_num` int(11) NOT NULL DEFAULT '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `wr_is_comment` tinyint(4) NOT NULL DEFAULT '0',
  `wr_comment` int(11) NOT NULL DEFAULT '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL DEFAULT '0',
  `wr_link2_hit` int(11) NOT NULL DEFAULT '0',
  `wr_hit` int(11) NOT NULL DEFAULT '0',
  `wr_good` int(11) NOT NULL DEFAULT '0',
  `wr_nogood` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wr_file` tinyint(4) NOT NULL DEFAULT '0',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_facebook_user` varchar(255) NOT NULL,
  `wr_twitter_user` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO g5_write_gallery VALUES("5","-3","","5","0","0","","","html1","sdfsa","<p>fsdf</p>","","","0","0","3","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:26:23","1","2019-01-26 00:26:23","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("4","-2","","4","0","0","","","html1","??2","<p>??2</p>","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 23:45:24","1","2019-01-25 23:45:24","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("3","-1","","3","0","0","","","html1","??1","<p>??1</p>","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 23:45:10","1","2019-01-25 23:45:10","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("6","-4","","6","0","0","","","html1","sdfs","<p>fsdf</p>","","","0","0","4","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:26:32","1","2019-01-26 00:26:32","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("7","-5","","7","0","0","","","html1","asda","<p>dasdad</p>","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:27:19","1","2019-01-26 00:27:19","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("8","-6","","8","0","0","","","html1","asdad","<p>asdad</p>","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:27:26","1","2019-01-26 00:27:26","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("9","-7","","9","0","0","","","html1","asd","<p>ada</p>","","","0","0","8","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:27:34","1","2019-01-26 00:27:34","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("10","-8","","10","0","0","","","html1","?? ??","<p>?? ??<br></p>","","","0","0","3","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-27 15:16:50","1","2019-01-27 15:16:50","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_gallery VALUES("11","-9","","11","0","0","","","html1","????","<p>?? ??<br></p>","","","0","0","13","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-27 15:17:41","1","2019-01-27 15:17:41","127.0.0.1","","","","","","","","","","","","");





CREATE TABLE `g5_write_notice` (
  `wr_id` int(11) NOT NULL AUTO_INCREMENT,
  `wr_num` int(11) NOT NULL DEFAULT '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `wr_is_comment` tinyint(4) NOT NULL DEFAULT '0',
  `wr_comment` int(11) NOT NULL DEFAULT '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL DEFAULT '0',
  `wr_link2_hit` int(11) NOT NULL DEFAULT '0',
  `wr_hit` int(11) NOT NULL DEFAULT '0',
  `wr_good` int(11) NOT NULL DEFAULT '0',
  `wr_nogood` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wr_file` tinyint(4) NOT NULL DEFAULT '0',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_facebook_user` varchar(255) NOT NULL,
  `wr_twitter_user` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO g5_write_notice VALUES("1","-1","","1","0","0","","","","sdfsdafsadfsdfsdf","sdfsfsdfasdf","","","0","0","1","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 10:57:36","0","2019-01-25 10:57:36","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_notice VALUES("2","-2","","2","0","0","","","","???? ???","asdfasdfdsaffdsfsdafdsfsdf","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 10:58:17","0","2019-01-25 10:58:17","127.0.0.1","","","","","","","","","","","","");





CREATE TABLE `g5_write_nvisittablemember` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(255) NOT NULL DEFAULT '',
  `wr_1` varchar(255) DEFAULT NULL,
  `wr_2` varchar(255) DEFAULT NULL,
  `wr_3` varchar(255) DEFAULT NULL,
  `wr_4` varchar(255) DEFAULT NULL,
  `wr_5` varchar(255) DEFAULT NULL,
  `wr_ip` varchar(255) NOT NULL DEFAULT '',
  `wr_6` varchar(255) NOT NULL DEFAULT '',
  `wr_7` varchar(255) NOT NULL DEFAULT '',
  `wr_8` varchar(255) NOT NULL DEFAULT '',
  `wr_9` varchar(255) NOT NULL DEFAULT '',
  `wr_10` varchar(255) NOT NULL DEFAULT '',
  `wr_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;






CREATE TABLE `g5_write_pdfv` (
  `wr_id` int(11) NOT NULL AUTO_INCREMENT,
  `wr_num` int(11) NOT NULL DEFAULT '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `wr_is_comment` tinyint(4) NOT NULL DEFAULT '0',
  `wr_comment` int(11) NOT NULL DEFAULT '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL DEFAULT '0',
  `wr_link2_hit` int(11) NOT NULL DEFAULT '0',
  `wr_hit` int(11) NOT NULL DEFAULT '0',
  `wr_good` int(11) NOT NULL DEFAULT '0',
  `wr_nogood` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wr_file` tinyint(4) NOT NULL DEFAULT '0',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_facebook_user` varchar(255) NOT NULL,
  `wr_twitter_user` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO g5_write_pdfv VALUES("1","-1","","1","0","0","","","html1","pdf viewer","PDF ?? ??","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 21:38:09","1","2019-01-26 21:38:09","127.0.0.1","","","","","","","","","","","","");





CREATE TABLE `g5_write_qa` (
  `wr_id` int(11) NOT NULL AUTO_INCREMENT,
  `wr_num` int(11) NOT NULL DEFAULT '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `wr_is_comment` tinyint(4) NOT NULL DEFAULT '0',
  `wr_comment` int(11) NOT NULL DEFAULT '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL DEFAULT '0',
  `wr_link2_hit` int(11) NOT NULL DEFAULT '0',
  `wr_hit` int(11) NOT NULL DEFAULT '0',
  `wr_good` int(11) NOT NULL DEFAULT '0',
  `wr_nogood` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wr_file` tinyint(4) NOT NULL DEFAULT '0',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_facebook_user` varchar(255) NOT NULL,
  `wr_twitter_user` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO g5_write_qa VALUES("1","-1","","1","0","1","","","html1","?????.","<p>?????.</p>","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 23:53:41","0","2019-01-25 23:57:01","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_qa VALUES("2","-1","","1","1","1","","","","","??","","","0","0","0","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 23:57:01","0","","127.0.0.1","","","","","","","","","","","","");





CREATE TABLE `g5_write_slideout_title` (
  `wr_id` int(11) NOT NULL AUTO_INCREMENT,
  `wr_num` int(11) NOT NULL DEFAULT '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL DEFAULT '0',
  `wr_is_comment` tinyint(4) NOT NULL DEFAULT '0',
  `wr_comment` int(11) NOT NULL DEFAULT '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL DEFAULT '0',
  `wr_link2_hit` int(11) NOT NULL DEFAULT '0',
  `wr_hit` int(11) NOT NULL DEFAULT '0',
  `wr_good` int(11) NOT NULL DEFAULT '0',
  `wr_nogood` int(11) NOT NULL DEFAULT '0',
  `mb_id` varchar(20) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wr_file` tinyint(4) NOT NULL DEFAULT '0',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_facebook_user` varchar(255) NOT NULL,
  `wr_twitter_user` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO g5_write_slideout_title VALUES("5","-3","","5","0","0","","","html1","sdfsa","<p>fsdf</p>","","","0","0","1","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:26:23","1","2019-01-26 00:26:23","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("4","-2","","4","0","0","","","html1","??2","<p>??2</p>","","","0","0","1","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 23:45:24","1","2019-01-25 23:45:24","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("3","-1","","3","0","0","","","html1","??1","<p>??1</p>","","","0","0","3","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-25 23:45:10","1","2019-01-25 23:45:10","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("6","-4","","6","0","0","","","html1","sdfs","<p>fsdf</p>","","","0","0","1","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:26:32","1","2019-01-26 00:26:32","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("7","-5","","7","0","0","","","html1","asda","<p>dasdad</p>","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:27:19","1","2019-01-26 00:27:19","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("8","-6","","8","0","0","","","html1","asdad","<p>asdad</p>","","","0","0","1","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:27:26","1","2019-01-26 00:27:26","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("9","-7","","9","0","0","","","html1","asd","<p>ada</p>","","","0","0","2","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-26 00:27:34","1","2019-01-26 00:27:34","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("10","-8","","10","0","0","","","html1","?? ??","<p>?? ??<br></p>","","","0","0","6","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-27 15:16:50","1","2019-01-27 15:16:50","127.0.0.1","","","","","","","","","","","","");
INSERT INTO g5_write_slideout_title VALUES("11","-9","","11","0","0","","","html1","????","<p>?? ??<br></p>","","","0","0","4","0","0","admin","*A4B6157319038724E3560894F7F932C8886EBFCF","?????","admin@domain.com","","2019-01-27 15:17:41","1","2019-01-27 15:17:41","127.0.0.1","","","","","","","","","","","","");



