<?php
class Database
{
	public $connection;
    public function Connect($mysqli_server, $mysqli_user, $mysqli_password)
    {
         $this->connection = mysqli_connect($mysqli_server, $mysqli_user, $mysqli_password);
    }

	public function SelectDB($database_name)
    {
        mysqli_select_db($database_name, $this->connection);
    }

    public function __destruct()
    {

    }

    public function Query($query)
    {
        return mysqli_query($query, $this->connection);
    }

	public function SQLQuery($query)
    {
        return mysqli_query($query, $this->connection);
    }

	public function SetParameter($param_id, $param_value)
    {
		global $DBprefix;

		mysqli_query("UPDATE ".$DBprefix."settings SET value='".mysqli_real_escape_string($param_value)."' WHERE id=".$param_id, $this->connection);
    }

	function ListDatabases($mysql_server, $mysql_user, $mysql_password)
	{
		$this->connection = mysqli_connect($mysql_server, $mysql_user, $mysql_password);

		if (mysqli_connect_errno())
		{
			die("<script>document.location.href='index.php?page=settings&connect_error=1';</script>");
		}


		$result = mysqli_query($this->connection, "SHOW DATABASES");
		$arr_result=array();

		while ($row = mysqli_fetch_array($result))
		{
			if($row[0]=="information_schema"||$row[0]=="test")
			continue;

			array_push($arr_result, $row[0]);

		}

		return $arr_result;

	}

	function GetFieldsInTable($strTable)
	{
		global $DBprefix;
		$mysqli_fields = array();
		$pieces = explode(",", $strTable);
		$oResult=mysqli_query("SHOW COLUMNS FROM ".$DBprefix.$pieces[0], $this->connection);

		while ($row = mysqli_fetch_assoc($oResult))
		{
		   array_push($mysqli_fields,$row["Field"]);
		}

		return $mysqli_fields;
	}

	function SQLInsert($strTable,$arrNames,$arrValues)
	{
		global $DBprefix;
		$strNames="";
		$strList="";

		$num = count($arrNames);

		for ($i = 0; $i < $num; $i++)
		{
			$strNames.=$arrNames[$i].",";
		}

		$num = count ($arrValues);

		for ($i = 0; $i < $num; $i++)
		{

			if(strpos($arrNames[$i], "html_")!== false)
			{

			}
			else
			if(!in_array($arrNames[$i], $this->allowed_html_fields))
			{
				if(is_array($arrValues[$i]))
				{
					$arrValues[$i]=implode(",",$arrValues[$i]);
				}
				$arrValues[$i]=strip_tags($arrValues[$i]);

			}


			$strList.="'".mysqli_real_escape_string($arrValues[$i])."',";

		}

		$strList=substr($strList,0,(strlen($strList)-1));
		$strNames=substr($strNames,0,(strlen($strNames)-1));

		$strQuery="INSERT INTO ".$DBprefix.$strTable."
		(".$strNames.")
		VALUES
		(".$strList.")";
		$strQuery=str_replace(",'',",",NULL,",$strQuery);
		$this->Query($strQuery);



		$iResult=mysqli_insert_id($this->connection);

		return $iResult;
	}

	public function SQLCount($table,$where_query="", $count_column = "id")
	{
		global $DBprefix;


		$result = $this->Query
		(
			"SELECT COUNT(".$count_column.")
			FROM ".$DBprefix.$table."
			".($where_query!=""?$where_query:"")
		);


		return mysqli_result($result, 0);
	}


	public function SQLMin($strTable, $strField)
	{
		global $DBprefix;
		$result = $this->Query
		(
			"SELECT MIN(".$strField.")
			FROM ".$DBprefix.$strTable
		);


		return mysqli_result($result, 0);
	}

	public function SQLMax($strTable, $strField)
	{
		global $DBprefix;
		$result = $this->Query
		(
			"SELECT MAX(".$strField.")
			FROM ".$DBprefix.$strTable
		);


		return mysqli_result($result, 0);
	}


	function SQLDelete($strTable,$Key,$arrIDs)
	{

		global $DBprefix;

		$strList="";


		$num = count ($arrIDs);

		for ($i = 0; $i < $num; $i++)
		{
			$strList.=$arrIDs[$i].",";
		}

		$strList=substr($strList,0,(strlen($strList)-1));


		$strQuery="DELETE FROM ".$DBprefix.$strTable." WHERE ".$Key." IN ($strList)";

		$this->Query($strQuery);

	}


	function SQLDeletePlus($auth_column,$auth_value,$strTable,$Key,$arrIDs)
	{

		global $DBprefix;

		$strList="";


		$num = count ($arrIDs);

		for ($i = 0; $i < $num; $i++)
		{
			$strList.=$arrIDs[$i].",";
		}

		$strList=substr($strList,0,(strlen($strList)-1));


		$strQuery="DELETE FROM ".$DBprefix.$strTable." WHERE ".$Key." IN ($strList) AND ".$auth_column."='".$auth_value."'";

		$this->Query($strQuery);

	}

	function SQLUpdate($strTable,$arrNames,$arrValues,$whereClause)
	{
		global $DBprefix;

		$strUpdateList="";

		$num = count($arrNames);

		for ($i = 0; $i < $num; $i++)
		{
			if(strpos($arrNames[$i], "html_")!== false)
			{

			}
			else
			if(!in_array($arrNames[$i], $this->allowed_html_fields))
			{
				if(is_array($arrValues[$i])) $arrValues[$i]=implode(",",$arrValues[$i]);
				$arrValues[$i]=strip_tags($arrValues[$i]);
			}
				$arr_decim=array("experience_level");

				if(in_array($arrNames[$i],$arr_decim))

				{
					$strUpdateList.=$arrNames[$i]."=NULL,";
				}
				else
				{
					$strUpdateList.=$arrNames[$i]."='".mysqli_real_escape_string($arrValues[$i])."',";
				}
		}

		$strUpdateList=substr($strUpdateList,0,(strlen($strUpdateList)-1));

		$strQuery="UPDATE ".$DBprefix.$strTable."
		SET ".$strUpdateList."
		WHERE ".$whereClause;
		$strQuery=str_replace("'NULL'","NULL",$strQuery);


		$iResult=$this->Query($strQuery);

		return $iResult;
	}

	function SQLUpdate_SingleValue
	(
		$strTable,
		$PrimaryKey,
		$PrimaryKeyValue,
		$FieldName,
		$FieldValue
	){


		global $DBprefix;

		if(!in_array($FieldName, $this->allowed_html_fields))
		{
			$FieldValue=strip_tags($FieldValue);
		}

		$strQuery="UPDATE ".$DBprefix.$strTable."
		SET ".$FieldName."='".mysqli_real_escape_string($FieldValue)."'
		WHERE ".$PrimaryKey."=".$PrimaryKeyValue;

		$iResult=$this->Query($strQuery);

		return $iResult;
	}


	function SQLSum_Query
	(
		$strTable,
		$strField,
		$whereQuery
	)
	{
		global $DBprefix;
		$strResult="";

		$strQuery="SELECT sum(".$strField.") abc FROM ".$DBprefix.$strTable." WHERE ".$whereQuery;

		$oResult=$this->Query($strQuery);

		$arrResult=mysqli_fetch_array($oResult);

		$strResult=$arrResult["abc"];

		return round($strResult,2);
	}


	function SQLAvg_Query
	(
		$strTable,
		$strField,
		$whereQuery
	)
	{

		$strResult="";

		global $DBprefix;

		$strQuery="SELECT avg(".$strField.") abc FROM ".$DBprefix.$strTable." WHERE ".$whereQuery;

		$oResult=$this->Query($strQuery);

		$arrResult=mysqli_fetch_array($oResult);

		$strResult=$arrResult["abc"];
		return round($strResult,2);
	}

	function SQLUpdateField_MultipleArray($strTable,$strName,$strValue,$strIdName,$arrIds)
	{

		if(sizeof($arrIds)==0)
		{
			return;
		}

		$strIds="";

		for($i=0;$i<sizeof($arrIds);$i++)
		{

			if($i==(sizeof($arrIds)-1))
			{
				$strIds.="".$arrIds[$i];
			}
			else{
				$strIds.="".$arrIds[$i].",";
			}

		}

		global $DBprefix;

		$strQuery="UPDATE ".$DBprefix.$strTable."
		SET ".$strName."='".mysqli_real_escape_string($strValue)."'
		WHERE ".$strIdName." IN (".$strIds.")";

		$this->Query($strQuery);
	}

	function getSingleValue
			(
				$strTable,
				$PrimaryKey,
				$PrimaryKeyValue,
				$FieldName
			)
	{

		$strResult="";
		global $DBprefix;


		$strQuery="SELECT $FieldName FROM $DBprefix".$strTable."
						  WHERE $PrimaryKey=$PrimaryKeyValue";

		$oResult=$this->Query($strQuery);

		$aResult=mysqli_fetch_array($oResult);

		$strResult=$aResult[$FieldName];

		return $strResult;
	}



	function CreateDump($host,$user,$pass,$name)
	{
		$return = "";
		$link = mysqli_connect($host,$user,$pass);
		mysqli_select_db($link,$name);



			$tables = array();
			$result = mysqli_query($link,'SHOW TABLES');
			while($row = mysqli_fetch_row($result))
			{
				$tables[] = $row[0];
			}


		foreach($tables as $table)
		{
			$result = mysqli_query($link,'SELECT * FROM '.$table);
			$num_fields = mysqli_num_fields($result);

			$return.= 'DROP TABLE '.$table.';';
			$row2 = mysqli_fetch_row(mysqli_query($link,'SHOW CREATE TABLE '.$table));
			$return.= "\n\n".$row2[1].";\n\n";

			for ($i = 0; $i < $num_fields; $i++)
			{
				while($row = mysqli_fetch_row($result))
				{
					$return.= 'INSERT INTO '.$table.' VALUES(';
					for($j=0; $j<$num_fields; $j++)
					{
						$row[$j] = addslashes($row[$j]);
						$row[$j] = str_replace("\n","\\n",$row[$j]);
						if (isset($row[$j])) { $return.= '"'.$row[$j].'"' ; } else { $return.= '""'; }
						if ($j<($num_fields-1)) { $return.= ','; }
					}
					$return.= ");\n";
				}
			}
			$return.="\n\n\n";
		}

		mysqli_close($link);

		return $return;
	}

}
?>
