<?php
class SiteManager
{
	public $lang="ko";

	public $page="home";

	public $arrPages = array();
	public $domain = "";
	public $multi_language = false;
	private $db;
	public $running_mode=1;


	public $default_page_name="ko_Home";

	/// The website title and meta description and keywords,
	/// which can be used for SEO purposes
	public $Title = true;
	public $Description = true;
	public $Keywords = true;

	/// The current language version on the website
	public $Language = true;

	/// The html code of the website template
	public $TemplateHTML = "";

	/// The site paramets
	public $settings = array();


	function SetLanguage($lang)
	{
		$this->lang= substr(preg_replace("/[^a-z]/i", "", $lang), 0, 2);
	}

	function SetDatabase(Database $db)
	{
		$this->db = $db;

	}

	function SetPage($page)
	{
		global $DBHost,$DBUser,$DBPass;
		$this->page=$page;
	}

	function LoadSettings()
	{

		if(file_exists("config.php"))
		{
			$this->settings = parse_ini_file("config.php",true);
		}
		else
		if(file_exists("../config.php"))
		{
			$this->settings = parse_ini_file("../config.php",true);
		}
		else
		{
			die("구성파일이 없습니다.");
		}

		date_default_timezone_set('Asia/Seoul');

	}

	function LoadTemplate()
	{
		global $_REQUEST,$DBprefix;

		if(file_exists("template.php"))
		{
			$templateArray=array();

			$templateArray["html"] = file_get_contents('template.php');

		}

		else
		{
			die("Error: template.php 파일이 없습니다.");
		}


		///end custom colors

		$this->TemplateHTML = stripslashes($templateArray["html"]);

		$pattern = "/{(\w+)}/i";
		preg_match_all($pattern, $this->TemplateHTML, $items_found);
		foreach($items_found[1] as $item_found)
		{
			global $$item_found;
			if(isset($$item_found))
			{
				$this->TemplateHTML=str_replace("{".$item_found."}",$$item_found,$this->TemplateHTML);
			}
		}


		$arrTags=array();

		array_push($arrTags, array("top_right_menu","top_right_menu.php"));


		if(is_array($arrTags))
		{
			foreach($arrTags as $arrTag)
			{
				$tag_pos = strpos($this->TemplateHTML,"<site ".$arrTag[0]."/>");

				if($tag_pos !== false)
				{
					if(trim($arrTag[1]) != "none" && trim($arrTag[0]) != "" && trim($arrTag[1]) != "")
					{
						$HTML="";
						ob_start();
						include("include/".$arrTag[1]);

						if($HTML=="")
						{
							$HTML = ob_get_contents();
						}
						ob_end_clean();
						$this->TemplateHTML = str_replace("<site ".$arrTag[0]."/>",$HTML,$this->TemplateHTML);
					}
				}
			}
		}




	}

	function Render()
	{
		global $database;
		if($this->page!="")
		{
			$HTML="";
			ob_start();

			if(file_exists("pages/".$this->page.".php"))
			{
				include("pages/".$this->page.".php");

			}
			$HTML = ob_get_contents();

			$this->TemplateHTML=str_replace("<site content/>",$HTML,$this->TemplateHTML);

			ob_end_clean();
		}

		echo $this->TemplateHTML;
	}


	function check_word($input)
	{
		if(!preg_match("/^[a-zA-Z0-9_]+$/i", $input)) die("");
	}

	function check_extended_word($input)
	{
		if(!preg_match("/^[a-zA-Z0-9_\-. @]+$/i", $input)) die("");
	}

	function check_integer($input)
	{
		if(!is_numeric($input)) die("");
	}

	function ms_w($input)
	{
		if(!preg_match("/^[a-zA-Z0-9_]+$/i", $input)) die("");
	}

	function ms_ew($input)
	{
		if(!preg_match("/^[a-zA-Z0-9_\-. @]+$/i", $input)) die("");
	}

	function ms_i($input)
	{
		if(!is_numeric($input)) die("");
	}

	function ms_ia($input)
	{
		foreach($input as $inp) if(!is_numeric($inp)) die("");
	}

	function sanitize($input)
	{
		$strip_chars = array("~", "`", "!","#", "$", "%", "^", "&", "*", "(", ")", "=", "+", "[", "{", "]",
                 "}", "\\", "|", ";", ":", "\"", "'", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8211;", "&#8212;",
                 ",", "<", ">", "/", "?");
		$output = trim(str_replace($strip_chars, " ", strip_tags($input)));
		$output = preg_replace('/\s+/', ' ',$output);
		$output = preg_replace('/\-+/', '-',$output);
		return $output;
	}


	function str_rot($s, $n = 13) {
    static $letters = 'AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz';
    $n = (int)$n % 26;
    if (!$n) return $s;
    if ($n < 0) $n += 26;
    if ($n == 13) return str_rot13($s);
    $rep = substr($letters, $n * 2) . substr($letters, 0, $n * 2);
    return strtr($s, $letters, $rep);
}



	function write_ini_file($file, array $options)
	{
		$tmp = '; <?php exit;?>';
		$tmp.="\n\n";
		foreach($options as $section => $values){
			$tmp .= "[$section]\n";
			foreach($values as $key => $val){
				if(is_array($val)){
					foreach($val as $k =>$v){
						$tmp .= "{$key}[$k] = \"$v\"\n";
					}
				}
				else
					$tmp .= "$key = \"$val\"\n";
			}
			$tmp .= "\n";
		}
		file_put_contents($file, $tmp);
		unset($tmp);
	}


}
?>
