(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("jquery"));
	else if(typeof define === 'function' && define.amd)
		define(["jquery"], factory);
	else if(typeof exports === 'object')
		exports["autonumeric"] = factory(require("jquery"));
	else
		root["autonumeric"] = factory(root["jQuery"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_1__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	eval("var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*** IMPORTS FROM imports-loader ***/\nvar jQuery = __webpack_require__(1);\nvar $ = __webpack_require__(1);\n(function() {\n\n'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"]) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); } }; }();\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; };\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/**\n *               autoNumeric.js\n *\n * @version      2.0.12\n * @date         2017-04-07 UTC 07:00\n *\n * @author       Bob Knothe\n * @contributors Alexandre Bonneau, Sokolov Yura and other Github users,\n *               cf. AUTHORS.md.\n * @copyright    2009 Robert J. Knothe http://www.decorplanit.com/plugin/\n * @since        2009-08-09\n *\n * @summary      autoNumeric is a library that provides live as-you-type\n *               formatting for international numbers and currencies.\n *\n *               Note : Some functions are borrowed from big.js\n * @link         https://github.com/MikeMcl/big.js/\n *\n * Please report any bugs to https://github.com/autoNumeric/autoNumeric\n *\n * @license      Released under the MIT License\n * @link         http://www.opensource.org/licenses/mit-license.php\n *\n * Permission is hereby granted, free of charge, to any person\n * obtaining a copy of this software and associated documentation\n * files (the \"Software\"), to deal in the Software without\n * restriction, including without limitation the rights to use,\n * copy, modify, merge, publish, distribute, sub license, and/or sell\n * copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following\n * conditions:\n *\n * The above copyright notice and this permission notice shall be\n * included in all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES\n * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT\n * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\n * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR\n * OTHER DEALINGS IN THE SOFTWARE.\n */\n\n/* global module, require, define */\n\n// Functions names for ES6 exports\nvar autoFormat = void 0;\nvar autoUnFormat = void 0;\nvar getDefaultConfig = void 0;\nvar getLanguages = void 0;\nvar validate = void 0;\nvar areSettingsValid = void 0;\n\n// AutoNumeric default settings\n/**\n * List of allowed tag on which autoNumeric can be used.\n */\nvar allowedTagList = ['b', 'caption', 'cite', 'code', 'const', 'dd', 'del', 'div', 'dfn', 'dt', 'em', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'ins', 'kdb', 'label', 'li', 'option', 'output', 'p', 'q', 's', 'sample', 'span', 'strong', 'td', 'th', 'u'];\n\n/**\n * Defaults options are public - these can be overridden by the following method:\n * - HTML5 data attributes (ie. `<input type=\"text\" data-currency-symbol=\" €\">`)\n * - Options passed by the 'init' or 'update' methods (ie. `aNInput.autoNumeric('update', { currencySymbol: ' €' });`)\n * - Use jQuery's `$.extend` method for global changes - also a great way to pass ASP.NET current culture settings\n */\nvar defaultSettings = {\n    /* Allowed thousand grouping separator characters :\n     * ','      // Comma\n     * '.'      // Dot\n     * ' '      // Normal space\n     * '\\u2009' // Thin-space\n     * '\\u202f' // Narrow no-break space\n     * '\\u00a0' // No-break space\n     * ''       // No separator\n     * \"'\"      // Apostrophe\n     * '٬'      // Arabic thousands separator\n     * '˙'      // Dot above\n     * Deprecated older option name : aSep\n     */\n    digitGroupSeparator: ',',\n\n    /* Remove the thousand separator on focus, currency symbol and suffix on focus\n     * example if the input value \"$ 1,999.88 suffix\"\n     * on \"focusin\" it becomes \"1999.88\" and back to \"$ 1,999.88 suffix\" on focus out.\n     * Deprecated older option name : nSep\n     */\n    noSeparatorOnFocus: false,\n\n    /* Digital grouping for the thousand separator used in Format\n     * digitalGroupSpacing: \"2\", results in 99,99,99,999 India's lakhs\n     * digitalGroupSpacing: \"2s\", results in 99,999,99,99,999 India's lakhs scaled\n     * digitalGroupSpacing: \"3\", results in 999,999,999 default\n     * digitalGroupSpacing: \"4\", results in 9999,9999,9999 used in some Asian countries\n     * Deprecated older option name : dGroup\n     */\n    digitalGroupSpacing: '3',\n\n    /* Allowed decimal separator characters :\n     * ',' : Comma\n     * '.' : Dot\n     * '·' : Middle-dot\n     * '٫' : Arabic decimal separator\n     * '⎖' : Decimal separator key symbol\n     * Deprecated older option name : aDec\n     */\n    decimalCharacter: '.',\n\n    /* Allow to declare an alternative decimal separator which is automatically replaced by `decimalCharacter` when typed.\n     * This is used by countries that use a comma \",\" as the decimal character and have keyboards\\numeric pads that have\n     * a period 'full stop' as the decimal characters (France or Spain for instance).\n     * Deprecated older option name : altDec\n     */\n    decimalCharacterAlternative: null,\n\n    /* currencySymbol = allowed currency symbol\n     * Must be in quotes currencySymbol: \"$\"\n     * space to the right of the currency symbol currencySymbol: '$ '\n     * space to the left of the currency symbol currencySymbol: ' $'\n     * Deprecated older option name : aSign\n     */\n    currencySymbol: '',\n\n    /* currencySymbolPlacement = placement of currency sign as a p=prefix or s=suffix\n     * for prefix currencySymbolPlacement: \"p\" (default)\n     * for suffix currencySymbolPlacement: \"s\"\n     * Deprecated older option name : pSign\n     */\n    //TODO Rename the options to more explicit names ('p' => 'prefix', etc.)\n    currencySymbolPlacement: 'p',\n\n    /* Placement of negative/positive sign relative to the currencySymbol option l=left, r=right, p=prefix & s=suffix\n     * -1,234.56  => default no options required\n     * -$1,234.56 => {currencySymbol: \"$\"} or {currencySymbol: \"$\", negativePositiveSignPlacement: \"l\"}\n     * $-1,234.56 => {currencySymbol: \"$\", negativePositiveSignPlacement: \"r\"} // Default if negativePositiveSignPlacement is 'null' and currencySymbol is not empty\n     * -1,234.56$ => {currencySymbol: \"$\", currencySymbolPlacement: \"s\", negativePositiveSignPlacement: \"p\"} // Default if negativePositiveSignPlacement is 'null' and currencySymbol is not empty\n     * 1,234.56-  => {negativePositiveSignPlacement: \"s\"}\n     * $1,234.56- => {currencySymbol: \"$\", negativePositiveSignPlacement: \"s\"}\n     * 1,234.56-$ => {currencySymbol: \"$\", currencySymbolPlacement: \"s\"}\n     * 1,234.56$- => {currencySymbol: \"$\", currencySymbolPlacement: \"s\", negativePositiveSignPlacement: \"r\"}\n     * Deprecated older option name : pNeg\n     */\n    //TODO Rename the options to more explicit names ('p' => 'prefix', etc.)\n    negativePositiveSignPlacement: null,\n\n    /* Allow the positive sign symbol `+` to be displayed for positive numbers.\n     * By default, this positive sign is not shown.\n     * The sign placement is controlled by the 'negativePositiveSignPlacement' option, mimicking the negative sign placement rules.\n     */\n    showPositiveSign: false,\n\n    /* Additional suffix\n     * Must be in quotes suffixText: 'gross', a space is allowed suffixText: ' dollars'\n     * Numeric characters and negative sign not allowed'\n     * Deprecated older option name : aSuffix\n     */\n    suffixText: '',\n\n    /* Override min max limits\n     * overrideMinMaxLimits: \"ceiling\" adheres to maximumValue and ignores minimumValue settings\n     * overrideMinMaxLimits: \"floor\" adheres to minimumValue and ignores maximumValue settings\n     * overrideMinMaxLimits: \"ignore\" ignores both minimumValue & maximumValue\n     * Deprecated older option name : oLimits\n     */\n    overrideMinMaxLimits: null,\n\n    /* Maximum possible value\n     * value must be enclosed in quotes and use the period for the decimal point\n     * value must be larger than minimumValue\n     * Deprecated older option name : vMax\n     */\n    maximumValue: '9999999999999.99', // 9.999.999.999.999,99 ~= 10000 billions\n\n    /* Minimum possible value\n     * value must be enclosed in quotes and use the period for the decimal point\n     * value must be smaller than maximumValue\n     * Deprecated older option name : vMin\n     */\n    minimumValue: '-9999999999999.99', // -9.999.999.999.999,99 ~= 10000 billions\n\n    /* Maximum number of decimal places = used to override decimal places set by the minimumValue & maximumValue values\n     * Deprecated older option name : mDec\n     */\n    decimalPlacesOverride: null,\n\n    /* Expanded decimal places visible when input has focus - example:\n     * {decimalPlacesShownOnFocus: \"5\"} and the default 2 decimal places with focus \"1,000.12345\" without focus \"1,000.12\" the results depends on the rounding method used\n     * the \"get\" method returns the extended decimal places\n     * Deprecated older option name : eDec\n     */\n    decimalPlacesShownOnFocus: null,\n\n    /* The next three options (scaleDivisor, scaleDecimalPlaces & scaleSymbol) handle scaling of the input when the input does not have focus\n     * Please note that the non-scaled value is held in data and it is advised that you use the \"saveValueToSessionStorage\" option to ensure retaining the value\n     * [\"divisor\", \"decimal places\", \"symbol\"]\n     * Example: with the following options set {scaleDivisor: '1000', scaleDecimalPlaces: '1', scaleSymbol: ' K'}\n     * Example: focusin value \"1,111.11\" focusout value \"1.1 K\"\n     */\n\n    /* The `scaleDivisor` decides the on focus value and places the result in the input on focusout\n     * Example {scaleDivisor: '1000'} or <input data-scale-divisor=\"1000\">\n     * The divisor value - does not need to be whole number but please understand that Javascript has limited accuracy in math\n     * The \"get\" method returns the full value, including the 'hidden' decimals.\n     */\n    scaleDivisor: null,\n\n    /*\n     * The `scaleDecimalPlaces` option is the number of decimal place when not in focus - for this to work, `scaledDivisor` must not be `null`.\n     * This is optional ; if omitted the decimal places will be the same when the input has the focus.\n     * Deprecated older option name : scaleDecimal\n     */\n    scaleDecimalPlaces: null,\n\n    /*\n     * The `scaleSymbol` option is a symbol placed as a suffix when not in focus.\n     * This is optional too.\n     */\n    scaleSymbol: null,\n\n    /* Set to true to allow the decimalPlacesShownOnFocus value to be saved with sessionStorage\n     * if ie 6 or 7 the value will be saved as a session cookie\n     * Deprecated older option name : aStor\n     */\n    saveValueToSessionStorage: false,\n\n    /*\n     * Manage how autoNumeric react when the user tries to paste an invalid number.\n     * - 'error'    : (This is the default behavior) The input value is not changed and an error is output in the console.\n     * - 'ignore'   : idem than 'error', but fail silently without outputting any error/warning in the console.\n     * - 'clamp'    : if the pasted value is either too small or too big regarding the minimumValue and maximumValue range, then the result is clamped to those limits.\n     * - 'truncate' : autoNumeric will insert as many pasted numbers it can at the initial caret/selection, until everything is pasted, or the range limit is hit.\n     *                The non-pasted numbers are dropped and therefore not used at all.\n     * - 'replace'  : autoNumeric will first insert as many pasted numbers it can at the initial caret/selection, then if the range limit is hit, it will try\n     *                to replace one by one the remaining initial numbers (on the right side of the caret) with the rest of the pasted numbers.\n     *\n     * Note 1 : A paste content starting with a negative sign '-' will be accepted anywhere in the input, and will set the resulting value as a negative number\n     * Note 2 : A paste content starting with a number will be accepted, even if the rest is gibberish (ie. '123foobar456').\n     *          Only the first number will be used (here '123').\n     * Note 3 : The paste event works with the `decimalPlacesShownOnFocus` option too.\n     */\n    //TODO Shouldn't we use `truncate` as the default value?\n    onInvalidPaste: 'error',\n\n    /* method used for rounding\n     * roundingMethod: \"S\", Round-Half-Up Symmetric (default)\n     * roundingMethod: \"A\", Round-Half-Up Asymmetric\n     * roundingMethod: \"s\", Round-Half-Down Symmetric (lower case s)\n     * roundingMethod: \"a\", Round-Half-Down Asymmetric (lower case a)\n     * roundingMethod: \"B\", Round-Half-Even \"Bankers Rounding\"\n     * roundingMethod: \"U\", Round Up \"Round-Away-From-Zero\"\n     * roundingMethod: \"D\", Round Down \"Round-Toward-Zero\" - same as truncate\n     * roundingMethod: \"C\", Round to Ceiling \"Toward Positive Infinity\"\n     * roundingMethod: \"F\", Round to Floor \"Toward Negative Infinity\"\n     * roundingMethod: \"N05\" Rounds to the nearest .05 => same as \"CHF\" used in 1.9X and still valid\n     * roundingMethod: \"U05\" Rounds up to next .05\n     * roundingMethod: \"D05\" Rounds down to next .05\n     * Deprecated older option name : mRound\n     */\n    //TODO Rename the options to more explicit names ('S' => 'RoundHalfUpSymmetric', etc.)\n    //TODO Add an `an.roundingMethod` object that enum those options clearly\n    roundingMethod: 'S',\n\n    /* Allow padding the decimal places with zeros\n     * allowDecimalPadding: true - always Pad decimals with zeros\n     * allowDecimalPadding: false - does not pad with zeros.\n     * Note: setting allowDecimalPadding to 'false' will override the 'decimalPlacesOverride' setting.\n     *\n     * thanks to Jonas Johansson for the suggestion\n     * Deprecated older option name : aPad\n     */\n    allowDecimalPadding: true,\n\n    /* Adds brackets on negative values (ie. transforms '-$ 999.99' to '(999.99)')\n     * Those brackets are visible only when the field does NOT have the focus.\n     * The left and right symbols should be enclosed in quotes and separated by a comma\n     * This option can be of the following values :\n     * null, // This is the default value, which deactivate this feature\n     * '(,)',\n     * '[,]',\n     * '<,>' or\n     * '{,}'\n     * Deprecated older option name : nBracket\n     */\n    //TODO Rename the options to more explicit names ('(,)' => 'parentheses', etc.)\n    negativeBracketsTypeOnBlur: null,\n\n    /* Displayed on empty string \"\"\n     * emptyInputBehavior: \"focus\" - (default) currency sign displayed and the input receives focus\n     * emptyInputBehavior: \"press\" - currency sign displays on any key being pressed\n     * emptyInputBehavior: \"always\" - always displays the currency sign only\n     * emptyInputBehavior: \"zero\" - if the input has no value on focus out displays a zero \"rounded\" with or without a currency sign\n     * Deprecated older option name : wEmpty\n     */\n    emptyInputBehavior: 'focus',\n\n    /* Controls leading zero behavior\n     * leadingZero: \"allow\", - allows leading zeros to be entered. Zeros will be truncated when entering additional digits. On focusout zeros will be deleted.\n     * leadingZero: \"deny\", - allows only one leading zero on values less than one\n     * leadingZero: \"keep\", - allows leading zeros to be entered. on focusout zeros will be retained.\n     * Deprecated older option name : lZero\n     */\n    leadingZero: 'deny',\n\n    /* Determine if the default value will be formatted on initialization.\n     * true = automatically formats the default value on initialization\n     * false = will not format the default value on initialization\n     * Deprecated older option name : aForm\n     */\n    formatOnPageLoad: true,\n\n    /* Determine if the select all keyboard command will select the complete input text, or only the input numeric value\n     * Note : If the currency symbol is between the numeric value and the negative sign, only the numeric value will selected\n     * Deprecated older option name : sNumber\n     */\n    selectNumberOnly: false,\n\n    /* Helper option for ASP.NET postback\n     * should be the value of the unformatted default value\n     * examples:\n     * no default value=\"\" {defaultValueOverride: \"\"}\n     * value=1234.56 {defaultValueOverride: '1234.56'}\n     * Deprecated older option name : anDefault\n     */\n    defaultValueOverride: null,\n\n    /* Removes formatting on submit event\n     * this output format: positive nnnn.nn, negative -nnnn.nn\n     * review the 'unSet' method for other formats\n     * Deprecated older option name : unSetOnSubmit\n     */\n    unformatOnSubmit: false,\n\n    /* Allows the output to be in the locale format via the \"get\", \"getString\" & \"getArray\" methods\n     * null or 'string' => 'nnnn.nn' or '-nnnn.nn' as text type. This is the default behavior.\n     * 'number'         => nnnn.nn or -nnnn.nn as a Number (Warning: this works only for integers inferior to Number.MAX_SAFE_INTEGER)\n     * ',' or '-,'      => 'nnnn,nn' or '-nnnn,nn'\n     * '.-'             => 'nnnn.nn' or 'nnnn.nn-'\n     * ',-'             => 'nnnn,nn' or 'nnnn,nn-'\n     * Deprecated older option name : outputType\n     */\n    outputFormat: null,\n\n    /* Defines if warnings should be shown\n     * Error handling function\n     * true => all warning are shown\n     * false => no warnings are shown, only the thrown errors\n     * Deprecated older option name : debug\n     */\n    showWarnings: true,\n\n    /*\n     * This option is the 'strict mode' (aka 'debug' mode), which allows autoNumeric to strictly analyse the options passed, and fails if an unknown options is used in the settings object.\n     * You should set that to 'TRUE' if you want to make sure you are only using 'pure' autoNumeric settings objects in your code.\n     * If you see uncaught errors in the console and your code starts to fail, this means somehow those options gets corrupted by another program.\n     */\n    failOnUnknownOption: false\n};\n\n/**\n * Wrapper variable that hold named keyboard keys with their respective keyCode as seen in DOM events.\n * //TODO Replace every call to this object with a call to `keyName`\n * @deprecated\n */\nvar keyCode = {\n    Backspace: 8,\n    Tab: 9,\n    Enter: 13,\n    Shift: 16,\n    Ctrl: 17,\n    Alt: 18,\n    PauseBreak: 19,\n    CapsLock: 20,\n    Esc: 27,\n    Space: 32,\n    PageUp: 33,\n    PageDown: 34,\n    End: 35,\n    Home: 36,\n    LeftArrow: 37,\n    UpArrow: 38,\n    RightArrow: 39,\n    DownArrow: 40,\n    Insert: 45,\n    Delete: 46,\n    num0: 48,\n    num1: 49,\n    num2: 50,\n    num3: 51,\n    num4: 52,\n    num5: 53,\n    num6: 54,\n    num7: 55,\n    num8: 56,\n    num9: 57,\n    a: 65,\n    b: 66,\n    c: 67,\n    d: 68,\n    e: 69,\n    f: 70,\n    g: 71,\n    h: 72,\n    i: 73,\n    j: 74,\n    k: 75,\n    l: 76,\n    m: 77,\n    n: 78,\n    o: 79,\n    p: 80,\n    q: 81,\n    r: 82,\n    s: 83,\n    t: 84,\n    u: 85,\n    v: 86,\n    w: 87,\n    x: 88,\n    y: 89,\n    z: 90,\n    Windows: 91,\n    RightClick: 93,\n    numpad0: 96,\n    numpad1: 97,\n    numpad2: 98,\n    numpad3: 99,\n    numpad4: 100,\n    numpad5: 101,\n    numpad6: 102,\n    numpad7: 103,\n    numpad8: 104,\n    numpad9: 105,\n    MultiplyNumpad: 106,\n    PlusNumpad: 107,\n    MinusNumpad: 109,\n    DotNumpad: 110,\n    SlashNumpad: 111,\n    F1: 112,\n    F2: 113,\n    F3: 114,\n    F4: 115,\n    F5: 116,\n    F6: 117,\n    F7: 118,\n    F8: 119,\n    F9: 120,\n    F10: 121,\n    F11: 122,\n    F12: 123,\n    NumLock: 144,\n    ScrollLock: 145,\n    MyComputer: 182,\n    MyCalculator: 183,\n    Semicolon: 186,\n    Equal: 187,\n    Comma: 188,\n    Hyphen: 189,\n    Dot: 190,\n    Slash: 191,\n    Backquote: 192,\n    LeftBracket: 219,\n    Backslash: 220,\n    RightBracket: 221,\n    Quote: 222,\n    Command: 224,\n    AndroidDefault: 229 };\n\n/**\n * Wrapper variable that hold named keyboard keys with their respective key name (as set in KeyboardEvent.key).\n * Those names are listed here :\n * @link https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values\n */\nvar keyName = {\n    // Special values\n    Unidentified: 'Unidentified',\n\n    // Modifier keys\n    Alt: 'Alt',\n    AltGr: 'AltGraph',\n    CapsLock: 'CapsLock', // Under Chrome, e.key is empty for CapsLock\n    Ctrl: 'Control',\n    Fn: 'Fn',\n    FnLock: 'FnLock',\n    Hyper: 'Hyper', // 'OS' under Firefox\n    Meta: 'Meta', // The Windows, Command or ⌘ key // 'OS' under Firefox and IE9\n    Windows: 'Meta', // This is a non-official key name\n    Command: 'Meta', // This is a non-official key name\n    NumLock: 'NumLock',\n    ScrollLock: 'ScrollLock',\n    Shift: 'Shift',\n    Super: 'Super', // 'OS' under Firefox\n    Symbol: 'Symbol',\n    SymbolLock: 'SymbolLock',\n\n    // Whitespace keys\n    Enter: 'Enter',\n    Tab: 'Tab',\n    Space: ' ', // 'Spacebar' for Firefox <37, and IE9\n\n    // Navigation keys\n    DownArrow: 'ArrowDown', // 'Down' for Firefox <=36, and IE9\n    LeftArrow: 'ArrowLeft', // 'Left' for Firefox <=36, and IE9\n    RightArrow: 'ArrowRight', // 'Right' for Firefox <=36, and IE9\n    UpArrow: 'ArrowUp', // 'Up' for Firefox <=36, and IE9\n    End: 'End',\n    Home: 'Home',\n    PageDown: 'PageDown',\n    PageUp: 'PageUp',\n\n    // Editing keys\n    Backspace: 'Backspace',\n    Clear: 'Clear',\n    Copy: 'Copy',\n    CrSel: 'CrSel', // 'Crsel' for Firefox <=36, and IE9\n    Cut: 'Cut',\n    Delete: 'Delete', // 'Del' for Firefox <=36, and IE9\n    EraseEof: 'EraseEof',\n    ExSel: 'ExSel', // 'Exsel' for Firefox <=36, and IE9\n    Insert: 'Insert',\n    Paste: 'Paste',\n    Redo: 'Redo',\n    Undo: 'Undo',\n\n    // UI keys\n    Accept: 'Accept',\n    Again: 'Again',\n    Attn: 'Attn', // 'Unidentified' for Firefox, Chrome, and IE9 ('KanaMode' when using the Japanese keyboard layout)\n    Cancel: 'Cancel',\n    ContextMenu: 'ContextMenu', // 'Apps' for Firefox <=36, and IE9\n    Esc: 'Escape', // 'Esc' for Firefox <=36, and IE9\n    Execute: 'Execute',\n    Find: 'Find',\n    Finish: 'Finish', // 'Unidentified' for Firefox, Chrome, and IE9 ('Katakana' when using the Japanese keyboard layout)\n    Help: 'Help',\n    Pause: 'Pause',\n    Play: 'Play',\n    Props: 'Props',\n    Select: 'Select',\n    ZoomIn: 'ZoomIn',\n    ZoomOut: 'ZoomOut',\n\n    // Device keys\n    BrightnessDown: 'BrightnessDown',\n    BrightnessUp: 'BrightnessUp',\n    Eject: 'Eject',\n    LogOff: 'LogOff',\n    Power: 'Power',\n    PowerOff: 'PowerOff',\n    PrintScreen: 'PrintScreen',\n    Hibernate: 'Hibernate', // 'Unidentified' for Firefox <=37\n    Standby: 'Standby', // 'Unidentified' for Firefox <=36, and IE9\n    WakeUp: 'WakeUp',\n\n    // IME and composition keys\n    Compose: 'Compose',\n    Dead: 'Dead',\n\n    // Function keys\n    F1: 'F1',\n    F2: 'F2',\n    F3: 'F3',\n    F4: 'F4',\n    F5: 'F5',\n    F6: 'F6',\n    F7: 'F7',\n    F8: 'F8',\n    F9: 'F9',\n    F10: 'F10',\n    F11: 'F11',\n    F12: 'F12',\n\n    // Document keys\n    Print: 'Print',\n\n    // 'Normal' keys\n    num0: '0',\n    num1: '1',\n    num2: '2',\n    num3: '3',\n    num4: '4',\n    num5: '5',\n    num6: '6',\n    num7: '7',\n    num8: '8',\n    num9: '9',\n    numpad0: '0',\n    numpad1: '1',\n    numpad2: '2',\n    numpad3: '3',\n    numpad4: '4',\n    numpad5: '5',\n    numpad6: '6',\n    numpad7: '7',\n    numpad8: '8',\n    numpad9: '9',\n    a: 'a',\n    b: 'b',\n    c: 'c',\n    d: 'd',\n    e: 'e',\n    f: 'f',\n    g: 'g',\n    h: 'h',\n    i: 'i',\n    j: 'j',\n    k: 'k',\n    l: 'l',\n    m: 'm',\n    n: 'n',\n    o: 'o',\n    p: 'p',\n    q: 'q',\n    r: 'r',\n    s: 's',\n    t: 't',\n    u: 'u',\n    v: 'v',\n    w: 'w',\n    x: 'x',\n    y: 'y',\n    z: 'z',\n    MultiplyNumpad: '*',\n    PlusNumpad: '+',\n    MinusNumpad: '-',\n    DotNumpad: '.',\n    SlashNumpad: '/',\n    Semicolon: ';',\n    Equal: '=',\n    Comma: ',',\n    Hyphen: '-',\n    Minus: '-',\n    Plus: '+',\n    Dot: '.',\n    Slash: '/',\n    Backquote: '`',\n    LeftBracket: '[',\n    RightBracket: ']',\n    Backslash: '\\\\',\n    Quote: \"'\",\n    NumpadDot: '.',\n    NumpadDotAlt: ',', // Modern browsers automatically adapt the character sent by this key to the decimal character of the current language\n    NumpadMultiply: '*',\n    NumpadPlus: '+',\n    NumpadMinus: '-',\n    NumpadSlash: '/',\n    NumpadDotObsoleteBrowsers: 'Decimal',\n    NumpadMultiplyObsoleteBrowsers: 'Multiply',\n    NumpadPlusObsoleteBrowsers: 'Add',\n    NumpadMinusObsoleteBrowsers: 'Subtract',\n    NumpadSlashObsoleteBrowsers: 'Divide'\n};\n\nvar defaultMinimumValue = '-999999999999.99';\nvar defaultMaximumValue = '999999999999.99';\nvar defaultRoundingMethod = 'U';\nvar defaultLeadingZero = 'deny';\nvar defaultSelectNumberOnly = true;\n\n/**\n * Predefined options for the most common languages\n */\nvar languageOption = {\n    French: { // Français\n        digitGroupSeparator: '.', // or '\\u202f'\n        decimalCharacter: ',',\n        decimalCharacterAlternative: '.',\n        currencySymbol: '\\u202F\\u20AC',\n        currencySymbolPlacement: 's',\n        selectNumberOnly: defaultSelectNumberOnly,\n        roundingMethod: defaultRoundingMethod,\n        leadingZero: defaultLeadingZero,\n        minimumValue: defaultMinimumValue,\n        maximumValue: defaultMaximumValue\n    },\n    NorthAmerican: {\n        digitGroupSeparator: ',',\n        decimalCharacter: '.',\n        currencySymbol: '$',\n        currencySymbolPlacement: 'p',\n        selectNumberOnly: defaultSelectNumberOnly,\n        roundingMethod: defaultRoundingMethod,\n        leadingZero: defaultLeadingZero,\n        minimumValue: defaultMinimumValue,\n        maximumValue: defaultMaximumValue\n    },\n    British: {\n        digitGroupSeparator: ',',\n        decimalCharacter: '.',\n        currencySymbol: '£',\n        currencySymbolPlacement: 'p',\n        selectNumberOnly: defaultSelectNumberOnly,\n        roundingMethod: defaultRoundingMethod,\n        leadingZero: defaultLeadingZero,\n        minimumValue: defaultMinimumValue,\n        maximumValue: defaultMaximumValue\n    },\n    Swiss: { // Suisse\n        digitGroupSeparator: '\\'',\n        decimalCharacter: '.',\n        currencySymbol: '\\u202FCHF',\n        currencySymbolPlacement: 's',\n        selectNumberOnly: defaultSelectNumberOnly,\n        roundingMethod: defaultRoundingMethod,\n        leadingZero: defaultLeadingZero,\n        minimumValue: defaultMinimumValue,\n        maximumValue: defaultMaximumValue\n    },\n    Japanese: { // 日本語\n        digitGroupSeparator: ',',\n        decimalCharacter: '.',\n        currencySymbol: '¥',\n        currencySymbolPlacement: 'p',\n        selectNumberOnly: defaultSelectNumberOnly,\n        roundingMethod: defaultRoundingMethod,\n        leadingZero: defaultLeadingZero,\n        minimumValue: defaultMinimumValue,\n        maximumValue: defaultMaximumValue\n    }\n};\nlanguageOption.Spanish = languageOption.French; // Español (idem French)\nlanguageOption.Chinese = languageOption.Japanese; // 中国語 (Chinese)\n\n/**\n * UMD structure\n */\n(function (factory) {\n    //TODO This surely can be improved by letting webpack take care of generating this UMD part\n    if (true) {\n        // AMD. Register as an anonymous module.\n        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(1)], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n    } else if ((typeof module === 'undefined' ? 'undefined' : _typeof(module)) === 'object' && module.exports) {\n        // Node/CommonJS\n        module.exports = factory(require('jquery'));\n    } else {\n        // Browser globals\n        factory(window.jQuery);\n    }\n})(function ($) {\n    // Helper functions\n\n    /**\n     * Return TRUE if the `value` is null\n     *\n     * @static\n     * @param {*} value The value to test\n     * @returns {boolean} Return TRUE if the `value` is null, FALSE otherwise\n     */\n    function isNull(value) {\n        return value === null;\n    }\n\n    /**\n     * Return TRUE if the `value` is undefined\n     *\n     * @static\n     * @param {*} value The value to test\n     * @returns {boolean} Return TRUE if the `value` is undefined, FALSE otherwise\n     */\n    function isUndefined(value) {\n        return value === void 0;\n    }\n\n    /**\n     * Return TRUE if the `value` is undefined, null or empty\n     *\n     * @param {*} value\n     * @returns {boolean}\n     */\n    function isUndefinedOrNullOrEmpty(value) {\n        return value === null || value === void 0 || '' === value;\n    }\n\n    /**\n     * Return TRUE if the given parameter is a String\n     *\n     * @param {*} str\n     * @returns {boolean}\n     */\n    function isString(str) {\n        return typeof str === 'string' || str instanceof String;\n    }\n\n    /**\n     * Return TRUE if the parameter is a boolean\n     *\n     * @static\n     * @param {*} value\n     * @returns {boolean}\n     */\n    function isBoolean(value) {\n        return typeof value === 'boolean';\n    }\n\n    /**\n     * Return TRUE if the parameter is a string 'true' or 'false'\n     *\n     * This function accepts any cases for those strings.\n     * @param {string} value\n     * @returns {boolean}\n     */\n    function isTrueOrFalseString(value) {\n        var lowercaseValue = String(value).toLowerCase();\n        return lowercaseValue === 'true' || lowercaseValue === 'false';\n    }\n\n    /**\n     * Return TRUE if the parameter is an object\n     *\n     * @param {*} reference\n     * @returns {boolean}\n     */\n    function isObject(reference) {\n        return (typeof reference === 'undefined' ? 'undefined' : _typeof(reference)) === 'object' && reference !== null && !Array.isArray(reference);\n    }\n\n    /**\n     * Return TRUE if the given object is empty\n     * cf. http://stackoverflow.com/questions/679915/how-do-i-test-for-an-empty-javascript-object and http://jsperf.com/empty-object-test\n     *\n     * @param {object} obj\n     * @returns {boolean}\n     */\n    function isEmptyObj(obj) {\n        for (var prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    }\n\n    /**\n     * Return TRUE if the parameter is a number (or a number written as a string).\n     *\n     * @param {*} n\n     * @returns {boolean}\n     */\n    function isNumber(n) {\n        return !isArray(n) && !isNaN(parseFloat(n)) && isFinite(n);\n    }\n\n    /**\n     * Return TRUE if the parameter is an integer (and not a float).\n     *\n     * @param {*} n\n     * @returns {boolean}\n     */\n    function isInt(n) {\n        return typeof n === 'number' && parseFloat(n) === parseInt(n, 10) && !isNaN(n);\n    }\n\n    /**\n     * Return the pasted text that will be used.\n     *\n     * @param {string} text\n     * @param {AutoNumericHolder} holder\n     * @returns {string|void|XML|*}\n     */\n    function preparePastedText(text, holder) {\n        return stripAllNonNumberCharacters(text, holder.settingsClone, true).replace(holder.settingsClone.decimalCharacter, '.');\n    }\n\n    /**\n     * Return TRUE is the string `str` contains the string `needle`\n     * Note: this function does not coerce the parameters types\n     *\n     * @param {string} str\n     * @param {string} needle\n     * @returns {boolean}\n     */\n    function contains(str, needle) {\n        if (!isString(str) || !isString(needle) || str === '' || needle === '') {\n            return false;\n        }\n\n        return str.indexOf(needle) !== -1;\n    }\n\n    /**\n     * Return TRUE if the `needle` is in the array\n     *\n     * @param {*} needle\n     * @param {Array} array\n     * @returns {boolean}\n     */\n    function isInArray(needle, array) {\n        if (!isArray(array) || array === [] || isUndefined(needle)) {\n            return false;\n        }\n\n        return array.indexOf(needle) !== -1;\n    }\n\n    /**\n     * Return TRUE if the parameter is an Array\n     *\n     * @param {*} arr\n     * @throws Error\n     * @returns {*|boolean}\n     */\n    function isArray(arr) {\n        if (Object.prototype.toString.call([]) === '[object Array]') {\n            // Make sure an array has a class attribute of [object Array]\n            // Test passed, now check if is an Array\n            return Array.isArray(arr) || (typeof arr === 'undefined' ? 'undefined' : _typeof(arr)) === 'object' && Object.prototype.toString.call(arr) === '[object Array]';\n        } else {\n            throw new Error('toString message changed for Object Array'); // Verify that the string returned by `toString` does not change in the future (cf. http://stackoverflow.com/a/8365215)\n        }\n    }\n\n    /**\n     * Return TRUE if the parameter is a string that represents a float number, and that number has a decimal part\n     *\n     * @param {string} str\n     * @returns {boolean}\n     */\n    // function hasDecimals(str) {\n    //     const [, decimalPart] = str.split('.');\n    //     return !isUndefined(decimalPart);\n    // }\n\n    /**\n     * Return the number of decimal places if the parameter is a string that represents a float number, and that number has a decimal part.\n     *\n     * @param {string} str\n     * @returns {int}\n     */\n    function decimalPlaces(str) {\n        var _str$split = str.split('.'),\n            _str$split2 = _slicedToArray(_str$split, 2),\n            decimalPart = _str$split2[1];\n\n        if (!isUndefined(decimalPart)) {\n            return decimalPart.length;\n        }\n\n        return 0;\n    }\n\n    /**\n     * Return the code for the key used to generate the given event.\n     *\n     * @param {Event} event\n     * @returns {string|Number}\n     */\n    function keyCodeNumber(event) {\n        // `event.keyCode` and `event.which` are deprecated, `KeyboardEvent.key` (https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key) must be used now\n        return typeof event.which === 'undefined' ? event.keyCode : event.which;\n    }\n\n    /**\n     * Return the character from the event key code.\n     * @example character(50) => '2'\n     *\n     * @param {Event} event\n     * @returns {string}\n     */\n    function character(event) {\n        if (typeof event.key === 'undefined' || event.key === 'Unidentified') {\n            return String.fromCharCode(keyCodeNumber(event));\n        } else {\n            // Special case for obsolete browsers like IE that return the old names\n            var result = void 0;\n            switch (event.key) {\n                case 'Decimal':\n                    result = keyName.NumpadDot;\n                    break;\n                case 'Multiply':\n                    result = keyName.NumpadMultiply;\n                    break;\n                case 'Add':\n                    result = keyName.NumpadPlus;\n                    break;\n                case 'Subtract':\n                    result = keyName.NumpadMinus;\n                    break;\n                case 'Divide':\n                    result = keyName.NumpadSlash;\n                    break;\n                case 'Del':\n                    // Special workaround for the obsolete browser IE11 which output a 'Delete' key when using the numpad 'dot' one! This fixes issue #401 //FIXME à terminer\n                    result = keyName.Dot; // as of version 2.0.8 the character() function is only called on keypress event. The 'Del' does not throw the keypress event.\n                    break;\n                default:\n                    result = event.key;\n            }\n\n            return result;\n        }\n    }\n\n    /**\n     * Return TRUE if the given value (a number as a string) is within the range set in the settings `minimumValue` and `maximumValue`, FALSE otherwise.\n     *\n     * @param {string} value\n     * @param {object} parsedMinValue Parsed via the `parseStr()` function\n     * @param {object} parsedMaxValue Parsed via the `parseStr()` function\n     * @returns {boolean}\n     */\n    function checkIfInRange(value, parsedMinValue, parsedMaxValue) {\n        var parsedValue = parseStr(value);\n        return testMinMax(parsedMinValue, parsedValue) > -1 && testMinMax(parsedMaxValue, parsedValue) < 1;\n    }\n\n    /**\n     * Return TRUE if the given string contains a negative sign :\n     * - everywhere in the string (by default), or\n     * - on the first character only if the `checkEverywhere` parameter is set to `false`.\n     *\n     * @param {string} numericString A number represented by a string\n     * @param {boolean} checkEverywhere If TRUE, then the negative sign is search everywhere in the numeric string (this is needed for instance if the string is '1234.56-')\n     * @returns {boolean}\n     */\n    function isNegative(numericString) {\n        var checkEverywhere = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;\n\n        //TODO Use the `negativeSignCharacter` from the settings here\n        if (checkEverywhere) {\n            return contains(numericString, '-');\n        }\n\n        return isNegativeStrict(numericString);\n    }\n\n    /**\n     * Return TRUE if the given string contains a negative sign on the first character (on the far left).\n     *\n     * @example isNegativeStrict('1234.56')     => false\n     * @example isNegativeStrict('1234.56-')    => false\n     * @example isNegativeStrict('-1234.56')    => true\n     * @example isNegativeStrict('-1,234.56 €') => true\n     *\n     * @param {string} numericString\n     * @returns {boolean}\n     */\n    function isNegativeStrict(numericString) {\n        //TODO Using the `negativeSignCharacter` from the settings here\n        return numericString.charAt(0) === '-';\n    }\n\n    /**\n     * Return TRUE if the formatted or unformatted numeric string represent the value 0 (ie. '0,00 €'), or is empty (' €').\n     * This works since we test if there are any numbers from 1 to 9 in the string. If there is none, then the number is zero (or the string is empty).\n     *\n     * @param {string} numericString\n     * @returns {boolean}\n     */\n    function isZeroOrHasNoValue(numericString) {\n        return !/[1-9]/g.test(numericString);\n    }\n\n    /**\n     * Return the negative version of the value (represented as a string) given as a parameter.\n     *\n     * @param {string} value\n     * @returns {*}\n     */\n    function setRawNegativeSign(value) {\n        if (!isNegativeStrict(value)) {\n            return '-' + value;\n        }\n\n        return value;\n    }\n\n    /**\n     * Replace the character at the position `index` in the string `string` by the character(s) `newCharacter`.\n     *\n     * @param {string} string\n     * @param {int} index\n     * @param {string} newCharacter\n     * @returns {string}\n     */\n    function replaceCharAt(string, index, newCharacter) {\n        return '' + string.substr(0, index) + newCharacter + string.substr(index + newCharacter.length);\n    }\n\n    /**\n     * Return the value clamped to the nearest minimum/maximum value, as defined in the settings.\n     *\n     * @param {string|number} value\n     * @param {object} settings\n     * @returns {number}\n     */\n    function clampToRangeLimits(value, settings) {\n        //XXX This function always assume `settings.minimumValue` is lower than `settings.maximumValue`\n        return Math.max(settings.minimumValue, Math.min(settings.maximumValue, value));\n    }\n\n    /**\n     * Return the number of number or dot characters on the left side of the caret, in a formatted number.\n     *\n     * @param {string} formattedNumberString\n     * @param {int} caretPosition This must be a positive integer\n     * @param {string} decimalCharacter\n     * @returns {number}\n     */\n    function countNumberCharactersOnTheCaretLeftSide(formattedNumberString, caretPosition, decimalCharacter) {\n        // Here we count the dot and report it as a number character too, since it will 'stay' in the Javascript number when unformatted\n        var numberDotOrNegativeSign = new RegExp('[0-9' + decimalCharacter + '-]'); // No need to escape the decimal character here, since it's in `[]`\n\n        var numberDotAndNegativeSignCount = 0;\n        for (var i = 0; i < caretPosition; i++) {\n            // Test if the character is a number, a dot or an hyphen. If it is, count it, otherwise ignore it\n            if (numberDotOrNegativeSign.test(formattedNumberString[i])) {\n                numberDotAndNegativeSignCount++;\n            }\n        }\n\n        return numberDotAndNegativeSignCount;\n    }\n\n    /**\n     * Walk the `formattedNumberString` from left to right, one char by one, counting the `formattedNumberStringIndex`.\n     * If the char is in the `rawNumberString` (starting at index 0), then `rawNumberStringIndex++`, and continue until\n     * there is no more characters in `rawNumberString`) or that `rawNumberStringIndex === caretPositionInRawValue`.\n     * When you stop, the `formattedNumberStringIndex` is the position where the caret should be set.\n     *\n     * @example\n     * 1234567|89.01   : position 7 (rawNumberString)\n     * 123.456.7|89,01 : position 9 (formattedNumberString)\n     *\n     * @param {string} rawNumberString\n     * @param {int} caretPositionInRawValue\n     * @param {string} formattedNumberString\n     * @param {string} decimalCharacter\n     * @returns {*}\n     */\n    function findCaretPositionInFormattedNumber(rawNumberString, caretPositionInRawValue, formattedNumberString, decimalCharacter) {\n        var formattedNumberStringSize = formattedNumberString.length;\n        var rawNumberStringSize = rawNumberString.length;\n\n        var formattedNumberStringIndex = void 0;\n        var rawNumberStringIndex = 0;\n        for (formattedNumberStringIndex = 0; formattedNumberStringIndex < formattedNumberStringSize && rawNumberStringIndex < rawNumberStringSize && rawNumberStringIndex < caretPositionInRawValue; formattedNumberStringIndex++) {\n            if (rawNumberString[rawNumberStringIndex] === formattedNumberString[formattedNumberStringIndex] || rawNumberString[rawNumberStringIndex] === '.' && formattedNumberString[formattedNumberStringIndex] === decimalCharacter) {\n                rawNumberStringIndex++;\n            }\n        }\n\n        return formattedNumberStringIndex;\n    }\n\n    /**\n     * Count the number of occurrence of the given character, in the given text.\n     *\n     * @param {string} character\n     * @param {string} text\n     * @returns {number}\n     */\n    function countCharInText(character, text) {\n        var charCounter = 0;\n        for (var i = 0; i < text.length; i++) {\n            if (text[i] === character) {\n                charCounter++;\n            }\n        }\n\n        return charCounter;\n    }\n\n    /**\n     * Return the index that can be used to set the caret position.\n     * This takes into account that the position is starting at '0', not 1.\n     *\n     * @param {int} characterCount\n     * @returns {number}\n     */\n    function convertCharacterCountToIndexPosition(characterCount) {\n        return Math.max(characterCount, characterCount - 1);\n    }\n\n    /**\n     * Cross browser routine for getting selected range/cursor position\n     *\n     * @param {HTMLElement|EventTarget} that\n     * @returns {{}}\n     */\n    function getElementSelection(that) {\n        var position = {};\n        if (isUndefined(that.selectionStart)) {\n            that.focus();\n            var select = document.selection.createRange();\n            position.length = select.text.length;\n            select.moveStart('character', -that.value.length);\n            position.end = select.text.length;\n            position.start = position.end - position.length;\n        } else {\n            position.start = that.selectionStart;\n            position.end = that.selectionEnd;\n            position.length = position.end - position.start;\n        }\n\n        return position;\n    }\n\n    /**\n     * Cross browser routine for setting selected range/cursor position\n     *\n     * @param {HTMLElement|EventTarget} that\n     * @param {int} start\n     * @param {int|null} end\n     */\n    function setElementSelection(that, start) {\n        var end = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;\n\n        if (isUndefinedOrNullOrEmpty(end)) {\n            end = start;\n        }\n\n        if (isUndefined(that.selectionStart)) {\n            that.focus();\n            var range = that.createTextRange();\n            range.collapse(true);\n            range.moveEnd('character', end);\n            range.moveStart('character', start);\n            range.select();\n        } else {\n            that.selectionStart = start;\n            that.selectionEnd = end;\n        }\n    }\n\n    /**\n     * Function that throw error messages\n     *\n     * @param {string} message\n     */\n    function throwError(message) {\n        throw new Error(message);\n    }\n\n    /**\n     * Function that display a warning messages, according to the debug level.\n     *\n     * @param {string} message\n     * @param {boolean} showWarning If FALSE, then the warning message is not displayed\n     */\n    function warning(message) {\n        var showWarning = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;\n\n        if (showWarning) {\n            /* eslint no-console: 0 */\n            console.warn('Warning: ' + message);\n        }\n    }\n\n    // autoNumeric-specific functions\n\n    /**\n     * Run any callbacks found in the settings object.\n     * Any parameter could be a callback:\n     * - a function, which invoked with jQuery element, parameters and this parameter name and returns parameter value\n     * - a name of function, attached to $(selector).autoNumeric.functionName(){} - which was called previously\n     * @param {object} $this jQuery-selected DOM element\n     * @param {object} settings\n     */\n    function runCallbacksFoundInTheSettingsObject($this, settings) {\n        // Loops through the settings object (option array) to find the following\n        $.each(settings, function (k, val) {\n            if (typeof val === 'function') {\n                settings[k] = val($this, settings, k);\n            } else if (typeof $this.autoNumeric[val] === 'function') {\n                // Calls the attached function from the html5 data example: data-a-sign=\"functionName\"\n                settings[k] = $this.autoNumeric[val]($this, settings, k);\n            }\n        });\n    }\n\n    /**\n     * Determine the maximum decimal length from the minimumValue and maximumValue settings\n     *\n     * @param {string} minimumValue\n     * @param {string} maximumValue\n     * @returns {number}\n     */\n    function maximumVMinAndVMaxDecimalLength(minimumValue, maximumValue) {\n        return Math.max(decimalPlaces(minimumValue), decimalPlaces(maximumValue));\n    }\n\n    /**\n     * Strip all unwanted non-number characters.\n     * This keeps the numbers, the negative sign as well as the custom decimal character.\n     *\n     * @param {string} s\n     * @param {object} settings\n     * @param {boolean} leftOrAll\n     * @returns {string|*}\n     */\n    function stripAllNonNumberCharacters(s, settings, leftOrAll) {\n        //TODO This function is called 10 times (sic!) on each key input, couldn't we lower that number? cf. issue #325\n        //TODO Refactor this with `convertToNumericString()` if possible?\n        if (settings.currencySymbol !== '') {\n            // Remove currency sign\n            s = s.replace(settings.currencySymbol, '');\n        }\n        if (settings.suffixText) {\n            // Remove suffix\n            while (contains(s, settings.suffixText)) {\n                s = s.replace(settings.suffixText, '');\n            }\n        }\n\n        // First replace anything before digits\n        s = s.replace(settings.skipFirstAutoStrip, '$1$2');\n\n        if ((settings.negativePositiveSignPlacement === 's' || settings.currencySymbolPlacement === 's' && settings.negativePositiveSignPlacement !== 'p') && isNegative(s) && s !== '') {\n            settings.trailingNegative = true;\n        }\n\n        // Then replace anything after digits\n        s = s.replace(settings.skipLastAutoStrip, '$1');\n\n        // Then remove any uninteresting characters\n        s = s.replace(settings.allowedAutoStrip, '');\n        if (settings.decimalCharacterAlternative) {\n            s = s.replace(settings.decimalCharacterAlternative, settings.decimalCharacter);\n        }\n\n        // Get only number string\n        var m = s.match(settings.numRegAutoStrip);\n        s = m ? [m[1], m[2], m[3]].join('') : '';\n\n        if (settings.leadingZero === 'allow' || settings.leadingZero === 'keep') {\n            var nSign = '';\n\n            var _s$split = s.split(settings.decimalCharacter),\n                _s$split2 = _slicedToArray(_s$split, 2),\n                integerPart = _s$split2[0],\n                decimalPart = _s$split2[1];\n\n            var modifiedIntegerPart = integerPart;\n            if (contains(modifiedIntegerPart, settings.negativeSignCharacter)) {\n                nSign = settings.negativeSignCharacter;\n                modifiedIntegerPart = modifiedIntegerPart.replace(settings.negativeSignCharacter, '');\n            }\n\n            // Strip leading zero on positive value if need\n            if (nSign === '' && modifiedIntegerPart.length > settings.mIntPos && modifiedIntegerPart.charAt(0) === '0') {\n                modifiedIntegerPart = modifiedIntegerPart.slice(1);\n            }\n\n            // Strip leading zero on negative value if need\n            if (nSign !== '' && modifiedIntegerPart.length > settings.mIntNeg && modifiedIntegerPart.charAt(0) === '0') {\n                modifiedIntegerPart = modifiedIntegerPart.slice(1);\n            }\n\n            s = '' + nSign + modifiedIntegerPart + (isUndefined(decimalPart) ? '' : settings.decimalCharacter + decimalPart);\n        }\n\n        if (leftOrAll && settings.leadingZero === 'deny' || !settings.hasFocus && settings.leadingZero === 'allow') {\n            s = s.replace(settings.stripReg, '$1$2');\n        }\n\n        return s;\n    }\n\n    /**\n     * Sets or removes brackets on negative values, depending on the focus state.\n     * The focus state is 'stored' in the settings object under the `settings.hasFocus` attribute.\n     * //TODO Use another object to keep track of internal data that are not settings\n     *\n     * @param {string} s\n     * @param {object} settings\n     * @returns {*}\n     */\n    function toggleNegativeBracket(s, settings) {\n        if (settings.currencySymbolPlacement === 'p' && settings.negativePositiveSignPlacement === 'l' || settings.currencySymbolPlacement === 's' && settings.negativePositiveSignPlacement === 'p') {\n            //TODO Split the first and last bracket only once during the settings initialization\n            var _settings$negativeBra = settings.negativeBracketsTypeOnBlur.split(','),\n                _settings$negativeBra2 = _slicedToArray(_settings$negativeBra, 2),\n                firstBracket = _settings$negativeBra2[0],\n                lastBracket = _settings$negativeBra2[1];\n\n            if (!settings.hasFocus) {\n                // Add brackets\n                s = s.replace(settings.negativeSignCharacter, '');\n                s = firstBracket + s + lastBracket;\n            } else if (settings.hasFocus && s.charAt(0) === firstBracket) {\n                // Remove brackets\n                //TODO Quid if the negative sign is not on the left, shouldn't we replace the '-' sign at the right place?\n                s = s.replace(firstBracket, settings.negativeSignCharacter);\n                s = s.replace(lastBracket, '');\n            }\n        }\n\n        return s;\n    }\n\n    /**\n     * Return a number as a numeric string that can be typecast to a Number that Javascript will understand.\n     *\n     * This function return the given string by stripping the currency sign (currencySymbol), the grouping separators (digitalGroupSpacing) and by replacing the decimal character (decimalCharacter) by a dot.\n     * Lastly, it also put the negative sign back to its normal position if needed.\n     *\n     * @param {string} s\n     * @param {object} settings\n     * @returns {string|void|XML|*}\n     */\n    function convertToNumericString(s, settings) {\n        // Remove the currency symbol\n        s = s.replace(settings.currencySymbol, '');\n\n        // Remove the grouping separators (thousands separators usually)\n        s = s.replace(settings.digitGroupSeparator, '');\n\n        // Replace the decimal character by a dot\n        if (settings.decimalCharacter !== '.') {\n            s = s.replace(settings.decimalCharacter, '.');\n        }\n\n        // Move the trailing negative sign to the right position, if any\n        if (isNegative(s) && s.lastIndexOf('-') === s.length - 1) {\n            s = s.replace('-', '');\n            s = '-' + s;\n        }\n\n        // Convert any arabic numbers to latin ones\n        var temp = arabicToLatinNumbers(s, true, false, false);\n        if (!isNaN(temp)) {\n            s = temp.toString();\n        }\n\n        return s;\n    }\n\n    /**\n     * Converts the ISO numeric string to the locale decimal and minus sign placement.\n     * See the \"outputFormat\" option definition for more details.\n     *\n     * @param {string|null} value\n     * @param {string} locale\n     * @returns {*}\n     */\n    function toLocale(value, locale) {\n        if (isNull(locale) || locale === 'string') {\n            return value;\n        }\n\n        var result = void 0;\n        switch (locale) {\n            case 'number':\n                result = Number(value);\n                break;\n            case '.-':\n                result = isNegative(value) ? value.replace('-', '') + '-' : value;\n                break;\n            case ',':\n            case '-,':\n                result = value.replace('.', ',');\n                break;\n            case ',-':\n                result = value.replace('.', ',');\n                result = isNegative(result) ? result.replace('-', '') + '-' : result;\n                break;\n            // The default case\n            case '.':\n            case '-.':\n                result = value;\n                break;\n            default:\n                throwError('The given outputFormat [' + locale + '] option is not recognized.');\n        }\n\n        return result;\n    }\n\n    /**\n     * Modify the negative sign and the decimal character of the given string value to an hyphen (-) and a dot (.) in order to make that value 'typecastable' to a real number.\n     *\n     * @param {string} s\n     * @param {object} settings\n     * @returns {string}\n     */\n    function modifyNegativeSignAndDecimalCharacterForRawValue(s, settings) {\n        if (settings.decimalCharacter !== '.') {\n            s = s.replace(settings.decimalCharacter, '.');\n        }\n        if (settings.negativeSignCharacter !== '-' && settings.negativeSignCharacter !== '') {\n            s = s.replace(settings.negativeSignCharacter, '-');\n        }\n        if (!s.match(/\\d/)) {\n            // The default value returned by `get` is not formatted with decimals\n            s += '0';\n        }\n\n        return s;\n    }\n\n    /**\n     * Modify the negative sign and the decimal character to use those defined in the settings.\n     *\n     * @param {string} s\n     * @param {object} settings\n     * @returns {string}\n     */\n    function modifyNegativeSignAndDecimalCharacterForFormattedValue(s, settings) {\n        if (settings.negativeSignCharacter !== '-' && settings.negativeSignCharacter !== '') {\n            s = s.replace('-', settings.negativeSignCharacter);\n        }\n        if (settings.decimalCharacter !== '.') {\n            s = s.replace('.', settings.decimalCharacter);\n        }\n\n        return s;\n    }\n\n    /**\n     * Private function to check for empty value\n     * //TODO Modify this function so that it return either TRUE or FALSE if the value is empty. Then create another function to return the input value if it's not empty.\n     *\n     * @param {string} inputValue\n     * @param {object} settings\n     * @param {boolean} signOnEmpty\n     * @returns {*}\n     */\n    function checkEmpty(inputValue, settings, signOnEmpty) {\n        if (inputValue === '' || inputValue === settings.negativeSignCharacter) {\n            if (settings.emptyInputBehavior === 'always' || signOnEmpty) {\n                return settings.negativePositiveSignPlacement === 'l' ? inputValue + settings.currencySymbol + settings.suffixText : settings.currencySymbol + inputValue + settings.suffixText;\n            }\n\n            return inputValue;\n        }\n\n        return null;\n    }\n\n    /**\n     * Modify the input value by adding the group separators, as defined in the settings.\n     *\n     * @param {string} inputValue\n     * @param {object} settings\n     * @returns {*}\n     */\n    function addGroupSeparators(inputValue, settings) {\n        if (settings.strip) {\n            inputValue = stripAllNonNumberCharacters(inputValue, settings, false);\n        }\n\n        //TODO This function `addGroupSeparators()` add group separators. Adding the negative sign as well is out of its scope. Move that to another function.\n        if (settings.trailingNegative && !isNegative(inputValue)) {\n            inputValue = '-' + inputValue;\n        }\n\n        var empty = checkEmpty(inputValue, settings, true);\n        var isValueNegative = isNegative(inputValue);\n        var isZero = isZeroOrHasNoValue(inputValue);\n        if (isValueNegative) {\n            inputValue = inputValue.replace('-', '');\n        }\n\n        if (!isNull(empty)) {\n            return empty;\n        }\n\n        settings.digitalGroupSpacing = settings.digitalGroupSpacing.toString();\n        var digitalGroup = void 0;\n        switch (settings.digitalGroupSpacing) {\n            case '2':\n                digitalGroup = /(\\d)((\\d)(\\d{2}?)+)$/;\n                break;\n            case '2s':\n                digitalGroup = /(\\d)((?:\\d{2}){0,2}\\d{3}(?:(?:\\d{2}){2}\\d{3})*?)$/;\n                break;\n            case '4':\n                digitalGroup = /(\\d)((\\d{4}?)+)$/;\n                break;\n            default:\n                digitalGroup = /(\\d)((\\d{3}?)+)$/;\n        }\n\n        // Splits the string at the decimal string\n\n        var _inputValue$split = inputValue.split(settings.decimalCharacter),\n            _inputValue$split2 = _slicedToArray(_inputValue$split, 2),\n            integerPart = _inputValue$split2[0],\n            decimalPart = _inputValue$split2[1];\n\n        if (settings.decimalCharacterAlternative && isUndefined(decimalPart)) {\n            var _inputValue$split3 = inputValue.split(settings.decimalCharacterAlternative);\n\n            var _inputValue$split4 = _slicedToArray(_inputValue$split3, 2);\n\n            integerPart = _inputValue$split4[0];\n            decimalPart = _inputValue$split4[1];\n        }\n\n        if (settings.digitGroupSeparator !== '') {\n            // Re-inserts the thousand separator via a regular expression\n            while (digitalGroup.test(integerPart)) {\n                integerPart = integerPart.replace(digitalGroup, '$1' + settings.digitGroupSeparator + '$2');\n            }\n        }\n\n        if (settings.decimalPlacesOverride !== 0 && !isUndefined(decimalPart)) {\n            if (decimalPart.length > settings.decimalPlacesOverride) {\n                decimalPart = decimalPart.substring(0, settings.decimalPlacesOverride);\n            }\n\n            // Joins the whole number with the decimal value\n            inputValue = integerPart + settings.decimalCharacter + decimalPart;\n        } else {\n            // Otherwise if it's an integer\n            inputValue = integerPart;\n        }\n\n        settings.trailingNegative = false;\n\n        if (settings.currencySymbolPlacement === 'p') {\n            if (isValueNegative) {\n                switch (settings.negativePositiveSignPlacement) {\n                    case 'l':\n                        inputValue = '' + settings.negativeSignCharacter + settings.currencySymbol + inputValue;\n                        break;\n                    case 'r':\n                        inputValue = '' + settings.currencySymbol + settings.negativeSignCharacter + inputValue;\n                        break;\n                    case 's':\n                        inputValue = '' + settings.currencySymbol + inputValue + settings.negativeSignCharacter;\n                        settings.trailingNegative = true;\n                        break;\n                    default:\n                    //\n                }\n            } else if (settings.showPositiveSign && !isZero) {\n                switch (settings.negativePositiveSignPlacement) {\n                    case 'l':\n                        inputValue = '' + settings.positiveSignCharacter + settings.currencySymbol + inputValue;\n                        break;\n                    case 'r':\n                        inputValue = '' + settings.currencySymbol + settings.positiveSignCharacter + inputValue;\n                        break;\n                    case 's':\n                        inputValue = '' + settings.currencySymbol + inputValue + settings.positiveSignCharacter;\n                        break;\n                    default:\n                    //\n                }\n            } else {\n                inputValue = settings.currencySymbol + inputValue;\n            }\n        }\n\n        if (settings.currencySymbolPlacement === 's') {\n            if (isValueNegative) {\n                switch (settings.negativePositiveSignPlacement) {\n                    case 'r':\n                        inputValue = '' + inputValue + settings.currencySymbol + settings.negativeSignCharacter;\n                        settings.trailingNegative = true;\n                        break;\n                    case 'l':\n                        inputValue = '' + inputValue + settings.negativeSignCharacter + settings.currencySymbol;\n                        settings.trailingNegative = true;\n                        break;\n                    case 'p':\n                        inputValue = '' + settings.negativeSignCharacter + inputValue + settings.currencySymbol;\n                        break;\n                    default:\n                    //\n                }\n            } else if (settings.showPositiveSign && !isZero) {\n                switch (settings.negativePositiveSignPlacement) {\n                    case 'r':\n                        inputValue = '' + inputValue + settings.currencySymbol + settings.positiveSignCharacter;\n                        break;\n                    case 'l':\n                        inputValue = '' + inputValue + settings.positiveSignCharacter + settings.currencySymbol;\n                        break;\n                    case 'p':\n                        inputValue = '' + settings.positiveSignCharacter + inputValue + settings.currencySymbol;\n                        break;\n                    default:\n                    //\n                }\n            } else {\n                inputValue = inputValue + settings.currencySymbol;\n            }\n        }\n\n        // Removes the negative sign and places brackets\n        if (settings.negativeBracketsTypeOnBlur !== null && (settings.rawValue < 0 || isNegativeStrict(inputValue))) {\n            inputValue = toggleNegativeBracket(inputValue, settings);\n        }\n\n        return inputValue + settings.suffixText;\n    }\n\n    /**\n     * Truncate not needed zeros\n     *\n     * @param {string} roundedInputValue\n     * @param {int} temporaryDecimalPlacesOverride\n     * @returns {void|XML|string|*}\n     */\n    function truncateZeros(roundedInputValue, temporaryDecimalPlacesOverride) {\n        var regex = void 0;\n        switch (temporaryDecimalPlacesOverride) {\n            case 0:\n                // Prevents padding - removes trailing zeros until the first significant digit is encountered\n                regex = /(\\.(?:\\d*[1-9])?)0*$/;\n                break;\n            case 1:\n                // Allows padding when decimalPlacesOverride equals one - leaves one zero trailing the decimal character\n                regex = /(\\.\\d(?:\\d*[1-9])?)0*$/;\n                break;\n            default:\n                // Removes access zeros to the decimalPlacesOverride length when allowDecimalPadding is set to true\n                regex = new RegExp('(\\\\.\\\\d{' + temporaryDecimalPlacesOverride + '}(?:\\\\d*[1-9])?)0*');\n        }\n\n        // If there are no decimal places, we don't need a decimal point at the end\n        roundedInputValue = roundedInputValue.replace(regex, '$1');\n        if (temporaryDecimalPlacesOverride === 0) {\n            roundedInputValue = roundedInputValue.replace(/\\.$/, '');\n        }\n\n        return roundedInputValue;\n    }\n\n    /**\n     * Round the input value using the rounding method defined in the settings.\n     * This function accepts multiple rounding methods. See the documentation for more details about those.\n     *\n     * Note : This is handled as text since JavaScript math function can return inaccurate values.\n     *\n     * @param {string} inputValue\n     * @param {object} settings\n     * @returns {*}\n     */\n    function roundValue(inputValue, settings) {\n        inputValue = inputValue === '' ? '0' : inputValue.toString();\n        if (settings.roundingMethod === 'N05' || settings.roundingMethod === 'CHF' || settings.roundingMethod === 'U05' || settings.roundingMethod === 'D05') {\n            switch (settings.roundingMethod) {\n                case 'N05':\n                    inputValue = (Math.round(inputValue * 20) / 20).toString();\n                    break;\n                case 'U05':\n                    inputValue = (Math.ceil(inputValue * 20) / 20).toString();\n                    break;\n                default:\n                    inputValue = (Math.floor(inputValue * 20) / 20).toString();\n            }\n\n            var result = void 0;\n            if (!contains(inputValue, '.')) {\n                result = inputValue + '.00';\n            } else if (inputValue.length - inputValue.indexOf('.') < 3) {\n                result = inputValue + '0';\n            } else {\n                result = inputValue;\n            }\n            return result;\n        }\n\n        var ivRounded = '';\n        var i = 0;\n        var nSign = '';\n        var temporaryDecimalPlacesOverride = void 0;\n\n        // sets the truncate zero method\n        if (settings.allowDecimalPadding) {\n            temporaryDecimalPlacesOverride = settings.decimalPlacesOverride;\n        } else {\n            temporaryDecimalPlacesOverride = 0;\n        }\n\n        // Checks if the inputValue (input Value) is a negative value\n        if (isNegativeStrict(inputValue)) {\n            nSign = '-';\n\n            // Removes the negative sign that will be added back later if required\n            inputValue = inputValue.replace('-', '');\n        }\n\n        // Append a zero if the first character is not a digit (then it is likely to be a dot)\n        if (!inputValue.match(/^\\d/)) {\n            inputValue = '0' + inputValue;\n        }\n\n        // Determines if the value is equal to zero. If it is, remove the negative sign\n        if (Number(inputValue) === 0) {\n            nSign = '';\n        }\n\n        // Trims leading zero's as needed\n        if (Number(inputValue) > 0 && settings.leadingZero !== 'keep' || inputValue.length > 0 && settings.leadingZero === 'allow') {\n            inputValue = inputValue.replace(/^0*(\\d)/, '$1');\n        }\n\n        var dPos = inputValue.lastIndexOf('.');\n        var inputValueHasADot = dPos === -1;\n\n        // Virtual decimal position\n        var vdPos = inputValueHasADot ? inputValue.length - 1 : dPos;\n\n        // Checks decimal places to determine if rounding is required :\n        // Check if no rounding is required\n        var cDec = inputValue.length - 1 - vdPos;\n\n        if (cDec <= settings.decimalPlacesOverride) {\n            // Check if we need to pad with zeros\n            ivRounded = inputValue;\n            if (cDec < temporaryDecimalPlacesOverride) {\n                if (inputValueHasADot) {\n                    ivRounded += settings.decimalCharacter;\n                }\n\n                var zeros = '000000';\n                while (cDec < temporaryDecimalPlacesOverride) {\n                    zeros = zeros.substring(0, temporaryDecimalPlacesOverride - cDec);\n                    ivRounded += zeros;\n                    cDec += zeros.length;\n                }\n            } else if (cDec > temporaryDecimalPlacesOverride) {\n                ivRounded = truncateZeros(ivRounded, temporaryDecimalPlacesOverride);\n            } else if (cDec === 0 && temporaryDecimalPlacesOverride === 0) {\n                ivRounded = ivRounded.replace(/\\.$/, '');\n            }\n\n            return Number(ivRounded) === 0 ? ivRounded : nSign + ivRounded;\n        }\n\n        // Rounded length of the string after rounding\n        var rLength = void 0;\n        if (inputValueHasADot) {\n            rLength = settings.decimalPlacesOverride - 1;\n        } else {\n            rLength = settings.decimalPlacesOverride + dPos;\n        }\n\n        var tRound = Number(inputValue.charAt(rLength + 1));\n        var odd = inputValue.charAt(rLength) === '.' ? inputValue.charAt(rLength - 1) % 2 : inputValue.charAt(rLength) % 2;\n        var ivArray = inputValue.substring(0, rLength + 1).split('');\n\n        if (tRound > 4 && settings.roundingMethod === 'S' || // Round half up symmetric\n        tRound > 4 && settings.roundingMethod === 'A' && nSign === '' || // Round half up asymmetric positive values\n        tRound > 5 && settings.roundingMethod === 'A' && nSign === '-' || // Round half up asymmetric negative values\n        tRound > 5 && settings.roundingMethod === 's' || // Round half down symmetric\n        tRound > 5 && settings.roundingMethod === 'a' && nSign === '' || // Round half down asymmetric positive values\n        tRound > 4 && settings.roundingMethod === 'a' && nSign === '-' || // Round half down asymmetric negative values\n        tRound > 5 && settings.roundingMethod === 'B' || // Round half even \"Banker's Rounding\"\n        tRound === 5 && settings.roundingMethod === 'B' && odd === 1 || // Round half even \"Banker's Rounding\"\n        tRound > 0 && settings.roundingMethod === 'C' && nSign === '' || // Round to ceiling toward positive infinite\n        tRound > 0 && settings.roundingMethod === 'F' && nSign === '-' || // Round to floor toward negative infinite\n        tRound > 0 && settings.roundingMethod === 'U') {\n            // Round up away from zero\n            // Round up the last digit if required, and continue until no more 9's are found\n            for (i = ivArray.length - 1; i >= 0; i -= 1) {\n                if (ivArray[i] !== '.') {\n                    ivArray[i] = +ivArray[i] + 1;\n                    if (ivArray[i] < 10) {\n                        break;\n                    }\n\n                    if (i > 0) {\n                        ivArray[i] = '0';\n                    }\n                }\n            }\n        }\n\n        // Reconstruct the string, converting any 10's to 0's\n        ivArray = ivArray.slice(0, rLength + 1);\n\n        // Return the rounded value\n        ivRounded = truncateZeros(ivArray.join(''), temporaryDecimalPlacesOverride);\n\n        return Number(ivRounded) === 0 ? ivRounded : nSign + ivRounded;\n    }\n\n    /**\n     * Truncates the decimal part of a number.\n     *\n     * @param {string} s\n     * @param {object} settings\n     * @param {boolean} isPaste\n     * @returns {*}\n     */\n    function truncateDecimal(s, settings, isPaste) {\n        s = isPaste ? roundValue(s, settings) : s;\n\n        if (settings.decimalCharacter && settings.decimalPlacesOverride) {\n            var _s$split3 = s.split(settings.decimalCharacter),\n                _s$split4 = _slicedToArray(_s$split3, 2),\n                integerPart = _s$split4[0],\n                decimalPart = _s$split4[1];\n\n            // truncate decimal part to satisfying length since we would round it anyway\n\n\n            if (decimalPart && decimalPart.length > settings.decimalPlacesOverride) {\n                if (settings.decimalPlacesOverride > 0) {\n                    var modifiedDecimalPart = decimalPart.substring(0, settings.decimalPlacesOverride);\n                    s = '' + integerPart + settings.decimalCharacter + modifiedDecimalPart;\n                } else {\n                    s = integerPart;\n                }\n            }\n        }\n\n        return s;\n    }\n\n    /**\n     * Function to parse minimumValue, maximumValue & the input value to prepare for testing to determine if the value falls within the min / max range.\n     * Return an object example: minimumValue: \"999999999999999.99\" returns the following \"{s: -1, e: 12, c: Array[15]}\".\n     *\n     * This function is adapted from Big.js https://github.com/MikeMcl/big.js/. Many thanks to Mike.\n     *\n     * @param {number|string} n A numeric value.\n     * @returns {{}}\n     */\n    function parseStr(n) {\n        var x = {}; // A Big number instance.\n        var e = void 0;\n        var i = void 0;\n        var nL = void 0;\n        var j = void 0;\n\n        // Minus zero?\n        if (n === 0 && 1 / n < 0) {\n            n = '-0';\n        }\n\n        // Determine sign. 1 positive, -1 negative\n        n = n.toString();\n        if (isNegativeStrict(n)) {\n            n = n.slice(1);\n            x.s = -1;\n        } else {\n            x.s = 1;\n        }\n\n        // Decimal point?\n        e = n.indexOf('.');\n        if (e > -1) {\n            n = n.replace('.', '');\n        }\n\n        // length of string if no decimal character\n        if (e < 0) {\n            // Integer\n            e = n.length;\n        }\n\n        // Determine leading zeros\n        i = n.search(/[1-9]/i) === -1 ? n.length : n.search(/[1-9]/i);\n        nL = n.length;\n        if (i === nL) {\n            // Zero\n            x.e = 0;\n            x.c = [0];\n        } else {\n            // Determine trailing zeros\n            for (j = nL - 1; n.charAt(j) === '0'; j -= 1) {\n                nL -= 1;\n            }\n            nL -= 1;\n\n            // Decimal location\n            x.e = e - i - 1;\n            x.c = [];\n\n            // Convert string to array of digits without leading/trailing zeros\n            for (e = 0; i <= nL; i += 1) {\n                x.c[e] = +n.charAt(i);\n                e += 1;\n            }\n        }\n\n        return x;\n    }\n\n    /**\n     * Function to test if the input value falls with the Min / Max settings.\n     * This uses the parsed strings for the above parseStr function.\n     *\n     * This function is adapted from Big.js https://github.com/MikeMcl/big.js/. Many thanks to Mike.\n     *\n     * @param {object} y Big number instance\n     * @param {object} x Big number instance\n     * @returns {*}\n     */\n    function testMinMax(y, x) {\n        var xc = x.c;\n        var yc = y.c;\n        var i = x.s;\n        var j = y.s;\n        var k = x.e;\n        var l = y.e;\n\n        // Either zero?\n        if (!xc[0] || !yc[0]) {\n            var _result = void 0;\n            if (!xc[0]) {\n                _result = !yc[0] ? 0 : -j;\n            } else {\n                _result = i;\n            }\n            return _result;\n        }\n\n        // Signs differ?\n        if (i !== j) {\n            return i;\n        }\n        var xNeg = i < 0;\n\n        // Compare exponents\n        if (k !== l) {\n            return k > l ^ xNeg ? 1 : -1;\n        }\n        i = -1;\n        k = xc.length;\n        l = yc.length;\n        j = k < l ? k : l;\n\n        // Compare digit by digit\n        for (i += 1; i < j; i += 1) {\n            if (xc[i] !== yc[i]) {\n                return xc[i] > yc[i] ^ xNeg ? 1 : -1;\n            }\n        }\n\n        // Compare lengths\n        var result = void 0;\n        if (k === l) {\n            result = 0;\n        } else {\n            result = k > l ^ xNeg ? 1 : -1;\n        }\n\n        return result;\n    }\n\n    /**\n     * Check that the number satisfy the format conditions\n     * and lays between settings.minimumValue and settings.maximumValue\n     * and the string length does not exceed the digits in settings.minimumValue and settings.maximumValue\n     *\n     * @param {string} s\n     * @param {object} settings\n     * @returns {*}\n     */\n    function checkIfInRangeWithOverrideOption(s, settings) {\n        s = s.toString();\n        s = s.replace(',', '.');\n        var minParse = parseStr(settings.minimumValue);\n        var maxParse = parseStr(settings.maximumValue);\n        var valParse = parseStr(s);\n\n        var result = void 0;\n        switch (settings.overrideMinMaxLimits) {\n            case 'floor':\n                result = [testMinMax(minParse, valParse) > -1, true];\n                break;\n            case 'ceiling':\n                result = [true, testMinMax(maxParse, valParse) < 1];\n                break;\n            case 'ignore':\n                result = [true, true];\n                break;\n            default:\n                result = [testMinMax(minParse, valParse) > -1, testMinMax(maxParse, valParse) < 1];\n        }\n\n        return result;\n    }\n\n    /**\n     * Thanks to Anthony & Evan C\n     *\n     * @param {Element|string} element\n     * @returns {*|jQuery|HTMLElement}\n     */\n    function getCurrentElement(element) {\n        /*\n         * If the parameter is a string (and therefore is a CSS selector), then we need to modify this string in order\n         * for jQuery to be able to parse the selector correctly.\n         * cf. http://learn.jquery.com/using-jquery-core/faq/how-do-i-select-an-element-by-an-id-that-has-characters-used-in-css-notation/\n         */\n        if (isString(element)) {\n            //TODO This block is apparently never entered. We should remove it after making sure that's 100% the case\n            element = '#' + element.replace(/(:|\\.|\\[|]|,|=)/g, '\\\\$1');\n        }\n\n        return $(element);\n    }\n\n    /**\n     * Function that attach the autoNumeric field properties to the DOM element via an AutoNumericHolder object.\n     *\n     * @param {object} $this jQuery-selected DOM element\n     * @param {object} settings\n     * @param {boolean} update\n     * @returns {*}\n     */\n    function getAutoNumericHolder($this, settings) {\n        var update = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n\n        var data = $this.data('autoNumeric');\n        if (!data) {\n            data = {};\n            $this.data('autoNumeric', data);\n        }\n\n        var holder = data.holder;\n        if (update || isUndefined(holder) && settings) {\n            holder = new AutoNumericHolder($this.get(0), settings);\n            data.holder = holder;\n        }\n\n        return holder;\n    }\n\n    /**\n     * Original settings saved for use when decimalPlacesShownOnFocus & noSeparatorOnFocus options are being used.\n     * Those original settings are used exclusively in the `focusin` and `focusout` event handlers.\n     *\n     * @param {object} settings\n     */\n    function keepAnOriginalSettingsCopy(settings) {\n        //TODO Rename the old option names to the new ones\n        settings.oDec = settings.decimalPlacesOverride;\n        settings.oPad = settings.allowDecimalPadding;\n        settings.oBracket = settings.negativeBracketsTypeOnBlur;\n        settings.oSep = settings.digitGroupSeparator;\n        settings.oSign = settings.currencySymbol;\n        settings.oSuffix = settings.suffixText;\n    }\n\n    /**\n     * Original settings saved for use when `decimalPlacesShownOnFocus` & `noSeparatorOnFocus` options are being used.\n     * This is taken from Quirksmode.\n     *\n     * @param {string} name\n     * @returns {*}\n     */\n    function readCookie(name) {\n        var nameEQ = name + '=';\n        var ca = document.cookie.split(';');\n        var c = '';\n        for (var i = 0; i < ca.length; i += 1) {\n            c = ca[i];\n            while (c.charAt(0) === ' ') {\n                c = c.substring(1, c.length);\n            }\n            if (c.indexOf(nameEQ) === 0) {\n                return c.substring(nameEQ.length, c.length);\n            }\n        }\n\n        return null;\n    }\n\n    /**\n     * Test if sessionStorage is supported.\n     * This is taken from Modernizr.\n     *\n     * @returns {boolean}\n     */\n    function storageTest() {\n        var mod = 'modernizr';\n        try {\n            sessionStorage.setItem(mod, mod);\n            sessionStorage.removeItem(mod);\n            return true;\n        } catch (e) {\n            return false;\n        }\n    }\n\n    /**\n     * properly formats the string to a numeric when leadingZero does not 'keep'.\n     *\n     * @param {string} value\n     * @param {object} settings\n     * @returns {string}\n     */\n    function cleanLeadingTrailingZeros(value, settings) {\n        // Return the empty string is the value is already empty. This prevent converting that value to '0'.\n        if (value === '') {\n            return '';\n        }\n\n        // Return '0' if the value is zero\n        if (Number(value) === 0 && settings.leadingZero !== 'keep') {\n            return '0';\n        }\n\n        if (settings.leadingZero !== 'keep') {\n            // Trim leading zero's - leaves one zero to the left of the decimal point\n            value = value.replace(/^(-)?0+(?=\\d)/g, '$1');\n\n            //TODO remove this from that function and use `trimPaddedZerosFromDecimalPlaces()` instead. Also create a new `trailingZero` option.\n            if (contains(value, '.')) {\n                // Trims trailing zeros after the decimal point\n                value = value.replace(/(\\.[0-9]*?)0+$/, '$1');\n            }\n        }\n        // Strips trailing decimal point\n        value = value.replace(/\\.$/, '');\n\n        return value;\n    }\n\n    /**\n     * Remove the trailing zeros in the decimal part of a number.\n     *\n     * @param {string} numericString\n     * @returns {*}\n     */\n    function trimPaddedZerosFromDecimalPlaces(numericString) {\n        var _numericString$split = numericString.split('.'),\n            _numericString$split2 = _slicedToArray(_numericString$split, 2),\n            integerPart = _numericString$split2[0],\n            decimalPart = _numericString$split2[1];\n\n        if (isUndefinedOrNullOrEmpty(decimalPart)) {\n            return integerPart;\n        }\n\n        var trimmedDecimalPart = decimalPart.replace(/0+$/g, '');\n\n        var result = void 0;\n        if (trimmedDecimalPart === '') {\n            result = integerPart;\n        } else {\n            result = integerPart + '.' + trimmedDecimalPart;\n        }\n\n        return result;\n    }\n\n    /**\n     * Creates or removes sessionStorage or cookie depending on what the browser is supporting.\n     *\n     * @param {Element|EventTarget} element\n     * @param {object} settings\n     * @param {string} action\n     * @returns {*}\n     */\n    function saveValueToPersistentStorage(element, settings, action) {\n        if (settings.saveValueToSessionStorage) {\n            var storedName = element.name !== '' && !isUndefined(element.name) ? 'AUTO_' + decodeURIComponent(element.name) : 'AUTO_' + element.id;\n            var date = void 0;\n            var expires = void 0;\n\n            // Sets cookie for browser that do not support sessionStorage IE 6 & IE 7\n            if (storageTest() === false) {\n                switch (action) {\n                    case 'set':\n                        document.cookie = storedName + '=' + settings.rawValue + '; expires= ; path=/';\n                        break;\n                    case 'wipe':\n                        date = new Date();\n                        date.setTime(date.getTime() + -1 * 24 * 60 * 60 * 1000);\n                        expires = '; expires=' + date.toUTCString(); // Note : `toGMTString()` has been deprecated (cf. https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toGMTString)\n                        document.cookie = storedName + '=\\'\\' ;' + expires + '; path=/';\n                        break;\n                    case 'get':\n                        return readCookie(storedName);\n                }\n            } else {\n                switch (action) {\n                    case 'set':\n                        sessionStorage.setItem(storedName, settings.rawValue);\n                        break;\n                    case 'wipe':\n                        sessionStorage.removeItem(storedName);\n                        break;\n                    case 'get':\n                        return sessionStorage.getItem(storedName);\n                }\n            }\n        }\n    }\n\n    /**\n     * Holder object for field properties\n     */\n\n    var AutoNumericHolder = function () {\n        /**\n         * Class constructor\n         *\n         * @param {HTMLElement} that - A reference to the current DOM element\n         * @param {object} settings\n         */\n        function AutoNumericHolder(that, settings) {\n            _classCallCheck(this, AutoNumericHolder);\n\n            this.settings = settings;\n            this.that = that;\n            this.$that = $(that);\n            this.formatted = false;\n            this.settingsClone = settings;\n            this.value = that.value;\n        }\n\n        /**\n         * Update the value and the selection values inside the AutoNumericHolder object.\n         * This keeps tracks of the input value, as well as the current selection.\n         * This also resets the 'processed' and 'formatted' state.\n         *\n         * Note : Those two can change between the keydown, keypress and keyup events, that's why\n         *        this function is called on each event handler.\n         *\n         * @private\n         */\n\n\n        _createClass(AutoNumericHolder, [{\n            key: '_updateAutoNumericHolderProperties',\n            value: function _updateAutoNumericHolderProperties() {\n                this.value = this.that.value;\n                this.selection = getElementSelection(this.that);\n                this.processed = false;\n                this.formatted = false;\n            }\n\n            /**\n             * Update the keycode of the key that triggered the given event.\n             * Note : e.which is sometimes different than e.keyCode during the keypress event, when entering a printable character key (ie. 't'). `e.which` equals 0 for non-printable characters.\n             *\n             * //TODO Switch to the non-deprecated e.key attribute, instead of inconsistant e.which and e.keyCode.\n             * e.key describe the key name used to trigger the event.\n             * e.keyCode being deprecated : https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyCode\n             * How e.key works : https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key\n             * The key list is described here\n             * @link https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values\n             *\n             * @param {Event} e\n             * @private\n             */\n\n        }, {\n            key: '_updateAutoNumericHolderEventKeycode',\n            value: function _updateAutoNumericHolderEventKeycode(e) {\n                // Note: the keypress event overwrites meaningful value of e.keyCode, hence we do not update that value on 'keypress'\n                this.eventKeyCode = keyCodeNumber(e);\n            }\n\n            /**\n             * Set the text selection inside the input with the given start and end position.\n             *\n             * @param {int} start\n             * @param {int} end\n             * @param {undefined|boolean} setReal\n             * @private\n             */\n\n        }, {\n            key: '_setSelection',\n            value: function _setSelection(start, end, setReal) {\n                //TODO Modify setReal to be more explicit (and a boolean)\n                start = Math.max(start, 0);\n                end = Math.min(end, this.that.value.length); //TODO Replace `this.that.value.length` with `this.value.length`\n                this.selection = {\n                    start: start,\n                    end: end,\n                    length: end - start\n                };\n\n                if (isUndefined(setReal) || setReal) {\n                    setElementSelection(this.that, start, end);\n                }\n            }\n\n            /**\n             * Set the caret position inside the input at the given position.\n             *\n             * @param {int} pos\n             * @param {undefined|boolean} setReal\n             * @private\n             */\n\n        }, {\n            key: '_setCaretPosition',\n            value: function _setCaretPosition(pos, setReal) {\n                //TODO Modify setReal to be more explicit (and a boolean)\n                this._setSelection(pos, pos, setReal);\n            }\n\n            /**\n             * Return an array containing the string parts located on the left and right side of the caret or selection.\n             * Those parts are left 'untouched', ie. formatted by autoNumeric.\n             *\n             * @returns {[string, string]} The parts on the left and right of the caret or selection\n             * @private\n             */\n\n        }, {\n            key: '_getLeftAndRightPartAroundTheSelection',\n            value: function _getLeftAndRightPartAroundTheSelection() {\n                var value = this.value;\n                var left = value.substring(0, this.selection.start);\n                var right = value.substring(this.selection.end, value.length);\n\n                return [left, right];\n            }\n\n            /**\n             * Return an array containing the string parts located on the left and right side of the caret or selection.\n             * Those parts are unformatted (stripped) of any non-numbers characters.\n             *\n             * @returns {[string, string]} The parts on the left and right of the caret or selection, unformatted.\n             * @private\n             */\n\n        }, {\n            key: '_getUnformattedLeftAndRightPartAroundTheSelection',\n            value: function _getUnformattedLeftAndRightPartAroundTheSelection() {\n                var settingsClone = this.settingsClone;\n\n                var _getLeftAndRightPartA = this._getLeftAndRightPartAroundTheSelection(),\n                    _getLeftAndRightPartA2 = _slicedToArray(_getLeftAndRightPartA, 2),\n                    left = _getLeftAndRightPartA2[0],\n                    right = _getLeftAndRightPartA2[1];\n\n                if (left === '' && right === '') {\n                    settingsClone.trailingNegative = false;\n                }\n                // if changing the sign and left is equal to the number zero - prevents stripping the leading zeros\n                var stripZeros = true;\n                if (this.eventKeyCode === keyCode.Hyphen && Number(left) === 0) {\n                    stripZeros = false;\n                }\n                left = stripAllNonNumberCharacters(left, this.settingsClone, stripZeros);\n                right = stripAllNonNumberCharacters(right, this.settingsClone, false);\n\n                if (settingsClone.trailingNegative && !isNegative(left)) {\n                    left = '-' + left;\n                    right = right === '-' ? '' : right;\n                    settingsClone.trailingNegative = false;\n                }\n\n                return [left, right];\n            }\n\n            /**\n             * Strip parts from excess characters and leading zeros.\n             *\n             * @param {string} left\n             * @param {string} right\n             * @returns {[*,*]}\n             * @private\n             */\n\n        }, {\n            key: '_normalizeParts',\n            value: function _normalizeParts(left, right) {\n                var settingsClone = this.settingsClone;\n\n                // if changing the sign and left is equal to the number zero - prevents stripping the leading zeros\n                var stripZeros = true;\n                if (this.eventKeyCode === keyCode.Hyphen && Number(left) === 0) {\n                    stripZeros = false;\n                }\n                left = stripAllNonNumberCharacters(left, settingsClone, stripZeros);\n\n                // If right is not empty and first character is not decimalCharacter\n                right = stripAllNonNumberCharacters(right, settingsClone, false);\n\n                // Prevents multiple leading zeros from being entered\n                if (settingsClone.leadingZero === 'deny' && (this.eventKeyCode === keyCode.num0 || this.eventKeyCode === keyCode.numpad0) && Number(left) === 0 && !contains(left, settingsClone.decimalCharacter) && right !== '') {\n                    left = left.substring(0, left.length - 1);\n                }\n\n                if (settingsClone.trailingNegative && !isNegative(left)) {\n                    left = '-' + left;\n                    settingsClone.trailingNegative = false;\n                }\n\n                // Insert zero if has leading dot\n                this.newValue = left + right;\n                if (settingsClone.decimalCharacter) {\n                    var m = this.newValue.match(new RegExp('^' + settingsClone.aNegRegAutoStrip + '\\\\' + settingsClone.decimalCharacter));\n                    if (m) {\n                        left = left.replace(m[1], m[1] + '0');\n                        this.newValue = left + right;\n                    }\n                }\n\n                return [left, right];\n            }\n\n            /**\n             * Set part of number to value while keeping the cursor position. //TODO What about the cursor selection?\n             *\n             * @param {string} left\n             * @param {string} right\n             * @param {boolean} isPaste\n             * @returns {boolean}\n             * @private\n             */\n\n        }, {\n            key: '_setValueParts',\n            value: function _setValueParts(left, right) {\n                var isPaste = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n\n                var settingsClone = this.settingsClone;\n                var parts = this._normalizeParts(left, right);\n\n                var _checkIfInRangeWithOv = checkIfInRangeWithOverrideOption(this.newValue, settingsClone),\n                    _checkIfInRangeWithOv2 = _slicedToArray(_checkIfInRangeWithOv, 2),\n                    minTest = _checkIfInRangeWithOv2[0],\n                    maxTest = _checkIfInRangeWithOv2[1];\n\n                var position = parts[0].length;\n                this.newValue = parts.join('');\n\n                if (minTest && maxTest) {\n                    this.newValue = truncateDecimal(this.newValue, settingsClone, isPaste);\n                    //TODO Check if we need to replace the hard-coded ',' with settings.decimalCharacter\n                    var testValue = contains(this.newValue, ',') ? this.newValue.replace(',', '.') : this.newValue;\n                    if (testValue === '' || testValue === settingsClone.negativeSignCharacter) {\n                        settingsClone.rawValue = settingsClone.emptyInputBehavior === 'zero' ? '0' : '';\n                    } else {\n                        settingsClone.rawValue = cleanLeadingTrailingZeros(testValue, settingsClone);\n                    }\n\n                    if (position > this.newValue.length) {\n                        position = this.newValue.length;\n                    }\n\n                    // Make sure when the user enter a '0' on the far left with a leading zero option set to 'deny', that the caret does not moves since the input is dropped (fix issue #283)\n                    if (position === 1 && parts[0] === '0' && settingsClone.leadingZero === 'deny') {\n                        // If the user enter `0`, then the caret is put on the right side of it (Fix issue #299)\n                        if (parts[1] === '' || parts[0] === '0' && parts[1] !== '') {\n                            position = 1;\n                        } else {\n                            position = 0;\n                        }\n                    }\n\n                    this.value = this.newValue;\n                    this._setCaretPosition(position, false);\n\n                    return true;\n                }\n\n                if (!minTest) {\n                    this.$that.trigger('autoNumeric:minExceeded');\n                } else if (!maxTest) {\n                    this.$that.trigger('autoNumeric:maxExceeded');\n                }\n\n                return false;\n            }\n\n            /**\n             * Helper function for `_expandSelectionOnSign()`.\n             *\n             * @returns {*} Sign position of a formatted value\n             * @private\n             */\n\n        }, {\n            key: '_getSignPosition',\n            value: function _getSignPosition() {\n                var settingsClone = this.settingsClone;\n                var currencySymbol = settingsClone.currencySymbol;\n                var that = this.that;\n\n                if (currencySymbol) {\n                    var currencySymbolLen = currencySymbol.length;\n                    if (settingsClone.currencySymbolPlacement === 'p') {\n                        var hasNeg = settingsClone.negativeSignCharacter && that.value && that.value.charAt(0) === settingsClone.negativeSignCharacter;\n                        return hasNeg ? [1, currencySymbolLen + 1] : [0, currencySymbolLen];\n                    }\n                    var valueLen = that.value.length;\n                    return [valueLen - currencySymbolLen, valueLen];\n                }\n\n                return [1000, -1];\n            }\n\n            /**\n             * Expands selection to cover whole sign\n             * Prevents partial deletion/copying/overwriting of a sign\n             *\n             * @param {undefined|boolean} setReal\n             * @private\n             */\n\n        }, {\n            key: '_expandSelectionOnSign',\n            value: function _expandSelectionOnSign(setReal) {\n                //TODO Modify setReal to be more explicit (and a boolean only)\n                //TODO Use array destructuring here to set signPosition to more explicit variables\n                var signPosition = this._getSignPosition();\n                var selection = this.selection;\n\n                // If selection catches something except sign and catches only space from sign\n                if (selection.start < signPosition[1] && selection.end > signPosition[0]) {\n                    // Then select without empty space\n                    if ((selection.start < signPosition[0] || selection.end > signPosition[1]) && this.value.substring(Math.max(selection.start, signPosition[0]), Math.min(selection.end, signPosition[1])).match(/^\\s*$/)) {\n                        if (selection.start < signPosition[0]) {\n                            this._setSelection(selection.start, signPosition[0], setReal);\n                        } else {\n                            this._setSelection(signPosition[1], selection.end, setReal);\n                        }\n                    } else {\n                        // Else select with whole sign\n                        this._setSelection(Math.min(selection.start, signPosition[0]), Math.max(selection.end, signPosition[1]), setReal);\n                    }\n                }\n            }\n\n            /**\n             * Try to strip pasted value to digits\n             */\n\n        }, {\n            key: '_checkPaste',\n            value: function _checkPaste() {\n                if (!isUndefined(this.valuePartsBeforePaste)) {\n                    var oldParts = this.valuePartsBeforePaste;\n\n                    var _getLeftAndRightPartA3 = this._getLeftAndRightPartAroundTheSelection(),\n                        _getLeftAndRightPartA4 = _slicedToArray(_getLeftAndRightPartA3, 2),\n                        left = _getLeftAndRightPartA4[0],\n                        right = _getLeftAndRightPartA4[1];\n\n                    // Try to strip the pasted value first\n\n\n                    delete this.valuePartsBeforePaste;\n\n                    var modifiedLeftPart = left.substr(0, oldParts[0].length) + stripAllNonNumberCharacters(left.substr(oldParts[0].length), this.settingsClone, true);\n                    if (!this._setValueParts(modifiedLeftPart, right, true)) {\n                        this.value = oldParts.join('');\n                        this._setCaretPosition(oldParts[0].length, false);\n                    }\n                }\n            }\n\n            /**\n             * Process pasting, cursor moving and skipping of not interesting keys.\n             * If this function returns TRUE, then further processing is not performed.\n             *\n             * @param {Event} e\n             * @returns {boolean}\n             * @private\n             */\n\n        }, {\n            key: '_skipAlways',\n            value: function _skipAlways(e) {\n                // Catch the ctrl up on ctrl-v\n                if ((e.ctrlKey || e.metaKey) && e.type === 'keyup' && !isUndefined(this.valuePartsBeforePaste) || e.shiftKey && this.eventKeyCode === keyCode.Insert) {\n                    //TODO Move this test inside the `onKeyup` handler\n                    this._checkPaste();\n                    return false;\n                }\n\n                // Skip all function keys (F1-F12), Windows keys, tab and other special keys\n                if (this.eventKeyCode >= keyCode.F1 && this.eventKeyCode <= keyCode.F12 || this.eventKeyCode >= keyCode.Windows && this.eventKeyCode <= keyCode.RightClick || this.eventKeyCode >= keyCode.Tab && this.eventKeyCode < keyCode.Space ||\n                // `e.which` is sometimes different than `this.eventKeyCode` during the keypress event when entering a printable character key (ie. 't'). Also, `e.which` equals 0 for non-printable characters.\n                this.eventKeyCode < keyCode.Backspace && (e.which === 0 || e.which === this.eventKeyCode) || this.eventKeyCode === keyCode.NumLock || this.eventKeyCode === keyCode.ScrollLock || this.eventKeyCode === keyCode.Insert || this.eventKeyCode === keyCode.Command) {\n                    return true;\n                }\n\n                // If a \"Select all\" keyboard shortcut is detected (ctrl + a)\n                if ((e.ctrlKey || e.metaKey) && this.eventKeyCode === keyCode.a) {\n                    if (this.settings.selectNumberOnly) {\n                        // `preventDefault()` is used here to prevent the browser to first select all the input text (including the currency sign), otherwise we would see that whole selection first in a flash, then the selection with only the number part without the currency sign.\n                        e.preventDefault();\n                        var valueLen = this.that.value.length;\n                        var currencySymbolLen = this.settings.currencySymbol.length;\n                        var negLen = !isNegative(this.that.value) ? 0 : 1;\n                        var suffixTextLen = this.settings.suffixText.length;\n                        var currencySymbolPlacement = this.settings.currencySymbolPlacement;\n                        var negativePositiveSignPlacement = this.settings.negativePositiveSignPlacement;\n\n                        var start = void 0;\n                        if (currencySymbolPlacement === 's') {\n                            start = 0;\n                        } else {\n                            start = negativePositiveSignPlacement === 'l' && negLen === 1 && currencySymbolLen > 0 ? currencySymbolLen + 1 : currencySymbolLen;\n                        }\n\n                        var end = void 0;\n                        if (currencySymbolPlacement === 'p') {\n                            end = valueLen - suffixTextLen;\n                        } else {\n                            switch (negativePositiveSignPlacement) {\n                                case 'l':\n                                    end = valueLen - (suffixTextLen + currencySymbolLen);\n                                    break;\n                                case 'r':\n                                    end = currencySymbolLen > 0 ? valueLen - (currencySymbolLen + negLen + suffixTextLen) : valueLen - (currencySymbolLen + suffixTextLen);\n                                    break;\n                                default:\n                                    end = valueLen - (currencySymbolLen + suffixTextLen);\n                            }\n                        }\n\n                        setElementSelection(this.that, start, end);\n                    }\n\n                    return true;\n                }\n\n                // If a \"Copy\", \"Paste\" or \"Cut\" keyboard shortcut is detected (respectively 'ctrl + c', 'ctrl + v' or 'ctrl + x')\n                if ((e.ctrlKey || e.metaKey) && (this.eventKeyCode === keyCode.c || this.eventKeyCode === keyCode.v || this.eventKeyCode === keyCode.x)) {\n                    if (e.type === 'keydown') {\n                        this._expandSelectionOnSign();\n                    }\n\n                    // Try to prevent wrong paste\n                    if (this.eventKeyCode === keyCode.v || this.eventKeyCode === keyCode.Insert) {\n                        if (e.type === 'keydown' || e.type === 'keypress') {\n                            if (isUndefined(this.valuePartsBeforePaste)) {\n                                this.valuePartsBeforePaste = this._getLeftAndRightPartAroundTheSelection();\n                            }\n                        } else {\n                            this._checkPaste();\n                        }\n                    }\n\n                    return e.type === 'keydown' || e.type === 'keypress' || this.eventKeyCode === keyCode.c;\n                }\n\n                if (e.ctrlKey || e.metaKey) {\n                    return true;\n                }\n\n                // Jump over thousand separator\n                //TODO Move this test inside the `onKeydown` handler\n                if (this.eventKeyCode === keyCode.LeftArrow || this.eventKeyCode === keyCode.RightArrow) {\n                    if (e.type === 'keydown' && !e.shiftKey) {\n                        if (this.eventKeyCode === keyCode.LeftArrow && (this.that.value.charAt(this.selection.start - 2) === this.settingsClone.digitGroupSeparator || this.that.value.charAt(this.selection.start - 2) === this.settingsClone.decimalCharacter)) {\n                            this._setCaretPosition(this.selection.start - 1);\n                        } else if (this.eventKeyCode === keyCode.RightArrow && (this.that.value.charAt(this.selection.start + 1) === this.settingsClone.digitGroupSeparator || this.that.value.charAt(this.selection.start + 1) === this.settingsClone.decimalCharacter)) {\n                            this._setCaretPosition(this.selection.start + 1);\n                        }\n                    }\n                    return true;\n                }\n\n                return this.eventKeyCode >= keyCode.PageDown && this.eventKeyCode <= keyCode.DownArrow;\n            }\n\n            /**\n             * Process deletion of characters when the minus sign is to the right of the numeric characters.\n             *\n             * @param {string} left The part on the left of the caret or selection\n             * @param {string} right The part on the right of the caret or selection\n             * @returns {[string, string]}\n             * @private\n             */\n\n        }, {\n            key: '_processCharacterDeletionIfTrailingNegativeSign',\n            value: function _processCharacterDeletionIfTrailingNegativeSign(_ref) {\n                var _ref2 = _slicedToArray(_ref, 2),\n                    left = _ref2[0],\n                    right = _ref2[1];\n\n                var settingsClone = this.settingsClone;\n                if (settingsClone.currencySymbolPlacement === 'p' && settingsClone.negativePositiveSignPlacement === 's') {\n                    if (this.eventKeyCode === keyCode.Backspace) {\n                        settingsClone.caretFix = this.selection.start >= this.value.indexOf(settingsClone.suffixText) && settingsClone.suffixText !== '';\n                        if (this.value.charAt(this.selection.start - 1) === '-') {\n                            left = left.substring(1);\n                        } else if (this.selection.start <= this.value.length - settingsClone.suffixText.length) {\n                            left = left.substring(0, left.length - 1);\n                        }\n                    } else {\n                        settingsClone.caretFix = this.selection.start >= this.value.indexOf(settingsClone.suffixText) && settingsClone.suffixText !== '';\n                        if (this.selection.start >= this.value.indexOf(settingsClone.currencySymbol) + settingsClone.currencySymbol.length) {\n                            right = right.substring(1, right.length);\n                        }\n                        if (isNegative(left) && this.value.charAt(this.selection.start) === '-') {\n                            left = left.substring(1);\n                        }\n                    }\n                }\n\n                //TODO Merge the two following 'if' blocks into one `if (settingsClone.currencySymbolPlacement === 's') {` and a switch on settingsClone.negativePositiveSignPlacement\n                if (settingsClone.currencySymbolPlacement === 's' && settingsClone.negativePositiveSignPlacement === 'l') {\n                    settingsClone.caretFix = this.selection.start >= this.value.indexOf(settingsClone.negativeSignCharacter) + settingsClone.negativeSignCharacter.length;\n                    if (this.eventKeyCode === keyCode.Backspace) {\n                        if (this.selection.start === this.value.indexOf(settingsClone.negativeSignCharacter) + settingsClone.negativeSignCharacter.length && contains(this.value, settingsClone.negativeSignCharacter)) {\n                            left = left.substring(1);\n                        } else if (left !== '-' && (this.selection.start <= this.value.indexOf(settingsClone.negativeSignCharacter) || !contains(this.value, settingsClone.negativeSignCharacter))) {\n                            left = left.substring(0, left.length - 1);\n                        }\n                    } else {\n                        if (left[0] === '-') {\n                            right = right.substring(1);\n                        }\n                        if (this.selection.start === this.value.indexOf(settingsClone.negativeSignCharacter) && contains(this.value, settingsClone.negativeSignCharacter)) {\n                            left = left.substring(1);\n                        }\n                    }\n                }\n\n                if (settingsClone.currencySymbolPlacement === 's' && settingsClone.negativePositiveSignPlacement === 'r') {\n                    settingsClone.caretFix = this.selection.start >= this.value.indexOf(settingsClone.negativeSignCharacter) + settingsClone.negativeSignCharacter.length;\n                    if (this.eventKeyCode === keyCode.Backspace) {\n                        if (this.selection.start === this.value.indexOf(settingsClone.negativeSignCharacter) + settingsClone.negativeSignCharacter.length) {\n                            left = left.substring(1);\n                        } else if (left !== '-' && this.selection.start <= this.value.indexOf(settingsClone.negativeSignCharacter) - settingsClone.currencySymbol.length) {\n                            left = left.substring(0, left.length - 1);\n                        } else if (left !== '' && !contains(this.value, settingsClone.negativeSignCharacter)) {\n                            left = left.substring(0, left.length - 1);\n                        }\n                    } else {\n                        settingsClone.caretFix = this.selection.start >= this.value.indexOf(settingsClone.currencySymbol) && settingsClone.currencySymbol !== '';\n                        if (this.selection.start === this.value.indexOf(settingsClone.negativeSignCharacter)) {\n                            left = left.substring(1);\n                        }\n                        right = right.substring(1);\n                    }\n                }\n\n                return [left, right];\n            }\n\n            /**\n             * Process the deletion of characters.\n             */\n\n        }, {\n            key: '_processCharacterDeletion',\n            value: function _processCharacterDeletion() {\n                var settingsClone = this.settingsClone;\n\n                var left = void 0;\n                var right = void 0;\n\n                if (!this.selection.length) {\n                    var _getUnformattedLeftAn = this._getUnformattedLeftAndRightPartAroundTheSelection();\n\n                    var _getUnformattedLeftAn2 = _slicedToArray(_getUnformattedLeftAn, 2);\n\n                    left = _getUnformattedLeftAn2[0];\n                    right = _getUnformattedLeftAn2[1];\n\n                    if (left === '' && right === '') {\n                        settingsClone.throwInput = false;\n                    }\n\n                    if ((settingsClone.currencySymbolPlacement === 'p' && settingsClone.negativePositiveSignPlacement === 's' || settingsClone.currencySymbolPlacement === 's' && (settingsClone.negativePositiveSignPlacement === 'l' || settingsClone.negativePositiveSignPlacement === 'r')) && isNegative(this.value)) {\n                        var _processCharacterDele = this._processCharacterDeletionIfTrailingNegativeSign([left, right]); //TODO Change `this.value` to `this.that.value`?\n\n\n                        var _processCharacterDele2 = _slicedToArray(_processCharacterDele, 2);\n\n                        left = _processCharacterDele2[0];\n                        right = _processCharacterDele2[1];\n                    } else {\n                        if (this.eventKeyCode === keyCode.Backspace) {\n                            left = left.substring(0, left.length - 1);\n                        } else {\n                            right = right.substring(1, right.length);\n                        }\n                    }\n                } else {\n                    this._expandSelectionOnSign(false);\n\n                    var _getUnformattedLeftAn3 = this._getUnformattedLeftAndRightPartAroundTheSelection();\n\n                    var _getUnformattedLeftAn4 = _slicedToArray(_getUnformattedLeftAn3, 2);\n\n                    left = _getUnformattedLeftAn4[0];\n                    right = _getUnformattedLeftAn4[1];\n                }\n\n                this._setValueParts(left, right);\n            }\n\n            /**\n             * This function decides if the key pressed should be dropped or accepted, and modify the value 'on-the-fly' accordingly.\n             * Returns TRUE if the keycode is allowed.\n             * This functions also modify the value on-the-fly. //FIXME This should use another function in order to separate the test and the modification\n             *\n             * @param {Event|string} eventOrChar The event object, or the character entered (from an android device)\n             * @returns {boolean}\n             */\n\n        }, {\n            key: '_processCharacterInsertion',\n            value: function _processCharacterInsertion(eventOrChar) {\n                var settingsClone = this.settingsClone;\n\n                var _getUnformattedLeftAn5 = this._getUnformattedLeftAndRightPartAroundTheSelection(),\n                    _getUnformattedLeftAn6 = _slicedToArray(_getUnformattedLeftAn5, 2),\n                    left = _getUnformattedLeftAn6[0],\n                    right = _getUnformattedLeftAn6[1];\n\n                var eventCharacter = void 0;\n                if (isString(eventOrChar)) {\n                    // Android browsers\n                    eventCharacter = eventOrChar;\n                } else {\n                    // Normal browsers\n                    settingsClone.throwInput = true;\n\n                    // Retrieve the real character that has been entered (ie. 'a' instead of the key code)\n                    eventCharacter = character(eventOrChar);\n                }\n\n                // Start rules when the decimal character key is pressed always use numeric pad dot to insert decimal separator\n                // Do not allow decimal character if no decimal part allowed\n                if (eventCharacter === settingsClone.decimalCharacter || settingsClone.decimalCharacterAlternative && eventCharacter === settingsClone.decimalCharacterAlternative || (eventCharacter === '.' || eventCharacter === ',') && this.eventKeyCode === keyCode.DotNumpad) {\n                    if (!settingsClone.decimalPlacesOverride || !settingsClone.decimalCharacter) {\n                        return true;\n                    }\n\n                    // Do not allow decimal character before negativeSignCharacter character\n                    if (settingsClone.negativeSignCharacter && contains(right, settingsClone.negativeSignCharacter)) {\n                        return true;\n                    }\n\n                    // Do not allow decimal character if other decimal character present\n                    if (contains(left, settingsClone.decimalCharacter)) {\n                        return true;\n                    }\n\n                    if (right.indexOf(settingsClone.decimalCharacter) > 0) {\n                        return true;\n                    }\n\n                    if (right.indexOf(settingsClone.decimalCharacter) === 0) {\n                        right = right.substr(1);\n                    }\n\n                    this._setValueParts(left + settingsClone.decimalCharacter, right);\n\n                    return true;\n                }\n\n                // Prevent minus if not allowed\n                if ((eventCharacter === '-' || eventCharacter === '+') && settingsClone.negativeSignCharacter === '-') {\n                    if (!settingsClone) {\n                        return true;\n                    }\n\n                    // Caret is always after minus\n                    if (settingsClone.currencySymbolPlacement === 'p' && settingsClone.negativePositiveSignPlacement === 's' || settingsClone.currencySymbolPlacement === 's' && settingsClone.negativePositiveSignPlacement !== 'p') {\n                        if (left === '' && contains(right, settingsClone.negativeSignCharacter)) {\n                            left = settingsClone.negativeSignCharacter;\n                            right = right.substring(1, right.length);\n                        }\n\n                        // Change number sign, remove part if should\n                        if (isNegativeStrict(left) || contains(left, settingsClone.negativeSignCharacter)) {\n                            left = left.substring(1, left.length);\n                        } else {\n                            left = eventCharacter === '-' ? settingsClone.negativeSignCharacter + left : left;\n                        }\n                    } else {\n                        if (left === '' && contains(right, settingsClone.negativeSignCharacter)) {\n                            left = settingsClone.negativeSignCharacter;\n                            right = right.substring(1, right.length);\n                        }\n\n                        // Change number sign, remove part if should\n                        if (left.charAt(0) === settingsClone.negativeSignCharacter) {\n                            left = left.substring(1, left.length);\n                        } else {\n                            left = eventCharacter === '-' ? settingsClone.negativeSignCharacter + left : left;\n                        }\n                    }\n\n                    this._setValueParts(left, right);\n\n                    return true;\n                }\n\n                // If the user tries to insert digit before minus sign\n                var eventNumber = Number(eventCharacter);\n                if (eventNumber >= 0 && eventNumber <= 9) {\n                    if (settingsClone.negativeSignCharacter && left === '' && contains(right, settingsClone.negativeSignCharacter)) {\n                        left = settingsClone.negativeSignCharacter;\n                        right = right.substring(1, right.length);\n                    }\n\n                    if (settingsClone.maximumValue <= 0 && settingsClone.minimumValue < settingsClone.maximumValue && !contains(this.value, settingsClone.negativeSignCharacter) && eventCharacter !== '0') {\n                        left = settingsClone.negativeSignCharacter + left;\n                    }\n\n                    this._setValueParts(left + eventCharacter, right);\n\n                    return true;\n                }\n\n                // Prevent any other character\n                settingsClone.throwInput = false;\n\n                return false;\n            }\n\n            /**\n             * Formatting of just processed value while keeping the cursor position\n             *\n             * @param {Event} e\n             * @private\n             */\n\n        }, {\n            key: '_formatValue',\n            value: function _formatValue(e) {\n                var _this = this;\n\n                var settingsClone = this.settingsClone;\n                var leftLength = this.value;\n\n                var _getUnformattedLeftAn7 = this._getUnformattedLeftAndRightPartAroundTheSelection(),\n                    _getUnformattedLeftAn8 = _slicedToArray(_getUnformattedLeftAn7, 1),\n                    left = _getUnformattedLeftAn8[0];\n\n                // No grouping separator and no currency sign\n\n\n                if ((settingsClone.digitGroupSeparator === '' || settingsClone.digitGroupSeparator !== '' && !contains(leftLength, settingsClone.digitGroupSeparator)) && (settingsClone.currencySymbol === '' || settingsClone.currencySymbol !== '' && !contains(leftLength, settingsClone.currencySymbol))) {\n                    var _leftLength$split = leftLength.split(settingsClone.decimalCharacter),\n                        _leftLength$split2 = _slicedToArray(_leftLength$split, 1),\n                        subParts = _leftLength$split2[0];\n\n                    var nSign = '';\n                    if (isNegative(subParts)) {\n                        nSign = '-';\n                        subParts = subParts.replace('-', '');\n                        left = left.replace('-', '');\n                    }\n\n                    // Strip leading zero on positive value if needed\n                    if (nSign === '' && subParts.length > settingsClone.mIntPos && left.charAt(0) === '0') {\n                        left = left.slice(1);\n                    }\n\n                    // Strip leading zero on negative value if needed\n                    if (nSign === '-' && subParts.length > settingsClone.mIntNeg && left.charAt(0) === '0') {\n                        left = left.slice(1);\n                    }\n\n                    left = nSign + left;\n                }\n\n                var value = addGroupSeparators(this.value, this.settingsClone);\n                var position = value.length;\n                if (value) {\n                    // Prepare regexp which searches for cursor position from unformatted left part\n                    var leftAr = left.split('');\n\n                    // Fixes caret position with trailing minus sign\n                    if ((settingsClone.negativePositiveSignPlacement === 's' || settingsClone.currencySymbolPlacement === 's' && settingsClone.negativePositiveSignPlacement !== 'p') && leftAr[0] === '-' && settingsClone.negativeSignCharacter !== '') {\n                        leftAr.shift();\n\n                        if ((this.eventKeyCode === keyCode.Backspace || this.eventKeyCode === keyCode.Delete) && settingsClone.caretFix) {\n                            if (settingsClone.currencySymbolPlacement === 's' && settingsClone.negativePositiveSignPlacement === 'l') {\n                                leftAr.push('-');\n                                settingsClone.caretFix = e.type === 'keydown';\n                            }\n\n                            if (settingsClone.currencySymbolPlacement === 'p' && settingsClone.negativePositiveSignPlacement === 's') {\n                                leftAr.push('-');\n                                settingsClone.caretFix = e.type === 'keydown';\n                            }\n\n                            if (settingsClone.currencySymbolPlacement === 's' && settingsClone.negativePositiveSignPlacement === 'r') {\n                                (function () {\n                                    var signParts = settingsClone.currencySymbol.split('');\n                                    var escapeChr = ['\\\\', '^', '$', '.', '|', '?', '*', '+', '(', ')', '['];\n                                    var escapedParts = [];\n                                    $.each(signParts, function (i, miniParts) {\n                                        miniParts = signParts[i];\n                                        if (isInArray(miniParts, escapeChr)) {\n                                            escapedParts.push('\\\\' + miniParts);\n                                        } else {\n                                            escapedParts.push(miniParts);\n                                        }\n                                    });\n\n                                    if (_this.eventKeyCode === keyCode.Backspace) {\n                                        escapedParts.push('-');\n                                    }\n\n                                    // Pushing the escaped sign\n                                    leftAr.push(escapedParts.join(''));\n                                    settingsClone.caretFix = e.type === 'keydown';\n                                })();\n                            }\n                        }\n                    }\n\n                    for (var i = 0; i < leftAr.length; i++) {\n                        if (!leftAr[i].match('\\\\d')) {\n                            leftAr[i] = '\\\\' + leftAr[i];\n                        }\n                    }\n\n                    var leftReg = new RegExp('^.*?' + leftAr.join('.*?'));\n\n                    // Search cursor position in formatted value\n                    var newLeft = value.match(leftReg);\n                    if (newLeft) {\n                        position = newLeft[0].length;\n\n                        // If the positive sign is shown, calculate the caret position accordingly\n                        if (settingsClone.showPositiveSign) {\n                            if (position === 0 && newLeft.input.charAt(0) === settingsClone.positiveSignCharacter) {\n                                position = newLeft.input.indexOf(settingsClone.currencySymbol) === 1 ? settingsClone.currencySymbol.length + 1 : 1;\n                            }\n\n                            if (position === 0 && newLeft.input.charAt(settingsClone.currencySymbol.length) === settingsClone.positiveSignCharacter) {\n                                position = settingsClone.currencySymbol.length + 1;\n                            }\n                        }\n\n                        // If we are just before the sign which is in prefix position\n                        if ((position === 0 && value.charAt(0) !== settingsClone.negativeSignCharacter || position === 1 && value.charAt(0) === settingsClone.negativeSignCharacter) && settingsClone.currencySymbol && settingsClone.currencySymbolPlacement === 'p') {\n                            // Place caret after prefix sign\n                            //TODO Should the test be 'isNegative' instead of 'isNegativeStrict' in order to search for '-' everywhere in the string?\n                            position = this.settingsClone.currencySymbol.length + (isNegativeStrict(value) ? 1 : 0);\n                        }\n                    } else {\n                        if (settingsClone.currencySymbol && settingsClone.currencySymbolPlacement === 's') {\n                            // If we could not find a place for cursor and have a sign as a suffix\n                            // Place caret before suffix currency sign\n                            position -= settingsClone.currencySymbol.length;\n                        }\n\n                        if (settingsClone.suffixText) {\n                            // If we could not find a place for cursor and have a suffix\n                            // Place caret before suffix\n                            position -= settingsClone.suffixText.length;\n                        }\n                    }\n                }\n\n                // Only update the value if it has changed. This prevents modifying the selection, if any.\n                if (value !== this.that.value || value === this.that.value && (this.eventKeyCode === keyCode.num0 || this.eventKeyCode === keyCode.numpad0)) {\n                    this.that.value = value;\n                    this._setCaretPosition(position);\n                }\n\n                if (settingsClone.androidSelectionStart !== null) {\n                    // If an Android browser is detected, fix the caret position\n                    // Unfortunately this does not fix all android browsers, only Android Chrome currently.\n                    // This is due to the fact those provide different order of events and/or keycodes thrown (this is a real mess :|).\n                    this._setCaretPosition(settingsClone.androidSelectionStart);\n                }\n\n                this.formatted = true; //TODO Rename `this.formatted` to `this._formatExecuted`, since it's possible this function does not need to format anything (in the case where the keycode is dropped for instance)\n            }\n        }]);\n\n        return AutoNumericHolder;\n    }();\n\n    /**\n     * This function factorise the `getString()` and `getArray()` functions since they share quite a lot of code.\n     *\n     * The \"getString\" method uses jQuery's .serialize() method that creates a text string in standard URL-encoded notation.\n     * The \"getArray\" method on the other hand uses jQuery's .serializeArray() method that creates array or objects that can be encoded as a JSON string.\n     *\n     * It then loops through the string and un-formats the inputs with autoNumeric.\n     * By defaults values returned as ISO numeric string \"1234.56\" or \"-1234.56\" where the decimal character is a period\n     * Locale formats are supported \"1234.56-\" or \"1234,56\" or \"-1234,56 or \"1234,56-\", or even plain numbers => please see option \"outputFormat\" for more details\n     *\n     * @param {boolean} getArrayBehavior - If set to TRUE, then this function behave like `getArray()`, otherwise if set to FALSE, it behave like `getString()`\n     * @param {HTMLElement} that - A reference to the current DOM element\n     * @returns {*}\n     * @private\n     */\n\n\n    function _getStringOrArray() {\n        var getArrayBehavior = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;\n        var that = arguments[1];\n\n        var $this = getCurrentElement(that);\n        var formIndex = $('form').index($this);\n        var allFormElements = $('form:eq(' + formIndex + ')')[0];\n        var aiIndex = [];\n\n        // all input index\n        var scIndex = [];\n\n        // successful control index\n        var rSubmitterTypes = /^(?:submit|button|image|reset|file)$/i;\n\n        // from jQuery serialize method\n        var rSubmittable = /^(?:input|select|textarea|keygen)/i;\n\n        // from jQuery serialize method\n        var rCheckableType = /^(?:checkbox|radio)$/i;\n        var rNonAutoNumericTypes = /^(?:button|checkbox|color|date|datetime|datetime-local|email|file|image|month|number|password|radio|range|reset|search|submit|time|url|week)/i;\n\n        var count = 0;\n\n        // index of successful elements\n        $.each(allFormElements, function (i, field) {\n            if (field.name !== '' && rSubmittable.test(field.localName) && !rSubmitterTypes.test(field.type) && !field.disabled && (field.checked || !rCheckableType.test(field.type))) {\n                scIndex.push(count);\n                count++;\n            } else {\n                scIndex.push(-1);\n            }\n        });\n\n        // index of all inputs tags except checkbox\n        count = 0;\n        $.each(allFormElements, function (i, field) {\n            if (field.localName === 'input' && (field.type === '' || field.type === 'text' || field.type === 'hidden' || field.type === 'tel')) {\n                aiIndex.push(count);\n                count++;\n            } else {\n                aiIndex.push(-1);\n                if (field.localName === 'input' && rNonAutoNumericTypes.test(field.type)) {\n                    count++;\n                }\n            }\n        });\n\n        if (getArrayBehavior) {\n            var formFields = $this.serializeArray();\n\n            $.each(formFields, function (i, field) {\n                var scElement = scIndex.indexOf(i);\n\n                if (scElement > -1 && aiIndex[scElement] > -1) {\n                    var testInput = $('form:eq(' + formIndex + ') input:eq(' + aiIndex[scElement] + ')');\n                    var settings = testInput.data('autoNumeric');\n\n                    if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) === 'object') {\n                        field.value = testInput.autoNumeric('getLocalized').toString();\n                    }\n                }\n            });\n\n            return formFields;\n        } else {\n            var _ret2 = function () {\n                // getString() behavior\n                var formFields = $this.serialize();\n                var formParts = formFields.split('&');\n\n                $.each(formParts, function (i) {\n                    var _formParts$i$split = formParts[i].split('='),\n                        _formParts$i$split2 = _slicedToArray(_formParts$i$split, 2),\n                        inputName = _formParts$i$split2[0],\n                        inputValue = _formParts$i$split2[1];\n\n                    var scElement = scIndex.indexOf(i);\n\n                    // If the current element is a valid element\n                    if (scElement > -1 && aiIndex[scElement] > -1) {\n                        var testInput = $('form:eq(' + formIndex + ') input:eq(' + aiIndex[scElement] + ')');\n                        var settings = testInput.data('autoNumeric');\n\n                        if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) === 'object') {\n                            if (inputValue !== null) {\n                                var modifiedInputValue = testInput.autoNumeric('getLocalized').toString();\n                                formParts[i] = inputName + '=' + modifiedInputValue;\n                            }\n                        }\n                    }\n                });\n\n                return {\n                    v: formParts.join('&')\n                };\n            }();\n\n            if ((typeof _ret2 === 'undefined' ? 'undefined' : _typeof(_ret2)) === \"object\") return _ret2.v;\n        }\n    }\n\n    /**\n     * Handler for 'focusin' events\n     *\n     * @param {object} $this jQuery-selected DOM element\n     * @param {AutoNumericHolder} holder\n     * @param {Event} e\n     */\n    function onFocusInAndMouseEnter($this, holder, e) {\n        var settings = holder.settingsClone;\n\n        if (e.type === 'focusin' || e.type === 'mouseenter' && !$this.is(':focus') && settings.emptyInputBehavior === 'focus') {\n            settings.hasFocus = true;\n\n            if (settings.negativeBracketsTypeOnBlur !== null && settings.negativeSignCharacter !== '') {\n                $this.val(toggleNegativeBracket(e.target.value, settings));\n            }\n\n            // clean the value to compare to rawValue\n            var result = stripAllNonNumberCharacters(e.target.value, settings, true);\n            result = convertToNumericString(result, settings);\n            result = cleanLeadingTrailingZeros(result, settings);\n            if (settings.trailingNegative) {\n                result = '-' + result;\n            }\n\n            var roundedValue = void 0;\n            if (settings.decimalPlacesShownOnFocus) {\n                settings.decimalPlacesOverride = settings.decimalPlacesShownOnFocus;\n                roundedValue = roundValue(settings.rawValue, settings);\n                $this.val(addGroupSeparators(roundedValue, settings));\n            } else if (settings.scaleDivisor) {\n                settings.decimalPlacesOverride = Number(settings.oDec);\n                roundedValue = roundValue(settings.rawValue, settings);\n                $this.val(addGroupSeparators(roundedValue, settings));\n            } else if (settings.noSeparatorOnFocus) {\n                settings.digitGroupSeparator = '';\n                settings.currencySymbol = '';\n                settings.suffixText = '';\n                roundedValue = roundValue(settings.rawValue, settings);\n                $this.val(addGroupSeparators(roundedValue, settings));\n            } else if (result !== settings.rawValue) {\n                // updates the rawValue\n                $this.autoNumeric('set', result);\n            }\n\n            // In order to send a 'native' change event when blurring the input, we need to first store the initial input value on focus.\n            holder.valueOnFocus = e.target.value;\n            holder.lastVal = holder.valueOnFocus;\n            var onEmpty = checkEmpty(holder.valueOnFocus, settings, true);\n            if (onEmpty !== null && onEmpty !== '' && settings.emptyInputBehavior === 'focus') {\n                $this.val(onEmpty);\n                if (onEmpty === settings.currencySymbol && settings.currencySymbolPlacement === 's') {\n                    setElementSelection(e.target, 0, 0);\n                }\n            }\n        }\n    }\n\n    /**\n     * Handler for 'keydown' events.\n     * The user just started pushing any key, hence one event is sent.\n     *\n     * Note :\n     * By default a 'normal' input output those events in the right order when inputting a character key (ie. 'a') :\n     * - keydown\n     * - keypress\n     * - input\n     * - keyup\n     *\n     * ...when inputting a modifier key (ie. 'ctrl') :\n     * - keydown\n     * - keyup\n     *\n     * If 'delete' or 'backspace' is entered, the following events are sent :\n     * - keydown\n     * - input\n     * - keyup\n     *\n     * If 'enter' is entered and the value has not changed, the following events are sent :\n     * - keydown\n     * - keypress\n     * - keyup\n     *\n     * If 'enter' is entered and the value has been changed, the following events are sent :\n     * - keydown\n     * - keypress\n     * - change\n     * - keyup\n     *\n     * When a paste is done, the following events are sent :\n     * - input (if paste is done with the mouse)\n     *\n     * - keydown (if paste is done with ctrl+v)\n     * - keydown\n     * - input\n     * - keyup\n     * - keyup\n     *\n     * @param {AutoNumericHolder} holder\n     * @param {Event} e\n     */\n    function onKeydown(holder, e) {\n        //TODO Create a function that retrieve the element value (either by using `e.target.value` when the element is an <input>, or by using `element.textContent` when the element as its `contenteditable` set to true)\n        holder._updateAutoNumericHolderEventKeycode(e);\n        holder.initialValueOnKeydown = e.target.value; // This is needed in `onKeyup()` to check if the value as changed during the key press\n\n        if (holder.that.readOnly) {\n            holder.processed = true;\n\n            return;\n        }\n\n        // The \"enter\" key throws a `change` event if the value has changed since the `focus` event\n        if (holder.eventKeyCode === keyCode.Enter && holder.valueOnFocus !== e.target.value) {\n            triggerEvent('change', e.target);\n            holder.valueOnFocus = e.target.value;\n        }\n\n        holder._updateAutoNumericHolderProperties(e);\n\n        if (holder._skipAlways(e)) {\n            holder.processed = true;\n\n            return;\n        }\n\n        // Check if the key is a delete/backspace key\n        if (holder.eventKeyCode === keyCode.Backspace || holder.eventKeyCode === keyCode.Delete) {\n            holder._processCharacterDeletion(); // Because backspace and delete only triggers keydown and keyup events, not keypress\n            holder.processed = true;\n            holder._formatValue(e);\n\n            // If and only if the resulting value has changed after that backspace/delete, then we have to send an 'input' event like browsers normally do.\n            if (e.target.value !== holder.lastVal && holder.settingsClone.throwInput) {\n                // Throw an input event when a character deletion is detected\n                triggerEvent('input', e.target);\n                e.preventDefault(); // ...and immediately prevent the browser to delete a second character\n            }\n\n            holder.lastVal = e.target.value;\n            holder.settingsClone.throwInput = true;\n\n            return;\n        }\n\n        holder.formatted = false; //TODO Is this line needed?\n    }\n\n    /**\n     * Handler for 'keypress' events.\n     * The user is still pressing the key, which will output a character (ie. '2') continuously until it releases the key.\n     * Note: 'keypress' events are not sent for delete keys like Backspace/Delete.\n     *\n     * @param {AutoNumericHolder} holder\n     * @param {Event} e\n     */\n    function onKeypress(holder, e) {\n        // Retrieve the real character that has been entered (ie. 'a' instead of the key code)\n        var eventCharacter = character(e);\n\n        // Firefox generate a 'keypress' event (e.keyCode === 0) for the keys that do not print a character (ie. 'Insert', 'Delete', 'Fn' keys, 'PageUp', 'PageDown' etc.). 'Shift' on the other hand does not generate a keypress event.\n        if (eventCharacter === keyName.Insert) {\n            return;\n        }\n\n        var processed = holder.processed;\n        holder._updateAutoNumericHolderProperties(e);\n\n        if (holder._skipAlways(e)) {\n            return;\n        }\n\n        if (processed) {\n            e.preventDefault();\n\n            return;\n        }\n\n        var isCharacterInsertionAllowed = holder._processCharacterInsertion(e);\n        if (isCharacterInsertionAllowed) {\n            holder._formatValue(e);\n            if (e.target.value !== holder.lastVal && holder.settingsClone.throwInput) {\n                // Throws input event on adding a character\n                triggerEvent('input', e.target);\n                e.preventDefault(); // ...and immediately prevent the browser to add a second character\n            } else {\n                if ((eventCharacter === holder.settings.decimalCharacter || eventCharacter === holder.settings.decimalCharacterAlternative) && getElementSelection(e.target).start === getElementSelection(e.target).end && getElementSelection(e.target).start === e.target.value.indexOf(holder.settings.decimalCharacter)) {\n                    var position = getElementSelection(e.target).start + 1;\n                    setElementSelection(e.target, position, position);\n                }\n                e.preventDefault();\n            }\n\n            holder.lastVal = e.target.value;\n            holder.settingsClone.throwInput = true;\n\n            return;\n        }\n\n        e.preventDefault();\n\n        holder.formatted = false;\n    }\n\n    /**\n     * Handler for 'input' events.\n     * added to support android devices with mobile chrome browsers and others\n     * Has the potential to replace the keypress event.\n     *\n     * @param {AutoNumericHolder} holder\n     * @param {Event} e\n     */\n    function onInput(holder, e) {\n        var value = e.target.value;\n\n        // Fix the caret position on keyup in the `_formatValue()` function\n        holder.settings.androidSelectionStart = null;\n\n        if (holder.eventKeyCode === keyCode.AndroidDefault) {\n            // The keyCode is equal to the default Android Chrome one (which is always equal to `keyCode.AndroidDefault`)\n            if (value.length > holder.lastVal.length || value.length >= holder.lastVal.length - holder.selection.length) {\n                // Determine the keycode of the character that was entered, and overwrite the faulty `eventKeyCode` info with it\n                holder.eventKeyCode = value.charCodeAt(holder.selection.start);\n\n                // Capture the actual character entered\n                var androidCharEntered = value.charAt(holder.selection.start);\n\n                // Check if the given character should be inserted, and if so, do insert it into the current element value\n                var isCharacterInsertionAllowed = holder._processCharacterInsertion(androidCharEntered);\n\n                if (isCharacterInsertionAllowed) {\n                    // Allowed character entered (number, decimal or plus/minus sign)\n                    holder._formatValue(e);\n\n                    // Capture the new caret position. This is required because on keyup, `_updateAutoNumericHolderEventKeycode()` captures the old caret position\n                    //TODO Check if this is an Android bug or an autoNumeric one\n                    holder.settings.androidSelectionStart = holder.selection.start;\n\n                    var decimalCharacterPosition = e.target.value.indexOf(holder.settings.decimalCharacter);\n                    var hasDecimalCharacter = decimalCharacterPosition === -1;\n\n                    // Move the caret to the right if the `androidCharEntered` is the decimal character or if it's on the left of the caret position\n                    if (androidCharEntered === holder.settings.decimalCharacter || !hasDecimalCharacter && decimalCharacterPosition < holder.settings.androidSelectionStart) {\n                        holder.settings.androidSelectionStart = holder.selection.start + 1;\n                    }\n\n                    if (e.target.value.length > value.length) {\n                        // Position the caret right now before the 'keyup' event in order to prevent the caret from jumping around\n                        setElementSelection(e.target, holder.settings.androidSelectionStart, holder.settings.androidSelectionStart);\n                    }\n\n                    holder.lastVal = e.target.value;\n\n                    return;\n                } else {\n                    // The entered character is not allowed ; overwrite the new invalid value with the previous valid one, and set back the caret/selection\n                    e.target.value = holder.lastVal;\n                    setElementSelection(e.target, holder.selection.start, holder.selection.end);\n                    holder.settings.androidSelectionStart = holder.selection.start;\n                }\n\n                e.preventDefault(); //FIXME How does that affects the normal trigger of the input event?\n\n                holder.formatted = false;\n            } else {\n                // Character deleted\n                //TODO What about the `Delete` key?\n                holder.eventKeyCode = keyCode.Backspace;\n            }\n        }\n    }\n\n    /**\n     * Handler for 'keyup' events.\n     * The user just released any key, hence one event is sent.\n     *\n     * @param {AutoNumericHolder} holder\n     * @param {object} settings\n     * @param {Event} e\n     */\n    function onKeyup(holder, settings, e) {\n        holder._updateAutoNumericHolderProperties(e);\n\n        var skip = holder._skipAlways(e);\n        delete holder.valuePartsBeforePaste;\n        var isOnAndroid = holder.settingsClone.androidSelectionStart !== null;\n        if (skip && !isOnAndroid || e.target.value === '') {\n            return;\n        }\n\n        // Added to properly place the caret when only the currency sign is present\n        if (e.target.value === holder.settingsClone.currencySymbol) {\n            if (holder.settingsClone.currencySymbolPlacement === 's') {\n                setElementSelection(e.target, 0, 0);\n            } else {\n                setElementSelection(e.target, holder.settingsClone.currencySymbol.length, holder.settingsClone.currencySymbol.length);\n            }\n        } else if (holder.eventKeyCode === keyCode.Tab) {\n            setElementSelection(e.target, 0, e.target.value.length);\n        }\n\n        if (e.target.value === holder.settingsClone.suffixText || holder.settingsClone.rawValue === '' && holder.settingsClone.currencySymbol !== '' && holder.settingsClone.suffixText !== '') {\n            setElementSelection(e.target, 0, 0);\n        }\n\n        // Saves the extended decimal to preserve the data when navigating away from the page\n        if (holder.settingsClone.decimalPlacesShownOnFocus !== null && holder.settingsClone.saveValueToSessionStorage) {\n            saveValueToPersistentStorage(e.target, settings, 'set');\n        }\n\n        if (!holder.formatted) {\n            holder._formatValue(e);\n        }\n\n        // If the input value has changed during the key press event chain, an event is sent to alert that a formatting has been done (cf. Issue #187)\n        if (e.target.value !== holder.initialValueOnKeydown) {\n            triggerEvent('autoNumeric:formatted', e.target);\n        }\n    }\n\n    /**\n     * Handler for 'focusout' events\n     *\n     * @param {object} $this jQuery-selected DOM element\n     * @param {AutoNumericHolder} holder\n     * @param {Event} e\n     */\n    function onFocusOutAndMouseLeave($this, holder, e) {\n        if (!$this.is(':focus')) {\n            var value = e.target.value;\n            var origValue = value;\n            var settings = holder.settingsClone;\n            settings.hasFocus = false;\n\n            if (settings.saveValueToSessionStorage) {\n                saveValueToPersistentStorage(e.target, settings, 'set');\n            }\n\n            if (settings.noSeparatorOnFocus === true) {\n                settings.digitGroupSeparator = settings.oSep;\n                settings.currencySymbol = settings.oSign;\n                settings.suffixText = settings.oSuffix;\n            }\n\n            if (settings.decimalPlacesShownOnFocus !== null) {\n                settings.decimalPlacesOverride = settings.oDec;\n                settings.allowDecimalPadding = settings.oPad;\n                settings.negativeBracketsTypeOnBlur = settings.oBracket;\n            }\n\n            value = stripAllNonNumberCharacters(value, settings, true);\n\n            if (value !== '') {\n                if (settings.trailingNegative && !isNegative(value)) {\n                    value = '-' + value;\n                    settings.trailingNegative = false;\n                }\n\n                var _checkIfInRangeWithOv3 = checkIfInRangeWithOverrideOption(value, settings),\n                    _checkIfInRangeWithOv4 = _slicedToArray(_checkIfInRangeWithOv3, 2),\n                    minTest = _checkIfInRangeWithOv4[0],\n                    maxTest = _checkIfInRangeWithOv4[1];\n\n                if (checkEmpty(value, settings, false) === null && minTest && maxTest) {\n                    value = modifyNegativeSignAndDecimalCharacterForRawValue(value, settings);\n                    settings.rawValue = cleanLeadingTrailingZeros(value, settings);\n\n                    if (settings.scaleDivisor) {\n                        value = value / settings.scaleDivisor;\n                        value = value.toString();\n                    }\n\n                    settings.decimalPlacesOverride = settings.scaleDivisor && settings.scaleDecimalPlaces ? Number(settings.scaleDecimalPlaces) : settings.decimalPlacesOverride;\n                    value = roundValue(value, settings);\n                    value = modifyNegativeSignAndDecimalCharacterForFormattedValue(value, settings);\n                } else {\n                    if (!minTest) {\n                        $this.trigger('autoNumeric:minExceeded');\n                    }\n                    if (!maxTest) {\n                        $this.trigger('autoNumeric:maxExceeded');\n                    }\n\n                    value = settings.rawValue;\n                }\n            } else {\n                if (settings.emptyInputBehavior === 'zero') {\n                    settings.rawValue = '0';\n                    value = roundValue('0', settings);\n                } else {\n                    settings.rawValue = '';\n                }\n            }\n\n            var groupedValue = checkEmpty(value, settings, false);\n            if (groupedValue === null) {\n                groupedValue = addGroupSeparators(value, settings);\n            }\n\n            if (groupedValue !== origValue) {\n                groupedValue = settings.scaleSymbol ? groupedValue + settings.scaleSymbol : groupedValue;\n                $this.val(groupedValue);\n            }\n\n            if (groupedValue !== holder.valueOnFocus) {\n                $this.change();\n                delete holder.valueOnFocus;\n            }\n        }\n    }\n\n    /**\n     * Handler for 'paste' events\n     *\n     * @param {object} $this jQuery-selected DOM element\n     * @param {AutoNumericHolder} holder\n     * @param {Event} e\n     */\n    function onPaste($this, holder, e) {\n        //TODO Using ctrl+z after a paste should cancel it -> How would that affect other frameworks/component built with that feature in mind though?\n        //FIXME When pasting '000' on a thousand group selection, the whole selection gets deleted, and only one '0' is pasted (cf. issue #302)\n        // The event is prevented by default, since otherwise the user would be able to paste invalid characters into the input\n        e.preventDefault();\n\n        var rawPastedText = e.clipboardData.getData('text/plain');\n\n        // 0. Special case if the user has selected all the input text before pasting\n        var initialFormattedValue = e.target.value;\n        var selectionStart = e.target.selectionStart || 0;\n        var selectionEnd = e.target.selectionEnd || 0;\n        var selectionSize = selectionEnd - selectionStart;\n        var isAllInputTextSelected = false;\n\n        if (selectionSize === initialFormattedValue.length) {\n            isAllInputTextSelected = true;\n        }\n\n        // 1. Check if the paste has a negative sign (only if it's the first character), and store that information for later use\n        var isPasteNegative = isNegativeStrict(rawPastedText);\n        if (isPasteNegative) {\n            // 1a. Remove the negative sign from the pasted text\n            rawPastedText = rawPastedText.slice(1, rawPastedText.length);\n        }\n\n        // 2. Strip all thousand separators, brackets and currency sign, and convert the decimal character to a dot\n        var untranslatedPastedText = preparePastedText(rawPastedText, holder);\n\n        var pastedText = void 0;\n        if (untranslatedPastedText === '.') {\n            // Special case : If the user tries to paste a single decimal character (that has been translated to '.' already)\n            pastedText = '.';\n        } else {\n            // Normal case\n            // Allow pasting arabic numbers\n            pastedText = arabicToLatinNumbers(untranslatedPastedText, false, false, false);\n        }\n\n        // 3. Test if the paste is valid (only has numbers and eventually a decimal character). If it's not valid, stop here.\n        if (pastedText !== '.' && (!isNumber(pastedText) || pastedText === '')) {\n            if (holder.settings.onInvalidPaste === 'error') {\n                //TODO Should we send a warning instead of throwing an error?\n                throwError('The pasted value \\'' + rawPastedText + '\\' is not a valid paste content.');\n            }\n\n            return;\n        }\n\n        // 4. Calculate the paste result\n        var caretPositionOnInitialTextAfterPasting = void 0;\n        var initialUnformattedNumber = void 0;\n        if (e.target.value === '') {\n            // autoNumeric 'get' returns '0.00' if the input is empty, hence we need to store the 'real' empty initial value when needed\n            //FIXME This has been fixed in a previous commit, get should return '' on an empty input. Remove this unneeded 'if'\n            initialUnformattedNumber = '';\n        } else {\n            initialUnformattedNumber = $this.autoNumeric('get');\n        }\n        var isInitialValueNegative = isNegativeStrict(initialUnformattedNumber);\n        var isPasteNegativeAndInitialValueIsPositive = void 0;\n        var result = void 0;\n\n        // If the pasted content is negative, then the result will be negative too\n        if (isPasteNegative && !isInitialValueNegative) {\n            initialUnformattedNumber = '-' + initialUnformattedNumber;\n            isInitialValueNegative = true;\n            isPasteNegativeAndInitialValueIsPositive = true;\n        } else {\n            isPasteNegativeAndInitialValueIsPositive = false;\n        }\n\n        var leftPartContainedADot = false;\n        var leftPart = void 0;\n        var rightPart = void 0;\n        switch (holder.settings.onInvalidPaste) {\n            /* 4a. Truncate paste behavior:\n             * Insert as many numbers as possible on the right hand side of the caret from the pasted text content, until the input reach its range limit.\n             * If there is more characters in the clipboard once a limit is reached, drop the extraneous characters.\n             * Otherwise paste all the numbers in the clipboard.\n             * While doing so, we check if the result is within the minimum and maximum values allowed, and stop as soon as we encounter one of those.\n             *\n             * 4b. Replace paste behavior:\n             * Idem than the 'truncate' paste behavior, except that when a range limit is hit, we try to replace the subsequent initial numbers with the pasted ones, until we hit the range limit a second (and last) time, or we run out of numbers to paste\n             */\n            /* eslint no-case-declarations: 0 */\n            case 'truncate':\n            case 'replace':\n                var leftFormattedPart = initialFormattedValue.slice(0, selectionStart);\n                var rightFormattedPart = initialFormattedValue.slice(selectionEnd, initialFormattedValue.length);\n\n                if (selectionStart !== selectionEnd) {\n                    // a. If there is a selection, remove the selected part, and return the left and right part\n                    result = preparePastedText(leftFormattedPart + rightFormattedPart, holder);\n                } else {\n                    // b. Else if this is only one caret (and therefore no selection), then return the left and right part\n                    result = preparePastedText(initialFormattedValue, holder);\n                }\n\n                // Add back the negative sign if needed\n                if (isInitialValueNegative) {\n                    result = setRawNegativeSign(result);\n                }\n\n                // Build the unformatted result string\n                caretPositionOnInitialTextAfterPasting = convertCharacterCountToIndexPosition(countNumberCharactersOnTheCaretLeftSide(initialFormattedValue, selectionStart, holder.settings.decimalCharacter));\n                if (isPasteNegativeAndInitialValueIsPositive) {\n                    // If the initial paste is negative and the initial value is not, then I must offset the caret position by one place to the right to take the additional hyphen into account\n                    caretPositionOnInitialTextAfterPasting++;\n                    //TODO Quid if the negative sign is not on the left (negativePositiveSignPlacement and currencySymbolPlacement)?\n                }\n\n                leftPart = result.slice(0, caretPositionOnInitialTextAfterPasting);\n                rightPart = result.slice(caretPositionOnInitialTextAfterPasting, result.length);\n                if (pastedText === '.') {\n                    if (contains(leftPart, '.')) {\n                        // If I remove a dot here, then I need to update the caret position (decrement it by 1) when positioning it\n                        // To do so, we keep that info in order to modify the caret position later\n                        leftPartContainedADot = true;\n                        leftPart = leftPart.replace('.', '');\n                    }\n                    rightPart = rightPart.replace('.', '');\n                }\n                // -- Here, we are good to go to continue on the same basis\n\n                // c. Add numbers one by one at the caret position, while testing if the result is valid and within the range of the minimum and maximum value\n                //    Continue until you either run out of numbers to paste, or that you get out of the range limits\n                var minParse = parseStr(holder.settings.minimumValue);\n                var maxParse = parseStr(holder.settings.maximumValue);\n                var lastGoodKnownResult = result; // This is set as the default, in case we do not add even one number\n                var pastedTextIndex = 0;\n                var modifiedLeftPart = leftPart;\n\n                while (pastedTextIndex < pastedText.length) {\n                    // Modify the result with another pasted character\n                    modifiedLeftPart += pastedText[pastedTextIndex];\n                    result = modifiedLeftPart + rightPart;\n\n                    // Check the range limits\n                    if (!checkIfInRange(result, minParse, maxParse)) {\n                        // The result is out of the range limits, stop the loop here\n                        break;\n                    }\n\n                    // Save the last good known result\n                    lastGoodKnownResult = result;\n\n                    // Update the local variables for the next loop\n                    pastedTextIndex++;\n                }\n\n                // Update the last caret position where to insert a new number\n                caretPositionOnInitialTextAfterPasting += pastedTextIndex;\n\n                //XXX Here we have the result for the `truncate` option\n                if (holder.settings.onInvalidPaste === 'truncate') {\n                    //TODO If the user as defined a truncate callback and there are still some numbers (that will be dropped), then call this callback with the initial paste as well as the remaining numbers\n                    result = lastGoodKnownResult;\n\n                    if (leftPartContainedADot) {\n                        // If a dot has been removed for the part on the left of the caret, we decrement the caret index position\n                        caretPositionOnInitialTextAfterPasting--;\n                    }\n                    break;\n                }\n                //XXX ...else we need to continue modifying the result for the 'replace' option\n\n                // d. Until there are numbers to paste, replace the initial numbers one by one, and still do the range test.\n                //    Stop when you have no more numbers to paste, or if you are out of the range limits.\n                //    If you do get to the range limits, use the previous known good value within those limits.\n                //    Note: The numbers are replaced one by one, in the integer then decimal part, while ignoring the decimal character\n                //TODO What should happen if the user try to paste a decimal number? Should we override the current initial decimal character in favor of this new one? If we do, then we have to recalculate the vMin/vMax from the start in order to take into account this new decimal character position..\n                var lastGoodKnownResultIndex = caretPositionOnInitialTextAfterPasting;\n                var lastGoodKnownResultSize = lastGoodKnownResult.length;\n\n                while (pastedTextIndex < pastedText.length && lastGoodKnownResultIndex < lastGoodKnownResultSize) {\n                    if (lastGoodKnownResult[lastGoodKnownResultIndex] === '.') {\n                        // We skip the decimal character 'replacement'. That way, we do not change the decimal character position regarding the remaining numbers.\n                        lastGoodKnownResultIndex++;\n                        continue;\n                    }\n\n                    // This replace one character at a time\n                    result = replaceCharAt(lastGoodKnownResult, lastGoodKnownResultIndex, pastedText[pastedTextIndex]);\n\n                    // Check the range limits\n                    if (!checkIfInRange(result, minParse, maxParse)) {\n                        // The result is out of the range limits, stop the loop here\n                        break;\n                    }\n\n                    // Save the last good known result\n                    lastGoodKnownResult = result;\n\n                    // Update the local variables for the next loop\n                    pastedTextIndex++;\n                    lastGoodKnownResultIndex++;\n                }\n\n                // Update the last caret position where to insert a new number\n                caretPositionOnInitialTextAfterPasting = lastGoodKnownResultIndex;\n\n                if (leftPartContainedADot) {\n                    // If a dot has been removed for the part on the left of the caret, we decrement the caret index position\n                    caretPositionOnInitialTextAfterPasting--;\n                }\n\n                result = lastGoodKnownResult;\n\n                break;\n            /* 4c. Normal paste behavior:\n             * Insert the pasted number inside the current unformatted text, at the right caret position or selection\n             */\n            case 'error':\n            case 'ignore':\n            case 'clamp':\n            default:\n                // 1. Generate the unformatted result\n                var leftFormattedPart2 = initialFormattedValue.slice(0, selectionStart);\n                var rightFormattedPart2 = initialFormattedValue.slice(selectionEnd, initialFormattedValue.length);\n\n                if (selectionStart !== selectionEnd) {\n                    // a. If there is a selection, remove the selected part, and return the left and right part\n                    result = preparePastedText(leftFormattedPart2 + rightFormattedPart2, holder);\n                } else {\n                    // b. Else if this is only one caret (and therefore no selection), then return the left and right part\n                    result = preparePastedText(initialFormattedValue, holder);\n                }\n\n                // Add back the negative sign if needed\n                if (isInitialValueNegative) {\n                    result = setRawNegativeSign(result);\n                }\n\n                // Build the unformatted result string\n                caretPositionOnInitialTextAfterPasting = convertCharacterCountToIndexPosition(countNumberCharactersOnTheCaretLeftSide(initialFormattedValue, selectionStart, holder.settings.decimalCharacter));\n                if (isPasteNegativeAndInitialValueIsPositive) {\n                    // If the initial paste is negative and the initial value is not, then I must offset the caret position by one place to the right to take the additional hyphen into account\n                    caretPositionOnInitialTextAfterPasting++;\n                    //TODO Quid if the negative sign is not on the left (negativePositiveSignPlacement and currencySymbolPlacement)?\n                }\n\n                leftPart = result.slice(0, caretPositionOnInitialTextAfterPasting);\n                rightPart = result.slice(caretPositionOnInitialTextAfterPasting, result.length);\n                if (pastedText === '.') {\n                    // If the user only paste a single decimal character, then we remove the previously existing one (if any)\n                    if (contains(leftPart, '.')) {\n                        // If I remove a dot here, then I need to update the caret position (decrement it by 1) when positioning it\n                        // To do so, we keep that info in order to modify the caret position later\n                        leftPartContainedADot = true;\n                        leftPart = leftPart.replace('.', '');\n                    }\n                    rightPart = rightPart.replace('.', '');\n                }\n                // -- Here, we are good to go to continue on the same basis\n\n                // Generate the unformatted result\n                result = '' + leftPart + pastedText + rightPart;\n\n                // 2. Calculate the caret position in the unformatted value, for later use\n                if (selectionStart === selectionEnd) {\n                    // There is no selection, then the caret position is set after the pasted text\n                    var indexWherePastedTextHasBeenInserted = convertCharacterCountToIndexPosition(countNumberCharactersOnTheCaretLeftSide(initialFormattedValue, selectionStart, holder.settings.decimalCharacter));\n                    caretPositionOnInitialTextAfterPasting = indexWherePastedTextHasBeenInserted + pastedText.length; // I must not count the characters that have been removed from the pasted text (ie. '.')\n                } else {\n                    if (isAllInputTextSelected) {\n                        // Special case when all the input text is selected before pasting, which means we'll completely erase its content and paste only the clipboard content\n                        caretPositionOnInitialTextAfterPasting = result.length;\n                    } else if (rightPart === '') {\n                        // If the user selected from the caret position to the end of the input (on the far right)\n                        caretPositionOnInitialTextAfterPasting = convertCharacterCountToIndexPosition(countNumberCharactersOnTheCaretLeftSide(initialFormattedValue, selectionStart, holder.settings.decimalCharacter)) + pastedText.length;\n                    } else {\n                        // Normal case\n                        var indexSelectionEndInRawValue = convertCharacterCountToIndexPosition(countNumberCharactersOnTheCaretLeftSide(initialFormattedValue, selectionEnd, holder.settings.decimalCharacter));\n\n                        // Here I must not count the characters that have been removed from the pasted text (ie. '.'), or the thousand separators in the initial selected text\n                        var selectedText = e.target.value.slice(selectionStart, selectionEnd);\n                        caretPositionOnInitialTextAfterPasting = indexSelectionEndInRawValue - selectionSize + countCharInText(holder.settings.digitGroupSeparator, selectedText) + pastedText.length;\n                    }\n                }\n\n                // Modify the caret position for special cases, only if the whole input has not been selected\n                if (!isAllInputTextSelected) {\n                    if (isPasteNegativeAndInitialValueIsPositive) {\n                        // If the pasted value has a '-' sign, but the initial value does not, offset the index by one\n                        caretPositionOnInitialTextAfterPasting++;\n                    }\n\n                    if (leftPartContainedADot) {\n                        // If a dot has been removed for the part on the left of the caret, we decrement the caret index position\n                        caretPositionOnInitialTextAfterPasting--;\n                    }\n                }\n        }\n\n        // 5. Check if the result is a valid number, if not, drop the paste and do nothing.\n        if (!isNumber(result) || result === '') {\n            if (holder.settings.onInvalidPaste === 'error') {\n                throwError('The pasted value \\'' + rawPastedText + '\\' would result into an invalid content \\'' + result + '\\'.'); //TODO Should we send a warning instead of throwing an error?\n                //TODO This is not DRY ; refactor with above\n            }\n            return;\n        }\n\n        // 6. If it's a valid number, check if it falls inside the minimum and maximum value. If this fails, modify the value following this procedure :\n        /*\n         * If 'error' (this is the default) :\n         *      - Normal paste behavior.\n         *      - Try to set the new value, if it fails, then throw an error in the console.\n         *      - Do not change the input value, do not change the current selection.\n         * If 'ignore' :\n         *      - Normal paste behavior.\n         *      - Try to set the new value, if it fails, do nothing more.\n         *      - Do not change the input value, do not change the current selection.\n         * If 'clamp' :\n         *      - Normal paste behavior.\n         *      - Try to set the new value, if it fails, set the value to the minimum or maximum limit, whichever is closest to the\n         *        paste result.\n         *      - Change the caret position to be positioned on the left hand side of the decimal character.\n         * If 'truncate' :\n         *      - Truncate paste behavior.\n         *      - Try to set the new value, until it fails (if the result is out of the min and max value limits).\n         *      - Drop the remaining non-pasted numbers, and keep the last known non-failing result.\n         *      - Change the caret position to be positioned after the last pasted character.\n         * If 'replace' :\n         *      - Replace paste behavior.\n         *      - Try to set the new value, until it fails (if the result is out of the min and max value limits).\n         *     - Then try to replace as many numbers as possible with the pasted ones. Once it fails, keep the last known non-failing result.\n         *      - Change the caret position to be positioned after the last pasted character.\n         */\n        var valueHasBeenSet = false;\n        var valueHasBeenClamped = false;\n        try {\n            $this.autoNumeric('set', result);\n            valueHasBeenSet = true;\n        } catch (error) {\n            var clampedValue = void 0;\n            switch (holder.settings.onInvalidPaste) {\n                case 'clamp':\n                    clampedValue = clampToRangeLimits(result, holder.settings);\n                    try {\n                        $this.autoNumeric('set', clampedValue);\n                    } catch (error) {\n                        throwError('Fatal error: Unable to set the clamped value \\'' + clampedValue + '\\'.');\n                    }\n\n                    valueHasBeenClamped = true;\n                    valueHasBeenSet = true;\n                    result = clampedValue; // This is used only for setting the caret position later\n                    break;\n                case 'error':\n                case 'truncate':\n                case 'replace':\n                    // Throw an error message\n                    throwError('The pasted value \\'' + rawPastedText + '\\' results in a value \\'' + result + '\\' that is outside of the minimum [' + holder.settings.minimumValue + '] and maximum [' + holder.settings.maximumValue + '] value range.');\n                // falls through\n                case 'ignore':\n                // Do nothing\n                // falls through\n                default:\n                    return; // ...and nothing else should be changed\n            }\n        }\n\n        // 7. Then lastly, set the caret position at the right logical place\n        var caretPositionInFormattedNumber = void 0;\n        if (valueHasBeenSet) {\n            switch (holder.settings.onInvalidPaste) {\n                case 'clamp':\n                    if (valueHasBeenClamped) {\n                        if (holder.settings.currencySymbolPlacement === 's') {\n                            setElementSelection(e.target, e.target.value.length - holder.settings.currencySymbol.length); // This puts the caret on the right of the last decimal place\n                        } else {\n                            setElementSelection(e.target, e.target.value.length); // ..and this on the far right\n                        }\n\n                        break;\n                    } // else if the value has not been clamped, the default behavior is used...\n                // falls through\n                case 'error':\n                case 'ignore':\n                case 'truncate':\n                case 'replace':\n                default:\n                    // Whenever one or multiple characters are pasted, this means we have to manage the potential thousand separators that could be added by the formatting\n                    caretPositionInFormattedNumber = findCaretPositionInFormattedNumber(result, caretPositionOnInitialTextAfterPasting, e.target.value, holder.settings.decimalCharacter);\n                    setElementSelection(e.target, caretPositionInFormattedNumber);\n            }\n        }\n\n        // 8. We make sure we send an input event only if the result is different than the initial value before the paste\n        if (valueHasBeenSet && initialFormattedValue !== e.target.value) {\n            // On a 'normal' non-autoNumeric input, an `input` event is sent when a paste is done. We mimic that.\n            triggerEvent('input', e.target);\n        }\n    }\n\n    /**\n     * When focusing out of the input, we check if the value has changed, and if it has, then we send a `change` event (since the native one would have been prevented by `e.preventDefault()` called in the other event listeners).\n     *\n     * @param {AutoNumericHolder} holder\n     * @param {Event} e\n     */\n    function onBlur(holder, e) {\n        if (e.target.value !== holder.valueOnFocus) {\n            triggerEvent('change', e.target);\n            // e.preventDefault(); // ...and immediately prevent the browser to send a second change event (that somehow gets picked up by jQuery, but not by `addEventListener()` //FIXME KNOWN BUG : This does not prevent the second change event to be picked up by jQuery, which adds '.00' at the end of an integer\n        }\n    }\n\n    /**\n     * Handler for 'submit' events\n     *\n     * @param {object} $this jQuery-selected DOM element\n     * @param {AutoNumericHolder} holder\n     */\n    function onSubmit($this, holder) {\n        $this.closest('form').on('submit.autoNumeric', function () {\n            if (holder) {\n                var $settings = holder.settingsClone;\n\n                if ($settings.unformatOnSubmit) {\n                    $this.val($settings.rawValue);\n                }\n            }\n        });\n    }\n\n    /**\n     * Return the jQuery selected input if the tag and type are supported by autoNumeric.\n     *\n     * @param {object} $this jQuery-selected DOM element\n     * @returns {boolean|*}\n     */\n    function getInputIfSupportedTagAndType($this) {\n        // Supported input type\n        var $input = $this.is('input[type=text], input[type=hidden], input[type=tel], input:not([type])');\n\n        // Checks for non-supported input types\n        if (!$input && $this.prop('tagName').toLowerCase() === 'input') {\n            throwError('The input type \"' + $this.prop('type') + '\" is not supported by autoNumeric');\n        }\n\n        // Checks for non-supported tags\n        var currentElementTag = $this.prop('tagName').toLowerCase();\n        if (currentElementTag !== 'input' && !isInArray(currentElementTag, allowedTagList)) {\n            throwError('The <' + currentElementTag + '> tag is not supported by autoNumeric');\n        }\n\n        return $input;\n    }\n\n    /**\n     * Formats the default value on page load.\n     * This is called only if the `formatOnPageLoad` option is set to `true`.\n     *\n     * @param {object} settings\n     * @param {object} $input jQuery-selected <input> element\n     * @param {object} $this jQuery-selected DOM element\n     */\n    function formatDefaultValueOnPageLoad(settings, $input, $this) {\n        var setValue = true;\n\n        if ($input) {\n            var currentValue = $this.val();\n            /*\n             * If the input value has been set by the dev, but not directly as an attribute in the html, then it takes\n             * precedence and should get formatted on init (if this input value is a valid number and that the\n             * developer wants it formatted on init (cf. `settings.formatOnPageLoad`)).\n             * Note; this is true whatever the developer has set for `data-an-default` in the html (asp.net users).\n             *\n             * In other words : if `defaultValueOverride` is not null, it means the developer is trying to prevent postback problems.\n             * But if `input.value` is set to a number, and `$this.attr('value')` is not set, then it means the dev has\n             * changed the input value, and then it means we should not overwrite his own decision to do so.\n             * Hence, if `defaultValueOverride` is not null, but `input.value` is a number and `$this.attr('value')` is not set,\n             * we should ignore `defaultValueOverride` altogether.\n             */\n            var unLocalizedCurrentValue = toNumericValue(currentValue, settings); // This allows to use a localized value on startup oDec\n            if (settings.formatOnPageLoad && currentValue !== '' && isUndefinedOrNullOrEmpty($this.attr('value'))) {\n                // Check if the `value` is valid or not\n                if (!isNaN(unLocalizedCurrentValue) && Infinity !== unLocalizedCurrentValue) {\n                    $this.autoNumeric('set', unLocalizedCurrentValue);\n                    setValue = false;\n                } else {\n                    // If not, inform the developer that nothing usable has been provided\n                    throwError('The value [' + currentValue + '] used in the input is not a valid value autoNumeric can work with.');\n                }\n            } else {\n                /* Checks for :\n                 * - page reload from back button, and\n                 * - ASP.net form post back\n                 *      The following HTML data attribute is REQUIRED (data-an-default=\"same value as the value attribute\")\n                 *      example: <asp:TextBox runat=\"server\" id=\"someID\" text=\"1234.56\" data-an-default=\"1234.56\">\n                 */\n                if (settings.defaultValueOverride !== null && settings.defaultValueOverride.toString() !== currentValue || settings.defaultValueOverride === null && currentValue !== '' && currentValue !== $this.attr('value') || currentValue !== '' && $this.attr('type') === 'hidden' && !isNumber(unLocalizedCurrentValue)) {\n                    if (settings.decimalPlacesShownOnFocus !== null && settings.saveValueToSessionStorage || settings.scaleDivisor && settings.saveValueToSessionStorage) {\n                        settings.rawValue = saveValueToPersistentStorage($this[0], settings, 'get');\n                    }\n\n                    // If the decimalPlacesShownOnFocus value should NOT be saved in sessionStorage\n                    if (!settings.saveValueToSessionStorage) {\n                        var toStrip = void 0;\n\n                        if (settings.negativeBracketsTypeOnBlur !== null && settings.negativeSignCharacter !== '') {\n                            settings.hasFocus = true;\n                            toStrip = toggleNegativeBracket(currentValue, settings);\n                        } else {\n                            toStrip = currentValue;\n                        }\n\n                        if ((settings.negativePositiveSignPlacement === 's' || settings.negativePositiveSignPlacement !== 'p' && settings.currencySymbolPlacement === 's') && settings.negativeSignCharacter !== '' && isNegative(currentValue)) {\n                            settings.rawValue = settings.negativeSignCharacter + stripAllNonNumberCharacters(toStrip, settings, true);\n                        } else {\n                            settings.rawValue = stripAllNonNumberCharacters(toStrip, settings, true);\n                        }\n                    }\n\n                    setValue = false;\n                }\n            }\n\n            if (currentValue === '') {\n                switch (settings.emptyInputBehavior) {\n                    case 'focus':\n                        setValue = false;\n                        break;\n                    case 'always':\n                        $this.val(settings.currencySymbol);\n                        setValue = false;\n                        break;\n                    case 'zero':\n                        $this.autoNumeric('set', '0');\n                        setValue = false;\n                        break;\n                    default:\n                    //\n                }\n            } else if (setValue && currentValue === $this.attr('value')) {\n                $this.autoNumeric('set', currentValue);\n            }\n        }\n\n        if (isInArray($this.prop('tagName').toLowerCase(), settings.tagList) && $this.text() !== '') {\n            if (settings.defaultValueOverride !== null) {\n                if (settings.defaultValueOverride === $this.text()) {\n                    $this.autoNumeric('set', $this.text());\n                }\n            } else {\n                $this.autoNumeric('set', $this.text());\n            }\n        }\n    }\n\n    /**\n     * Enhance the user experience by modifying the default `negativePositiveSignPlacement` option depending on `currencySymbol` and `currencySymbolPlacement`.\n     *\n     * If the user has not set the placement of the negative sign (`negativePositiveSignPlacement`), but has set a currency symbol (`currencySymbol`),\n     * then we modify the default value of `negativePositiveSignPlacement` in order to keep the resulting output logical by default :\n     * - \"$-1,234.56\" instead of \"-$1,234.56\" ({currencySymbol: \"$\", negativePositiveSignPlacement: \"r\"})\n     * - \"-1,234.56$\" instead of \"1,234.56-$\" ({currencySymbol: \"$\", currencySymbolPlacement: \"s\", negativePositiveSignPlacement: \"p\"})\n     *\n     * @param {object} settings\n     */\n    function correctNegativePositiveSignPlacementOption(settings) {\n        // If negativePositiveSignPlacement is already set, we do not overwrite it\n        if (!isNull(settings.negativePositiveSignPlacement)) {\n            return;\n        }\n\n        if (!isUndefined(settings) && isUndefinedOrNullOrEmpty(settings.negativePositiveSignPlacement) && !isUndefinedOrNullOrEmpty(settings.currencySymbol)) {\n            switch (settings.currencySymbolPlacement) {\n                case 's':\n                    settings.negativePositiveSignPlacement = 'p'; // Default -1,234.56 €\n                    break;\n                case 'p':\n                    settings.negativePositiveSignPlacement = 'l'; // Default -$1,234.56\n                    break;\n                default:\n                //\n            }\n        } else {\n            // Sets the default value if `negativePositiveSignPlacement` is `null`\n            settings.negativePositiveSignPlacement = 'l';\n        }\n    }\n\n    /**\n     * Analyze and save the minimumValue and maximumValue integer size for later uses\n     *\n     * @param {object} settings\n     */\n    function calculateVMinAndVMaxIntegerSizes(settings) {\n        var _settings$maximumValu = settings.maximumValue.toString().split('.'),\n            _settings$maximumValu2 = _slicedToArray(_settings$maximumValu, 1),\n            maximumValueIntegerPart = _settings$maximumValu2[0];\n\n        var _ref3 = !settings.minimumValue && settings.minimumValue !== 0 ? [] : settings.minimumValue.toString().split('.'),\n            _ref4 = _slicedToArray(_ref3, 1),\n            minimumValueIntegerPart = _ref4[0];\n\n        maximumValueIntegerPart = maximumValueIntegerPart.replace('-', '');\n        minimumValueIntegerPart = minimumValueIntegerPart.replace('-', '');\n\n        settings.mIntPos = Math.max(maximumValueIntegerPart.length, 1);\n        settings.mIntNeg = Math.max(minimumValueIntegerPart.length, 1);\n    }\n\n    /**\n     * Modify `decimalPlacesOverride` as needed\n     *\n     * @param {object} settings\n     */\n    function correctDecimalPlacesOverrideOption(settings) {\n        if (isNull(settings.decimalPlacesOverride)) {\n            settings.decimalPlacesOverride = maximumVMinAndVMaxDecimalLength(settings.minimumValue, settings.maximumValue);\n        }\n        settings.oDec = String(settings.decimalPlacesOverride);\n\n        // Most calculus assume `decimalPlacesOverride` is an integer, the following statement makes it clear (otherwise having it as a string leads to problems in rounding for instance)\n        settings.decimalPlacesOverride = Number(settings.decimalPlacesOverride);\n    }\n\n    /**\n     * Sets the alternative decimal separator key.\n     *\n     * @param {object} settings\n     */\n    function setsAlternativeDecimalSeparatorCharacter(settings) {\n        if (isNull(settings.decimalCharacterAlternative) && Number(settings.decimalPlacesOverride) > 0) {\n            if (settings.decimalCharacter === '.' && settings.digitGroupSeparator !== ',') {\n                settings.decimalCharacterAlternative = ',';\n            } else if (settings.decimalCharacter === ',' && settings.digitGroupSeparator !== '.') {\n                settings.decimalCharacterAlternative = '.';\n            }\n        }\n    }\n\n    /**\n     * Caches regular expressions for stripAllNonNumberCharacters\n     *\n     * @param {object} settings\n     */\n    function cachesUsualRegularExpressions(settings) {\n        var allNumbersReg = '[0-9]';\n        var noAllNumbersReg = '[^0-9]';\n\n        // Test if there is a negative character in the string\n        var aNegReg = settings.negativeSignCharacter ? '([-\\\\' + settings.negativeSignCharacter + ']?)' : '(-?)';\n        settings.aNegRegAutoStrip = aNegReg;\n\n        var negativeSignRegPart = void 0;\n        if (settings.negativeSignCharacter) {\n            negativeSignRegPart = '\\\\' + settings.negativeSignCharacter;\n        } else {\n            negativeSignRegPart = '';\n        }\n        settings.skipFirstAutoStrip = new RegExp(aNegReg + '[^-' + negativeSignRegPart + '\\\\' + settings.decimalCharacter + allNumbersReg + '].*?(' + allNumbersReg + '|\\\\' + settings.decimalCharacter + allNumbersReg + ')');\n        settings.skipLastAutoStrip = new RegExp('(' + allNumbersReg + '\\\\' + settings.decimalCharacter + '?)[^\\\\' + settings.decimalCharacter + allNumbersReg + ']' + noAllNumbersReg + '*$');\n\n        var allowed = '-0123456789\\\\' + settings.decimalCharacter;\n        settings.allowedAutoStrip = new RegExp('[^' + allowed + ']', 'g');\n        settings.numRegAutoStrip = new RegExp(aNegReg + '(?:\\\\' + settings.decimalCharacter + '?(' + allNumbersReg + '+\\\\' + settings.decimalCharacter + allNumbersReg + '+)|(' + allNumbersReg + '*(?:\\\\' + settings.decimalCharacter + allNumbersReg + '*)?))');\n\n        // Using this regex version `^${settings.aNegRegAutoStrip}0*(\\\\d|$)` entirely clear the input on blur\n        settings.stripReg = new RegExp('^' + settings.aNegRegAutoStrip + '0*(' + allNumbersReg + ')');\n    }\n\n    /**\n     * Modify the user settings to make them 'exploitable' later.\n     *\n     * @param {object} settings\n     */\n    function transformOptionsValuesToDefaultTypes(settings) {\n        $.each(settings, function (key, value) {\n            // Convert the string 'true' and 'false' to real Boolean\n            if (value === 'true' || value === 'false') {\n                settings[key] = value === 'true';\n            }\n\n            // Convert numbers in options to strings\n            //TODO if a value is already of type 'Number', shouldn't we keep it as a number for further manipulation, instead of using a string?\n            if (typeof value === 'number' && key !== 'aScale') {\n                settings[key] = value.toString();\n            }\n        });\n    }\n\n    /**\n     * Convert the old settings options name to new ones.\n     *\n     * @param {object} options\n     */\n    function convertOldOptionsToNewOnes(options) {\n        //TODO Delete this function once the old options are not used anymore\n        var oldOptionsConverter = {\n            // Old option name, with their corresponding new option\n            aSep: 'digitGroupSeparator',\n            nSep: 'noSeparatorOnFocus',\n            dGroup: 'digitalGroupSpacing',\n            aDec: 'decimalCharacter',\n            altDec: 'decimalCharacterAlternative',\n            aSign: 'currencySymbol',\n            pSign: 'currencySymbolPlacement',\n            pNeg: 'negativePositiveSignPlacement',\n            aSuffix: 'suffixText',\n            oLimits: 'overrideMinMaxLimits',\n            vMax: 'maximumValue',\n            vMin: 'minimumValue',\n            mDec: 'decimalPlacesOverride',\n            eDec: 'decimalPlacesShownOnFocus',\n            scaleDecimal: 'scaleDecimalPlaces',\n            aStor: 'saveValueToSessionStorage',\n            mRound: 'roundingMethod',\n            aPad: 'allowDecimalPadding',\n            nBracket: 'negativeBracketsTypeOnBlur',\n            wEmpty: 'emptyInputBehavior',\n            lZero: 'leadingZero',\n            aForm: 'formatOnPageLoad',\n            sNumber: 'selectNumberOnly',\n            anDefault: 'defaultValueOverride',\n            unSetOnSubmit: 'unformatOnSubmit',\n            outputType: 'outputFormat',\n            debug: 'showWarnings',\n            // Current options :\n            digitGroupSeparator: true,\n            noSeparatorOnFocus: true,\n            digitalGroupSpacing: true,\n            decimalCharacter: true,\n            decimalCharacterAlternative: true,\n            currencySymbol: true,\n            currencySymbolPlacement: true,\n            negativePositiveSignPlacement: true,\n            showPositiveSign: true,\n            suffixText: true,\n            overrideMinMaxLimits: true,\n            maximumValue: true,\n            minimumValue: true,\n            decimalPlacesOverride: true,\n            decimalPlacesShownOnFocus: true,\n            scaleDivisor: true,\n            scaleDecimalPlaces: true,\n            scaleSymbol: true,\n            saveValueToSessionStorage: true,\n            onInvalidPaste: true,\n            roundingMethod: true,\n            allowDecimalPadding: true,\n            negativeBracketsTypeOnBlur: true,\n            emptyInputBehavior: true,\n            leadingZero: true,\n            formatOnPageLoad: true,\n            selectNumberOnly: true,\n            defaultValueOverride: true,\n            unformatOnSubmit: true,\n            outputFormat: true,\n            showWarnings: true,\n            failOnUnknownOption: true,\n            //FIXME Find a way to exclude those internal data from the settings object (ideally by using another object, or better yet, class attributes) -->\n            hasFocus: true,\n            runOnce: true,\n            rawValue: true,\n            trailingNegative: true,\n            caretFix: true,\n            throwInput: true,\n            strip: true,\n            tagList: true,\n            negativeSignCharacter: true,\n            positiveSignCharacter: true,\n            mIntPos: true,\n            mIntNeg: true,\n            oDec: true,\n            oPad: true,\n            oBracket: true,\n            oSep: true,\n            oSign: true,\n            oSuffix: true,\n            aNegRegAutoStrip: true,\n            skipFirstAutoStrip: true,\n            skipLastAutoStrip: true,\n            allowedAutoStrip: true,\n            numRegAutoStrip: true,\n            stripReg: true,\n            holder: true\n        };\n\n        for (var option in options) {\n            if (options.hasOwnProperty(option)) {\n                if (oldOptionsConverter[option] === true) {\n                    // If the option is a 'new' option, we continue looping\n                    continue;\n                }\n\n                if (oldOptionsConverter.hasOwnProperty(option)) {\n                    // Else we have an 'old' option name\n                    warning('You are using the deprecated option name \\'' + option + '\\'. Please use \\'' + oldOptionsConverter[option] + '\\' instead from now on. The old option name will be dropped soon.', true);\n\n                    // Then we modify the initial option object to use the new options instead of the old ones\n                    options[oldOptionsConverter[option]] = options[option];\n                    delete options[option];\n                } else if (options.failOnUnknownOption) {\n                    // ...or the option name is unknown. This means there is a problem with the options object, therefore we throw an error.\n                    throwError('Option name \\'' + option + '\\' is unknown. Please fix the options passed to autoNumeric');\n                }\n            }\n        }\n    }\n\n    /**\n     * Analyse the settings/options passed by the user, validate and clean them, then return them.\n     * Note: This returns `null` if somehow the settings returned by jQuery is not an object.\n     *\n     * @param {object} options\n     * @param {object} $this jQuery-selected DOM element\n     * @param {boolean} update - If TRUE, then the settings already exists and this function only updates them instead of recreating them from scratch\n     * @returns {object|null}\n     */\n    function getInitialSettings(options, $this) {\n        var update = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n\n        // Attempt to grab \"autoNumeric\" settings. If they do not exist, it returns \"undefined\".\n        var settings = $this.data('autoNumeric');\n\n        // If the user used old options, we convert them to new ones\n        if (update || !isNull(options)) {\n            convertOldOptionsToNewOnes(options);\n        }\n\n        if (update || isUndefined(settings)) {\n            if (update) {\n                // The settings are updated\n                settings = $.extend(settings, options);\n            } else {\n                // If we couldn't grab any settings, create them from the default ones and combine them with the options passed\n                // The settings are generated for the first time\n                // This also attempt to grab the HTML5 data. If it doesn't exist, we'll get \"undefined\"\n                var tagData = $this.data();\n                settings = $.extend({}, defaultSettings, tagData, options, {\n                    hasFocus: false,\n                    runOnce: false,\n                    rawValue: '',\n                    trailingNegative: false,\n                    caretFix: false,\n                    androidSelectionStart: null,\n                    throwInput: true, // Throw input event\n                    strip: true,\n                    tagList: allowedTagList\n                });\n            }\n\n            // Modify the user settings to make them 'exploitable'\n            transformOptionsValuesToDefaultTypes(settings);\n\n            // Improve the `negativePositiveSignPlacement` option if needed\n            correctNegativePositiveSignPlacementOption(settings);\n\n            // Set the negative and positive signs, as needed\n            settings.negativeSignCharacter = settings.minimumValue < 0 ? '-' : '';\n            settings.positiveSignCharacter = settings.maximumValue >= 0 ? '+' : '';\n\n            // Additional changes to the settings object (from the original autoCode() function)\n            runCallbacksFoundInTheSettingsObject($this, settings);\n            calculateVMinAndVMaxIntegerSizes(settings);\n            correctDecimalPlacesOverrideOption(settings);\n            setsAlternativeDecimalSeparatorCharacter(settings);\n            cachesUsualRegularExpressions(settings);\n\n            // Validate the settings\n            validate(settings, false); // Throws if necessary\n\n            // Original settings saved for use when decimalPlacesShownOnFocus, scaleDivisor & noSeparatorOnFocus options are being used\n            keepAnOriginalSettingsCopy(settings);\n\n            // Save our new settings\n            $this.data('autoNumeric', settings);\n\n            return settings;\n        } else {\n            return null;\n        }\n    }\n\n    /**\n     * Convert the `value` parameter that can either be :\n     * - a real number,\n     * - a string representing a real number, or\n     * - a string representing a localized number (with specific group separators and decimal character),\n     * ...to a string representing a real 'javascript' number (ie. '1234' or '1234.567').\n     *\n     * This function returns `NaN` if such conversion fails.\n     *\n     * @param {int|float|string} value\n     * @param {object} settings\n     * @returns {string|NaN}\n     */\n    function toNumericValue(value, settings) {\n        var result = void 0;\n        if (isNumber(Number(value))) {\n            // The value has either already been stripped, or a 'real' javascript number is passed as a parameter\n            result = value;\n        } else {\n            // Else if it's a string that `Number()` cannot typecast, then we try to convert the localized numeric string to a numeric one\n            // Convert the value to a numeric string, stripping unnecessary characters in the process\n            result = convertToNumericString(value.toString(), settings);\n\n            // If the result is still not a numeric string, then we throw a warning\n            if (!isNumber(Number(result))) {\n                warning('The value \"' + value + '\" being \"set\" is not numeric and therefore cannot be used appropriately.', settings.showWarnings);\n                result = NaN;\n            }\n        }\n\n        return result;\n    }\n\n    /**\n     * Methods supported by autoNumeric\n     */\n    var methods = {\n        /**\n         * Method to initialize autoNumeric and attach the settings (options can be passed as a parameter)\n         * The options passed as a parameter is an object that contains the settings (ie. {digitGroupSeparator: \".\", decimalCharacter: \",\", currencySymbol: '€ '})\n         *\n         * @example\n         * $(someSelector).autoNumeric('init');            // Initiate autoNumeric with defaults\n         * $(someSelector).autoNumeric();                  // Initiate autoNumeric with defaults\n         * $(someSelector).autoNumeric('init', {options}); // Initiate autoNumeric with options\n         * $(someSelector).autoNumeric({options});         // Initiate autoNumeric with options\n         *\n         * @param {object} options\n         * @returns {*|{statements, branches, lines, functions, excludes, overrides}|{statements, branches, lines, functions, excludes}|{statements, lines, branches, functions, excludes}}\n         */\n        init: function init(options) {\n            return this.each(function () {\n                var $this = $(this);\n                var $input = getInputIfSupportedTagAndType($this);\n\n                var settings = getInitialSettings(options, $this, false);\n                if (isNull(settings)) {\n                    return this;\n                }\n\n                // Create the AutoNumericHolder object that store the field properties\n                var holder = getAutoNumericHolder($this, settings, false);\n\n                if (!settings.runOnce && settings.formatOnPageLoad) {\n                    formatDefaultValueOnPageLoad(settings, $input, $this);\n                }\n\n                settings.runOnce = true;\n\n                // Add the events listeners to supported input types (\"text\", \"hidden\", \"tel\" and no type)\n                if ($input) {\n                    this.addEventListener('focusin', function (e) {\n                        onFocusInAndMouseEnter($this, holder, e);\n                    }, false);\n                    this.addEventListener('mouseenter', function (e) {\n                        onFocusInAndMouseEnter($this, holder, e);\n                    }, false);\n                    this.addEventListener('blur', function (e) {\n                        onFocusOutAndMouseLeave($this, holder, e);\n                    }, false);\n                    this.addEventListener('mouseleave', function (e) {\n                        onFocusOutAndMouseLeave($this, holder, e);\n                    }, false);\n                    this.addEventListener('keydown', function (e) {\n                        onKeydown(holder, e);\n                    }, false);\n                    this.addEventListener('keypress', function (e) {\n                        onKeypress(holder, e);\n                    }, false);\n                    this.addEventListener('input', function (e) {\n                        onInput(holder, e);\n                    }, false);\n                    this.addEventListener('keyup', function (e) {\n                        onKeyup(holder, settings, e);\n                    }, false);\n                    this.addEventListener('blur', function (e) {\n                        onBlur(holder, e);\n                    }, false);\n                    this.addEventListener('paste', function (e) {\n                        onPaste($this, holder, e);\n                    }, false);\n                    onSubmit($this, holder); //TODO Switch to `addEventListener'\n                }\n            });\n        },\n\n\n        /**\n         * Method to stop and remove autoNumeric for the current element.\n         * Note: this does not remove the formatting.\n         *\n         * @example $(someSelector).autoNumeric(\"destroy\"); // Destroys autoNumeric on this selected element\n         *\n         * @returns {*|jQuery}\n         */\n        destroy: function destroy() {\n            return $(this).each(function () {\n                var $this = getCurrentElement(this);\n                var settings = $this.data('autoNumeric');\n                if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) === 'object') {\n                    $this.val('');\n                    saveValueToPersistentStorage($this[0], settings, 'wipe');\n                    $this.removeData('autoNumeric');\n                    $this.off('.autoNumeric');\n                }\n            });\n        },\n\n\n        /**\n         * Method to clear the value from sessionStorage (or cookie, depending on browser supports).\n         *\n         * @example $(someSelector).autoNumeric(\"wipe\"); // Removes session storage and cookies from memory\n         *\n         * @returns {*|jQuery}\n         */\n        wipe: function wipe() {\n            return $(this).each(function () {\n                var $this = getCurrentElement(this);\n                var settings = $this.data('autoNumeric');\n                if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) === 'object') {\n                    $this.val('');\n                    settings.rawValue = '';\n                    saveValueToPersistentStorage($this[0], settings, 'wipe');\n                }\n            });\n        },\n\n\n        /**\n         * Method that updates the autoNumeric settings.\n         * It can be called multiple times if needed.\n         * The options passed as a parameter is an object that contains the settings (ie. {digitGroupSeparator: \".\", decimalCharacter: \",\", currencySymbol: '€ '}).\n         *\n         * @example $(someSelector).autoNumeric(\"update\", {options}); // Updates the settings\n         *\n         * @param {object} options\n         * @returns {*|jQuery}\n         */\n        update: function update(options) {\n            return $(this).each(function () {\n                // Retrieve the current unformatted input value\n                var $this = getCurrentElement(this);\n                var strip = $this.autoNumeric('get');\n\n                // Update the settings\n                var settings = getInitialSettings(options, $this, true);\n\n                // Update the AutoNumericHolder object that store the field properties\n                getAutoNumericHolder($this, settings, true);\n\n                // Reformat the input value with the new settings\n                if ($this.val() !== '' || $this.text() !== '') {\n                    return $this.autoNumeric('set', strip);\n                }\n            });\n        },\n\n\n        /**\n         * Method to format the value passed as a parameter.\n         * If the value is passed as a string, it can be an integer '1234' or a double '1234.56789'\n         * and must contain only numbers and one decimal (period) character\n         *\n         * @example $(someSelector).autoNumeric('set', '12345.67'); // Formats the value being passed as the second parameter\n         *\n         * @param {*} newValue\n         * @returns {*|jQuery}\n         */\n        set: function set(newValue) {\n            return $(this).each(function () {\n                if (newValue === null || isUndefined(newValue)) {\n                    return;\n                }\n\n                //TODO This looks a lot like `getInputIfSupportedTagAndType()`. Is that necessary? Can the input element be changed since autoNumeric has been initialized?\n                var $this = getCurrentElement(this);\n                var settings = $this.data('autoNumeric');\n                if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) !== 'object') {\n                    throwError('Initializing autoNumeric is required prior to calling the \"set\" method.');\n                }\n                // Reset the trailing negative settings, since it's possible the previous value was negative, but not the newly set one\n                settings.trailingNegative = false;\n\n                var $input = $this.is('input[type=text], input[type=hidden], input[type=tel], input:not([type])');\n\n                var value = toNumericValue(newValue, settings);\n                if (isNaN(value)) {\n                    return $this.val('');\n                }\n\n                if (value !== '') {\n                    var _checkIfInRangeWithOv5 = checkIfInRangeWithOverrideOption(value, settings),\n                        _checkIfInRangeWithOv6 = _slicedToArray(_checkIfInRangeWithOv5, 2),\n                        minTest = _checkIfInRangeWithOv6[0],\n                        maxTest = _checkIfInRangeWithOv6[1];\n                    // This test is needed by the showPositiveSign option\n\n\n                    var isZero = isZeroOrHasNoValue(value);\n                    if (isZero) {\n                        value = '0';\n                    }\n\n                    if (minTest && maxTest) {\n                        if ($input || isInArray($this.prop('tagName').toLowerCase(), settings.tagList)) {\n                            // to ensure rounding does not happen twice\n                            var hasBeenRounded = false;\n\n                            // rounds the the extended decimal places\n                            var tempDecimal = void 0;\n                            if (settings.decimalPlacesShownOnFocus) {\n                                tempDecimal = settings.decimalPlacesOverride;\n                                settings.decimalPlacesOverride = Number(settings.decimalPlacesShownOnFocus);\n                                value = roundValue(value, settings);\n                                hasBeenRounded = true;\n                                settings.decimalPlacesOverride = tempDecimal;\n                            }\n\n                            if (settings.scaleDivisor && !settings.onOff) {\n                                value = roundValue(value, settings);\n                                settings.rawValue = cleanLeadingTrailingZeros(value.replace(settings.decimalCharacter, '.'), settings);\n                                value = toNumericValue(value, settings);\n                                value = value / settings.scaleDivisor;\n                                value = value.toString();\n                                if (settings.scaleDecimalPlaces) {\n                                    tempDecimal = settings.decimalPlacesOverride;\n                                    settings.decimalPlacesOverride = Number(settings.scaleDecimalPlaces);\n                                    value = roundValue(value, settings);\n                                    hasBeenRounded = true;\n                                }\n                            }\n\n                            // Rounds if this has not been done already\n                            if (!hasBeenRounded) {\n                                value = roundValue(value, settings);\n                            }\n\n                            // Stores rawValue including the decimalPlacesShownOnFocus\n                            if (!settings.scaleDivisor) {\n                                settings.rawValue = cleanLeadingTrailingZeros(value.replace(settings.decimalCharacter, '.'), settings);\n                            }\n\n                            value = modifyNegativeSignAndDecimalCharacterForFormattedValue(value, settings);\n                            value = addGroupSeparators(value, settings);\n\n                            if (settings.scaleDivisor && settings.scaleDecimalPlaces && !settings.onOff) {\n                                settings.decimalPlacesOverride = tempDecimal;\n                            }\n                        }\n\n                        if (settings.saveValueToSessionStorage && (settings.decimalPlacesShownOnFocus || settings.scaleDivisor)) {\n                            saveValueToPersistentStorage($this[0], settings, 'set');\n                        }\n                    } else {\n                        settings.rawValue = '';\n                        saveValueToPersistentStorage($this[0], settings, 'wipe');\n                        var attemptedValue = value;\n                        value = '';\n                        if (!minTest) {\n                            $this.trigger('autoNumeric:minExceeded');\n                        }\n\n                        if (!maxTest) {\n                            $this.trigger('autoNumeric:maxExceeded');\n                        }\n\n                        throwError('The value [' + attemptedValue + '] being set falls outside of the minimumValue [' + settings.minimumValue + '] and maximumValue [' + settings.maximumValue + '] range set for this element');\n\n                        return $this.val('');\n                    }\n                } else {\n                    return $this.val('');\n                }\n\n                if (!settings.hasFocus && settings.scaleSymbol) {\n                    value = value + settings.scaleSymbol;\n                }\n\n                if ($input) {\n                    return $this.val(value);\n                }\n\n                if (isInArray($this.prop('tagName').toLowerCase(), settings.tagList)) {\n                    return $this.text(value);\n                }\n\n                return false;\n            });\n        },\n\n\n        /**\n         * Method to un-format inputs.\n         * This is handy to use right before form submission.\n         *\n         * By default, values are returned as ISO numeric strings (ie. \"1234.56\" or \"-1234.56\"), where the decimal character is a period.\n         * Locale formats are supported \"1234.56-\" or \"1234,56\" or \"-1234,56 or \"1234,56-\", or even plain numbers.\n         * Please see option \"outputFormat\" for more details\n         *\n         * @example $(someSelector).autoNumeric('unSet');\n         *\n         * @returns {*|jQuery}\n         */\n        unSet: function unSet() {\n            return $(this).each(function () {\n                var $this = getCurrentElement(this);\n                var settings = $this.data('autoNumeric');\n                if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) === 'object') {\n                    settings.hasFocus = true;\n                    $this.val($this.autoNumeric('getLocalized'));\n                }\n            });\n        },\n\n\n        /**\n         * Method to re-format inputs.\n         * This is handy to use right after form submission.\n         *\n         * This is called after the 'unSet' method to reformat the input\n         *\n         * @example $(someSelector).autoNumeric('reSet');\n         *\n         * @returns {*|jQuery}\n         */\n        reSet: function reSet() {\n            return $(this).each(function () {\n                var $this = getCurrentElement(this);\n                var settings = $this.data('autoNumeric');\n                if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) === 'object') {\n                    $this.autoNumeric('set', $this.val());\n                }\n            });\n        },\n\n\n        /**\n         * Return the unformatted value as a string.\n         *\n         * @usage $(someSelector).autoNumeric('get');\n         *\n         * @returns {string}\n         */\n        get: function get() {\n            //TODO Why would we need to get a new reference to $this since it has been done in `init()`?\n            var $this = getCurrentElement(this);\n            //TODO This looks a lot like `getInputIfSupportedTagAndType()`. Is that necessary? Can the input element be changed since autoNumeric has been initialized?\n            var $input = $this.is('input[type=text], input[type=hidden], input[type=tel], input:not([type])');\n            var settings = $this.data('autoNumeric');\n            if ((typeof settings === 'undefined' ? 'undefined' : _typeof(settings)) !== 'object') {\n                throwError('Initializing autoNumeric is required prior to calling the \"get\" method.');\n            }\n\n            // determine the element type then use .eq(0) selector to grab the value of the first element in selector\n            var value = '';\n            if ($input) {\n                value = $this.eq(0).val();\n            } else if (isInArray($this.prop('tagName').toLowerCase(), settings.tagList)) {\n                value = $this.eq(0).text();\n            } else {\n                throwError('The \"<' + $this.prop('tagName').toLowerCase() + '>\" tag is not supported by autoNumeric');\n            }\n\n            if (settings.decimalPlacesShownOnFocus || settings.scaleDivisor) {\n                value = settings.rawValue;\n            } else {\n                // Test if the value is negative\n                var isValueNegative = isNegative(value);\n\n                if (!/\\d/.test(value) && settings.emptyInputBehavior === 'focus') {\n                    return '';\n                }\n\n                if (value !== '' && settings.negativeBracketsTypeOnBlur !== null) {\n                    settings.hasFocus = true;\n                    value = toggleNegativeBracket(value, settings);\n                }\n\n                if (settings.runOnce || settings.formatOnPageLoad === false) {\n                    // Strips trailing negative symbol\n                    value = stripAllNonNumberCharacters(value, settings, true);\n                    // Trims leading and trailing zeros when leadingZero does NOT equal \"keep\".\n                    value = cleanLeadingTrailingZeros(value.replace(settings.decimalCharacter, '.'), settings);\n\n                    // Places the negative symbol in front of the trailing negative\n                    if (settings.trailingNegative && isValueNegative && !isNegative(value) && Number(value) !== 0) {\n                        value = '-' + value;\n                    }\n                }\n\n                if (value !== '' || value === '' && settings.emptyInputBehavior === 'zero') {\n                    value = modifyNegativeSignAndDecimalCharacterForRawValue(value, settings);\n                }\n            }\n\n            // Always return a numeric string\n            // This gets rid of the trailing zeros in the decimal places since `get` does not pad decimals\n            return trimPaddedZerosFromDecimalPlaces(value);\n        },\n\n\n        /**\n         * Returns the unformatted value, but following the `outputFormat` setting, which means the output can either be :\n         * - a string (that could or could not represent a number (ie. \"12345,67-\")), or\n         * - a plain number (if the setting 'number' is used).\n         *\n         * By default the returned values are an ISO numeric string \"1234.56\" or \"-1234.56\" where the decimal character is a period.\n         * Check the \"outputFormat\" option definition for more details.\n         *\n         * @usage $(someSelector).autoNumeric('getLocalized');\n         *\n         * @returns {*}\n         */\n        getLocalized: function getLocalized() {\n            var $this = getCurrentElement(this);\n            var value = $this.autoNumeric('get');\n            var settings = $this.data('autoNumeric');\n\n            if (Number(value) === 0 && settings.leadingZero !== 'keep') {\n                value = '0';\n            }\n\n            return toLocale(value, settings.outputFormat);\n        },\n\n\n        /**\n         * Return the input unformatted value as a real Javascript number.\n         *\n         * @usage $(someSelector).autoNumeric('getNumber');\n         *\n         * @returns {number}\n         */\n        getNumber: function getNumber() {\n            var $this = getCurrentElement(this);\n            var value = $this.autoNumeric('get');\n\n            return toLocale(value, 'number');\n        },\n\n\n        /**\n         * Return the current formatted value of the autoNumeric element.\n         * @usage aNInput.autoNumeric('getFormatted'))\n         *\n         * @returns {string}\n         */\n        getFormatted: function getFormatted() {\n            // Make sure `this[0]` exists as well as `.value` before trying to access that property\n            if (!this.hasOwnProperty('0') || !('value' in this[0])) {\n                throwError('Unable to get the formatted string from the element.');\n            }\n\n            return this[0].value;\n        },\n\n\n        /**\n         * The \"getString\" method uses jQuery's .serialize() method that creates a text string in standard URL-encoded notation.\n         *\n         * It then loops through the string and un-formats the inputs with autoNumeric.\n         * By defaults values returned as ISO numeric string \"1234.56\" or \"-1234.56\" where the decimal character is a period\n         * Locale formats are supported \"1234.56-\" or \"1234,56\" or \"-1234,56 or \"1234,56-\" or plain numbers => please see option \"outputFormat\" for details\n         *\n         * @returns {string}\n         */\n        getString: function getString() {\n            return _getStringOrArray(false, this);\n        },\n\n\n        /**\n         * The \"getArray\" method on the other hand uses jQuery's .serializeArray() method that creates array or objects that can be encoded as a JSON string.\n         *\n         * It then loops through the string and un-formats the inputs with autoNumeric.\n         * By defaults values returned as ISO numeric string \"1234.56\" or \"-1234.56\" where the decimal character is a period\n         * Locale formats are supported \"1234.56-\" or \"1234,56\" or \"-1234,56 or \"1234,56-\" or plain numbers => please see option \"outputFormat\" for details\n         *\n         * @returns {{}|[]}\n         */\n        getArray: function getArray() {\n            return _getStringOrArray(true, this);\n        },\n\n\n        /**\n         * The 'getSettings' function returns an object containing all the current autoNumeric settings.\n         *\n         * @example\n         * $(someSelector).autoNumeric('getSettings');\n         * $(someSelector).autoNumeric('getSettings').decimalCharacter; // Return the decimalCharacter setting as a string - any valid option name can be used\n         *\n         * @returns {object}\n         */\n        getSettings: function getSettings() {\n            //TODO Add an option argument `optionName` to this function so that it return only the value of that option, not the entire settings object\n            return this.data('autoNumeric');\n        }\n    };\n\n    /**\n     * The autoNumeric function accepts methods names (in string format) and those method parameters if needed.\n     * It initialize autoNumeric on the given element.\n     *\n     * @param {string} method The method name (ie. 'set', 'get', etc.)\n     * @param {*} args\n     * @returns {*}\n     */\n    $.fn.autoNumeric = function (method) {\n        if (methods[method]) {\n            for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n                args[_key - 1] = arguments[_key];\n            }\n\n            return methods[method].apply(this, args);\n        }\n\n        if ((typeof method === 'undefined' ? 'undefined' : _typeof(method)) === 'object' || !method) {\n            // The options have been passed directly, without using a named method\n            return methods.init.apply(this, [method]);\n        }\n\n        throwError('Method \"' + method + '\" is not supported by autoNumeric');\n    };\n\n    /**\n     * Return the default autoNumeric settings.\n     *\n     * @returns {object}\n     */\n    getDefaultConfig = function getDefaultConfig() {\n        return defaultSettings;\n    };\n\n    $.fn.autoNumeric.defaults = defaultSettings; // Make those settings public via jQuery too.\n\n    /**\n     * Return all the predefined language options in one object.\n     * You can also access a specific language object directly by using `an.getLanguages().French` for instance.\n     *\n     * @returns {object}\n     */\n    getLanguages = function getLanguages() {\n        return languageOption;\n    };\n\n    $.fn.autoNumeric.lang = languageOption; // Make those predefined language options public via jQuery too.\n\n    /**\n     * Public function that allows formatting without an element trigger.\n     *\n     * @param {number|string} value A number, or a string that represent a javascript number\n     * @param {object|null} options\n     * @returns {*}\n     */\n    autoFormat = function autoFormat(value) {\n        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n\n        if (isUndefined(value) || value === null) {\n            return null;\n        }\n\n        if (!isString(value) && !isNumber(value)) {\n            throwError('The value \"' + value + '\" being \"set\" is not numeric and therefore cannot be used appropriately.');\n        }\n\n        // Initiate a very basic settings object\n        var settings = $.extend({}, defaultSettings, { strip: false }, options);\n        if (value < 0) {\n            settings.negativeSignCharacter = '-';\n        }\n\n        if (isNull(settings.decimalPlacesOverride)) {\n            settings.decimalPlacesOverride = maximumVMinAndVMaxDecimalLength(settings.minimumValue, settings.maximumValue);\n        }\n\n        // Check the validity of the `value` parameter\n        // Convert the value to a numeric string, stripping unnecessary characters in the process\n        var valueString = toNumericValue(value, settings);\n        if (isNaN(valueString)) {\n            throwError('The value [' + valueString + '] that you are trying to format is not a recognized number.');\n        }\n\n        // Basic tests to check if the given valueString is valid\n\n        var _checkIfInRangeWithOv7 = checkIfInRangeWithOverrideOption(valueString, settings),\n            _checkIfInRangeWithOv8 = _slicedToArray(_checkIfInRangeWithOv7, 2),\n            minTest = _checkIfInRangeWithOv8[0],\n            maxTest = _checkIfInRangeWithOv8[1];\n\n        if (!minTest || !maxTest) {\n            // Throw a custom event\n            triggerEvent('autoFormat.autoNumeric', document, 'Range test failed');\n            throwError('The value [' + valueString + '] being set falls outside of the minimumValue [' + settings.minimumValue + '] and maximumValue [' + settings.maximumValue + '] range set for this element');\n        }\n\n        // Everything is ok, proceed to rounding, formatting and grouping\n        valueString = roundValue(valueString, settings);\n        valueString = modifyNegativeSignAndDecimalCharacterForFormattedValue(valueString, settings);\n        valueString = addGroupSeparators(valueString, settings);\n\n        return valueString;\n    };\n\n    $.fn.autoFormat = autoFormat; // The jQuery export\n\n    /**\n     * Public function that allows unformatting without an element.\n     *\n     * @param {string|number} value\n     * @param {object} options\n     * @returns {*}\n     */\n    autoUnFormat = function autoUnFormat(value, options) {\n        if (isUndefined(value) || value === null) {\n            return null;\n        }\n\n        // Giving an unformatted value should return the same unformatted value, whatever the options passed as a parameter\n        if (isNumber(value)) {\n            return Number(value);\n        }\n\n        if (isArray(value) || isObject(value)) {\n            //TODO Complete the test to throw when given a wrongly formatted number (ie. 'foobar')\n            // Check the validity of the `value` parameter\n            throwError('A number or a string representing a number is needed to be able to unformat it, [' + value + '] given.');\n        }\n\n        var settings = $.extend({}, defaultSettings, { strip: false }, options);\n        var allowed = '-0123456789\\\\' + settings.decimalCharacter;\n        var autoStrip = new RegExp('[^' + allowed + ']', 'gi');\n        value = value.toString();\n\n        // This checks is a negative sign is anywhere in the `value`, not just on the very first character (ie. '12345.67-')\n        if (isNegative(value)) {\n            settings.negativeSignCharacter = '-';\n        } else if (settings.negativeBracketsTypeOnBlur && settings.negativeBracketsTypeOnBlur.split(',')[0] === value.charAt(0)) {\n            settings.negativeSignCharacter = '-';\n            settings.hasFocus = true;\n            value = toggleNegativeBracket(value, settings);\n        }\n\n        value = value.replace(autoStrip, '');\n        value = value.replace(settings.decimalCharacter, '.');\n        value = toLocale(value, settings.outputFormat);\n\n        return value;\n    };\n\n    $.fn.autoUnformat = autoUnFormat; // The jQuery export\n\n    /**\n     * Validate the given option object.\n     * If the options are valid, this function returns nothing, otherwise if the options are invalid, this function throws an error.\n     *\n     * This tests if the options are not conflicting and are well formatted.\n     * This function is lenient since it only tests the settings properties ; it ignores any other properties the options object could have.\n     *\n     * @param {*} userOptions\n     * @param {Boolean} shouldExtendDefaultOptions If TRUE, then this function will extends the `userOptions` passed by the user, with the default options.\n     * @throws Error\n     */\n    validate = function validate(userOptions) {\n        var shouldExtendDefaultOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;\n\n        if (isUndefinedOrNullOrEmpty(userOptions) || !isObject(userOptions) || isEmptyObj(userOptions)) {\n            throwError('The userOptions are invalid ; it should be a valid object, [' + userOptions + '] given.');\n        }\n\n        // If the user used old options, we convert them to new ones\n        if (!isNull(userOptions)) {\n            convertOldOptionsToNewOnes(userOptions);\n        }\n\n        // The user can choose if the `userOptions` has already been extended with the default options, or not\n        var options = void 0;\n        if (shouldExtendDefaultOptions) {\n            options = $.extend({}, defaultSettings, userOptions);\n        } else {\n            options = userOptions;\n        }\n\n        // First things first, we test that the `showWarnings` option is valid\n        if (!isTrueOrFalseString(options.showWarnings) && !isBoolean(options.showWarnings)) {\n            throwError('The debug option \\'showWarnings\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.showWarnings + '] given.');\n        }\n\n        // Define the regular expressions needed for the following tests\n        var testPositiveInteger = /^[0-9]+$/;\n        var testNumericalCharacters = /[0-9]+/;\n        // const testFloatAndPossibleNegativeSign = /^-?[0-9]+(\\.?[0-9]+)$/;\n        var testFloatOrIntegerAndPossibleNegativeSign = /^-?[0-9]+(\\.?[0-9]+)?$/;\n        var testPositiveFloatOrInteger = /^[0-9]+(\\.?[0-9]+)?$/;\n\n        // Then tests the options individually\n        if (!isInArray(options.digitGroupSeparator, [',', // Comma\n        '.', // Dot\n        ' ', // Normal space\n        '\\u2009', // Thin-space\n        '\\u202F', // Narrow no-break space\n        '\\xA0', // No-break space\n        '', // No separator\n        \"'\", // Apostrophe\n        '٬', // Arabic thousands separator\n        '˙'])) {\n            throwError('The thousand separator character option \\'digitGroupSeparator\\' is invalid ; it should be \\',\\', \\'.\\', \\'\\u066C\\', \\'\\u02D9\\', \"\\'\", \\' \\', \\'\\u2009\\', \\'\\u202F\\', \\'\\xA0\\' or empty (\\'\\'), [' + options.digitGroupSeparator + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.noSeparatorOnFocus) && !isBoolean(options.noSeparatorOnFocus)) {\n            throwError('The \\'noSeparatorOnFocus\\' option is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.noSeparatorOnFocus + '] given.');\n        }\n\n        if (!testPositiveInteger.test(options.digitalGroupSpacing)) {\n            throwError('The digital grouping for thousand separator option \\'digitalGroupSpacing\\' is invalid ; it should be a positive integer, [' + options.digitalGroupSpacing + '] given.');\n        }\n\n        if (!isInArray(options.decimalCharacter, [',', // Comma\n        '.', // Dot\n        '·', // Middle-dot\n        '٫', // Arabic decimal separator\n        '⎖'])) {\n            throwError('The decimal separator character option \\'decimalCharacter\\' is invalid ; it should be \\'.\\', \\',\\', \\'\\xB7\\', \\'\\u2396\\' or \\'\\u066B\\', [' + options.decimalCharacter + '] given.');\n        }\n\n        // Checks if the decimal and thousand characters are the same\n        if (options.decimalCharacter === options.digitGroupSeparator) {\n            throwError('autoNumeric will not function properly when the decimal character \\'decimalCharacter\\' [' + options.decimalCharacter + '] and the thousand separator \\'digitGroupSeparator\\' [' + options.digitGroupSeparator + '] are the same character.');\n        }\n\n        if (!isNull(options.decimalCharacterAlternative) && !isString(options.decimalCharacterAlternative)) {\n            throwError('The alternate decimal separator character option \\'decimalCharacterAlternative\\' is invalid ; it should be a string, [' + options.decimalCharacterAlternative + '] given.');\n        }\n\n        if (options.currencySymbol !== '' && !isString(options.currencySymbol)) {\n            throwError('The currency symbol option \\'currencySymbol\\' is invalid ; it should be a string, [' + options.currencySymbol + '] given.');\n        }\n\n        if (!isInArray(options.currencySymbolPlacement, ['p', 's'])) {\n            throwError('The placement of the currency sign option \\'currencySymbolPlacement\\' is invalid ; it should either be \\'p\\' (prefix) or \\'s\\' (suffix), [' + options.currencySymbolPlacement + '] given.');\n        }\n\n        if (!isInArray(options.negativePositiveSignPlacement, ['p', 's', 'l', 'r', null])) {\n            throwError('The placement of the negative sign option \\'negativePositiveSignPlacement\\' is invalid ; it should either be \\'p\\' (prefix), \\'s\\' (suffix), \\'l\\' (left), \\'r\\' (right) or \\'null\\', [' + options.negativePositiveSignPlacement + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.showPositiveSign) && !isBoolean(options.showPositiveSign)) {\n            throwError('The show positive sign option \\'showPositiveSign\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.showPositiveSign + '] given.');\n        }\n\n        if (!isString(options.suffixText) || options.suffixText !== '' && (isNegative(options.suffixText) || testNumericalCharacters.test(options.suffixText))) {\n            throwError('The additional suffix option \\'suffixText\\' is invalid ; it should not contains the negative sign \\'-\\' nor any numerical characters, [' + options.suffixText + '] given.');\n        }\n\n        if (!isNull(options.overrideMinMaxLimits) && !isInArray(options.overrideMinMaxLimits, ['ceiling', 'floor', 'ignore'])) {\n            throwError('The override min & max limits option \\'overrideMinMaxLimits\\' is invalid ; it should either be \\'ceiling\\', \\'floor\\' or \\'ignore\\', [' + options.overrideMinMaxLimits + '] given.');\n        }\n\n        if (!isString(options.maximumValue) || !testFloatOrIntegerAndPossibleNegativeSign.test(options.maximumValue)) {\n            throwError('The maximum possible value option \\'maximumValue\\' is invalid ; it should be a string that represents a positive or negative number, [' + options.maximumValue + '] given.');\n        }\n\n        if (!isString(options.minimumValue) || !testFloatOrIntegerAndPossibleNegativeSign.test(options.minimumValue)) {\n            throwError('The minimum possible value option \\'minimumValue\\' is invalid ; it should be a string that represents a positive or negative number, [' + options.minimumValue + '] given.');\n        }\n\n        if (parseFloat(options.minimumValue) > parseFloat(options.maximumValue)) {\n            throwError('The minimum possible value option is greater than the maximum possible value option ; \\'minimumValue\\' [' + options.minimumValue + '] should be smaller than \\'maximumValue\\' [' + options.maximumValue + '].');\n        }\n\n        if (!(isNull(options.decimalPlacesOverride) || isInt(options.decimalPlacesOverride) && options.decimalPlacesOverride >= 0 || // If integer option\n        isString(options.decimalPlacesOverride) && testPositiveInteger.test(options.decimalPlacesOverride)) // If string option\n        ) {\n                throwError('The maximum number of decimal places option \\'decimalPlacesOverride\\' is invalid ; it should be a positive integer, [' + options.decimalPlacesOverride + '] given.');\n            }\n\n        // Write a warning message in the console if the number of decimal in minimumValue/maximumValue is overridden by decimalPlacesOverride (and not if decimalPlacesOverride is equal to the number of decimal used in minimumValue/maximumValue)\n        var vMinAndVMaxMaximumDecimalPlaces = maximumVMinAndVMaxDecimalLength(options.minimumValue, options.maximumValue);\n        if (!isNull(options.decimalPlacesOverride) && vMinAndVMaxMaximumDecimalPlaces !== Number(options.decimalPlacesOverride)) {\n            warning('Setting \\'decimalPlacesOverride\\' to [' + options.decimalPlacesOverride + '] will override the decimals declared in \\'minimumValue\\' [' + options.minimumValue + '] and \\'maximumValue\\' [' + options.maximumValue + '].', options.showWarnings);\n        }\n\n        if (!options.allowDecimalPadding && !isNull(options.decimalPlacesOverride)) {\n            warning('Setting \\'allowDecimalPadding\\' to [false] will override the current \\'decimalPlacesOverride\\' setting [' + options.decimalPlacesOverride + '].', options.showWarnings);\n        }\n\n        if (!isNull(options.decimalPlacesShownOnFocus) && (!isString(options.decimalPlacesShownOnFocus) || !testPositiveInteger.test(options.decimalPlacesShownOnFocus))) {\n            throwError('The number of expanded decimal places option \\'decimalPlacesShownOnFocus\\' is invalid ; it should be a positive integer, [' + options.decimalPlacesShownOnFocus + '] given.');\n        }\n\n        // Checks if the extended decimal places \"decimalPlacesShownOnFocus\" is greater than the normal decimal places \"decimalPlacesOverride\"\n        if (!isNull(options.decimalPlacesShownOnFocus) && !isNull(options.decimalPlacesOverride) && Number(options.decimalPlacesOverride) > Number(options.decimalPlacesShownOnFocus)) {\n            warning('The extended decimal places \\'decimalPlacesShownOnFocus\\' [' + options.decimalPlacesShownOnFocus + '] should be greater than the \\'decimalPlacesOverride\\' [' + options.decimalPlacesOverride + '] value. Currently, this will limit the ability of your client to manually change some of the decimal places. Do you really want to do that?', options.showWarnings);\n        }\n\n        if (!isNull(options.scaleDivisor) && !testPositiveFloatOrInteger.test(options.scaleDivisor)) {\n            throwError('The scale divisor option \\'scaleDivisor\\' is invalid ; it should be a positive number, preferably an integer, [' + options.scaleDivisor + '] given.');\n        }\n\n        if (!isNull(options.scaleDecimalPlaces) && !testPositiveInteger.test(options.scaleDecimalPlaces)) {\n            throwError('The scale number of decimals option \\'scaleDecimalPlaces\\' is invalid ; it should be a positive integer, [' + options.scaleDecimalPlaces + '] given.');\n        }\n\n        if (!isNull(options.scaleSymbol) && !isString(options.scaleSymbol)) {\n            throwError('The scale symbol option \\'scaleSymbol\\' is invalid ; it should be a string, [' + options.scaleSymbol + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.saveValueToSessionStorage) && !isBoolean(options.saveValueToSessionStorage)) {\n            throwError('The save to session storage option \\'saveValueToSessionStorage\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.saveValueToSessionStorage + '] given.');\n        }\n\n        if (!isInArray(options.onInvalidPaste, ['error', 'ignore', 'clamp', 'truncate', 'replace'])) {\n            throwError('The paste behavior option \\'onInvalidPaste\\' is invalid ; it should either be \\'error\\', \\'ignore\\', \\'clamp\\', \\'truncate\\' or \\'replace\\' (cf. documentation), [' + options.onInvalidPaste + '] given.');\n        }\n\n        if (!isInArray(options.roundingMethod, ['S', 'A', 's', 'a', 'B', 'U', 'D', 'C', 'F', 'N05', 'CHF', 'U05', 'D05'])) {\n            throwError('The rounding method option \\'roundingMethod\\' is invalid ; it should either be \\'S\\', \\'A\\', \\'s\\', \\'a\\', \\'B\\', \\'U\\', \\'D\\', \\'C\\', \\'F\\', \\'N05\\', \\'CHF\\', \\'U05\\' or \\'D05\\' (cf. documentation), [' + options.roundingMethod + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.allowDecimalPadding) && !isBoolean(options.allowDecimalPadding)) {\n            throwError('The control decimal padding option \\'allowDecimalPadding\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.allowDecimalPadding + '] given.');\n        }\n\n        if (!isNull(options.negativeBracketsTypeOnBlur) && !isInArray(options.negativeBracketsTypeOnBlur, ['(,)', '[,]', '<,>', '{,}'])) {\n            throwError('The brackets for negative values option \\'negativeBracketsTypeOnBlur\\' is invalid ; it should either be \\'(,)\\', \\'[,]\\', \\'<,>\\' or \\'{,}\\', [' + options.negativeBracketsTypeOnBlur + '] given.');\n        }\n\n        if (!isInArray(options.emptyInputBehavior, ['focus', 'press', 'always', 'zero'])) {\n            throwError('The display on empty string option \\'emptyInputBehavior\\' is invalid ; it should either be \\'focus\\', \\'press\\', \\'always\\' or \\'zero\\', [' + options.emptyInputBehavior + '] given.');\n        }\n\n        if (!isInArray(options.leadingZero, ['allow', 'deny', 'keep'])) {\n            throwError('The leading zero behavior option \\'leadingZero\\' is invalid ; it should either be \\'allow\\', \\'deny\\' or \\'keep\\', [' + options.leadingZero + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.formatOnPageLoad) && !isBoolean(options.formatOnPageLoad)) {\n            throwError('The format on initialization option \\'formatOnPageLoad\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.formatOnPageLoad + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.selectNumberOnly) && !isBoolean(options.selectNumberOnly)) {\n            throwError('The select number only option \\'selectNumberOnly\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.selectNumberOnly + '] given.');\n        }\n\n        if (!isNull(options.defaultValueOverride) && options.defaultValueOverride !== '' && !testFloatOrIntegerAndPossibleNegativeSign.test(options.defaultValueOverride)) {\n            throwError('The unformatted default value option \\'defaultValueOverride\\' is invalid ; it should be a string that represents a positive or negative number, [' + options.defaultValueOverride + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.unformatOnSubmit) && !isBoolean(options.unformatOnSubmit)) {\n            throwError('The remove formatting on submit option \\'unformatOnSubmit\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.unformatOnSubmit + '] given.');\n        }\n\n        if (!isNull(options.outputFormat) && !isInArray(options.outputFormat, ['string', 'number', '.', '-.', ',', '-,', '.-', ',-'])) {\n            throwError('The custom locale format option \\'outputFormat\\' is invalid ; it should either be null, \\'string\\', \\'number\\', \\'.\\', \\'-.\\', \\',\\', \\'-,\\', \\'.-\\' or \\',-\\', [' + options.outputFormat + '] given.');\n        }\n\n        if (!isTrueOrFalseString(options.failOnUnknownOption) && !isBoolean(options.failOnUnknownOption)) {\n            throwError('The debug option \\'failOnUnknownOption\\' is invalid ; it should be either \\'false\\' or \\'true\\', [' + options.failOnUnknownOption + '] given.');\n        }\n    };\n\n    $.fn.autoValidate = validate;\n\n    /**\n     * Return TRUE is the settings/options are valid, FALSE otherwise.\n     *\n     * @param {object} options\n     * @returns {boolean}\n     */\n    areSettingsValid = function areSettingsValid(options) {\n        var isValid = true;\n        try {\n            validate(options);\n        } catch (error) {\n            isValid = false;\n        }\n\n        return isValid;\n    };\n\n    /**\n     * Take an arabic number as a string and return a javascript number.\n     * By default, this function does not try to convert the arabic decimal and thousand separator characters.\n     * This returns `NaN` is the conversion is not possible.\n     * Based on http://stackoverflow.com/a/17025392/2834898\n     *\n     * @param {string} arabicNumbers\n     * @param {boolean} returnANumber If `true`, return a Number, otherwise return a String\n     * @param {boolean} parseDecimalCharacter\n     * @param {boolean} parseThousandSeparator\n     * @returns {string|number|NaN}\n     */\n    function arabicToLatinNumbers(arabicNumbers) {\n        var returnANumber = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;\n        var parseDecimalCharacter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n        var parseThousandSeparator = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;\n\n        var result = arabicNumbers.toString();\n        if (result === '' || result.match(/[٠١٢٣٤٥٦٧٨٩۴۵۶]/g) === null) {\n            // If no Arabic/Persian numbers are found, return the numeric string directly\n            return arabicNumbers;\n        }\n\n        if (parseDecimalCharacter) {\n            result = result.replace(/٫/, '.'); // Decimal character\n        }\n\n        if (parseThousandSeparator) {\n            result = result.replace(/٬/g, ''); // Thousand separator\n        }\n\n        // Replace the numbers only\n        result = result.replace(/[٠١٢٣٤٥٦٧٨٩]/g, function (d) {\n            return d.charCodeAt(0) - 1632;\n        }) // Arabic numbers\n        .replace(/[۰۱۲۳۴۵۶۷۸۹]/g, function (d) {\n            return d.charCodeAt(0) - 1776;\n        }); // Persian numbers\n\n        // `NaN` has precedence over the string `'NaN'`\n        var resultAsNumber = Number(result);\n        if (isNaN(resultAsNumber)) {\n            return resultAsNumber;\n        }\n\n        if (returnANumber) {\n            result = resultAsNumber;\n        }\n\n        return result;\n    }\n\n    /**\n     * Create a custom event and immediately sent it from the given element.\n     * By default, if no element is given, the event is thrown from `document`.\n     *\n     * @param {string} eventName\n     * @param {Element} element\n     * @param {object} detail\n     */\n    function triggerEvent(eventName) {\n        var element = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document;\n        var detail = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;\n\n        var event = void 0;\n        if (window.CustomEvent) {\n            event = new CustomEvent(eventName, { detail: detail, bubbles: false, cancelable: false }); // This is not supported by default by IE ; We use the polyfill for IE9 and later.\n        } else {\n            event = document.createEvent('CustomEvent');\n            event.initCustomEvent(eventName, true, true, { detail: detail });\n        }\n\n        element.dispatchEvent(event);\n    }\n\n    /**\n     * Polyfill from https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent/CustomEvent for obsolete browsers (IE)\n     */\n    (function () {\n        if (typeof window.CustomEvent === 'function') {\n            return false;\n        }\n\n        function CustomEvent(event, params) {\n            params = params || { bubbles: false, cancelable: false, detail: void 0 };\n            var evt = document.createEvent('CustomEvent');\n            evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail);\n            return evt;\n        }\n\n        CustomEvent.prototype = window.Event.prototype;\n        window.CustomEvent = CustomEvent;\n    })();\n});\n\n/**\n * This exports the interface for the autoNumeric object\n */\nexports.default = {\n    format: autoFormat,\n    unFormat: autoUnFormat,\n    getDefaultConfig: getDefaultConfig,\n    getLanguages: getLanguages,\n    validate: validate, // an.validate(options) : throws if necessary\n    areSettingsValid: areSettingsValid };\n}.call(window));//# sourceMappingURL=data:application/json;charset=utf-8;base64,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");

/***/ },
/* 1 */
/***/ function(module, exports) {

	eval("module.exports = __WEBPACK_EXTERNAL_MODULE_1__;//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwge1wicm9vdFwiOlwialF1ZXJ5XCIsXCJjb21tb25qc1wiOlwianF1ZXJ5XCIsXCJjb21tb25qczJcIjpcImpxdWVyeVwiLFwiYW1kXCI6XCJqcXVlcnlcIn0/NWNiYyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSIsImZpbGUiOiIxLmpzIiwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSBfX1dFQlBBQ0tfRVhURVJOQUxfTU9EVUxFXzFfXztcblxuXG4vLy8vLy8vLy8vLy8vLy8vLy9cbi8vIFdFQlBBQ0sgRk9PVEVSXG4vLyBleHRlcm5hbCB7XCJyb290XCI6XCJqUXVlcnlcIixcImNvbW1vbmpzXCI6XCJqcXVlcnlcIixcImNvbW1vbmpzMlwiOlwianF1ZXJ5XCIsXCJhbWRcIjpcImpxdWVyeVwifVxuLy8gbW9kdWxlIGlkID0gMVxuLy8gbW9kdWxlIGNodW5rcyA9IDAiXSwic291cmNlUm9vdCI6IiJ9");

/***/ }
/******/ ])
});
;