<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

$alarm_delete_day = 30; //알람 보관 일자
$table_name = "alarm"; //테이블명
$g5['g5_alarm_table'] = G5_TABLE_PREFIX.$table_name; //접두사를 붙힌 실제테이블

//보관일자 지난 알람 삭제하고 시작
if ($member['mb_id']) {
    //묻지도 따지지도 말고 삭제
    $que = "delete from {$g5['g5_alarm_table']} where to_mb_id = '{$member['mb_id']}' and al_input_date < date_add(now(), interval -".$alarm_delete_day." day)";
    sql_query($que);
}

if ($w == "r") {
    $re_wr_id = $wr_id;
}

add_event('write_update_after', 'insert_after_rewrite_alarm', G5_HOOK_DEFAULT_PRIORITY, 3);
add_event('comment_update_after','insert_after_comment_alarm', G5_HOOK_DEFAULT_PRIORITY, 6);
add_event('bbs_good_after','insert_after_good_alarm', G5_HOOK_DEFAULT_PRIORITY, 3);
add_event('memo_form_update_after','insert_after_memo_alarm', G5_HOOK_DEFAULT_PRIORITY, 2);

function insert_after_rewrite_alarm($board, $wr_id, $w) {

    global $g5, $re_wr_id;

    cheke_alarm_table();

    if ($w != 'r') {
        return;
    }

    $que = "select * from {$g5['write_prefix']}{$board['bo_table']} where wr_id = '{$wr_id}'";
    $ne_wr = sql_fetch($que);

    $que = "select * from {$g5['write_prefix']}{$board['bo_table']} where wr_id = '{$re_wr_id}'";
    $pa_wr = sql_fetch($que);

    if ($pa_wr['mb_id'] && $ne_wr['mb_id'] != $pa_wr['mb_id']) {
        $msg_subject = '['. conv_subject($pa_wr['wr_subject'],15,'…') . ']';
        $sql_insert = "insert into {$g5['g5_alarm_table']}
                        set 
                        to_mb_id = '{$pa_wr['mb_id']}',
                        from_mb_id = '{$ne_wr['mb_id']}',
                        from_mb_nick = '{$ne_wr['wr_name']}',
                        al_msg_type = 'r',
                        al_msg_table = '{$board['bo_table']}',
                        al_msg_id = '{$wr_id}',
                        al_msg_subject = '{$msg_subject}',
                        al_input_date = '".G5_TIME_YMDHIS."'";
        sql_query($sql_insert);
    }
}

function insert_after_comment_alarm($board, $wr_id, $w, $qstr, $redirect_url, $comment_id) {

    global $g5;

    cheke_alarm_table();

    if ($w != 'c') {
        return;
    }

    $que = "select * from {$g5['write_prefix']}{$board['bo_table']} where wr_id = '{$comment_id}'";
    $ne_wr = sql_fetch($que);

    $que = "select * from {$g5['write_prefix']}{$board['bo_table']} where wr_id = '{$wr_id}'";
    $pa_wr = sql_fetch($que);

    if ($pa_wr['mb_id'] && $ne_wr['mb_id'] != $pa_wr['mb_id']) {
        $msg_subject = '['. conv_subject($pa_wr['wr_subject'],15,'…') . ']';
        $sql_insert = "insert into {$g5['g5_alarm_table']}
                        set 
                        to_mb_id = '{$pa_wr['mb_id']}',
                        from_mb_id = '{$ne_wr['mb_id']}',
                        from_mb_nick = '{$ne_wr['wr_name']}',
                        al_msg_type = 'c',
                        al_msg_table = '{$board['bo_table']}',
                        al_msg_id = '{$comment_id}',
                        al_msg_subject = '{$msg_subject}',
                        al_input_date = '".G5_TIME_YMDHIS."'";
        sql_query($sql_insert);
    }
}

function insert_after_good_alarm($bo_table, $wr_id, $good) {

    global $g5, $member;

    cheke_alarm_table();

    $que = "select * from {$g5['write_prefix']}{$bo_table} where wr_id = '{$wr_id}'";
    $pa_wr = sql_fetch($que);

    if ($pa_wr['mb_id'] && $member['mb_id'] != $pa_wr['mb_id']) {
        if ($good == 'good') {
            $good_msg = '좋아요';
        } else {
            $good_msg = '싫어요';
        }
        $msg_subject = '['. conv_subject($pa_wr['wr_subject'],15,'…') . ']에 '. $good_msg ;
        $sql_insert = "insert into {$g5['g5_alarm_table']}
                        set 
                        to_mb_id = '{$pa_wr['mb_id']}',
                        from_mb_id = '{$member['mb_id']}',
                        from_mb_nick = '{$member['mb_nick']}',
                        al_msg_type = 'a',
                        al_msg_table = '{$bo_table}',
                        al_msg_id = '{$wr_id}',
                        al_msg_subject = '{$msg_subject}',
                        al_input_date = '".G5_TIME_YMDHIS."'";
        sql_query($sql_insert);
    }
}

function insert_after_memo_alarm($member_list, $str_nick_list) {

    global $g5, $member;

    cheke_alarm_table();

   for ($i=0; $i<count($member_list['id']); $i++) {

        $me_id_que = "select * from {$g5['memo_table']} where me_recv_mb_id = '{$member_list['id'][$i]}' and me_send_mb_id = '{$member['mb_id']}' and me_type = 'recv' order by me_send_datetime desc limit 1";
        $me_id_res = sql_fetch($me_id_que);
        $msg_subject = '';
        $sql_insert = "insert into {$g5['g5_alarm_table']}
                        set 
                        to_mb_id = '{$member_list['id'][$i]}',
                        from_mb_id = '{$member['mb_id']}',
                        from_mb_nick = '{$member['mb_nick']}',
                        al_msg_type = 'm',
                        al_msg_table = 'memo',
                        al_msg_id = '{$me_id_res['me_id']}',
                        al_msg_subject = '{$msg_subject}',
                        al_input_date = '".G5_TIME_YMDHIS."'";
        sql_query($sql_insert);
   }
}



function cheke_alarm_table() {
    
    global $g5;

    //알람테이블체크
    $que = "show tables like '{$g5['g5_alarm_table']}'";
    $res_table = sql_query($que);
    if ($res_table->num_rows === 0) {
        $create_table = "
            CREATE TABLE IF NOT EXISTS `{$g5['g5_alarm_table']}` (
                `al_id` int(11) NOT NULL auto_increment,
                `to_mb_id` varchar(20) NOT NULL default '',
                `from_mb_id` varchar(20) NOT NULL default '',
                `from_mb_nick` varchar(255) NOT NULL default '',
                `al_msg_type` set('c','r','m','a','s') NOT NULL default 'c',
                `al_msg_table` varchar(255) NOT NULL default '',
                `al_msg_id` int(11) NOT NULL,
                `al_msg_subject` varchar(255) NOT NULL default '',
                `al_link_url` varchar(255) NOT NULL default '',			
                `al_input_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                `al_read_date` datetime NOT NULL default '0000-00-00 00:00:00',
                `al_msg_check` set('n','y','d')  NOT NULL default 'n',
                PRIMARY KEY  (`al_id`),
                KEY `to_mb_id` (`to_mb_id`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;		
        ";
        sql_query($create_table) or die(sql_error_info());
    }
}
?>