<?php
include_once('./_common.php');

if (!$member['mb_id']) {
    alert('로그인 후 이용 할 수 있습니다.');
}

include_once(G5_THEME_PATH.'/head.php');

// sql_common
$sql_common = " from {$g5['g5_alarm_table']} ";
// sql_search
$sql_search = " where to_mb_id='{$member['mb_id']}' and al_msg_check in ('y','n') ";
if ($msgcheck) {
    $sql_search .= " and al_msg_check = '{$msgcheck}' ";
}
// sql_order
$sql_order = " order by al_id desc ";

// paging
$config['cf_page_rows'] = 15;
$config['cf_mobile_pages'] = $config['cf_write_pages'] = 10;
$sql = " select count(*) as cnt {$sql_common} {$sql_search} {$sql_order} ";
$row = sql_fetch($sql);
$total_count = intval($row['cnt']); // 전체 수
$rows = $_GET['pagenum'] ? $_GET['pagenum'] : $config['cf_page_rows']; // 페이지당 목록 수
$total_page  = ceil($total_count / $rows);  // 전체 페이지 계산
if ($page < 1) $page = 1; // 페이지가 없으면 첫 페이지 (1 페이지)
$from_record = ($page - 1) * $rows; // 시작 열을 구함

// query
$sql = " select * {$sql_common} {$sql_search} {$sql_order} limit {$from_record}, {$rows} ";
$result = sql_query($sql);
// etc
$colspan = 8; // 테이블 column 수
// query string 재정의
$qstr = 'msgcheck='.$msgcheck.'&amp;'.$qstr;

?>

<div class="alarm_list_head">
    <p class="alarm_list_title">총 <?php echo $total_count ?>건, 알림 보관 기간은 <?php echo $alarm_delete_day ?>일 입니다.</p>
    <form name="falarmlist" id="falarmlist" action="./alarm_list_update.php" onsubmit="return falarmlist_submit(this);" method="post">
    <input type="hidden" name="msgcheck" value="<?php echo $msgcheck ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="pressed" value="">
    <input type="hidden" name="token" value="">
    <ul class="list_head_btn">
        <li>
            <button type="button" class="alarm_btn select_all">전체선택</button>
            <button type="submit" name="btn_submit" value="선택삭제" class="alarm_btn select_delete" onclick="document.pressed=this.value">선택삭제</button>
            <button type="submit" name="btn_submit" value="읽음표시" class="alarm_btn select_read" onclick="document.pressed=this.value">읽음표시</button>
        </li>
        <li>
            <a href="./alarm_list.php" class="alarm_link abtn_list">전체보기</a>
            <a href="./alarm_list.php?msgcheck=y" class="alarm_link abtn_list">읽은알림</a>
            <a href="./alarm_list.php?msgcheck=n" class="alarm_link abtn_list">안읽음알림</a>
        </li>
    </ul>
</div>
<div class="alarm_list">
    <ul>
    <?php
    for ($i=0; $row=sql_fetch_array($result); $i++) {
        $link_url = get_pretty_url($row['al_msg_table'], $row['al_msg_id'],'#c_'.$row['al_msg_id']);
        if ($row['al_msg_type'] == 'm') { //쪽지
            $link_url = G5_BBS_URL.'/memo_view.php?me_id='.$row['al_msg_id'].'&kind=recv';
            $msg = '<span class="from_nick">'.$row['from_mb_nick'].'</span>님이 쪽지를 보내셨습니다.';
        } elseif ($row['al_msg_type'] == 'c') { //댓글
            $msg = '<span class="from_nick">'.$row['from_mb_nick'].'</span>님이 '.$row['al_msg_subject'].'에 댓글을 남기셨습니다.';
        } elseif ($row['al_msg_type'] == 'a') { //좋아요, 싫어요
            $msg = '<span class="from_nick">'.$row['from_mb_nick'].'</span>님이 '.$row['al_msg_subject'].'를 남기셨습니다.';
        } else { //답글
            $msg = '<span class="from_nick">'.$row['from_mb_nick'].'</span>님이 '.$row['al_msg_subject'].'에 답글을 남기셨습니다.';
        }
        if ($row['al_msg_check'] == 'n') {
            $msg_chk = '읽지않음';
        } else {
            $msg_chk = '읽음';
        }
        echo '<li id="alarm_'.$row['al_id'].'">';
            echo '<label for="al_chk_'.$i.'" class="al_label sound_only">번</label><span class="al_chkbox"><input type="checkbox" name="al_chk_id[]" value="'.$row['al_id'].'" id="al_chk_'.$i.'"></span>';
            echo '<span class="al_check">'.$msg_chk.'</span>';
            echo '<span class="al_date">'.substr($row['al_input_date'],0,10).'</span>';
            echo '<span class="al_subject" data-href="'.$link_url.'" data-msgtype="'.$row['al_msg_type'].'" data-alid="'.$row['al_id'].'">'.$msg.'</span>';
            echo '<span class="al_delete" data-alid="'.$row['al_id'].'">삭제</span>';
        echo '</li>';
    }
    ?>
    </ul>
</div>
<div class="alarm_list_footer">
    <ul class="list_footer_btn">
        <li>
            <button type="button" class="alarm_btn select_all">전체선택</button>
            <button type="submit" name="btn_submit" value="선택삭제" class="alarm_btn select_delete" onclick="document.pressed=this.value">선택삭제</button>
            <button type="submit" name="btn_submit" value="읽음표시" class="alarm_btn select_read" onclick="document.pressed=this.value">읽음표시</button>
        </li>
    </ul>
</div>
<script>
$(function() {
    $('.al_delete').on('click', function() {
        var $this = $(this),
            alid = $this.data('alid');
        $.ajax({
            type: "POST",
            data: {act:'alarm_delete', alid:alid},
            async: false,
            url: '<?php echo G5_PLUGIN_URL; ?>/alarm_in/ajax.alarm.php',
            success: function(data) {
                //console.log(data);
                $('#alarm_'+alid).hide();
            }
        });
    });

    $('.select_all').on("click", function(){
        if (!$(this).data('toggle_enable')) {
            $(this).data('toggle_enable', true);
        } else {
            $(this).data('toggle_enable', false);
        }
        $('[name="al_chk_id[]"]').prop('checked', $(this).data('toggle_enable') );
    });

    $('.al_subject').on('click', function() {
        var $this = $(this),
            href = $this.data('href'),
            msgtype = $this.data('msgtype'),
            alid = $this.data('alid');
        $.ajax({
            type: "POST",
            data: {act:'alarm_read', alid:alid},
            async: false,
            url: '<?php echo G5_PLUGIN_URL; ?>/alarm_in/ajax.alarm.php',
            success: function(data) {
                //console.log(data);
                if (msgtype == 'm') { //쪽지
                    win_memo(href);
                    return false;
                } else {
                    document.location.href = href;
                    return false;
                }
            }
        });
    });
});

function falarmlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "al_chk_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 알림을 삭제합니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_url+"/plugin/alarm_in/alarm_list_update.php";
    }

    if(document.pressed == "읽음표시") {
        f.removeAttribute("target");
        f.action = g5_url+"/plugin/alarm_in/alarm_list_update.php";
    }

    return true;
}

</script>
<?php include_once(G5_THEME_PATH.'/tail.php'); ?>