<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/style.css">', 0);
$list_count = (is_array($list) && $list) ? count($list) : 0;

// 타이틀색상
$sep_color = ($options['color']) ? $options['color'] : 'navy';

// 내용길이,줄수
if($options['cont_len'] == "") $options['cont_len'] = 200;
$options['line'] = (isset($options['line']) && $options['line'] > 0) ? $options['line'] : 2;
$options['line_height'] = 18 * $options['line'];

// 날짜
$is_date = (isset($options['date']) && $options['date']) ? true : false;
$is_dtype = (isset($options['dtype']) && $options['dtype']) ? $options['dtype'] : 'm.d';

// 강조글
$bold = array();
$strong = explode(",", $options['strong']);
$is_strong = count($strong);
for($i=0; $i < $is_strong; $i++) {

	list($n, $bc) = explode("|", $strong[$i]);

	if(!$n) continue;

	$n = $n - 1;
	$bold[$n]['num'] = true;
	$bold[$n]['color'] = ($bc) ? ' class="text-bold '.$bc.'"' : '';
}

?>

<style>
.basic-post-timeline .post-subject { height:<?php echo $options['line_height'];?>px; }
</style>

<div class="basic-post-timeline">
	<div class="timeline">
		<?php
		for ($i=0; $i<$list_count; $i++) {

			$list[$i]['date'] = strtotime($list[$i]['wr_datetime']);

			//날짜
			$timeline_sep = '';
			if($options['sep'] == 'day') {
				$date_sep = date("Ymd", $list[$i]['date']);
				$date_title = date("d M Y", $list[$i]['date']);
				$am_pm = (int)date("H", $list[$i]['date']);
				$am_pm = ($am_pm > 12) ? 'PM' : 'AM';
				$date_wr = date("Y.m.d h:i", $list[$i]['date']).' '.$am_pm;
			} else if($options['sep'] == 'year') {
				$date_sep = date("Y", $list[$i]['date']);
				$date_title = date("Y", $list[$i]['date']);
				$date_wr = date("d M Y", $list[$i]['date']);
			} else {
				$date_sep = date("Ym", $list[$i]['date']);
				$date_title = date("M Y", $list[$i]['date']);
				$date_wr = date("d M Y", $list[$i]['date']);
			}

			if(substr($list[$i]['wr_datetime'], 0, 10) == G5_TIME_YMD) {
				$date_sep = $date_title = 'Today';
			}

			if($save_sep == $date_sep) {
				;
			} else {
				$timeline_sep = ' timeline-sep';
				$save_sep = $date_sep;
			}

			//강조글
			if($is_strong) {
				if($bold[$i]['num']) {
					$list[$i]['subject'] = '<b'.$bold[$i]['color'].'>'.$list[$i]['subject'].'</b>';
				}
			}

			//랜덤숫자
			$rdm_number = rand(1,10);

			//회원사진
			$photo = ($list[$i]['mb_id'] && $options['photo']) ? get_member_profile_img($list[$i]['mb_id']) : '';
			$fa_icon = ($photo) ? $photo : '<img src="'.$latest_skin_url.'/img/'.$rdm_number.'.png" alt="Image">';


			get_member_profile_img($member['mb_id'])

		?>
		<?php if($timeline_sep) { ?>
		<div class="timeline-header" style="margin-bottom: 20px; margin-top: 0px;">
			<div class="timeline-header-title bg-<?php echo $sep_color;?>"><?php echo $date_title;?></div>
		</div>
		<?php } ?>
		<div class="timeline-entry">
			<div class="timeline-stat">
				<div class="timeline-icon">
					<?php echo $fa_icon;?>
				</div>
				<?php if ($is_date) { ?>
				<div class="timeline-time"><?php echo date($is_dtype, $list[$i]['date']); ?></div>
				<?php } ?>
			</div>
			<div class="timeline-label" style="padding-right:20px;">
				<a href="<?php echo $list[$i]['href'];?>">
				<p class="text-main text-semibold black ellipsis">
				<?php echo $list[$i]['subject'];?>
				</p>
				<div class="post-subject"><?php echo conv_subject(strip_tags($list[$i]['wr_content']), $options['cont_len'], '…');?></div>

				<div class="timeline-info text-muted">
					<div class="pull-left">
						<?php echo $list[$i]['name'];?>
						<?php if($list[$i]['ca_name']) { ?>
							<span class="list-sp">|</span>
							<?php echo $list[$i]['ca_name'];?>
						<?php } ?>
					</div>
					<div class="timeline-details pull-right">
						<i class="fa fa-comment"></i> <span class="red"><?php echo number_format($list[$i]['wr_comment']);?></span>
						<i class="fa fa-eye"></i> <span class="violet"><?php echo number_format($list[$i]['wr_hit']);?></span>
						<i class="fa fa-thumbs-up"></i> <span class="blue"><?php echo number_format($list[$i]['wr_good']);?></span>
					</div>
					<div class="clearfix"></div>
				</div>
				</a>
			</div>
		</div>
		<?php }  ?>
		<?php if(!$list_count) { ?>
		<div class="timeline-header">
			<div class="timeline-header-title bg-navy">Today</div>
		</div>
		<div class="timeline-entry">
			<div class="timeline-stat">
				<div class="timeline-icon">
					<img src="<?php echo $latest_skin_url;?>/img/1.png" alt="Image">
				</div>
				<div class="timeline-time"><?php echo substr(G5_TIME_YMDHIS, 5, 5); ?></div>
			</div>
			<div class="timeline-label" style="padding-right:20px;">
				<p class="text-main text-semibold ellipsis font-13">
					글이 없습니다.
				</p>
			</div>
		</div>
		<?php } ?>

	</div>
</div>
