<?php

// 스킨파일은 단독으로 실행할 수 없다
if(defined('_GNUBOARD_') == false)
{
    exit('함수파일은 단독으로 실행할 수 없습니다.');
}

// 파일의 확장자를 추출한다
function getExe($file)
{
    $array = explode('.', $file);
    $var = array_pop($array);
    $result = strtolower($var);
    return $result;
}

// 파일의 확장자를 검사한다
function checkExe($file, $exe)
{
    $var = getExe($file);
    $result = in_array($var, $exe);
    return $result;
}

// 썸네일 생성이 가능한지 검사한다
function checkThumb($file)
{
    $array = array('gif', 'jpg', 'jpeg', 'png');
    $result = checkExe($file, $array);
    return $result;
}

// 썸네일 이미지를 생성한다
function makeThumb($oldFile, $newFile, $newWidth, $newHeight, $fileName = null, $failSource = null)
{
    if(file_exists($oldFile) == true && checkThumb($oldFile) == true)
    {
        if(file_exists($newFile) == false)
        {
            list($thisWidth, $thisHeight, $thisType) = getimagesize($oldFile);
            switch($thisType)
            {
                case 1 : 
                    $thisImage = imagecreatefromgif($oldFile);
                    break;
                case 2 : 
                    $thisImage = imagecreatefromjpeg($oldFile);
                    break;
                case 3 : 
                    $thisImage = imagecreatefrompng($oldFile);
                    break;
            }
            $newImage = imagecreatetruecolor($newWidth, $newHeight);
            imagecopyresampled($newImage, $thisImage, 0, 0, 0, 0, $newWidth, $newHeight, $thisWidth, $thisHeight);
            imagejpeg($newImage, $newFile, 100);
        }
        $result = "<img src=\"{$newFile}\" alt=\"{$fileName}\">";
    }
    else
    {
        $result = $failSource;
    }
    return $result;
}

?>
