<?php

// 스킨파일은 단독으로 실행할 수 없다
if(defined('_GNUBOARD_') == false)
{
    exit('스킨파일은 단독으로 실행할 수 없습니다.');
}

// 프로그램 연산에 필요한 선행함수를 실행한다
include_once($board_skin_path . '/skin.function.php');

//g5 썸네일
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 게시글보기 썸네일 생성
function get_thumbnail($bo_table, $img, $width, $height=0, $alt, $view=0)
{
    $str = '';

    $file = G5_DATA_PATH.'/file/'.$bo_table.'/'.$img;
    if(is_file($file))
        $size = @getimagesize($file);

    if($size[2] < 1 || $size[2] > 3)
        return '';

    $img_width = $size[0];
    $img_height = $size[1];
    $filename = basename($file);
    $filepath = dirname($file);

    if($img_width && !$height) {
        $height = round(($width * $img_height) / $img_width);
    }

    $thumb = thumbnail($filename, $filepath, $filepath, $width, $height, false, false, 'center', true, $um_value='80/0.5/3');

    if($thumb) {
        $file_url = str_replace(G5_PATH, G5_URL, $filepath.'/'.$thumb);
        $str = '<img src="'.$file_url.'" width="'.$width.'" height="'.$height.'" alt="'.$alt.'">';
    }

    if($view == 1) return $str;
}

?>
<script src="<?php echo $board_skin_url; ?>/script.js"></script>
<link rel="stylesheet" href="<?php echo $board_skin_url; ?>/style.css">
<div class="mara_view_wrap" style="width:<?php echo $width; ?>;">
    <h1 class="subject">
        <?php echo cut_hangul_last(get_text($view['wr_subject'])); ?>
    </h1>
    <div class="thumb">
        <div class="photo"><?php if($view['file']['0']['file']){ ?><?php echo get_thumbnail($bo_table, $view['file'][0]['file'], 590, 380, $view['file'][0]['bf_content'], 1); ?><?php } ?></div>
        <ul class="minThumb">
            <?php for($i = 0; $i <= count($view['file']); $i++) { // 객실 이미지 뷰 ?>
            <?php if($view['file'][$i]['file']){
                get_thumbnail($bo_table, $view['file'][$i]['file'], 590, 380, $view['file'][$i]['bf_content']);
            ?>
            <li><a href="<?php echo $view['file'][$i]['path'] . '/' . $view['file'][$i]['file']; ?>" target="_blank"><?php echo get_thumbnail($bo_table, $view['file'][$i]['file'], 118, 90, $view['file'][$i]['bf_content'], 1); ?></a></li>
            <?php } ?>
            <?php } ?>
        </ul>
    </div>

    <table class="mara_view">
    <caption class="tit_desc">
        <?php echo $view['wr_1']; ?>평형 객실인 <?php echo cut_hangul_last(get_text($view['wr_subject'])); ?>의 상세정보
    </caption>
    <colgroup>
        <col class="rm_grid_3"><!-- 15% -->
        <col class="rm_grid_3"><!-- 15% -->
        <col class="rm_grid_3"><!-- 15% -->
        <col class="rm_grid_3"><!-- 15% -->
        <col class="rm_grid_3"><!-- 15% -->
        <col class="rm_grid_5"><!-- 25% -->
    </colgroup>
    <thead>
    <tr>
        <th scope="col">구분</th>
        <th scope="col">비성수기<br>주중 요금</th>
        <th scope="col">비성수기<br>주말 요금</th>
        <th scope="col">성수기<br>주중 요금</th>
        <th scope="col">성수기<br>주말 요금</th>
        <th scope="col">비고</th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <th scope="row">요금안내<?php echo $view['wr_id']; ?></th>
        <td><?php echo number_format($view['wr_4']); ?>원</td>
        <td><?php echo number_format($view['wr_5']); ?>원</td>
        <td><?php echo number_format($view['wr_6']); ?>원</td>
        <td><?php echo number_format($view['wr_7']); ?>원</td>
        <td>1인 추가시 <?php echo number_format($view['wr_8']); ?>원 <br>(기준 : <?php echo $view['wr_2']; ?>원명, 최대 : <?php echo $view['wr_3']; ?>명)</td>
    </tr>
    <tr>
        <th scope="row">시설안내</th>
        <td class="left" colspan="5"><?php echo $view['content'];?></td>
    </tr>
    <tr>
        <th scope="row">성수기안내</th>
        <td class="left" colspan="5"><?php echo $board['bo_1']; ?></td>
    </tr>
    </tbody>
    </table>
    <?php if($board['bo_2']){ ?>
    <div class="booking">
        <a href="<?php echo G5_BBS_URL; ?>/write.php?bo_table=<?php echo $board['bo_2']; ?>"><img src="<?php echo $board_skin_url; ?>/img/b_booking.gif" alt="예약하기"></a>
    </div>
    <?php } ?>
    <?php if($is_admin){ ?>
    <div class="mara_btn_area">
        <a href="<?php echo $write_href; ?>"><img src="<?php echo $board_skin_url; ?>/img/b_write.gif" alt="등록하기"></a>
        <a href="<?php echo $update_href; ?>"><img src="<?php echo $board_skin_url; ?>/img/b_update.gif" alt="수정하기"></a>
        <a href="<?php echo $delete_href; ?>"><img src="<?php echo $board_skin_url; ?>/img/b_delete.gif" alt="삭제하기"></a>
        <a href="<?php echo $copy_href; ?>"><img src="<?php echo $board_skin_url; ?>/img/b_copy.gif" alt="복사하기"></a>
        <a href="<?php echo $move_href; ?>"><img src="<?php echo $board_skin_url; ?>/img/b_move.gif" alt="이동하기"></a>
        <a href="<?php echo $list_href; ?>"><img src="<?php echo $board_skin_url; ?>/img/b_list.gif" alt="목록보기"></a>
    </div>
    <?php } ?>
</div>

