<?php
$sub_menu = '100320';
include_once('./_common.php');
include_once(G5_EDITOR_LIB);

auth_check($auth[$sub_menu], "w");

$ta_id = preg_replace('/[^0-9]/', '', $ta_id);

$html_title = "상단 AD";

// 팝업레이어 테이블에 쇼핑몰, 커뮤니티 인지 구분하는 여부 필드 추가
$sql = " ALTER TABLE `{$g5['top_ad_table']}` ADD `ta_division` VARCHAR(10) NOT NULL DEFAULT 'both' ";
sql_query($sql, false);

if ($w == "u")
{
    $html_title .= " 수정";
    $sql = " select * from {$g5['top_ad_table']} where ta_id = '$ta_id' ";
    $ta = sql_fetch($sql);
    if (!$ta['ta_id']) alert("등록된 자료가 없습니다.");
}
else
{
    $html_title .= " 입력";
    $ta['ta_device'] = 'both';
    $ta['ta_disable_hours'] = 24;
    $ta['ta_height'] = 500;
    $ta['ta_content_html'] = 2;
}

$g5['title'] = $html_title;
include_once (G5_ADMIN_PATH.'/admin.head.php');
?>

<form name="frmtopad" action="./topadformupdate.php" onsubmit="return frmtopad_check(this);" method="post">
<input type="hidden" name="w" value="<?php echo $w; ?>">
<input type="hidden" name="ta_id" value="<?php echo $ta_id; ?>">
<input type="hidden" name="token" value="">

<div class="local_desc01 local_desc">
    <p>초기화면 접속 시 자동으로 뜰 상단AD 설정합니다.</p>
</div>

<div class="tbl_frm01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?></caption>
    <colgroup>
        <col class="grid_4">
        <col>
    </colgroup>
    <tbody>
    <tr>
        <th scope="row"><label for="ta_division">구분</label></th>
        <td>
            <?php echo help("커뮤니티에 표시될 것인지 쇼핑몰에 표시될 것인지를 설정합니다."); ?>
            <select name="ta_division" id="ta_division">
                <option value="both"<?php echo get_selected($ta['ta_division'], 'both', true); ?>>커뮤니티와 쇼핑몰</option>
                <option value="comm"<?php echo get_selected($ta['ta_division'], 'comm'); ?>>커뮤니티</option>
                <option value="shop"<?php echo get_selected($ta['ta_division'], 'shop'); ?>>쇼핑몰</option>
            </select>
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_device">접속기기</label></th>
        <td>
            <?php echo help("팝업레이어가 표시될 접속기기를 설정합니다."); ?>
            <select name="ta_device" id="ta_device">
                <option value="both"<?php echo get_selected($ta['ta_device'], 'both', true); ?>>PC와 모바일</option>
                <option value="pc"<?php echo get_selected($ta['ta_device'], 'pc'); ?>>PC</option>
                <option value="mobile"<?php echo get_selected($ta['ta_device'], 'mobile'); ?>>모바일</option>
            </select>
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_disable_hours">시간<strong class="sound_only"> 필수</strong></label></th>
        <td>
            <?php echo help("고객이 다시 보지 않음을 선택할 시 몇 시간동안 팝업레이어를 보여주지 않을지 설정합니다."); ?>
            <input type="text" name="ta_disable_hours" value="<?php echo $ta['ta_disable_hours']; ?>" id="ta_disable_hours" required class="frm_input required" size="5"> 시간
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_begin_time">시작일시<strong class="sound_only"> 필수</strong></label></th>
        <td>
            <input type="text" name="ta_begin_time" value="<?php echo $ta['ta_begin_time']; ?>" id="ta_begin_time" required class="frm_input required" size="21" maxlength="19">
            <input type="checkbox" name="ta_begin_chk" value="<?php echo date("Y-m-d 00:00:00", G5_SERVER_TIME); ?>" id="ta_begin_chk" onclick="if (this.checked == true) this.form.ta_begin_time.value=this.form.ta_begin_chk.value; else this.form.ta_begin_time.value = this.form.ta_begin_time.defaultValue;">
            <label for="ta_begin_chk">시작일시를 오늘로</label>
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_end_time">종료일시<strong class="sound_only"> 필수</strong></label></th>
        <td>
            <input type="text" name="ta_end_time" value="<?php echo $ta['ta_end_time']; ?>" id="ta_end_time" required class="frm_input required" size="21" maxlength="19">
            <input type="checkbox" name="ta_end_chk" value="<?php echo date("Y-m-d 23:59:59", G5_SERVER_TIME+(60*60*24*7)); ?>" id="ta_end_chk" onclick="if (this.checked == true) this.form.ta_end_time.value=this.form.ta_end_chk.value; else this.form.ta_end_time.value = this.form.ta_end_time.defaultValue;">
            <label for="ta_end_chk">종료일시를 오늘로부터 7일 후로</label>
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_height">상단AD레이어 높이<strong class="sound_only"> 필수</strong></label></th>
        <td>
            <input type="text" name="ta_height" value="<?php echo $ta['ta_height'] ?>" id="ta_height" required class="frm_input required" size="5"> px
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_link">상단AD레이어 링크<strong class="sound_only"> 필수</strong></label></th>
        <td>
            <input type="text" name="ta_link" value="<?php echo $ta['ta_link'] ?>" id="ta_link" required class="frm_input required" size="60">
            <select name="ta_link_pop" id="ta_link_pop">
              <option value="_blank"<?php echo get_selected($ta['ta_link_pop'], '_blank'); ?>>새창에서 열기</option>
              <option value="_self"<?php echo get_selected($ta['ta_link_pop'], '_self'); ?>>현재창에서 열기</option>
            </select>
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_subject">제목</label></th>
        <td><input type="text" name="ta_subject" value="<?php echo $ta['ta_subject'] ?>" id="ta_subject" required class="frm_input required" size="60"></td>
    </tr>
    <tr>
        <th scope="row"><label for="ta_content">내용</label></th>
        <td><?php echo editor_html('ta_content', get_text(html_purifier($ta['ta_content']), 0)); ?></td>
    </tr>
    </tbody>
    </table>
</div>

<div class="btn_fixed_top">
    <a href="./topadlist.php" class=" btn btn_02">목록</a>
    <input type="submit" value="확인" class="btn_submit btn" accesskey="s">
</div>
</form>

<script>
function frmtopad_check(f)
{
    errmsg = "";
    errfld = "";

    <?php echo get_editor_js('ta_content'); ?>

    check_field(f.ta_subject, "제목을 입력하세요.");

    if (errmsg != "") {
        alert(errmsg);
        errfld.focus();
        return false;
    }
    return true;
}
</script>

<?php
include_once (G5_ADMIN_PATH.'/admin.tail.php');
?>
