<?
include_once('./_common.php');

if(AMINA != "g4s") include_once(AMINA_PATH.'/lib/head.lib.php');

if (!$bo_table) {
	alert_close("값이 넘어오지 않았습니다.");
}

//설정값
if(!$lat) $lat = '37.566535';
if(!$lng) $lng = '126.977969';
if(!$zoom) $zoom = 14;

if(G4_IS_MOBILE) { 
	$map_width = '100%';
	$map_height = '450px';
	$border = 'border:15px solid #fafafa; border-top:0px;';
} else {
	$map_width = '100%';
	$map_height = '450px';
	$border = 'border:0px;';
}

?>
<!doctype html>
<html lang="ko">
<head>
<meta charset="utf-8">
<? if (G4_IS_MOBILE) {?>
<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=0,maximum-scale=10,user-scalable=yes">
<meta name="HandheldFriendly" content="true">
<meta name="format-detection" content="telephone=no">
<? } ?>
<title>구글지도</title>
<style>
	body, table, form { margin:0; padding:0; font:normal 12px dotum; -webkit-text-size-adjust:100%; }
	button { border-radius:0;-webkit-appearance:none; }
	input {	border:1px solid #ddd; border-radius:0;-webkit-appearance:none; }
	.title { padding:12px; text-align:center; font:bold 14px verdana; color:gold; background:#333 !important; border:0px; }
	.tbl { border-collapse:collapse; width:100%; } 
	.tbl th { width:30px; text-align:center; background:#fafafa; border:1px solid #ddd; padding: 6px 10px; line-height:1.6; font-size:12px; -webkit-text-size-adjust:100%;}
	.tbl td { background:#fff; border:1px solid #ddd; padding: 6px 10px; line-height:1.6; font-size:12px; -webkit-text-size-adjust:100%;}
	.tbl span { font-size:12px; -webkit-text-size-adjust:100%; }
	.btn_save {cursor:pointer; padding:4px 6px; background:red; font-weight:bold; color:#ffffff; border:0px; cursor:pointer; border-radius:0;-webkit-appearance:none;}
	.btn_search {cursor:pointer; padding:4px 6px; background:#333333; font-weight:bold; color:gold; border:0px; cursor:pointer; border-radius:0;-webkit-appearance:none;}
	div#map { position: relative; <?=$border?> }
	div#crosshair {
		position: absolute;
	    top: 214px;
		height: 22px;
	    width: 22px;
		left: 50%;
	    margin-left: -10px;
		display: block;
	    background-image: url('./img/crosshair.gif');
		background-position: center center;
	    background-repeat: no-repeat;
	}
</style>
<script src="http://maps.google.com/maps/api/js?v=3.3&sensor=true&language=ko"></script>
<script>
	var map;
	var geocoder;
	var centerChangedLast;
	var reverseGeocodedLast;
	var currentReverseGeocodeResponse;

	function addLoadEvent(func) {
		var oldonload = window.onload;
		if (typeof window.onload != 'function') {
			window.onload = func;
		} else {
			window.onload = function() {
				if (oldonload) {
					oldonload();
				}
				func();
			}
		}
	}

	function initialize() {
		var latlng = new google.maps.LatLng(<?=$lat?>, <?=$lng?>);
		var myOptions = {
			zoom: <?=$zoom?>,
			scaleControl: true,
			center: latlng,
			mapTypeId: google.maps.MapTypeId.ROADMAP
		};

		map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
		geocoder = new google.maps.Geocoder();
 
		google.maps.event.addListener(map, 'zoom_changed', function() {
			document.getElementById("zoom_level").innerHTML = map.getZoom();
			document.getElementById("map_zoom").value = map.getZoom();

			zoomLevel = map.getZoom(); 
			if (zoomLevel > 19) { 
				map.setZoom(19); 
			}   
			if (zoomLevel < 1) { 
				map.setZoom(1); 
			}   
		});

		setupEvents();
		centerChanged();
	}
 
	function setupEvents() {
		reverseGeocodedLast = new Date();
		centerChangedLast = new Date();
 
		setInterval(function() {
			if((new Date()).getSeconds() - centerChangedLast.getSeconds() > 1) {
				if(reverseGeocodedLast.getTime() < centerChangedLast.getTime())
				reverseGeocode();
			}
		}, 1000);
 
		google.maps.event.addListener(map, 'center_changed', centerChanged);
 
		google.maps.event.addDomListener(document.getElementById('crosshair'),'dblclick', function() {
			map.setZoom(map.getZoom() + 1);
		});
	}
 
	function getCenterLatLngText() {
 
		var nn = 1000000;
		var tmpLat = Math.round(map.getCenter().lat()*nn)/nn;
		var tmpLng = Math.round(map.getCenter().lng()*nn)/nn;
 
		document.getElementById("map_lat").value = tmpLat;
		document.getElementById("map_lng").value = tmpLng;

		return tmpLat +', '+ tmpLng;
	}
 
	function centerChanged() {
		centerChangedLast = new Date();
		var latlng = getCenterLatLngText();
		var loc = latlng.split(',');	
		geocoder.geocode({latLng:map.getCenter()},reverseGeocodeResult);
		document.getElementById('lat').innerHTML = loc[0];
		document.getElementById('lng').innerHTML = loc[1];
		document.getElementById('formatedAddress').innerHTML = '';
		currentReverseGeocodeResponse = null;
	}
 
	function reverseGeocode() {
		reverseGeocodedLast = new Date();
		geocoder.geocode({latLng:map.getCenter()},reverseGeocodeResult);
	}
 
	function reverseGeocodeResult(results, status) {
		currentReverseGeocodeResponse = results;
		if(status == 'OK') {
			if(results.length == 0) {
				document.getElementById('formatedAddress').innerHTML = 'None';
			} else {
				document.getElementById('formatedAddress').innerHTML = results[0].formatted_address;
			}
		} else {
			document.getElementById('formatedAddress').innerHTML = 'Error';
		}
	}

 	function geocode() {
		var address = document.getElementById("address").value;
		geocoder.geocode({
			'address': address,
			'partialmatch': true}, geocodeResult);
	}
 
	function geocodeResult(results, status) {
		if (status == 'OK' && results.length > 0) {
			map.fitBounds(results[0].geometry.viewport);
		} else {
			alert("Info : " + status);
		}
	}
</script>
</head>
<body>
<div class="title">Google Map</div>

<table border="1" class="tbl">
<tbody>
<tr>
<th scope="col">찾기</th>
<td> 
	<input type="text" id="address" style="width:60%;" onKeyDown="if(event.keyCode==13){geocode();}" />
	&nbsp;<input type="button" class="btn_search" value=" 검색 " onclick="geocode()">
	&nbsp;<input type="button" class="btn_save" value=" 등록 " onclick="geocode_submit()">

	<input type="hidden" id="map_lat" value="<?=$lat?>">
	<input type="hidden" id="map_lng"	value="<?=$lng?>">
	<input type="hidden" id="map_zoom" value="<?=$zoom?>">
</td>
</tr>
<tr><th scope="col">주소</th><td colspan=3><span id="formatedAddress"></span></td></tr>
<tr><th scope="col">위치</th><td>
	<? if(G4_IS_MOBILE) { ?>
		<span id="lat"></span>, <span id="lng"></span>, z<span id="zoom_level"><?=$zoom?></span>
	<? } else { ?>
		위도 : <span id="lat"></span> / 경도 : <span id="lng"></span> / 줌 : <span id="zoom_level"><?=$zoom?></span>
	<? } ?>
</td>
</tr>
<tr><th scope="col">크기</th><td>
	<input type="text" id="map_w" size=4 numeric style="width:50px;" value="<?=$map_w?>" /> 
	x 
	<input type="text" id="map_h" size=4 numeric style="width:50px;" value="<?=$map_h?>" /> 
	Size
</td>
</tr>
</table>

<div id="map">
	<div id="map_canvas" style="width:<?=$map_width?>; height:<?=$map_height?>;"></div>
	<div id="crosshair"></div>
</div>

<script> 

	function move_center() {
		var sw = screen.width;
	    var sh = screen.height;
		var cw = document.body.clientWidth;
	    var ch = document.body.clientHeight;
	    var top  = sh / 2 - ch / 2 - 100;
		var left = sw / 2 - cw / 2;
	    moveTo(left, top);
	}

	function geocode_submit() {
		//부모창 값변경
		opener.document.fwrite.map_width.value = document.getElementById("map_w").value;
		opener.document.fwrite.map_height.value = document.getElementById("map_h").value;
		opener.document.fwrite.map_lat.value = document.getElementById("map_lat").value;
		opener.document.fwrite.map_lng.value = document.getElementById("map_lng").value;
		opener.document.fwrite.map_zoom.value = document.getElementById("map_zoom").value;
		opener.document.fwrite.map_open.value = "설정변경";
		window.close();
    }

	addLoadEvent(function() {
		move_center();
		initialize();
	});
</script>
</body>
</html>