<?php
if (!defined('_GNUBOARD_')) exit; // 개별 Page 접근 불가

// input의 name을 wset[배열키] 형태로 등록
// Mobile 설정값은 동일 배열키에 배열변수만 wmset으로 지정 → wmset[배열키]

if(!$wset['new']) $wset['new'] = 'red';

?>

<div class="tbl_head01 tbl_wrap">
	<table>
	<caption>Widget Settings</caption>
	<colgroup>
		<col class="grid_2">
		<col>
	</colgroup>
	<thead>
	<tr>
		<th scope="col">Category</th>
		<th scope="col">Set</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td align="center">Thumbnail</td>
		<td>
			<?php echo help('Basic 400x300(4:3) - Apply default when not in use');?>
			<input type="text" name="wset[thumb_w]" value="<?php echo $wset['thumb_w']; ?>" class="frm_input" size="4">
			x
			<input type="text" name="wset[thumb_h]" value="<?php echo $wset['thumb_h']; ?>" class="frm_input" size="4">
			px 
			&nbsp;
			<label><input type="checkbox" name="wset[vicon]" value="1"<?php echo get_checked('1', $wset['vicon']); ?>> Hide Video Icon</label>
		</td>
	</tr>
	<tr>
		<td rowspan="2" align="center">Image Writing</td>
		<td>
			<select name="wset[irows]">
				<option value="1"<?php echo get_selected('1', $wset['irows']);?>>1개</option>
				<option value="2"<?php echo get_selected('2', $wset['irows']);?>>2개</option>
				<option value="3"<?php echo get_selected('3', $wset['irows']);?>>3개</option>
			</select>
			Show
			&nbsp;
			<input type="text" name="wset[line]" value="<?php echo $wset['line']; ?>" class="frm_input" size="4"> 줄(Basic 3)
			&nbsp;
			<label><input type="checkbox" name="wset[right]" value="1"<?php echo get_checked('1', $wset['right']); ?>> Right Position</label>
		</td>
	</tr>
	<tr>
		<td>
			<label><input type="checkbox" name="wset[bold]" value="1"<?php echo get_checked('1', $wset['bold']); ?>> Bold</label>
			&nbsp;
			<label><input type="checkbox" name="wset[idate]" value="1"<?php echo get_checked('1', $wset['idate']); ?>> Date</label>
			&nbsp;
			<label><input type="checkbox" name="wset[cate]" value="1"<?php echo get_checked('1', $wset['cate']); ?>> Class</label>
		</td>
	</tr>
	<tr>
		<td align="center">Title Link</td>
		<td>
			<select name="wset[modal]">
				<option value=""<?php echo get_selected('', $wset['modal']);?>>Content - Current Window</option>
				<option value="1"<?php echo get_selected('1', $wset['modal']);?>>Content - Modal Window</option>
				<option value="2"<?php echo get_selected('2', $wset['modal']);?>>Link#1 - New Window</option>
			</select>
		</td>
	</tr>
	<tr>
		<td align="center">Highlight Title</td>
		<td>
			<?php echo help('강조하는 글의 순번을 콤마(,)로 구분해서 등록. 바(|)를 이용하여 red, blue, green, crimson, orangred 등의 Basic 컬러설정 가능. ex) 1|red,4|blue,6');?>
			<input type="text" name="wset[strong]" value="<?php echo ($wset['strong']);?>" size="60" class="frm_input"> 
		</td>
	</tr>
	<tr>
		<td align="center">Post Icon</td>
		<td>
			<input type="text" name="wset[icon]" id="fcon" value="<?php echo ($wset['icon']);?>" size="30" class="frm_input"> 
			<a href="<?php echo G5_BBS_URL;?>/ficon.php?fid=fcon" class="btn_frmline win_scrap">아이콘 선택</a>
			&nbsp;
			<label><input type="checkbox" name="wset[ticon]" value="1"<?php echo get_checked('1', $wset['ticon']); ?>> 글타입 아이콘 사용</label>
		</td>
	</tr>
	<tr>
		<td align="center">Date Type</td>
		<td>
			<input type="text" name="wset[dtype]" value="<?php echo $wset['dtype'];?>" size="8" class="frm_input" >
			(Y.m.d, Y/m/d Date Type)
			&nbsp;
			<label><input type="checkbox" name="wset[date]" value="1"<?php echo get_checked('1', $wset['date']);?>> Show</label>
			&nbsp;
			<label><input type="checkbox" name="wset[dtxt]" value="1"<?php echo get_checked('1', $wset['dtxt']);?>> few seconds,time style</label>
		</td>
	</tr>
	<tr>
		<td align="center">Extract</td>
		<td>
			<input type="text" name="wset[rows]" value="<?php echo $wset['rows']; ?>" class="frm_input" size="3"> 개 - PC
			&nbsp;
			<input type="text" name="wmset[rows]" value="<?php echo $wmset['rows']; ?>" class="frm_input" size="3"> 개 - Mobile
			&nbsp;
			<input type="text" name="wset[page]" value="<?php echo $wset['page'];?>" size="3" class="frm_input"> Page
			&nbsp;
			<select name="wset[main]">
				<option value=""<?php echo get_selected('', $wset['main']); ?>>All Posts</option>
				<option value="1"<?php echo get_selected('1', $wset['main']); ?>>Main Article</option>
			</select>
			Extraction
		</td>
	</tr>
	<tr>
		<td align="center">Extract Board</td>
		<td>
			<?php echo help('You can register multiple board IDs by separating them with comma (,).');?>
			<input type="text" name="wset[bo_list]" value="<?php echo $wset['bo_list']; ?>" size="60" class="frm_input">
			&nbsp;
		</td>
	</tr>
	<tr>
		<td align="center">Board Group</td>
		<td>
			<?php echo help('You can register multiple group IDs separated by a comma (,).');?>
			<input type="text" name="wset[gr_list]" value="<?php echo $wset['gr_list']; ?>" size="60" class="frm_input">
		</td>
	</tr>
	<tr>
		<td align="center">ExtractClass</td>
		<td>
			<?php echo help('Multiple entries can be separated by commas (,), only for single board extraction');?>
			<input type="text" name="wset[ca_list]" value="<?php echo $wset['ca_list']; ?>" size="60" class="frm_input">
		</td>
	</tr>
	<tr>
		<td align="center">Exclude Settings</td>
		<td>
			<label><input type="checkbox" name="wset[except]" value="1"<?php echo get_checked('1', $wset['except']);?>> Exclude Specific Boards/Groups</label>
			&nbsp;
			<label><input type="checkbox" name="wset[ex_ca]" value="1"<?php echo get_checked('1', $wset['ex_ca']);?>> Exclude Class</label>
		</td>
	</tr>
	<tr>
		<td align="center">New Settings</td>
		<td>
			<input type="text" name="wset[newtime]" value="<?php echo ($wset['newtime']);?>" size="3" class="frm_input"> Within Hours
			&nbsp;
			Color
			<select name="wset[new]">
				<?php echo apms_color_options($wset['new']);?>
			</select>
		</td>
	</tr>
	<tr>
		<td align="center">Sort Settings</td>
		<td>
			<select name="wset[sort]">
				<?php echo apms_rank_options($wset['sort']);?>
			</select>
			&nbsp;
			Show Rank
			<select name="wset[rank]">
				<option value=""<?php echo get_selected('', $wset['rank']); ?>>Do Not Show</option>
				<?php echo apms_color_options($wset['rank']);?>
			</select>
		</td>
	</tr>
	<tr>
		<td align="center">Set Date Range</td>
		<td>
			<select name="wset[term]">
				<?php echo apms_term_options($wset['term']);?>
			</select>
			&nbsp;
			<input type="text" name="wset[dayterm]" value="<?php echo $wset['dayterm'];?>" size="3" class="frm_input"> Data up to the previous date (applied when setting date)
		</td>
	</tr>
	<tr>
		<td align="center">Member Select</td>
		<td>
			<?php echo help('You can register multiple member IDs separated by a comma (,).');?>
			<input type="text" name="wset[mb_list]" value="<?php echo $wset['mb_list']; ?>" size="46" class="frm_input">
			&nbsp;
			<label><input type="checkbox" name="wset[ex_mb]" value="1"<?php echo get_checked('1', $wset['ex_mb']);?>> Exclude</label>
		</td>
	</tr>
	<tr>
		<td align="center">Enable Cache</td>
		<td>
			<input type="text" name="wset[cache]" value="<?php echo $wset['cache']; ?>" class="frm_input" size="4"> Caching in seconds
		</td>
	</tr>
	</tbody>
	</table>
</div>