<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// input의 name을 wset[배열키] 형태로 등록
// Mobile Set값은 동일 배열키에 배열변수만 wmset으로 지정 → wmset[배열키]

?>

<div class="tbl_head01 tbl_wrap">
	<table>
	<caption>Widget Settings</caption>
	<colgroup>
		<col class="grid_1">
		<col class="grid_2">
		<col>
	</colgroup>
	<thead>
	<tr>
		<th scope="col" colspan="2">Category</th>
		<th scope="col">Set</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td align="center" rowspan="6">Common</td>
		<td align="center">PC Style</td>
		<td>
			<?php echo help('Basic 3000ms, 밀리초(ms)는 천분의 1초. ex) 5초 = 5000ms');?>
			<select name="wset[effect]">
				<?php echo apms_carousel_options($wset['effect']);?>
			</select>
			<input type="text" name="wset[auto]" value="<?php echo $wset['auto']; ?>" class="frm_input" size="4"> ms Interval (do not auto-run when 0 is entered)
		</td>
	</tr>
	<tr>
		<td align="center">Mobile Style</td>
		<td>
			<select name="wmset[effect]">
				<?php echo apms_carousel_options($wmset['effect']);?>
			</select>
			<input type="text" name="wmset[auto]" value="<?php echo $wmset['auto']; ?>" class="frm_input" size="4"> ms Interval (do not auto-run when 0 is entered)
		</td>
	</tr>
	<tr>
		<td align="center">Navigation Set</td>
		<td>
			<?php echo help('도트위치는 Basic 10px, 입력시 단위(px 또는 %)까지 입력.');?>
			<select name="wset[nav]">
				<option value=""<?php echo get_selected('', $wset['nav']);?>>No Navigation</option>
				<option value="1"<?php echo get_selected('1', $wset['nav']);?>>Dot Navigation</option>
			</select>
			&nbsp;
			Dot Position
			<input type="text" name="wset[dot]" value="<?php echo ($wset['dot']) ? $wset['dot'] : '10px' ; ?>" class="frm_input" size="6"> (px or %)
		</td>
	</tr>
	<tr>
		<td align="center">Output Set</td>
		<td>
			<select name="wset[arrow]">
				<option value=""<?php echo get_selected('', $wset['arrow']);?>>Big Arrow</option>
				<option value="1"<?php echo get_selected('1', $wset['arrow']);?>>Small Arrow</option>
				<option value="2"<?php echo get_selected('2', $wset['arrow']);?>>Do not show</option>
			</select>
			&nbsp;
			<select name="wset[shadow]">
				<?php echo apms_shadow_options($wset['shadow']);?>
			</select>
			&nbsp;
			<label><input type="checkbox" name="wset[rdm]" value="1"<?php echo get_checked('1', $wset['rdm']);?>> Random output</label>
		</td>
	</tr>
	<tr>
		<td align="center">Set Height</td>
		<td>
			<?php echo help('Basic 400px, Input unit (px or%) when input. ex) 400px or 56.25%');?>
			<table>
			<thead>
			<tr>
				<th scope="col">Category</th>
				<th scope="col">Basic</th>
				<th scope="col">lg(1199px~)</th>
				<th scope="col">md(991px~)</th>
				<th scope="col">sm(767px~)</th>
				<th scope="col">xs(480px~)</th>
			</tr>
			</thead>
			<tbody>
			<tr>
				<td align="center">Height(px,%)</td>
				<td align="center">
					<input type="text" name="wset[height]" value="<?php echo $wset['height']; ?>" class="frm_input" size="4">
				</td>
				<td align="center">
					<input type="text" name="wset[lg]" value="<?php echo $wset['lg']; ?>" class="frm_input" size="4">
				</td>
				<td align="center">
					<input type="text" name="wset[md]" value="<?php echo $wset['md']; ?>" class="frm_input" size="4">
				</td>
				<td align="center">
					<input type="text" name="wset[sm]" value="<?php echo $wset['sm']; ?>" class="frm_input" size="4">
				</td>
				<td align="center">
					<input type="text" name="wset[xs]" value="<?php echo $wset['xs']; ?>" class="frm_input" size="4">
				</td>
			</tr>
			</tbody>
			</table>
		</td>
	</tr>
	<tr>
		<td align="center"><b>Slider</b></td>
		<td>
			<input type="text" name="wset[slider]" value="<?php echo $wset['slider']; ?>" class="frm_input" size="4"> - After input and save, slider will be created.
		</td>
	</tr>
	<?php for ($i=1; $i <= $wset['slider']; $i++) { ?>
		<tr>
			<td align="center" rowspan="5">#<?php echo $i;?></td>
			<td align="center" class="bg-light"><b>Use or Not</b></td>
			<td class="bg-light">
				<label><input type="checkbox" name="wset[use<?php echo $i;?>]" value="1"<?php echo get_checked('1', $wset['use'.$i]); ?>> <b>Output</b></label>
			</td>
		</tr>
		<tr>
			<td align="center">Image</td>
			<td>
				<select name="wset[cl<?php echo $i;?>]">
					<option value=""<?php echo get_selected('', $wset['cl'.$i]);?>>Center</option>
					<option value="top"<?php echo get_selected('top', $wset['cl'.$i]);?>>Top</option>
					<option value="bottom"<?php echo get_selected('bottom', $wset['cl'.$i]);?>>Bottom</option>
				</select>
				<input type="text" name="wset[img<?php echo $i;?>]" value="<?php echo ($wset['img'.$i]);?>" id="img<?php echo $i;?>" size="36" class="frm_input"> 
				<a href="<?php echo G5_BBS_URL;?>/widget.image.php?fid=img<?php echo $i;?>" class="btn_frmline win_scrap">Select Image</a>
			</td>
		</tr>
		<tr>
			<td align="center">Caption</td>
			<td>
				<select name="wset[cs<?php echo $i;?>]">
					<option value=""<?php echo get_selected('', $wset['cs'.$i]);?>>No Caption</option>
					<option value="title"<?php echo get_selected('title', $wset['cs'.$i]);?>>Big Captions</option>
					<option value="caption"<?php echo get_selected('caption', $wset['cs'.$i]);?>>Medium Captions</option>
					<option value="subject"<?php echo get_selected('subject', $wset['cs'.$i]);?>>Small Captions</option>
				</select>
				&nbsp;
				<select name="wset[cf<?php echo $i;?>]">
					<option value="24"<?php echo get_selected('24', $wset['cf'.$i]);?>>24px</option>
					<option value="22"<?php echo get_selected('22', $wset['cf'.$i]);?>>22px</option>
					<option value="20"<?php echo get_selected('20', $wset['cf'.$i]);?>>20px</option>
					<option value="18"<?php echo get_selected('18', $wset['cf'.$i]);?>>18px</option>
					<option value="16"<?php echo get_selected('16', $wset['cf'.$i]);?>>16px</option>
					<option value="14"<?php echo get_selected('14', $wset['cf'.$i]);?>>14px</option>
					<option value="13"<?php echo get_selected('13', $wset['cf'.$i]);?>>13px</option>
					<option value="12"<?php echo get_selected('12', $wset['cf'.$i]);?>>12px</option>
				</select>
				&nbsp;
				<select name="wset[cc<?php echo $i;?>]">
					<?php echo apms_color_options($wset['cc'.$i]);?>
				</select>
				&nbsp;
				<a href="<?php echo G5_BBS_URL;?>/ficon.php?fid=caption<?php echo $i;?>" class="btn_frmline win_scrap">Select Icon</a>
				<div style="height:8px;"></div>
				<textarea id="caption<?php echo $i;?>" name="wset[caption<?php echo $i;?>]"><?php echo $wset['caption'.$i]; ?></textarea>
			</td>
		</tr>
		<tr>
			<td align="center">Link</td>
			<td>
				<?php echo help('URL(http://...)을 입력해야 하며, 미입력시 Link가 걸리지 않습니다.');?>
				<input type="text" name="wset[link<?php echo $i;?>]" value="<?php echo $wset['link'.$i]; ?>" size="40" class="frm_input" placeholder="http://...">
				&nbsp;
				Target
				<input type="text" name="wset[target<?php echo $i;?>]" value="<?php echo $wset['target'.$i]; ?>" size="8" class="frm_input">
			</td>
		</tr>
		<tr>
			<td align="center">Label</td>
			<td>
				<select name="wset[label<?php echo $i;?>]">
					<option value=""<?php echo get_selected('', $wset['label'.$i]); ?>>Not Used</option>
					<?php echo apms_color_options($wset['label'.$i]); ?>
				</select>
				&nbsp;
				<a href="<?php echo G5_BBS_URL;?>/ficon.php?fid=txt<?php echo $i;?>" class="btn_frmline win_scrap">아이콘 선택</a>
				<div style="height:8px;"></div>
				<textarea id="txt<?php echo $i;?>" name="wset[txt<?php echo $i;?>]" placeholder="영어 3자 또는 아이콘 등 입력"><?php echo $wset['txt'.$i]; ?></textarea>
			</td>
		</tr>
	<?php } ?>
	</tbody>
	</table>
</div>