<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

$imgwidth = 320; //표시할 이미지의 가로사이즈
$imgheight = 150; //표시할 이미지의 세로사이즈
?>

<style>
#event { margin-bottom:25px; }
#event:after { clear:both; display:block; content:""; *zoom:1 }
#event ul { float:right; position:relative; left:-50%; }
#event ul:after { clear:both; display:block; content:""; *zoom:1 }
#event li { float:left; width:320px; text-align:center; border:1px solid #ddd; position:relative; left:50%; }
#event li:hover { border:1px solid #888 }
#event li:nth-child(2) { margin:0 23px; }
#event .img { display:block; overflow:hidden }
#event .txt { display:block; padding:15px; text-align:center; }
#event .txt span { display:block; }
#event .txt span.date { color:#666; }
#event .txt span.tit { font-size:1rem; padding:4% 0; letter-spacing:-1px }

@media all and (max-width: 1200px) {
	#event li { width:32% }
	#event li:nth-child(2) { margin:0 5px; }
}

@media all and (max-width: 768px) {
	#event ul { float:none; position:none; left:0; }
	#event ul:after { clear:both; display:block; content:""; *zoom:1 }
	#event li { float:none; position:none; left:0; display:block; width:100% }
	#event li:nth-child(2) { margin:10px 0; }
	#event .txt span.tit { font-size:1rem; }
	#event .img img { width:100% }
}
</style>


<div id="event">
	
	<ul>
	<?php for ($i=0; $i<count($list); $i++) {
	
	?>	
		<li>
			<a href="<?php echo $list[$i]['href'] ?>">
				<div class="img">	
				<?php                
					$thumb = get_list_thumbnail($bo_table, $list[$i][wr_id], $imgwidth, $imgheight, 1, 1, 'center');    					            
					if($thumb['src']) {
						$img_content = '<img src="'.$thumb['src'].'">';
					} else {
						$img_content = 'NO IMAGE';
					}                
						echo $img_content;												               
				?>
				</div>
				<div class="txt">
					<span class="date"><?php echo $list[$i]['wr_1'] ?> ~ <?php echo $list[$i]['wr_2'] ?></span>
					<span class="tit"><?=cut_str($list[$i]['wr_subject'], 40, "")?></span>
				</div>
			</a>
		</li>
	<?php } ?>
	</ul>
</div>
