<?php
// swiper_parallax
// Author: 휴온(2016)
// URL: www.hnbuilder.net
/* -------------------------------------------------------------
[사용법]
// 첫 번째 옵션에 배경 이미지 경로를 지정합니다.
 echo latest("swiper_parallax", "gallery", 10, 0, 1, "./images/dandelion.jpg");

// 두 번째 옵션에 보여지는 영역의 width를 지정할 수 있습니다.(기본 500)
// echo latest("swiper_parallax", "gallery", 10, 0, 1, "./images/dandelion.jpg|500");

// 세 번째 옵션에 'v'를 추가하면 vertical 형식의 parallax가 됩니다.
// echo latest("swiper_parallax", "gallery", 10, 0, 1, "./images/dandelion.jpg|600|v");

[plugin]
Swiper: http://idangero.us/swiper/
------------------------------------------------------------- */
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 배경이미지
if ($options) {
	$tmp = explode("|", $options);
	$background_img = $tmp[0];
	
	if (is_numeric($tmp[1]))
		$text_width = $tmp[1];
	
	if ($tmp[2] == "v")
		$is_vertical = true;
}
?>
<link rel="stylesheet" href="<?php echo G5_URL ?>/plugin/swiper/css/swiper.min.css">
<link rel="stylesheet" href="<?php echo $latest_skin_url ?>/swiper_parallax.css">
<style>
<?php if ($text_width) { ?>.swiper-parallax .swiper-slide .text { max-width: <?php echo $text_width; ?>px; }<?php } ?>
<?php if ($is_vertical) { ?>.swiper-parallax .parallax-bg { width: 100%; height: 130%; }<?php } ?>
</style>
	
<!-- Swiper -->
<div class="swiper-container swiper-parallax">
	<?php if ($background_img) { ?><div class="parallax-bg" style="background-image:url(<?php echo $background_img; ?>)" data-swiper-parallax="-23%"></div><?php } ?>		
	<div class="swiper-wrapper">
<?php 
for ($i=0; $i<count($list); $i++) {  
	echo "		<div class=\"swiper-slide\">\n";
	echo "			<h1 class=\"title\" data-swiper-parallax=\"-100\">{$list[$i]['wr_subject']}</h1>\n";	
	// 원본이미지 출력
	if ( $list[$i]['file']['count'] ) {
		echo "			<div class=\"text\" data-swiper-parallax=\"-1000\">\n";	
		$list_files = get_file($bo_table, $list[$i]['wr_id']);
		
		for( $k=0; $k<count($list_files); $k++ ) {
			$current_file = $list_files[$k]['path']."/".$list_files[$k]['file'];			
			if (preg_match("/\.(gif|jpg|png)$/i", $current_file)) {
				echo "<img src=\"$current_file\" alt=\"\" border=\"0\" style=\"width:100%; height:auto;\"><br> \n";
			}
		}
		echo "			</div>\n";
	}
	echo "			<div class=\"text\" data-swiper-parallax=\"-2000\">\n";	
	echo nl2br(stripslashes($list[$i]['wr_content']))."\n";
	echo "			</div>\n";
	echo "		</div>\n";
} 
?>
	</div>
	<div class="swiper-pagination"></div>
<?php if (!$is_vertical) { ?>
	<div class="swiper-button-prev swiper-button-white"></div>
	<div class="swiper-button-next swiper-button-white"></div>
<?php } ?>	
</div>
<script src="<?php echo G5_URL ?>/plugin/swiper/js/swiper.min.js"></script>
<script>
<?php if ($is_vertical) { ?>
var swiper_parallax = new Swiper('.swiper-parallax', {
	pagination: '.swiper-pagination',
	paginationClickable: true,
	direction: 'vertical',
	keyboardControl: true,
	mousewheelControl: true,
	parallax: true,
	speed: 600
});
<?php } else { ?>	
var swiper_parallax = new Swiper('.swiper-parallax', {
	pagination: '.swiper-pagination',
	paginationClickable: true,
	nextButton: '.swiper-button-next',
	prevButton: '.swiper-button-prev',
	keyboardControl: true,
	parallax: true,
	speed: 600
});
<?php } ?>	
</script><!-- /Swiper -->