<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>

<!-- 게시물 읽기 시작 { -->
<div id="bo_v_table"><?php echo $board['bo_subject']; ?></div>

<article id="bo_v" style="width:<?php echo $width; ?>">
	<header>
		<h1 id="bo_v_title">
		<?php
		if ($category_name) echo "<span class='bo_v_cate'>".$view['ca_name']."</span> "; // 분류 출력 끝
			echo "<b>".cut_str(get_text($view['wr_subject']), 70)."</b>"; // 글제목 출력
		?>
		</h1>
	</header>

	<section id="bo_v_info" class='small4'>
		<h2>페이지 정보</h2>
		작성자 <?php echo $view['name'] ?><?php if ($is_ip_view) { echo " ($ip)"; } ?>,
			작성일 <?php echo date("y-m-d H:i", strtotime($view['wr_datetime'])) ?>,
			조회 <?php echo number_format($view['wr_hit']) ?>,
			댓글 <?php echo number_format($view['wr_comment']) ?>
	</section>

		<?php
		if ($view['file']['count']) 
		{
				$cnt = 0;
				for ($i=0; $i<count($view['file']); $i++) 
				{
					if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view'])
							$cnt++;
				}
		}
		?>

		<?php if($cnt) { ?>
		<!-- 첨부파일 시작 { -->
		<section id="bo_v_file" class='small'>
				<h2>첨부파일</h2>
				<ul>
				<?php
				// 가변 파일
				for ($i=0; $i<count($view['file']); $i++) 
				{
					if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view']) 
					{
			?>
					<li>
							<a href="<?php echo $view['file'][$i]['href'];  ?>" class="view_file_download">
								<img src="<?php echo $board_skin_url ?>/img/icon_file.gif" alt="첨부">
								<?php echo $view['file'][$i]['source'] ?>
								<span class='small4'><?php echo $view['file'][$i]['content'] ?> (<?php echo $view['file'][$i]['size'] ?>)</span>
							</a>
							<span class='small4'><?php echo $view['file'][$i]['download'] ?>회 다운  DATE <?php echo $view['file'][$i]['datetime'] ?></span>
					</li>
				<?php
					}
				}
			?>
				</ul>
		</section>
		<!-- } 첨부파일 끝 -->
		<?php } ?>

		<?php
		if ($view['link']) {
		?>
		<!-- 관련링크 시작 { -->
		<section id="bo_v_link" class='small'>
				<h2>관련링크</h2>
				<ul>
				<?php
				// 링크
				$cnt = 0;
				for ($i=1; $i<=count($view['link']); $i++) 
				{
					if ($view['link'][$i]) 
					{
							$cnt++;
							$link = cut_str($view['link'][$i], 70);
			?>
					<li>
							<a href="<?php echo $view['link_href'][$i] ?>" target="_blank">
								<img src="<?php echo $board_skin_url ?>/img/icon_link.gif" alt="관련링크">
								<?php echo $link ?>
							</a>
							<span class="small4"><?php echo $view['link_hit'][$i] ?>회 연결</span>
					</li>
				<?php
					}
				}
			?>
				</ul>
		</section>
		<!-- } 관련링크 끝 -->
		<?php } ?>

		<section id="bo_v_atc">
				<h2 id="bo_v_atc_title">본문</h2>

				<?php
				// 파일 출력
				$v_img_count = count($view['file']);
				if($v_img_count) 
				{
					echo "<br><div id=\"bo_v_img\" align='center'>\n";

					for ($i=0; $i<=count($view['file']); $i++) 
					{
							if ($view['file'][$i]['view']) 
							{
								//echo $view['file'][$i]['view'];
								echo get_view_thumbnail($view['file'][$i]['view']);
							}
					}
					echo "</div>\n";
				}
		 ?>

			<!-- 본문 내용 시작 { -->
			<div id="bo_v_con"><?php echo get_view_thumbnail(nl2br($view['content'])); ?></div>
			<?php//echo $view['rich_content']; // {이미지:0} 과 같은 코드를 사용할 경우 ?>
			<!-- } 본문 내용 끝 -->

			<?php if ($is_signature) { ?><p><?php echo $signature ?></p><?php } ?>

		 <!-- 스크랩 추천 비추천 시작 { -->
		 <?php if ($good_href || $nogood_href) { ?>
		 <div id="bo_v_act" class="btn_good_width">
			<?php if ($good_href) { ?>
				<li>
							<span class="bo_v_act_gng">
							<a href="<?php echo $good_href.'&amp;'.$qstr ?>" id="good_button" class="btn good"><strong><?php echo number_format($view['wr_good']) ?></strong><BR>좋아요</a>
								<b id="bo_v_act_good"></b>
					</span>
				<li>
					<?php } ?>
					<?php if ($nogood_href) { ?>
				<li>
						<span class="bo_v_act_gng">
						<a href="<?php echo $nogood_href.'&amp;'.$qstr ?>" id="nogood_button" class="btn nogood"><strong><?php echo number_format($view['wr_nogood']) ?></strong><BR>싫어요</a>
						<b id="bo_v_act_nogood"></b>
						</span>
				</li>
				<?php } ?>
		 </div>
			
		 <?php } else {
			
			if($board['bo_use_good'] || $board['bo_use_nogood']) 
			{
		 ?>
				 <div id="bo_v_act" class="btn_good_width">
					<?php if($board['bo_use_good']) { ?>
					<li><a href="javascript:alert('로그인이 필요함니다');" class="btn good"><?php echo number_format($view['wr_good'])?><BR>좋아요</a></b></li>
						<?php } ?>
						
						<?php if($board['bo_use_nogood']) { ?>
							<li><a href="javascript:alert('로그인이 필요함니다');" class="btn nogood"><?php echo number_format($view['wr_nogood'])?><BR>싫어요</a></li>
						<?php } ?>
				 </div>
		 <?php
			}
		 }
		 ?>
		 <div style="clear:both;"></div>
		 <!-- } 스크랩 추천 비추천 끝 -->

	</section>

	<div style="float:left;">
		<?php  include_once(G5_SNS_PATH."/view.sns.skin.php"); ?>
	</div>
	<?php if ($scrap_href) { ?><div style="float:left;"><a href="<?php echo $scrap_href;  ?>" target="_blank" class="btn2 s" onclick="win_scrap(this.href); return false;">스크랩</a></div><?php } ?>
	<div style="clear:both;"></div>

	<?php if($view[wr_2] != '1') { ?> 
	<div style="margin-top:20px; padding:5px 10px; background:#f8f8f8; border: 1px dashed #bbb;">
		<?php if($is_member) echo "<B>{$member[mb_nick]}</B> 님의 지식을 나누어 주세요!<br>"; ?>
		답변하시면 <b><?php echo number_format($board[bo_comment_point])?>P</b>를, 답변이 채택되면 <b><?php echo number_format($board[bo_comment_point] + $view[wr_1])?>P</b> (답변포인트 <?php echo number_format($board[bo_comment_point])?>P + 채택포인트 <?php echo number_format($view[wr_1])?>P)를 드립니다.
	</div>
	<?php } ?>

	<?php
	// 코멘트 입출력
	include_once(G5_BBS_PATH.'/view_comment.php');
	?>

	<!-- 게시물 상단 버튼 시작 -->
	<div id="bo_v_top">
		<?php
		ob_start();
		?>
		<?php if ($prev_href || $next_href) { ?>
		<ul class="bo_v_nb">
			<?php if ($prev_href) { ?><li><a href="<?php echo $prev_href ?>" class="btn2 m">이전글</a></li><?php } ?>
			<?php if ($next_href) { ?><li><a href="<?php echo $next_href ?>" class="btn2 m">다음글</a></li><?php } ?>
		</ul>
		<?php } ?>

		<ul class="bo_v_com">
			<?php if ($update_href) { ?><li><a href="<?php echo $update_href ?>" class="btn2 m">수정</a></li><?php } ?>
			<?php if ($delete_href) { ?><li><a href="<?php echo $delete_href ?>" class="btn2 m" onclick="del(this.href); return false;">삭제</a></li><?php } ?>
			<?php if ($copy_href) { ?><li><a href="<?php echo $copy_href ?>" class="btn2 m" onclick="board_move(this.href); return false;">복사</a></li><?php } ?>
			<?php if ($move_href) { ?><li><a href="<?php echo $move_href ?>" class="btn2 m" onclick="board_move(this.href); return false;">이동</a></li><?php } ?>
			<?php if ($search_href) { ?><li><a href="<?php echo $search_href ?>" class="btn2 m">검색</a></li><?php } ?>
			<li><a href="<?php echo $list_href ?>" class="btn2 m">목록</a></li>
			<?php if ($reply_href) { ?><li><a href="<?php echo $reply_href ?>" class="btn2 m">답변</a></li><?php } ?>
			<?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn m">글쓰기</a></li><?php } ?>
		</ul>
		<?php
		$link_buttons = ob_get_contents();
		ob_end_flush();
		?>
	</div>
	<!--게시물 상단 버튼 끝 -->
</article>
<!-- } 게시판 읽기 끝 -->

<script>
<?php if ($board['bo_download_point'] < 0) { ?>
$(function() {
	$("a.view_file_download").click(function() {
		if(!g5_is_member) {
			alert("다운로드 권한이 없습니다.\n회원이시라면 로그인 후 이용해 보십시오.");
			return false;
		}

		var msg = "파일을 다운로드 하시면 포인트가 차감(<?php echo number_format($board['bo_download_point']) ?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?";

		if(confirm(msg)) {
			var href = $(this).attr("href")+"&js=on";
			$(this).attr("href", href);

			return true;
		} else {
			return false;
		}
	});
});
<?php } ?>

function board_move(href)
{
	window.open(href, "boardmove", "left=50, top=50, width=500, height=550, scrollbars=1");
}
</script>

<script>
$(function() {
	$("a.view_image").click(function() {
		window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
		return false;
	});

	// 추천, 비추천
	$("#good_button, #nogood_button").click(function() {
		var $tx;
		if(this.id == "good_button")
			$tx = $("#bo_v_act_good");
		else
			$tx = $("#bo_v_act_nogood");

		excute_good(this.href, $(this), $tx);
		return false;
	});

	// 이미지 리사이즈
	$("#bo_v_atc").viewimageresize();
});

function excute_good(href, $el, $tx)
{
	$.post(
		href,
		{ js: "on" },
		function(data) {
			if(data.error) {
				alert(data.error);
				return false;
			}

			if(data.count) {
				$el.find("strong").text(number_format(String(data.count)));
				if($tx.attr("id").search("nogood") > -1) {
					$tx.text("이 글을 비추천하셨습니다.");
					$tx.fadeIn(200).delay(2500).fadeOut(200);
				} else {
					$tx.text("이 글을 추천하셨습니다.");
					$tx.fadeIn(200).delay(2500).fadeOut(200);
				}
			}
		}, "json"
	);
}
</script>
<!-- } 게시글 읽기 끝 -->