<?php
/*
by 변태스타킹
사용법
$ps['image'] 		= G5_IMG_URL."/photosphere/demo2.jpg"; 	// 이미지 파일 URL 또는 경로
$ps['id'] 			= "photosphere"; 						// 포토스피어 div id
$ps['width'] 		= 728; 									// 높이
$ps['height'] 		= 546; 									// 넓이
$ps['caption'] 		= ""; 									// 하단 툴바 캡션
$ps['download'] 	= true; 								// true = 이미지 다운로드 버튼 보임
$ps['fov'] 			= 70; 									// default field of view 30~90
$ps['mousewheel'] 	= true; 								// 마우스 휠로 줌인/아웃
$ps['time_anim'] 	= 2000; 								// 에니메이션 시작 시간 ms 또는 false

기타 옵션 설정 방법 : http://photo-sphere-viewer.js.org/#options 참고
*/
function photosphere($ps=array()){

	if(!isset($ps['image']) || empty($ps['image'])) 			$ps['image'] 		= G5_IMG_URL."/photosphere/demo.jpg";
	if(!isset($ps['id']) || empty($ps['id'])) 					$ps['id'] 			= "ps".rand(0,1000);
	if(!isset($ps['width']) || empty($ps['width'])) 			$ps['width']		= 728;
	if(!isset($ps['height']) || empty($ps['height'])) 			$ps['height'] 		= 546;
	if(!isset($ps['caption'])) 									$ps['caption'] 		= "<strong>DEMO</strong> by 변태스타킹";
	if(!isset($ps['download'])) 								$ps['download']		= true;
	if($ps['download'] === "false") 							$ps['download'] 	= false;
	if(!isset($ps['fov']) || empty($ps['fov'])) 				$ps['fov'] 			= 70;
	if(!isset($ps['mousewheel'])) 								$ps['mousewheel'] 	= true;	
	if(!isset($ps['time_anim'])) 								$ps['time_anim'] 	= 2000;
	
	echo ''.PHP_EOL;
	
	echo '<div id="'.$ps['id'].'"></div>'.PHP_EOL;
	
	add_stylesheet('<link rel="stylesheet" href="'.G5_CSS_URL.'/photosphere/photo-sphere-viewer.min.css">', 1);
	add_javascript('<script src="'.G5_JS_URL.'/photosphere/three.min.js"></script>', $order=1);
	add_javascript('<script src="'.G5_JS_URL.'/photosphere/D.min.js"></script>', $order=1);
	add_javascript('<script src="'.G5_JS_URL.'/photosphere/doT.min.js"></script>', $order=1);
	add_javascript('<script src="'.G5_JS_URL.'/photosphere/uevent.min.js"></script>', $order=1);
	add_javascript('<script src="'.G5_JS_URL.'/photosphere/CanvasRenderer.js"></script>', $order=1);
	add_javascript('<script src="'.G5_JS_URL.'/photosphere/Projector.js"></script>', $order=1);
	add_javascript('<script src="'.G5_JS_URL.'/photosphere/photo-sphere-viewer.min.js"></script>', $order=1);
	
	echo "<script>".PHP_EOL;
	echo "	var PSV = new PhotoSphereViewer({".PHP_EOL;
	echo "		panorama: '".$ps['image']."',".PHP_EOL;
	echo "		container: '".$ps['id']."',".PHP_EOL;
	echo "		caption: '".$ps['caption']."',".PHP_EOL;
	echo "		loading_img: '".G5_IMG_URL."/photosphere/photosphere-logo.gif',".PHP_EOL;
	echo "		navbar: 'autorotate zoom".($ps['download']? " download" : "")." caption fullscreen',".PHP_EOL;
	echo "		default_fov: ".$ps['fov'].",".PHP_EOL;
	echo "		mousewheel: ".($ps['mousewheel']? $ps['mousewheel'] : "false").",".PHP_EOL;
	echo "		time_anim: ".($ps['time_anim'] !== false? $ps['time_anim'] : "false").",".PHP_EOL;
	echo "		size: {".PHP_EOL;
	echo "			width: ".$ps['width'].",".PHP_EOL;
	echo "			height: ".$ps['height'].PHP_EOL;
	echo "		}".PHP_EOL;
	echo "	});".PHP_EOL;
	echo "</script>".PHP_EOL;
	
}

?>