<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
//add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>
<!-- AdminLTE Add -->
<div class="content-wrapper">
<section class="content-header">
	<h1 id="container_title"><?php echo $board['bo_subject'] ?>
		<small>Total <?php echo number_format($total_count) ?>건</small>
	</h1>
</section>

<section class="content">
	<div class="row">
		<div class="col-md-2">
			<a href="<?php echo $write_href ?>" class="btn btn-primary btn-block margin-bottom">글쓰기</a>
			<?php if($is_category) { ?>
			<!-- 게시판 카테고리 시작 { -->
			<div class="box box-solid">
				<div class="box-header width-border">
					<h3 class="box-title">Category</h3>
					
					<div class="box-tools">
						<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
						</button>
					</div>
				</div>
				<div class="box-body no-padding">
					<ul class="nav nav-pills nav-stacked" id="bo_cate_ul">
						<?php echo $category_option ?>
					</ul>
				</div>
				<!-- /.box-body -->
			</div>
			<?php } ?>
			<!-- /.box -->
			<!-- } 게시판 카테고리 끝 -->
		</div>
		<!-- /.col -->
		<div class="col-md-10">
			<div class="box box-primary">
				<div class="box-header width-border">
					<h3 class="box-totle">Inbox</h3>
					
					<div class="box-tools pull-right">
						<div class="has-feedback0">
							<input type="text" class="form-control input-sm" placeholder="Search ... ">
							<span class="glyphicon glyphicon-search form-control-feedback"></span>
						</div>
					</div>
					<!-- /.box-tools -->
				</div>
				
				<!-- /.box-header -->
				<form name="fboardlist" id="fboardlist" action="./board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
				<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
				<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
				<input type="hidden" name="stx" value="<?php echo $stx ?>">
				<input type="hidden" name="spt" value="<?php echo $spt ?>">
				<input type="hidden" name="sca" value="<?php echo $sca ?>">
				<input type="hidden" name="sst" value="<?php echo $sst ?>">
				<input type="hidden" name="sod" value="<?php echo $sod ?>">
				<input type="hidden" name="page" value="<?php echo $page ?>">
				<input type="hidden" name="sw" value="">				
				
				<div class="box-body no-padding">
					<div class="mailbox-controls">
						<!-- Check all button -->
						<button type="button" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);" class="btn btn-default btn-sm checkbox-toggle"><i class="fa fa-square-o"></i>
						</button>
						<div class="btn-group">
							<a href="<?php echo $rss_href ?>"><button type="button" class="btn btn-default btn-sm"><i class="fa fa-rss"></i></button></a>
							<a href="<?php echo $admin_href ?>"><button type="button" class="btn btn-default btn-sm"><i class="fa fa-cog"></i></button></a>
							<a href="<?php echo $write_href ?>"><button type="button" class="btn btn-default btn-sm"><i class="fa fa-pencil"></i></button></a>
						</div>
						<!-- /.btn-group -->
						<button type="button" class="btn btn-default btn-sm"><i class="fa fa-refresh"></i></button>
						<div class="pull-right">
							1-50/200
							<div class="btn-group">
								<button type="button" class="btn btn-default btn-sm"><i class="fa fa-chevron-left"></i></button>
								<button type="button" class="btn btn-default btn-sm"><i class="fa fa-chevron-right"></i></button>
							</div>
							<!-- /.btn-group -->
						</div>	
						<!-- /.pull-right -->
					</div>
					<div class="table-responsive mailbox-messages">
						<table class="table table-hover table-striped">
							<thead>
								<tr>
									<th scope="col">번호</th>
									<?php if($is_checkbox) { ?>
									<th scope="col">
										<label for="chkall" class="sound_only">현재 페이지 게시물 전체</label>
									</th>
									<?php } ?>
									<th scope="col">제목</th>
									<th scope="col">글쓴이</th>
									<th scope="col">날짜</th>
									<th scope="col">조회</th>
									<?php if ($is_good) { ?><th scope="col"><?php echo subject_sort_link('wr_good', $qstr2, 1) ?>추천</a></th><?php } ?>
									<?php if ($is_nogood) { ?><th scope="col"><?php echo subject_sort_link('wr_nogood', $qstr2, 1) ?>비추천</a></th><?php } ?>
								</tr>
							</thead>
							<tbody>
							<? 
							for($i = 0; $i < count($list); $i++) { 
							?>
							<tr class="<?php if($list[$i]['is_notice']) echo "bo_notice"; ?>">
								<td class="mailbox-attachment">
								<?php
									if($list[$i]['is_notice']) //공지사항
										echo '<strong>공지</strong>';
									else if($wr_id == $list[$i]['wr_id'])
										echo '<span class="bo_current">열람중</span>';
									else
										echo $list[$i]['num'];
								?>
								</td>
								<?php if($is_checkbox) { ?>
								<td>
									<label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
									<input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
								</td>
								<?php } ?>
								<td class="mailbox-subject">
									<?php
										echo $list[$i]['icon_reply'];
										if($is_category && $list[$i]['ca_name']) {
									?>
									<a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a>
									<?php } ?>
									<a href="<?php echo $list[$i]['href'] ?>">
										<?php echo $list[$i]['subject'] ?>
										<?php if($list[$i]['comment_cnt']) { ?>
											<span class="sound_only">댓글</span>
											<?php echo $list[$i]['comment_cnt']; ?><span class="sound_only">개</span>
										<?php } ?>
									</a>
									
									<?php
									
									if(isset($list[$i]['icon_new'])) echo $list[$i]['icon_new'];
									if(isset($list[$i]['icon_hot'])) echo $list[$i]['icon_hot'];
									if(isset($list[$i]['icon_file'])) echo $list[$i]['icon_file'];
									if(isset($list[$i]['icon_link'])) echo $list[$i]['icon_link'];
									if(isset($list[$i]['icon_secret'])) echo $list[$i]['icon_secret'];
						
									?>
								</td>
								<td class="mailbox-name"><?php echo $list[$i]['name'] ?></td>
								<td class="mailbox-date"><?php echo $list[$i]['datetime2'] ?></td>
								<td class="mailbox-attachment"><?php echo $list[$i]['wr_hit'] ?></td>
								<?php if ($is_good) { ?><td class="mailbox-attachment"><?php echo $list[$i]['wr_good'] ?></td><?php } ?>
								<?php if ($is_nogood) { ?><td class="mailbox-attachment"><?php echo $list[$i]['wr_nogood'] ?></td><?php } ?>
							</tr>
							<?php } ?>
							<?php if (count($list) == 0) {
								echo '<tr><td class="mailbox-subject" colspan="' . $colspan . '">게시물이 없습니다</td></tr>'; 
							} ?>
							</tbody>
						</table>
						<!-- /.table -->
					</div>
					<!-- /.mail-box-messages -->
				</div>
				<!-- /.box-body -->
				<?php if ($list_href || $is_checkbox || $write_href) { ?>
				<div class="box-footer no-padding">
					<?php if ($is_checkbox) { ?>
					<div class="mailbox-controls">
						<!-- Check all button -->
						<button type="button" class="btn btn-default btn-sm checkbox-toggle"><i class="fa fa-square-o"></i>
						</button>
						<div class="btn-group">
							<button type="submit" name="btn_submit" class="btn btn-default btn-sm" onclick="document.pressed=this.value"><i class="fa fa-trash-o"></i></button>
							<button type="submit" name="btn_submit" class="btn btn-default btn-sm" onclick="document.pressed=this.value"><i class="fa fa-files-o"></i></button>
							<button type="submit" name="btn_submit" class="btn btn-default btn-sm" onclick="document.pressed=this.value"><i class="fa fa-share"></i></button>
						</div>
					</div>
					<?php } ?>
				</div>
				<?php } ?>
				</form>
			</div>
		</div>
	</div>
</section>
						
<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<!-- 페이지 -->
<?php echo $write_pages;  ?>

<!-- 게시판 검색 시작 { -->

<!-- } 게시판 검색 끝 -->

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = "./board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = "./move.php";
    f.submit();
}
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->

</section>
</div>
