<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once($board_skin_path.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<link rel="stylesheet" type="text/css" href="<?php echo $board_skin_url?>/css/style.css" />
<link rel="stylesheet" type="text/css" href="<?php echo $board_skin_url?>/cloud-zoom/cloud-zoom.css" />
<link rel="stylesheet" type="text/css" href="<?php echo $board_skin_url?>/fancybox/jquery.fancybox-1.3.4.css" />
<script src="<?php echo $board_skin_url?>/js/cufon-yui.js" type="text/javascript"></script>

<h2 id="container_title"><?php echo $board['bo_subject'] ?><span class="sound_only"> 목록</span></h2>

<!-- 게시판 목록 시작 { -->
<div id="bo_list" style="width:<?php echo $width; ?>">

    <!-- 게시판 카테고리 시작 { -->
    <?php if ($is_category) { ?>
    <nav id="bo_cate">
        <h2><?php echo $board['bo_subject'] ?> 카테고리</h2>
        <ul id="bo_cate_ul">
            <?php echo $category_option ?>
        </ul>
    </nav>
    <?php } ?>
    <!-- } 게시판 카테고리 끝 -->

    <!-- 게시판 페이지 정보 및 버튼 시작 { -->
    <div class="bo_fx">
        <div id="bo_list_total">
            <span>Total <?php echo number_format($total_count) ?>건</span>
            <?php echo $page ?> 페이지
        </div>

        <?php if ($rss_href || $write_href) { ?>
        <ul class="btn_bo_user">
            <?php if ($is_checkbox) { ?>
            <li><label for="chkall" class="sound_only">현재 페이지 게시물 전체</label>
            <input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);"></li>
            <?php } ?>
            <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01">RSS</a></li><?php } ?>
            <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin">관리자</a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02">글쓰기</a></li><?php } ?>
        </ul>
        <?php } ?>
    </div>
    <!-- } 게시판 페이지 정보 및 버튼 끝 -->

    <form name="fboardlist" id="fboardlist" action="./board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="sw" value="">

    <div class="item_tbl_wrap">
        <?php
        for ($i=0; $i<count($list); $i++) {
         ?>

				<div class="item">
         			<div class="line"></div>
					<div class="thumb_wrapper">
						<div class="thumb">
							<ul>
                                <?php
                                    $thumb0 = get_list_thumbnail_bf_no($board['bo_table'], $list[$i]['wr_id'], $board['bo_gallery_width'], $board['bo_gallery_height'], false, true, 'center', false, '80/0.5/3', 0);
                                    $thumb0_1 = get_list_thumbnail_bf_no($board['bo_table'], $list[$i]['wr_id'], ($board['bo_gallery_width'] * 3), ($board['bo_gallery_height'] * 3), false, true, 'center', false, '80/0.5/3', 0);

                                    if($thumb0['src']) {
                                        $img_content0 = '<img src="'.$thumb0['src'].'" alt="'.$thumb0['alt'].'" width="'.$board['bo_gallery_width'].'" height="'.$board['bo_gallery_height'].'">';
                                    } else {
                                        $img_content0 = '<span style="width:'.$board['bo_gallery_width'].'px;height:'.$board['bo_gallery_height'].'px">no image</span>';
                                    }                                    
                                 ?>
								<li><a rev="group1" rel="zoomHeight:200, zoomWidth:400, adjustX: 10, adjustY:-4, position:'body'" class='cloud-zoom' href="<?php echo $thumb0_1['src']?>"><?php echo $img_content0;?></a></li>
                                <?php
                                    $thumb1 = get_list_thumbnail_bf_no($board['bo_table'], $list[$i]['wr_id'], $board['bo_gallery_width'], $board['bo_gallery_height'], false, true, 'center', false, '80/0.5/3', 1);
                                    $thumb1_1 = get_list_thumbnail_bf_no($board['bo_table'], $list[$i]['wr_id'], ($board['bo_gallery_width'] * 3), ($board['bo_gallery_height'] * 3), false, true, 'center', false, '80/0.5/3', 1);

                                    if($thumb0['src']) {
                                        $img_content1 = '<img src="'.$thumb1['src'].'" alt="'.$thumb1['alt'].'" width="'.$board['bo_gallery_width'].'" height="'.$board['bo_gallery_height'].'">';
                                    } else {
                                        $img_content1 = '<span style="width:'.$board['bo_gallery_width'].'px;height:'.$board['bo_gallery_height'].'px">no image</span>';
                                    }                                    
                                 ?>
								<li><a rev="group1" rel="zoomHeight:200, zoomWidth:400, adjustX: 10, adjustY:-4, position:'body'" class='cloud-zoom' href="<?php echo $thumb1_1['src']?>"><?php echo $img_content1;?></a></li>
                                <?php
                                    $thumb2 = get_list_thumbnail_bf_no($board['bo_table'], $list[$i]['wr_id'], $board['bo_gallery_width'], $board['bo_gallery_height'], false, true, 'center', false, '80/0.5/3', 2);
                                    $thumb2_1 = get_list_thumbnail_bf_no($board['bo_table'], $list[$i]['wr_id'], ($board['bo_gallery_width'] * 3), ($board['bo_gallery_height'] * 3), false, true, 'center', false, '80/0.5/3', 2);

                                    if($thumb2['src']) {
                                        $img_content2 = '<img src="'.$thumb2['src'].'" alt="'.$thumb2['alt'].'" width="'.$board['bo_gallery_width'].'" height="'.$board['bo_gallery_height'].'">';
                                    } else {
                                        $img_content2 = '<span style="width:'.$board['bo_gallery_width'].'px;height:'.$board['bo_gallery_height'].'px">no image</span>';
                                    }                                    
                                 ?>
								<li><a rev="group1" rel="zoomHeight:200, zoomWidth:400, adjustX: 10, adjustY:-4, position:'body'" class='cloud-zoom' href="<?php echo $thumb2_1['src']?>"><?php echo $img_content2;?></a></li>
							</ul>
						</div>
						<a class="prev" href="#"></a>
						<a class="next" href="#"></a>
						<span>
                            <?php
                            echo $list[$i]['icon_reply'];
                            if ($is_category && $list[$i]['ca_name']) {
                             ?>
                            <a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a>
                            <?php } ?>                        
                        </span>
					</div>
					<div class="description">
						<h2>
                            <?php
                            if ($list[$i]['is_notice']) // 공지사항
                                echo '<strong>공지</strong>';
                            else if ($wr_id == $list[$i]['wr_id'])
                                echo "<span class=\"bo_current\">열람중</span>";
                            else
                                echo '['.$list[$i]['num'].']';
                             ?>
                            <?php if ($is_checkbox) { ?>
                                <label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
                                <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
                            <?php } ?>
                            <a href="<?php echo $list[$i]['href'] ?>">
                                <?php echo $list[$i]['subject'] ?>
                                <?php if ($list[$i]['comment_cnt']) { ?><span class="sound_only">댓글</span><?php echo $list[$i]['comment_cnt']; ?><span class="sound_only">개</span><?php } ?>
                            </a>
                            <?php
                            // if ($list[$i]['link']['count']) { echo '['.$list[$i]['link']['count']}.']'; }
                            // if ($list[$i]['file']['count']) { echo '<'.$list[$i]['file']['count'].'>'; }

                            if (isset($list[$i]['icon_new'])) echo $list[$i]['icon_new'];
                            if (isset($list[$i]['icon_hot'])) echo $list[$i]['icon_hot'];
                            if (isset($list[$i]['icon_file'])) echo $list[$i]['icon_file'];
                            if (isset($list[$i]['icon_link'])) echo $list[$i]['icon_link'];
                            if (isset($list[$i]['icon_secret'])) echo $list[$i]['icon_secret'];
                            ?>                            
                        </h2>
						<p>
                            <?php echo $list[$i]['wr_content'] ?>
                        </p>
                        <div>
                            <?php echo $list[$i]['name'] ?> | <?php echo $list[$i]['datetime2'] ?> | <?php echo $list[$i]['wr_hit'] ?>
                            <?php if ($is_good) { ?> | <?php echo $list[$i]['wr_good'] ?><?php } ?>
                            <?php if ($is_nogood) { ?> | <?php echo $list[$i]['wr_nogood'] ?><?php } ?>
                        </div>
					</div>
				</div>
        <?php } ?>
        <?php if (count($list) == 0) { echo '<div class="item">게시물이 없습니다.</div>'; } ?>
    </div>
    
    <div class="clearfix"></div>
    <div class="h30"></div>

    <?php if ($list_href || $is_checkbox || $write_href) { ?>
    <div class="bo_fx">
        <?php if ($is_checkbox) { ?>
        <ul class="btn_bo_adm">
            <li><input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"></li>
            <li><input type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value"></li>
            <li><input type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value"></li>
        </ul>
        <?php } ?>

        <?php if ($list_href || $write_href) { ?>
        <ul class="btn_bo_user">
            <?php if ($list_href) { ?><li><a href="<?php echo $list_href ?>" class="btn_b01">목록</a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02">글쓰기</a></li><?php } ?>
        </ul>
        <?php } ?>
    </div>
    <?php } ?>
    </form>
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<!-- 페이지 -->
<?php echo $write_pages;  ?>

<!-- 게시판 검색 시작 { -->
<fieldset id="bo_sch">
    <legend>게시물 검색</legend>

    <form name="fsearch" method="get">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sop" value="and">
    <label for="sfl" class="sound_only">검색대상</label>
    <select name="sfl" id="sfl">
        <option value="wr_subject"<?php echo get_selected($sfl, 'wr_subject', true); ?>>제목</option>
        <option value="wr_content"<?php echo get_selected($sfl, 'wr_content'); ?>>내용</option>
        <option value="wr_subject||wr_content"<?php echo get_selected($sfl, 'wr_subject||wr_content'); ?>>제목+내용</option>
        <option value="mb_id,1"<?php echo get_selected($sfl, 'mb_id,1'); ?>>회원아이디</option>
        <option value="mb_id,0"<?php echo get_selected($sfl, 'mb_id,0'); ?>>회원아이디(코)</option>
        <option value="wr_name,1"<?php echo get_selected($sfl, 'wr_name,1'); ?>>글쓴이</option>
        <option value="wr_name,0"<?php echo get_selected($sfl, 'wr_name,0'); ?>>글쓴이(코)</option>
    </select>
    <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
    <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="frm_input required" size="15" maxlength="20">
    <input type="submit" value="검색" class="btn_submit">
    </form>
</fieldset>
<!-- } 게시판 검색 끝 -->

<!-- The JavaScript -->
<!-- <script type="text/javascript" src="http://code.jquery.com/jquery-1.4.4.min.js"></script> -->
<script type="text/javascript" src="<?php echo $board_skin_url?>/fancybox/jquery.easing-1.3.pack.js"></script>
<script type="text/javascript" src="<?php echo $board_skin_url?>/fancybox/jquery.fancybox-1.3.4.js"></script>
<script type="text/javascript" src="<?php echo $board_skin_url?>/cloud-zoom/cloud-zoom.1.0.2.js"></script>
<script type="text/javascript">
    $(function() {
        /*
        fancybox init on each cloud-zoom element
         */
        $("#bo_list .cloud-zoom").fancybox({
            'transitionIn'	:	'elastic',
            'transitionOut'	:	'none',
            'speedIn'		:	600,
            'speedOut'		:	200,
            'overlayShow'	:	true,
            'overlayColor'	:	'#000',
            'cyclic'		:	true,
            'easingIn'		:	'easeInOutExpo'
        });

        /*
        because the cloud zoom plugin draws a mousetrap
        div on top of the image, the fancybox click needs
        to be changed. What we do here is to trigger the click
        the fancybox expects, when we click the mousetrap div.
        We know the mousetrap div is inserted after
        the <a> we want to click:
         */
        $("#bo_list .mousetrap").live('click',function(){
            $(this).prev().trigger('click');
        });

        /*
        the content element;
        each list item / group with several images
         */
        var $content	= $('#bo_list'),
        $thumb_list = $content.find('.thumb > ul');
        /*
        we need to set the width of each ul (sum of the children width);
        we are also defining the click events on the right and left arrows
        of each item.
         */
        $thumb_list.each(function(){
            var $this_list	= $(this),
            total_w		= 0,
            loaded		= 0,
            //preload all the images first
            $images		= $this_list.find('img'),
            total_images= $images.length;
            $images.each(function(){
                var $img	= $(this);
                $('<img/>').load(function(){
                    ++loaded;
                    if (loaded == total_images){
                        $this_list.data('current',0).children().each(function(){
                            total_w	+= $(this).width();
                        });
                        $this_list.css('width', total_w + 'px');

                        //next / prev events

                        $this_list.parent()
                        .siblings('.next')
                        .bind('click',function(e){
                            var current = $this_list.data('current');
                            if(current == $this_list.children().length -1) return false;
                            var	next	= ++current,
                            ml		= -next * $this_list.children(':first').width();

                            $this_list.data('current',next)
                            .stop()
                            .animate({
                                'marginLeft'	: ml + 'px'
                            },400);
                            e.preventDefault();
                        })
                        .end()
                        .siblings('.prev')
                        .bind('click',function(e){
                            var current = $this_list.data('current');
                            if(current == 0) return false;
                            var	prev	= --current,
                            ml		= -prev * $this_list.children(':first').width();

                            $this_list.data('current',prev)
                            .stop()
                            .animate({
                                'marginLeft'	: ml + 'px'
                            },400);
                            e.preventDefault();
                        });
                    }
                }).attr('src',$img.attr('src'));
            });
        });
    });
</script>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = "./board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = "./move.php";
    f.submit();
}
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
