<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 2;

if ($is_checkbox) $colspan++;
/*  
공부하는이 : 정적인손님
스킨명 : 그누보드5 용 네이버지도를 이용한 네이버맵 멀티마커 게시판 스킨 모바일버전
버전 : 1.0.1
공유범위 : 수정배포 적극권장

<script type="text/javascript" src="https://openapi.map.naver.com/openapi/v3/maps.js?clientId=네이버API키&amp;submodules=panorama,geocoder,drawing,visualization"></script>

*/
// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
$navermapkey = '네이버API키';
?>
<script type="text/javascript" src="https://openapi.map.naver.com/openapi/v3/maps.js?clientId=<?php echo $navermapkey ?>&amp;submodules=panorama,geocoder,drawing,visualization"></script>
<script type="text/javascript" src="<?php echo $board_skin_url ?>/MarkerOverlappingRecognizer.js"></script>

<h2 id="container_title"><?php echo ($board['bo_mobile_subject'] ? $board['bo_mobile_subject'] : $board['bo_subject']) ?><span class="sound_only"> 목록</span></h2>

<!-- 게시판 목록 시작 -->
<div id="bo_list<?php if ($is_admin) echo "_admin"; ?>">

    <?php if ($is_category) { ?>
    <nav id="bo_cate">
        <h2><?php echo ($board['bo_mobile_subject'] ? $board['bo_mobile_subject'] : $board['bo_subject']) ?> 카테고리</h2>
        <ul id="bo_cate_ul">
            <?php echo $category_option ?>
        </ul>
    </nav>
    <?php } ?>

    <div class="bo_fx">
        <div id="bo_list_total">
            <span>Total <?php echo number_format($total_count) ?>건</span>
            <?php echo $page ?> 페이지
        </div>

        <?php if ($rss_href || $write_href) { ?>
        <ul class="btn_bo_user">
            <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01">RSS</a></li><?php } ?>
            <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin">관리자</a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02">글쓰기</a></li><?php } ?>
        </ul>
        <?php } ?>
        
        <div id="map" style="width:100%;height:300px;"></div>
    
<script>
    var MARKER_ICON_URL = '<?php echo $board_skin_url ?>/img/mapicon001.png';
    var MARKER_HIGHLIGHT_ICON_URL = '<?php echo $board_skin_url ?>/img/mapicon002.png';
    
    var MARKER_SPRITE_POSITION = {
	
		<?php for ($i=0; $i<count($list); $i++) {
	$yti=($list[$i][subject]);		
	$ylink="<a href='{$list[$i]['href']}'>{$yti}</a>";
	$ylat=($list[$i][wr_3]);
	$ylng=($list[$i][wr_4]);
	?>
	<?php if ($list[$i]['subject']){ ?>
	"<?php echo $yti?>": [<?php echo $ylat?>, <?php echo $ylng?>,"<?php echo $ylink?>"]
	<?php }?>
	<?php if ($i==count($list)-1) continue; ?>
	<?php if ($list[$i]['subject']){ ?>
	,
	<?php } ?>
	<?php } ?>

    };
	

    var position = new naver.maps.LatLng(37.5164414, 126.9839501);
	
	var mapOptions = {
		//zoom: 7,
		center: position,
		mapTypeControl: true,
		mapTypeControlOptions: {
			style: naver.maps.MapTypeControlStyle.BUTTON,
			position: naver.maps.Position.TOP_LEFT
		},
		zoomControl: true,
		zoomControlOptions: {
			style: naver.maps.ZoomControlStyle.SMALL,
			position: naver.maps.Position.BOTTOM_RIGHT
		},
		scaleControl: true,
		scaleControlOptions: {
			position: naver.maps.Position.RIGHT_CENTER
		},
		logoControl: true,
		logoControlOptions: {
			position: naver.maps.Position.TOP_LEFT
		},
		mapDataControl: true,
		mapDataControlOptions: {
			position: naver.maps.Position.BOTTOM_LEFT
		}
	};

	var map = new naver.maps.Map(document.getElementById('map'),mapOptions);
	
	var bounds = map.getBounds(),
    southWest = bounds.getSW(),
    northEast = bounds.getNE(),
    lngSpan = northEast.lng() - southWest.lng(),
    latSpan = northEast.lat() - southWest.lat();
	
	var markers = [], infoWindows = [];

    var recognizer = new MarkerOverlappingRecognizer({
        highlightRect: false,
        tolerance: 15
    });
    recognizer.setMap(map);

    function highlightMarker(marker) {
        var icon = marker.getIcon();

        if (icon.url !== MARKER_HIGHLIGHT_ICON_URL) {
            icon.url = MARKER_HIGHLIGHT_ICON_URL;
            marker.setIcon(icon);
        }

        marker.setZIndex(1000);
    }

    function unhighlightMarker(marker) {
        var icon = marker.getIcon();

        if (icon.url === MARKER_HIGHLIGHT_ICON_URL) {
            icon.url = MARKER_ICON_URL;
            marker.setIcon(icon);
        }

        marker.setZIndex(100);
    }
	
	

    for (var key in MARKER_SPRITE_POSITION) {
		
		var position = new naver.maps.LatLng(MARKER_SPRITE_POSITION[key][0], MARKER_SPRITE_POSITION[key][1]);

        var marker = new naver.maps.Marker({
            map: map,
            position: position,
            title: key,
            icon: {
                url: MARKER_ICON_URL,
                size: new naver.maps.Size(50, 50),
                anchor: new naver.maps.Point(25, 25),
                origin: new naver.maps.Point(0, 0)
            },
            
            zIndex: 100
        });
		
		var infoWindow = new naver.maps.InfoWindow({
			maxWidth: 120,
        content: '<div style="width:80px;text-align:center;padding:5px;">'+ MARKER_SPRITE_POSITION[key][2] +'</div>'
    	});
	
		markers.push(marker);
		infoWindows.push(infoWindow);

		marker.addListener('mouseover', function(e) {
			highlightMarker(e.overlay);
		});
	
		marker.addListener('mouseout', function(e) {
			unhighlightMarker(e.overlay);
		});
	
		recognizer.add(marker);
		window.MARKER = marker;
	};
	
	naver.maps.Event.addListener(map, 'zoom_changed', function() {
		updateMarkers(map, markers);
	});
	
	naver.maps.Event.addListener(map, 'dragend', function() {
		updateMarkers(map, markers);
	});

	function updateMarkers(map, markers) {
		var mapBounds = map.getBounds();
		var marker, position;
		for (var i = 0; i < markers.length; i++) {
			marker = markers[i]
			position = marker.getPosition();
			if (mapBounds.hasLatLng(position)) {
				showMarker(map, marker);
			} else {
            	hideMarker(map, marker);
			}
		}

	}

	function showMarker(map, marker) {
		if (marker.setMap()) return;
		marker.setMap(map);
	}

	function hideMarker(map, marker) {
		if (!marker.setMap()) return;
		marker.setMap(null);
	}
	
	function getClickHandler(seq) {
		return function(e) {
			var marker = markers[seq],
			infoWindow = infoWindows[seq];
			if (infoWindow.getMap()) {
				infoWindow.close();
			} else {
				infoWindow.open(map, marker);
			}
		}
	}

	for (var i=0, ii=markers.length; i<ii; i++) {
		naver.maps.Event.addListener(markers[i], 'click', getClickHandler(i));
	}


    var overlapCoverMarker = null;

    naver.maps.Event.addListener(recognizer, 'overlap', function(list) {
        if (overlapCoverMarker) {
            unhighlightMarker(overlapCoverMarker);
        }

        overlapCoverMarker = list[0].marker;

        naver.maps.Event.once(overlapCoverMarker, 'mouseout', function() {
            highlightMarker(overlapCoverMarker);
        });
    });

    naver.maps.Event.addListener(recognizer, 'clickItem', function(e) {
        recognizer.hide();

        if (overlapCoverMarker) {
            unhighlightMarker(overlapCoverMarker);

            overlapCoverMarker = null;
        }
    });

    map.setZoom(7);
</script>
    </div>

    <form name="fboardlist" id="fboardlist" action="./board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="sw" value="">
    
    


    <div class="tbl_head01 tbl_wrap">
        <table>
        <thead>
        <tr>
            <?php if ($is_checkbox) { ?>
            <th scope="col">
                <label for="chkall">현재 페이지 게시물 전체</label>
                <input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);">
            </th>
            <?php } ?>
            <th scope="col">제목</th>
            <th scope="col"><?php echo subject_sort_link('wr_datetime', $qstr2, 1) ?>날짜</a></th>
        </tr>
        </thead>
        <tbody>
        <?php
        for ($i=0; $i<count($list); $i++) {
        ?>
        <tr class="<?php if ($list[$i]['is_notice']) echo "bo_notice"; ?>">
            <?php if ($is_checkbox) { ?>
            <td class="td_chk">
                <label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
                <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
            </td><?php } ?>
            <td class="td_subject">
                <?php
                echo $list[$i]['icon_reply'];
                if ($is_category && $list[$i]['ca_name']) {
                ?>
                <a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a>
                <?php } ?>

                <a href="<?php echo $list[$i]['href'] ?>">
                    <?php echo $list[$i]['subject'] ?>
                    <?php if ($list[$i]['comment_cnt']) { ?><span class="sound_only">댓글</span><?php echo $list[$i]['comment_cnt']; ?><span class="sound_only">개</span><?php } ?>
                    <?php
                    // if ($list[$i]['link']['count']) { echo '['.$list[$i]['link']['count']}.']'; }
                    // if ($list[$i]['file']['count']) { echo '<'.$list[$i]['file']['count'].'>'; }

                    if (isset($list[$i]['icon_new'])) echo $list[$i]['icon_new'];
                    if (isset($list[$i]['icon_hot'])) echo $list[$i]['icon_hot'];
                    if (isset($list[$i]['icon_file'])) echo $list[$i]['icon_file'];
                    if (isset($list[$i]['icon_link'])) echo $list[$i]['icon_link'];
                    if (isset($list[$i]['icon_secret'])) echo $list[$i]['icon_secret'];

                    ?>
                </a>

            </td>
            <td class="td_date"><?php echo $list[$i]['datetime2'] ?></td>
        </tr>
        <?php } ?>
        <?php if (count($list) == 0) { echo '<tr><td colspan="'.$colspan.'" class="empty_table">게시물이 없습니다.</td></tr>'; } ?>
        </tbody>
        </table>
    </div>

    <?php if ($list_href || $is_checkbox || $write_href) { ?>
    <div class="bo_fx">
        <ul class="btn_bo_adm">
            <?php if ($list_href) { ?>
            <li><a href="<?php echo $list_href ?>" class="btn_b01"> 목록</a></li>
            <?php } ?>
            <?php if ($is_checkbox) { ?>
            <li><input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"></li>
            <li><input type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value"></li>
            <li><input type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value"></li>
            <?php } ?>
        </ul>

        <ul class="btn_bo_user">
            <li><?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="btn_b02">글쓰기</a><?php } ?></li>
        </ul>
    </div>
    <?php } ?>
    </form>
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<!-- 페이지 -->
<?php echo $write_pages; ?>

<fieldset id="bo_sch">
    <legend>게시물 검색</legend>

    <form name="fsearch" method="get">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sop" value="and">
    <label for="sfl" class="sound_only">검색대상</label>
    <select name="sfl">
        <option value="wr_subject"<?php echo get_selected($sfl, 'wr_subject', true); ?>>제목</option>
        <option value="wr_content"<?php echo get_selected($sfl, 'wr_content'); ?>>내용</option>
        <option value="wr_subject||wr_content"<?php echo get_selected($sfl, 'wr_subject||wr_content'); ?>>제목+내용</option>
        <option value="mb_id,1"<?php echo get_selected($sfl, 'mb_id,1'); ?>>회원아이디</option>
        <option value="mb_id,0"<?php echo get_selected($sfl, 'mb_id,0'); ?>>회원아이디(코)</option>
        <option value="wr_name,1"<?php echo get_selected($sfl, 'wr_name,1'); ?>>글쓴이</option>
        <option value="wr_name,0"<?php echo get_selected($sfl, 'wr_name,0'); ?>>글쓴이(코)</option>
    </select>
    <input name="stx" value="<?php echo stripslashes($stx) ?>" placeholder="검색어(필수)" required id="stx" class="required frm_input" size="15" maxlength="20">
    <input type="submit" value="검색" class="btn_submit">
    </form>
</fieldset>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = "./board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == 'copy')
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = "./move.php";
    f.submit();
}
</script>
<?php } ?>
<!-- 게시판 목록 끝 -->
