<?php
include_once('./_common.php');

$cfname = basename(__FILE__);
$cpath = strstr(realpath(__FILE__), '/'.$cfname, true); // PHP 5.3.0부터 //파일 이름을 뺀 절대 경로 -kss--
$cdir = str_replace(G5_PATH, "", $cpath);

$today = getdate(); // 오늘의 달력 일때
if ((int)$year < 1900 || (int)$year > 2200) $year = $today['year'];
if ((int)$month < 1 || (int)$month > 12) $month = $today['mon'];
$dayweek = date("w", mktime(0,0,0,$month,1,$year)); //1일 시작 요일

include_once(G5_PATH.$cdir . '/moonday.php'); // 석봉운님의 음력날짜 함수
list($md[1]) = febdays($year);

$daystyle = array();
$linkday  = array();
$disp_lun = array();
$annivday = array();

$annivsolar = @file(G5_PATH . $cdir . '/anniv_solar.txt') or $annivsolar = array('양력 기념일 파일 없음.'); //양력 기념일 파일
$annivlunar = @file(G5_PATH . $cdir . '/anniv_lunar.txt') or $annivlunar = array('음력 기념일 파일 없음.'); //음력 기념일 파일
$is_lunar = false; //양력 기념일 부터
foreach(array_merge($annivsolar, $annivlunar) as $annivtxt) {
	if (eregi('양력', $annivtxt)) $is_lunar = false; //양력 글자가 포함되어 있으면 그때부터 양력 기념일 시작
	if (eregi('음력', $annivtxt)) $is_lunar = true; //음력 글자가 포함되어 있으면 그때부터 음력 기념일 시작
	$arrDay = explode('|', $annivtxt);
	for ($i=0 ; $i < sizeof($arrDay) ; $i++) $arrDay[$i] = trim($arrDay[$i]);
	$mdate = preg_split('/[\s\/-]/i', $arrDay[0]);
	
	$sol = array('year' => $year, 'month' => (int)$mdate[count($mdate)-2], 'day' => (int)$mdate[count($mdate)-1]);
	if (count($mdate) == 3 && (int)$mdate[0] > 1900) $sol['year'] = (int)$mdate[0];
	
	if ($is_lunar && is_numeric($mdate[0]) && is_numeric($mdate[1])) {
		for ($i = $year - 1 ; $i < $year + 2 ; $i++) {
			$sol = luntosol($i, (int)$mdate[0], (int)$mdate[1]); // 석봉운님의 음력날짜 변수선언
			if ($year == $sol['year'] && $month == $sol['month']) {
				$disp_lun[$sol['day']] = " &nbsp; (음){$arrDay[0]}";
				break;
			}
		}
	}
	if ($year == $sol['year'] && $month == $sol['month']) {
		$annivday[$sol['day']] .= "\n<br><font color=\"{$arrDay[2]}\">{$arrDay[1]}</font>";
		if ($arrDay[2] == 'red') $daystyle[$sol['day']] = ' style="color:red"'; // 공휴일은 날짜를 빨간색으로 표시
	}
}

//테이블 없으면-b-
if (!$bo_table) {
	$board_skin_url = get_skin_url('board', 'basic');	
} else { //테이블 있으면-b-
	if (!$board['bo_table']) {
		alert('존재하지 않는 게시판입니다.', G5_URL.$cdir.'/'.$cfname);
	}
	
    include_once(G5_PATH.$cdir.'/g5_board_part1.php'); //g5 원본 일부분 가져오기 // 해당 게시판 읽기 권한
	
	if (!$sfl) {
		$sfl = 'wr_5,1';
	}
	//링크 날짜
	for ($iday = 1 ; $iday <= $md[$month-1] ; $iday++) {
		$f_date = $year."-".sprintf("%02d",$month)."-".sprintf("%02d",$iday);
		$linkday[$iday] = G5_BBS_URL."/board.php?bo_table={$bo_table}&s_wr_1_ge=".$f_date
						. "&s_wr_1_le=".urlencode($f_date." 23:59:59")."&sfl=".urlencode($sfl); //wr_1 을 날짜 필드로 사용
	}
	
	$k_srh1 = ""; // 글쎄 필요 할까 ?
	$sfl_a = explode(',', $sfl);
	
	//내용 가져오기
	$sql1 = "Select Distinct Left(`{$sfl_a[0]}`, 9) as `wr_sfl`, Left(wr_1, 10) as `wr_ymd` FROM `{$write_table}`"
		. " Where Left(`wr_1`, 7) = '{$year}-".sprintf("%02d",$month)."' and wr_is_comment = 0" . $k_srh1;
	$result = sql_query($sql1);
	
	// 내용을 보여주는 부분
	while ($row = sql_fetch_array($result)) {  // 제목글 뽑아서 링크 문자열 만들기..
		$iday = (int)iconv_substr($row['wr_ymd'], -2);
		$annivday[$iday] .= "\n<br><a href=\"{$linkday[$iday]}"
			. "&stx=" . urlencode($row['wr_sfl']) . "\">" . $row['wr_sfl'] . "</a>";
	}
}
//테이블 있으면-e-

include_once(G5_PATH . '/_head.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);

if (!$width) $width = 100;
$col_width = round($width / 7); //표의 가로 폭
$tmp1 = ($width <= 100) ? '%' : 'px';
$width .= $tmp1;
$col_width .= $tmp1;
$col_height= 90 ; // 표의 세로 폭

$pre_next = array_fill(0, 5, "?bo_table={$bo_table}");
$pre_next[1] .= "&year=" . ($year-1)."&month=".$month;
$pre_next[2] .= "&year=" . (($month == 1) ? ($year-1)."&month=12" : $year."&month=".($month-1));
$pre_next[3] .= "&year=" . (($month == 12) ? ($year+1)."&month=1" : $year."&month=".($month+1));
$pre_next[4] .= "&year=" . ($year+1)."&month=".$month;
?>

<style>
	table {border-collapse:collapse;background:#fff}
	th { border:1px solid #bbb }
	td { border:1px solid #bbb;vertical-align:top }
	.blank { background:#f8f8fa }
</style>


<!-- 게시판 페이지 정보 및 버튼 시작 { -->
<div>
	<ul class="btn_bo_adm">
		<li><a href="<?php echo $pre_next[0] ?>" class="btn_b02 btn"><i class="fa fa-user-circle" aria-hidden="true"></i> 오늘로</a></li>
		<?php if ($list_href) { ?><li><a href="<?php echo $list_href ?>" class="btn_b01 btn"><i class="fa fa-list" aria-hidden="true"></i> 목록 &nbsp;</a></li><?php } ?>
	</ul>
	
	<?php if ($rss_href || $write_href) { ?>
	<ul class="btn_bo_user">
		<?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01 btn"><i class="fa fa-rss" aria-hidden="true"></i> RSS</a></li><?php } ?>
		<?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin btn"><i class="fa fa-user-circle" aria-hidden="true"></i> 관리자</a></li><?php } ?>
		<?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02 btn"><i class="fa fa-pencil" aria-hidden="true"></i> 글쓰기</a></li><?php } ?>
	</ul>
	<?php } ?>
	
	<div style="text-align:center">
		<a href="<?php echo $pre_next[1] ?>"><img src="<?=G5_URL . $cdir ?>/y_prev.png" border="0" alt="<?=($year-1)?>년"></a>
		<a href="<?php echo $pre_next[2] ?>"><img src="<?=G5_URL . $cdir ?>/m_prev.png" border="0" alt="이전월"></a>
		<a href="<?php echo $pre_next[0] ?>" style="padding:0 10px;font-size:18px;font-weight:bold;" title="오늘로"><? echo $year."년 ".$month."월" ?></a>
		<a href="<?php echo $pre_next[3] ?>"><img src="<?=G5_URL . $cdir ?>/m_next.png" border="0" alt="다음월"></a>
		<a href="<?php echo $pre_next[4] ?>"><img src="<?=G5_URL . $cdir ?>/y_next.png" border="0" alt="<?=($year+1)?>년"></a>
	</div>
</div>
<!-- } 게시판 페이지 정보 및 버튼 끝 -->

<div style="margin-top:20px">
	<table width="<?=$width?>" border="1" cellspacing="1" cellpadding="5">
		<thead>
        <tr align="center" bgcolor="#CCEEEE">     
            <th style="width:<?php echo $col_width ?>;color:red">日</th>
            <th style="width:<?php echo $col_width ?>">月</th>
			<th style="width:<?php echo $col_width ?>">火</th>
			<th style="width:<?php echo $col_width ?>">水</th>
			<th style="width:<?php echo $col_width ?>">木</th>
			<th style="width:<?php echo $col_width ?>">金</th>
            <th style="width:<?php echo $col_width ?>;color:blue">土</th>
        </tr>
		</thead>
		
		<tbody>
			<tr height=<?php echo $col_height ?>>
				<?php for ($i=0; $i<$dayweek; $i++) echo '<td class="blank">&nbsp;</td>'; // 숫자가 들어가지 전 빈셀 ?>
<?php
		for ($iday = 1 ; $iday <= $md[$month-1] ; $iday++) { //숫자가 들어가는 셀들. 즉 11월 달에서 1일부터 30 일까지만 해당
			$bgcolor = '';
			if ($year."-".sprintf("%02d-%02d",$month,$iday) == G5_TIME_YMD) $bgcolor = ' style="background:#ffe"'; // 오늘날짜 연두색
			$lun = soltolun($year, $month, $iday);
			$lun2 = soltolun($year, $month, $iday + 1);
			if ($lun['day'] % 5 == 0 || $lun['day'] == 1 || $lun2['day'] == 1) $disp_lun[$iday] = " &nbsp; (음){$lun['month']}/{$lun['day']}";
			if (($iday + $dayweek) % 7 == 0 && !$daystyle[$iday]) $daystyle[$iday] = ' style="color:blue"';
			if (($iday + $dayweek) % 7 == 1) $daystyle[$iday] = ' style="color:red"'; // 토요일 일요일 글자색.
?>
				<td <?php echo $bgcolor ?>>
					<a <?php echo $daystyle[$iday]." href=\"{$linkday[$iday]}\"" ?>><?php echo $iday.$disp_lun[$iday] ?></a>
					<?php echo $annivday[$iday] ?>
				</td>
<?php
			if (($iday + $dayweek) % 7 == 0 && $iday < $md[$month-1]) { // 주당 7개씩 한쎌씩을 쌓는다. 
?>
			</tr>
			<tr height=<?php echo $col_height ?>>
<?php
			}
		} // 반복구문이 끝남
?>
				<?php for ($i=($md[$month-1]+$dayweek-1)%7+1 ; $i<7 ; $i++) echo '<td class="blank">&nbsp;</td>'; // 숫자가 끝나고 빈셀 ?>
			</tr>
		</tbody>
	</table>
</div>

<?php
include_once(G5_PATH.'/_tail.php');
?>