<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$qa_skin_url.'/style.css">', 0);
?>

<div id="bo_list">
    <?php if ($category_option) { ?>
    <!-- 카테고리 시작 { -->
    <nav id="bo_cate" class="cate-wrap">
        <h2><?php echo $qaconfig['qa_title'] ?> 카테고리</h2>
        <ul id="bo_cate_ul">
            <?php echo $category_option ?>
        </ul>
    </nav>
    <!-- } 카테고리 끝 -->
    <?php } ?>

     <!-- 게시판 페이지 정보 및 버튼 시작 { -->
    <div class="bo_fx">
        <?php if ($admin_href || $write_href) { ?>
        <ul class="btn_bo_user">
            <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin">관리자</a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02">문의등록</a></li><?php } ?>
        </ul>
        <?php } ?>
    </div>
    <!-- } 게시판 페이지 정보 및 버튼 끝 -->

	<section class="stylebox">

		<div id="container_title">
			<?php if ($is_checkbox) { ?>
				<label for="chkall" class="sound_only">현재 페이지 게시물 전체</label>
				<input type="checkbox" id="chkall" class="wzcheckbox" onclick="if (this.checked) all_checked(true); else all_checked(false);">
			<?php } ?>
			<span class="bo_list_total">Total <?php echo number_format($total_count) ?> 건 / <?php echo $page ?> 페이지</span>
		</div>

		<form name="fqalist" id="fqalist" action="./qadelete.php" onsubmit="return fqalist_submit(this);" method="post">
		<input type="hidden" name="stx" value="<?php echo $stx; ?>">
		<input type="hidden" name="sca" value="<?php echo $sca; ?>">
		<input type="hidden" name="page" value="<?php echo $page; ?>">

		<ul id="datalist">
			<?php
			for ($i=0; $i<count($list); $i++) {

			$boheader = "";
			if ($list[$i]['category']) { // 공지사항 
				$boheader = "<span class='textheader'>".$list[$i]['category']."</span> ";
			}
			?>
			<li>

				<?php if ($is_checkbox) { ?>
					<label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
					<input type="checkbox" name="chk_qa_id[]" class="list-check wzcheckbox" value="<?php echo $list[$i]['qa_id'] ?>" id="chk_qa_id_<?php echo $i ?>">
				<?php } ?>
				
				<a href="<?php echo $list[$i]['view_href']; ?>" class="list <?php echo ($is_checkbox ? "check" : "");?>">
					<span class="wsubject">
						<?php echo $boheader.$list[$i]['subject']; ?>
					</span>
					<span class="wname">
						<?php echo $list[$i]['name']; ?>&nbsp;<span class="vbar gray">&#124;</span>&nbsp;<?php echo $list[$i]['date']; ?>
						<?php echo preg_replace("/(\<img )([^\>]*)(\>)/i", "\\1 style='position:relative;top:-1px;margin-left:2px;' \\2 \\3", $list[$i]['icon_file']);?>
					</span>
					<div class="li_stat <?php echo ($list[$i]['qa_status'] ? 'txt_done' : 'txt_rdy'); ?>"><?php echo ($list[$i]['qa_status'] ? '답변완료' : '답변대기'); ?></div>
				</a>

			</li>
			<?php
			}
			?>

			<?php if ($i == 0) { echo '<li class="empty_list">게시물이 없습니다.</li>'; } ?>
		</ul>

	</section>

    <div class="bo_fx">
        <?php if ($is_checkbox) { ?>
        <ul class="btn_bo_adm">
            <li><input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"></li>
        </ul>
        <?php } ?>

        <ul class="btn_bo_user">
            <?php if ($list_href) { ?><li><a href="<?php echo $list_href ?>" class="btn_b01">목록</a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02">문의등록</a></li><?php } ?>
        </ul>
    </div>
    </form>
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<!-- 페이지 -->
<?php echo $list_pages;  ?>

<!-- 게시판 검색 시작 { -->
<div class="writebox">
	<div class="inputbox">
		<fieldset>
			<legend>게시물 검색</legend>
			<p>
				<form name="fsearch" method="get">
			    <input type="hidden" name="sca" value="<?php echo $sca ?>">

				<div class="searchcols" style="padding-left:0;">
					<p class="inputnt">
						<input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" placeholder="검색어" required id="stx" class="required" size="15" maxlength="15">
					</p>
					<button type="submit" class="common_btn"><span>검색</span></button>
				</div>

				</form>
			</p>
		</fieldset>
	</div>
</div>
<!-- } 게시판 검색 끝 -->

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fqalist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_qa_id[]")
            f.elements[i].checked = sw;
    }
}

function fqalist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_qa_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다"))
            return false;
    }

    return true;
}
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->