var	wrTrim = function(text){
	return text.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
};

function addLoadEvent(func) {
	var oldonload = window.onload;
	if (typeof window.onload != 'function') {
		window.onload = func;
	} else {
		window.onload = function() {
			if (oldonload) {
				oldonload();
			}
			func();
		}
	}
}

function amina_effect(type, id, effect, etime, data) {
	var id = "#" + id;

	if(!etime) etime = 400;

	if(effect == "rdm") {
		var rdm_effect = new Array("fade", "fadeTop", "fadeBottom", "fadeLeft", "fadeRight", "slideTop", "slideBottom", "slideLeft", "slideRight", "shake", "clip", "scale", "blind");
		effect = rdm_effect[Math.floor(Math.random() * rdm_effect.length)];
	}

	if(type == "show") {
		switch(effect) {
			case "fade"			: $(id).show("fade", etime); break;
			case "fadeTop"		: $(id).show("drop", { direction : "up" }, etime); break;
			case "fadeBottom"	: $(id).show("drop", { direction : "down" }, etime); break;
			case "fadeLeft"		: $(id).show("drop", { direction : "left" }, etime); break;
			case "fadeRight"	: $(id).show("drop", { direction : "right" }, etime); break;
			case "slideTop"		: $(id).show("slide", { direction : "up" }, etime); break;
			case "slideBottom"	: $(id).show("slide", { direction : "down" }, etime); break;
			case "slideLeft"	: $(id).show("slide", { direction : "left" }, etime); break;
			case "slideRight"	: $(id).show("slide", { direction : "right" }, etime); break;
			case "shake"		: $(id).show("shake", { direction : "down" }, etime); break;
			case "clip"			: $(id).show("clip", etime); break;
			case "scale"		: $(id).show("scale", etime); break;
			case "blind"		: $(id).slideDown(etime); break;
			default				: $(id).show(); break;
		}
	} else if(type == "hide") {
		switch(effect) {
			case "fade"			: $(id).hide("fade", etime); break;
			case "fadeTop"		: $(id).hide("drop", { direction : "up" }, etime); break;
			case "fadeBottom"	: $(id).hide("drop", { direction : "down" }, etime); break;
			case "fadeLeft"		: $(id).hide("drop", { direction : "left" }, etime); break;
			case "fadeRight"	: $(id).hide("drop", { direction : "right" }, etime); break;
			case "slideTop"		: $(id).hide("slide", { direction : "up" }, etime); break;
			case "slideBottom"	: $(id).hide("slide", { direction : "down" }, etime); break;
			case "slideLeft"	: $(id).hide("slide", { direction : "left" }, etime); break;
			case "slideRight"	: $(id).hide("slide", { direction : "right" }, etime); break;
			case "shake"		: $(id).hide("shake", { direction : "down" }, etime); break;
			case "clip"			: $(id).hide("clip", etime); break;
			case "scale"		: $(id).hide("scale", etime); break;
			case "blind"		: $(id).slideUp(etime); break;
			default				: $(id).hide(); break;
		}
	} else if(type == "ajax") {
		switch(effect) {
			case "fade"			: $(id).hide().html(data).show("fade", etime); break;
			case "fadeTop"		: $(id).hide().html(data).show("drop", { direction : "up" }, etime); break;
			case "fadeBottom"	: $(id).hide().html(data).show("drop", { direction : "down" }, etime); break;
			case "fadeLeft"		: $(id).hide().html(data).show("drop", { direction : "left" }, etime); break;
			case "fadeRight"	: $(id).hide().html(data).show("drop", { direction : "right" }, etime); break;
			case "slideTop"		: $(id).hide().html(data).show("slide", { direction : "up" }, etime); break;
			case "slideBottom"	: $(id).hide().html(data).show("slide", { direction : "down" }, etime); break;
			case "slideLeft"	: $(id).hide().html(data).show("slide", { direction : "left" }, etime); break;
			case "slideRight"	: $(id).hide().html(data).show("slide", { direction : "right" }, etime); break;
			case "shake"		: $(id).hide().html(data).show("shake", { direction : "down" }, etime); break;
			case "clip"			: $(id).hide().html(data).show("clip", etime); break;
			case "scale"		: $(id).hide().html(data).show("scale", etime); break;
			case "blind"		: $(id).hide().html(data).slideDown(etime); break;
			default				: $(id).hide().html(data).show(); break;
		}
	} else {
		switch(effect) {
			case "fade"			: $(id).hide().show("fade", etime); break;
			case "fadeTop"		: $(id).hide().show("drop", { direction : "up" }, etime); break;
			case "fadeBottom"	: $(id).hide().show("drop", { direction : "down" }, etime); break;
			case "fadeLeft"		: $(id).hide().show("drop", { direction : "left" }, etime); break;
			case "fadeRight"	: $(id).hide().show("drop", { direction : "right" }, etime); break;
			case "slideTop"		: $(id).hide().show("slide", { direction : "up" }, etime); break;
			case "slideBottom"	: $(id).hide().show("slide", { direction : "down" }, etime); break;
			case "slideLeft"	: $(id).hide().show("slide", { direction : "left" }, etime); break;
			case "slideRight"	: $(id).hide().show("slide", { direction : "right" }, etime); break;
			case "shake"		: $(id).hide().show("shake", { direction : "down" }, etime); break;
			case "clip"			: $(id).hide().show("clip", etime); break;
			case "scale"		: $(id).hide().show("scale", etime); break;
			case "blind"		: $(id).hide().slideDown(etime); break;
			default				: $(id).hide().show(); break;
		}
	}
}

function amina_show(id, open, close, edur) {
	var mode = $("#" + id).css("display");
	var etime = Number(edur);
	if(mode == "block") {
		amina_effect("hide", id, close, etime);
	} else {
		amina_effect("show", id, open, etime);
	}
}

function amina_open(id, effect, edur, url, opt) {
	var etime = Number(edur);
	if(url) {
		var fid = $('#' + id + ' iframe').attr('id');

		if(!opt) opt = "3";

		if(url.indexOf('?')) {
			url = url + '&frame=' + opt
		} else {
			url = url + '?frame=' + opt
		}

		url = encodeURI(url);

		if(fid) {
			$('#' + fid).css('height', 0);
			$('#' + fid).attr('src', url);
		} else {
			var data = '<iframe name="' + id + 'Frame" id="' + id + 'Frame" src="' + url + '" width="100%" height="0" scrolling="no" border="0" frameborder="0"></iframe>';
			$("#" + id + " .iframeDiv").html(data);
		}
	}

	amina_effect("show", id, effect, etime);
}

function amina_img(img) {
	var href = amina_url + "/view_image.php?img=" + encodeURI(img);
	window.open(href, "IMAGE", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
}

function amina_sns(href) {
    var new_win = window.open(href, "SNS", "left=0, top=0, width=1024, height=640, scrollbars=yes, resizable=yes");
	new_win.focus();
}

function amina_shingo(href, opt) {
	var str;

	if(opt == "lock") {
		str = "본 글을 블라인드 처리하시겠습니까?";
	} else if(opt == "unlock") {
		str = "본 글을 블라인드 해제하시겠습니까?";
	} else {
		str = "본 글을 신고하시겠습니까?\n\n한번 신고하면 취소할 수 없습니다.";
	}
	
	if (confirm(str)) {
		$.post(href, { js: "on" }, function(data) {
			if(data.error) {
				alert(data.error);
				return false;
			}

			if(data.success) {
				alert(data.success);
			}
		}, "json");
	}
}

function amina_cmt(href, form_id, cmt_id, cmt_url) {
	var str;
	var f = document.getElementById(form_id);
	if (fviewcomment_submit(f)) {
		document.getElementById('loading-icon').style.display = "block";
		$.ajax({
			url : href,
			type : 'POST',
			cache : false,
			data : $("#"+form_id).serialize() + "&js=on",
			dataType : "html",
			success : function(data) {
				document.getElementById('loading-icon').style.display = "none";
				str = data.substr(0, 5);
				if(str == "error") {
					data = data.replace('error','');
					alert(data);
					return false;
				} else {
					if(cmt_url) {
						document.location.href = cmt_url;
					} else {
						$("#"+cmt_id).html(data);
						comment_box('', 'c', 'refresh');
					}
				}
			},
			error : function(data) {
				document.getElementById('loading-icon').style.display = "none";
				$("#"+form_id).submit(); 
			}
		});
	}
}

function amina_cmt_del(href, cmt_id, cmt_url) {
	var str;
	if (confirm("이 댓글를 삭제하시겠습니까?")) {
		document.getElementById('loading-icon').style.display = "block";
		$.post(href, { js: "on" }, function(data) {
			document.getElementById('loading-icon').style.display = "none";
			str = data.substr(0, 5);
			if(str == "error") {
				data = data.replace('error','');
				alert(data);
				return false;
			} else {
				if(cmt_url) {
					document.location.href = cmt_url;
				} else {
					$("#"+cmt_id).html(data);
					comment_box('', 'c', 'refresh');
				}
			}
		});
	}
}

function amina_cmt_redo(href, cmt_id, cmt_url) {
	var str;
	document.getElementById('loading-icon').style.display = "block";
	$.post(href, { js: "on" }, function(data) {
		document.getElementById('loading-icon').style.display = "none";
		str = data.substr(0, 5);
		if(str == "error") {
			data = data.replace('error','');
			alert(data);
			return false;
		} else {
			if(cmt_url) {
				document.location.href = cmt_url;
			} else {
				$("#"+cmt_id).html(data);
				comment_box('', 'c', 'refresh');
			}
		}
	});
}

function amina_good(href, id, opt) {
	$.post(href, { js: "on" }, function(data) {
		if(data.error) {
			alert(data.error);
			return false;
		}

		if(data.success) {
			alert(data.success);
			$("#"+id).text(number_format(String(data.count)));
			if(opt) {
				$("#"+opt).val() = String(data.count);
			}
		}
	}, "json");
}

function amina_choice(href, cmt_id) {
	var str;
	if (confirm("이 댓글를 채택하시겠습니까?")) {
		$.post(href, { js: "on" }, function(data) {
			str = data.substr(0, 5);
			if(str == "error") {
				data = data.replace('error','');
				alert(data);
				return false;
			} else {
				alert("채택해 주셔서 감사합니다.");
				$("#"+cmt_id).html(data);
			}
		});
	}
}

function amina_star(href, form_id, star_id, opt) {
	var str;
	if(opt == 'select') {
		var strVal = $("#"+form_id+" select[name=star]").val();
	} else  {
		var strVal = $("#"+form_id+" input:radio[name=star]:checked").val();
	}

	if(!strVal) {
		alert("별점을 선택해 주세요.");
	} else {
		$.ajax({
			url : href,
			type : 'POST',
			cache : false,
			data : $("#"+form_id).serialize() + "&js=on",
			dataType : "html",
			success : function(data) {
				str = data.substr(0, 5);
				if(str == "error") {
					data = data.replace('error','');
					alert(data);
					return false;
				} else {
					alert(strVal + "점의 별점을 주셨습니다.");
					$("#"+star_id).html(data);
				}
			},
			error : function(data) {
				$("#"+form_id).submit(); 
			}
		});
	}
}

function amina_poll(href, form_id, poll_id) {
	var str;
	var strVal = $("#"+form_id+" input:radio[name=poll]:checked").val();
	if(!strVal) {
		alert("항목을 선택해 주세요.");
	} else {
		$.ajax({
			url : href,
			type : 'POST',
			cache : false,
			data : $("#"+form_id).serialize() + "&js=on",
			dataType : "html",
			success : function(data) {
				str = data.substr(0, 5);
				if(str == "error") {
					data = data.replace('error','');
					alert(data);
					return false;
				} else {
					alert("투표해 주셔서 감사합니다.");
					$("#"+poll_id).html(data);
				}
			},
			error : function(data) {
				$("#"+form_id).submit(); 
			}
		});
	}
}

function amina_linked(cnt,n,url) {
	var i;
	for (i = 1; i <= cnt; i++)	{
		$('#LinkedTab'+i).removeClass('on');
	}
	$('#LinkedTab'+n).addClass('on');

	if(n == 1) {
		$('#LinkedContent1').show();
		$('#LinkedContent2').hide();
	} else {
		$('#LinkedContent1').hide();
		var fid = $('#LinkedContent2 iframe').attr('id');
		if(fid) {
			$('#' + fid).attr('src', url);
		} else {
			var data = '<iframe name="LinkedFrame" id="LinkedFrame" src="' + url + '" width="100%" height="100%" scrolling="no" border="0" frameborder="0"></iframe>';
			$("#LinkedContent2 #LinkedPage").html(data);
		}
		$('#LinkedContent2').show();
	}
}

function google_map(id) {
    var f = document.fwrite;
	var map_w = f.map_width.value;
	var map_h = f.map_height.value;
	var map_lat = f.map_lat.value;
	var map_lng = f.map_lng.value;
	var map_zoom = f.map_zoom.value;
	var url = amina_url + "/google.map.php?bo_table=" + id + "&lat=" + map_lat + "&lng=" + map_lng + "&zoom=" + map_zoom + "&map_w=" + map_w + "&map_h=" + map_h;
	var new_win = window.open(url, "google_map", "width=660, height=620, toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no");
	new_win.focus();
}

function amina_win(mode,id,href) {
	var url;
	if(mode == 'emo') {
		url = amina_url + "/emoticon.php?bo_table=" + id;
	} else if(mode == 'help') {
		url = amina_url + "/help.php?bo_table=" + id;
	} else if(mode == 'poll') {
		url = amina_url + "/poll.set.php?bo_table=" + id;
	} else {
		url = encodeURI(href);
	}
	var new_win = window.open(url, "win", "width=580, height=640, toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes");
	new_win.focus();
}

function amina_page(page_id, page_name, page_title, opt) {
	var href;
	if(page_title) page_title = "&page_title=" + page_title;
	if(page_id) page_id = "&page_id=" + page_id;
	if(opt) {
		href = amina_url + "/page.php?page_name=" + page_name + page_id + page_title;
	} else {
		href = gnu_url + "/?page_name=" + page_name + page_id + page_title;
	}
	document.location.href = encodeURI(href);
}

function amina_search(f) {

	if(wrTrim(f.stx.value) == '' || wrTrim(f.stx.value) == 'Search ...') {
		alert("검색어를 입력하십시오.");
		f.stx.focus();
		return false;
	}

	if (f.stx.value.length < 2) {
		alert("검색어는 두글자 이상 입력하십시오.");
		f.stx.select();
		f.stx.focus();
		return false;
	}

	// 검색에 많은 부하가 걸리는 경우 이 주석을 제거하세요.
	var cnt = 0;
	for (var i=0; i<f.stx.value.length; i++) {
		if (f.stx.value.charAt(i) == ' ')
		cnt++;
	}

	if (cnt > 1) {
		alert("빠른 검색을 위하여 검색어에 공백은 한개만 입력할 수 있습니다.");
		f.stx.select();
		f.stx.focus();
		return false;
	}

	return true;
}

function amina_print(href) {
    var new_win = window.open(href, "PRINT", "left=100, top=100, width=780, height=700, scrollbars=1");
	new_win.focus();
}

function amina_href(href) {
	document.location.href = href;
	return false;
}

function amina_thumb(href, target) {

	if(target == "_blank") {
		window.open(href);
	} else if (target == "_parent") {
		parent.location.href = href;
	} else if (target == "_top") {
		top.location.href = href;
	} else {
		document.location.href = href;
	}
}

function amina_photo() {
	var new_win = window.open(amina_url + '/mb.photo.php','myphoto','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no,width=300,height=400');
	new_win.focus();
}

function amina_stats(bo_table, wr_id) {
	var new_win = window.open(amina_url + '/stats.view.php?bo_table=' + bo_table + '&wr_id=' + wr_id,'stats','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=1000,height=600');
	new_win.focus();
}

function amina_iframe(id,opt) {
	if(opt == 'down') {
		$('#'+id).height($('#'+id).height() + 100);
	} else {
		$('#'+id).height($('#'+id).height() - 100);
	}
}

function amina_textarea(id,mode) {
	if(mode == 'down') {
		$('#'+id).height($('#'+id).height() + 50);
	} else if(mode == 'up') {
		$('#'+id).height($('#'+id).height() - 50);
	} else {
		$('#'+id).height(mode);
	}
}

function amina_insert(html,opt) {
    try {
		if(opt == 'SEditor2') {
			html = "<br>" + html;
			oEditors.getById["wr_content"].exec("PASTE_HTML", [html]);
		} else if(opt == 'DEditor') {
			html = "<br>" + html;
			pasteImage(html);
		} else if(opt == 'cheditor' || opt == 'cheditor5') {
			html = "<br>" + html;
			ed_wr_content.insertContents(html);
		} else if(opt == 'ckeditor4') {
			var editor = CKEDITOR.instances.wr_content;
			if (editor.mode == 'wysiwyg')	{
				html = "<br>" + html;
				editor.insertHtml(html);
			} else {
				alert( 'WYSIWYG 모드에서만 가능합니다.' );
			}
		} else {
	        document.getElementById("wr_content").value += "\n" + html;
		}
    } catch (ex) {
        this.debug(ex);
    };
}

function amina_latest_list(t,id,n,url,effect,edur,type,on,off) {
	var i;
	var lw;
	var ld = "latest_" + id;
	var cd = "latest_content_" + id;
	var etime = Number(edur);

	if(!etime) etime = 500;

	if(!t) t = 0;

	if(type == "img") {
		if(!off) off = on;
		for(i=0; i < t; i++) {
			$("#Tab" + i + "_" + id).attr('src', off);
		}
		$("#Tab"+ n +"_"+ id).attr('src', on);
	} else {
		for (i=0; i < t; i++)	{
			$("#Tab"+ i +"_" + id).removeClass("on");
		}
		$("#Tab"+ n +"_" + id).addClass("on");
	}

	var	lh = $("#" + cd).height();
	$("#" + cd).css({"min-height":lh+"px"});

	if(n == 0) {
		ld = ld + "_first";
		$("#latest_content2_" + id).hide();
		$("#latest_content1_" + id).show();
		amina_effect("latest", ld, effect, etime);
	} else {
		$("#latest_content1_" + id).hide();
		$("#latest_content2_" + id).show();
		$.get(url, function (data) {
			amina_effect("ajax", ld, effect, etime, data);
			$('.amina-effect').hover(function () { 
				var id = $(this).attr('e-id');
				var effect = $(this).attr('e-show');
				var etime = $(this).attr('e-time');
				amina_effect("show", id, effect, etime);
			}, function () { 
				var id = $(this).attr('e-id');
				var effect = $(this).attr('e-hide');
				var etime = $(this).attr('e-time');
				amina_effect("hide", id, effect, etime);

			});
		});
	}
}

function amina_latest_btn(t,id,n,url,effect,etime,type,on,off) {

	for (i = 0; i < t; i++)	{
		$("#Btn"+ i +"_" + id).hide();
	}

	$("#Btn"+ n +"_" + id).show();

	amina_latest_list(t,id,n,url,effect,etime,type,on,off);
}

var amina_point = function(href) {
    var new_win = window.open(href, 'amina_point', 'left=100,top=100,width=600, height=600, scrollbars=1');
    new_win.focus();
}

$(function(){
	$('.btnTop').click(function() {
		$('html, body').stop().animate({scrollTop : 0}, 100);
        return false;
	});

    $('.popup_point').click(function() {
        amina_point(this.href);
        return false;
    });

    $('.popup_sns').click(function() {
        amina_sns(this.href);
        return false;
    });

    $('.popup_print').click(function() {
        amina_print(this.href);
        return false;
    });

    $('a.view_image_no').click(function() {
        return false;
    });

	//parent.jQuery.fancybox.close()

	$('.fbox').fancybox();
	$('.fbox-win').fancybox({
        type: 'iframe',
		autoWidth : true,
		autoHeight : true,
        beforeLoad : function() {         
			if(this.element.data('fbox-width')) {
				this.width  = parseInt(this.element.data('fbox-width'));
			}
			if(this.element.data('fbox-height')) {
				this.height = parseInt(this.element.data('fbox-height'));
			}
        }
    });
	$('.fbox-full').fancybox({
		type : "iframe",
		width : "95%",
		height : "95%",
		autoSize : false
	});
	$('.fbox-reload').fancybox({
		type : "iframe",
		width : "80%",
		height : "80%",
		autoSize : false,
	    afterClose : function() {
	        location.reload();
	        return;
	    }
	});
	$('.amina-effect').hover(function () { 
		var id = $(this).attr('e-id');
		var effect = $(this).attr('e-show');
		var etime = $(this).attr('e-time');
		amina_effect("show", id, effect, etime);
	}, function () { 
		var id = $(this).attr('e-id');
		var effect = $(this).attr('e-hide');
		var etime = $(this).attr('e-time');
		amina_effect("hide", id, effect, etime);

	});
});
