<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//-------------------------------------------------------------------------------------
// AMINA Skin Lib for AMINA BBS & THEMA - Copyright (c) 2012 AMINA - http://amina.co.kr
//
// only for AMINA View Skin
//-------------------------------------------------------------------------------------

include_once(AMINA_PATH.'/lib/video.lib.php');

//Auto Move
function amina_move($board, $wr_id_list, $bo_table_list, $ca_name='', $sw='move') {
    global $g5, $member, $config, $is_admin, $amina;

	$chk_bo_table = array();
	$chk_bo_table = explode(",", $bo_table_list);
	$auto_move = true;
	$bo_table = $board['bo_table'];
    $write_table = $g5['write_prefix'].$bo_table;

	include_once(AMINA_PATH.'/move.func.php');

    if($sw == "move") alert('이동된 게시물입니다.', G5_BBS_URL.'/board.php?bo_table='.$bo_table);

	return;
}

//Show Video Player
function amina_video_content($vid, $mobile='') {

	$video = array();
	$vid = str_replace("&nbsp;", " ", $vid);
	$video = amina_video_info($vid, "view");

	//Player Size
	$auto_size = false;
	if(!$video['width']) {
		$video['width'] = 640;
		$auto_size = true;
	}

	if(!$video['height']) {
		switch($video['type']) {
			case 'nate'		: $video['height'] = 384; break;
			default			: $video['height'] = 360; break;			
		}
	}

	$m_video = false;
	$ratio = ''; //출력비율

	/*
	if(G5_IS_MOBILE) {
		switch ($video['type']) {
			case 'pandora'		: $m_video = true; $m_txt = 'PandoraTV'; break;
			case 'nate'			: $m_video = true; $m_txt = 'NateTV'; break;
			case 'tagstory'		: $m_video = true; $m_txt = 'Tagstory'; break;
		}
	}
	*/

	$video_show = $video_size = '';

	if($m_video) {
		$m_photo = amina_video_img($video['video_url'], $video['vid'], $video['type']);
		$video_show = '<div class="m_video"><a href="'.$video['video'].'" target="_blank"><img src="'.$m_photo.'" class="mimg" alt="" /></a><p>['.$m_txt.'] 동영상을 보실려면 클릭해 주세요.</p></div>'."\n";
	} else {
		if($video['type'] == "file") { //JWPLAYER
			$show = amina_jwplayer($video['video'], $video['img'], $video['caption']);

			if($show) return $show;

		} else if($video['type'] == "youtube") { //유튜브
			$vlist = $video['vlist'] ? '&list='.$video['vlist'] : '';
			$show = '<iframe width="'.$video['width'].'" height="'.$video['height'].'" src="http://www.youtube.com/embed/'.$video['vid'].'?wmode=opaque&autohide=1'.$vlist.'" frameborder="0" allowfullscreen></iframe>';
		} else if($video['type'] == "vimeo") { //비메오
			if($video['auto']) $auto = "&amp;autoplay=1";
			$show = '<iframe src="http://player.vimeo.com/video/'.$video['vid'].'?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff'.$auto.'&amp;wmode=opaque" width="'.$video['width'].'" height="'.$video['height'].'" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';
		} else if($video['type'] == "ted") { //테드
			$show = '<iframe src="http://embed.ted.com'.$video['rid'].'?&wmode=opaque" width="'.$video['width'].'" height="'.$video['height'].'" frameborder="0" scrolling="no" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';
		} else if($video['type'] == "daum") { //다음TV
			$show = '<iframe width="'.$video['width'].'" height="'.$video['height'].'" src="http://videofarm.daum.net/controller/video/viewer/Video.html?vid='.$video['rid'].'&play_loc=undefined&wmode=opaque" frameborder="0" scrolling="no"></iframe>';
		} else if($video['type'] == "dailymotion") { //Dailymotion
			$show = '<iframe frameborder="0" width="'.$video['width'].'" height="'.$video['height'].'" src="http://www.dailymotion.com/embed/video/'.$video['vid'].'?&wmode=opaque"></iframe>';
		} else if($video['type'] == "pandora") { //판도라TV
			if($video['auto']) $auto = "&amp;autoPlay=true";
			$show = '<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" width="'.$video['width'].'" height="'.$video['height'].'" id="movie" align="middle">';
			$show .= '<param name="quality" value="high" /><param name="movie" value="http://flvr.pandora.tv/flv2pan/flvmovie.dll/userid='.$video['ch_userid'].'&amp;prgid='.$video['prgid'].'&amp;skin=1'.$auto.'&amp;share=on&countryChk=ko" /><param name="allowScriptAccess" value="always" /><param name="allowFullScreen" value="true" /><param name="wmode" value="transparent" />';
			$show .= '<embed src="http://flvr.pandora.tv/flv2pan/flvmovie.dll/userid='.$video['ch_userid'].'&amp;prgid='.$video['prgid'].'&amp;skin=1'.$auto.'&amp;share=on&countryChk=ko" type="application/x-shockwave-flash" wmode="transparent" allowScriptAccess="always" allowFullScreen="true" pluginspage="http://www.macromedia.com/go/getflashplayer" width="'.$video['width'].'" height="'.$video['height'].'" /></embed></object>';
		} else if($video['type'] == "nate") { //네이트TV
			$show = '<object id="skplayer" name="skplayer" width="'.$video['width'].'" height="'.$video['height'].'" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9.0.115.00">';
			$show .= '<param name="movie" value="http://v.nate.com/v.sk/movie/'.$video[vs_keys].'/'.$video[mov_id].'" /><param name="allowFullscreen" value="true" /><param name="allowScriptAccess" value="always" /><param name="wmode" value="transparent" />';
			$show .= '<embed src="http://v.nate.com/v.sk/movie/'.$video['vs_keys'].'/'.$video['mov_id'].'" wmode="transparent" allowScriptAccess="always" allowFullscreen="true" name="skplayer" width="'.$video['width'].'" height="'.$video['height'].'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" /></object>';
		} else if($video['type'] == "tagstory") { //Tagstory
			$show = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,16,0" width="'.$video['width'].'" height="'.$video['height'].'" id="ScrapPlayer" >';
			$show .= '<param name="movie" value="http://www.tagstory.com/player/basic/'.$video['vid'].'" /><param name="wmode" value="transparent" /><param name="quality" value="high" /><param name="allowScriptAccess" value="always" /><param name="allowNetworking" value="all" /><param name="allowFullScreen" value="true" />';
			$show .= '<embed src="http://www.tagstory.com/player/basic/'.$video[vid].'" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,16,0" id="ScrapPlayer" name="ScrapPlayer" width="'.$video['width'].'" height="'.$video['height'].'" wmode="transparent" quality="high" allowScriptAccess="always" allowNetworking="all" allowFullScreen="true" /></object>';
		} else if($video['type'] == "slidershare"){ // SliderShare
			$show = '<iframe src="'.$video['play_url'].'" width="'.$video['width'].'" height="'.$video['height'].'" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" allowfullscreen></iframe>';
		} else if($video['type'] == "facebook"){ // Facebook - 라니안님 코드 반영
			$show = '<iframe src="https://www.facebook.com/video/embed?video_id='.urlencode($video['vid']).'" width="'.$video['width'].'" height="'.$video['height'].'" frameborder="0"></iframe>';
		} else if($video['type'] == "naver"){ // Naver - 라니안님 코드 반영
			if(FBOX_WIDTH) {
				$naver_w = FBOX_WIDTH - 20;
				$naver_h = round(($naver_w * 9) / 16);
				$video_size = ' style="width:'.$naver_w.'px; height:'.$naver_h.'px;"';
			} 
			$show = '<iframe width="'.$video['width'].'" height="'.$video['height'].'" src="http://serviceapi.nmv.naver.com/flash/convertIframeTag.nhn?vid='.$video['vid'].'&outKey='.$video['outKey'].'" frameborder="no" scrolling="no"'.$video_size.'></iframe>';
		} else if($video['type'] == "tvcast"){ // Naver Tvcast - 라니안님 코드 반영
			if(FBOX_WIDTH) {
				$naver_w = FBOX_WIDTH - 20;
				$naver_h = round(($naver_w * 9) / 16);
				$video_size = ' style="width:'.$naver_w.'px; height:'.$naver_h.'px;"';
			} 
			$show = '<iframe width="'.$video['width'].'" height="'.$video['height'].'" src="http://serviceapi.rmcnmv.naver.com/flash/outKeyPlayer.nhn?vid='.$video['vid'].'&outKey='.$video['outKey'].'&controlBarMovable=true&jsCallable=true&skinName=tvcast_black" frameborder="no" scrolling="no" marginwidth="0" marginheight="0"'.$video_size.'></iframe>';
		}

		if($show) $video_show = $auto_size ? '<div class="auto-size">'.$show.'</div>'."\n" : '<div>'.$show.'</div>'."\n";
	}

	return $video_show;
}

//Show SoundCloud
function amina_soundcloud($str) {

	$str = strip_tags($str);
	$str = str_replace('\"', '', $str);

	if(!$str) return;

	$cloud = array();
	$cloud = amina_query($str);
	$cloud['params'] = $cloud['params'] ? '&'.str_replace("&amp;", "&", $cloud['params']) : '';
	$show_sound = '';
	if(preg_match('/api.soundcloud.com/i', $cloud['url'])) {
		$show_sound = '<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url='.urlencode($cloud['url']).$cloud['params'].'"></iframe>'."\n";
	}

	return $show_sound;
}

//Syntaxhighlighter
function amina_syntaxhighlighter($m) {

	$str = $m[1];
	$str = str_replace(array("<br>", "<br/>", "<br />", "<div>", "</div>", "<p>", "</p>", "&nbsp;"), array("\n", "\n", "\n", "", "", "\n", "", "\t"), $str);
	$str = stripslashes($str);

	return '<pre class="brush:php;">'.$str.'</pre>';
}

//Google Map
function amina_google_map($geo_data, $bo_tbl='', $attach='', $opt='') {
	global $bo_table, $wr_file;

	if($opt) {
		preg_match("/{지도\:([^}]*)}/ie", $geo_data, $match);
		$geo_data = $match[1];
	}

	$geo_data = stripslashes($geo_data);

	if(!$geo_data) return;
	
	$map = array();
	$map = amina_value($geo_data);

	//Marker
	preg_match("/m=\"([^\"]*)\"/ie", $geo_data, $marker);
	$map['m'] = $marker[1];

	if(is_numeric($map['img'])) {
		$bo_tbl = $bo_tbl ? $bo_tbl : $bo_table;
		$attach = $attach ? $attach : $wr_file;
		list($lat, $lng) = amina_geo_info($bo_tbl, $attach, (int)$map['img']);
	}
	
	if(!$lat || !$lng) {
		list($lat, $lng) = explode(",",$map['loc']);
		if(!$lat || !$lng) return;
	}

	$map['z'] = ($map['z'] > 0) ? $map['z'] : 14;
	$width = $map['w'] ? $map['w'] : '100%';
	$height = $map['h'] ? $map['h'] : '480';

	$load_map = '<iframe width="'.$width.'" height="'.$height.'" src="'.AMINA_URL.'/google.map.view.php?lat='.urlencode($lat).'&lng='.urlencode($lng).'&zoom='.$map['z'].'&width='.$map['w'].'&hight='.$map['h'].'&marker='.urlencode($map['m']).'" frameborder="0" scrolling="no"></iframe>';

	return $load_map;
}


//Good
function amina_good_skin($skin, $bo_table, $wr_id, $good_cnt, $nogood_cnt){
	global $g5, $board;

	if(!$bo_table || !$wr_id) return;

	$good_skin_path = AMINA_PATH.'/skin/good/'.$skin;
	$good_skin_url = AMINA_URL.'/skin/good/'.$skin;

	ob_start();
	include $good_skin_path.'/good.skin.php';
	$view_good = ob_get_contents();
    ob_end_clean();

	return $view_good;
}

//Star
function amina_star_skin($skin, $bo_table, $wr_id, $wr_7, $opt=false){
	global $g5, $amina;

	if(!$bo_table || !$wr_id) return;

	$star_skin_path = AMINA_PATH.'/skin/star/'.$skin;
	$star_skin_url = AMINA_URL.'/skin/star/'.$skin;

	ob_start();
	if(!$opt) echo "<div id=\"view_star".$wr_id."\">\n";
	include $star_skin_path.'/star.skin.php';
	if(!$opt) echo "</div>\n";
	$view_star = ob_get_contents();
    ob_end_clean();

	return $view_star;
}

//Sign
function amina_sign_skin($skin, $bo_table, $wr_id, $mb_id, $name, $signature){
	global $g5, $amina;

	if(!$bo_table || !$wr_id || !$mb_id) return;

	$info = xp_info($mb_id); //현재 레벨
	$info['icon'] = xp_icon($mb_id, $info['level']);

	$signature = $signature ? $signature : '등록된 서명이 없습니다.';

	$sign_skin_path = AMINA_PATH.'/skin/sign/'.$skin;
	$sign_skin_url = AMINA_URL.'/skin/sign/'.$skin;

	ob_start();
	include $sign_skin_path.'/sign.skin.php';
	$view_sign = ob_get_contents();
    ob_end_clean();

	return $view_sign;
}

//Attach
function amina_attach_skin($skin, $bo_table, $wr_id, $view, $opt=''){
	global $g5, $amina;

	if(!$bo_table || !$wr_id) return;

	$attach_skin_path = AMINA_PATH.'/skin/attach/'.$skin;
	$attach_skin_url = AMINA_URL.'/skin/attach/'.$skin;

	ob_start();
	include $attach_skin_path.'/attach.skin.php';
	$view_attach = ob_get_contents();
    ob_end_clean();

	return $view_attach;
}

//Summary
function amina_preview_skin($skin, $bo_table, $wr_id, $view, $title){
	global $g5, $board, $page, $qstr;

	if(!$bo_table || !$wr_id) return;

	if($view['wr_3']) {
		$desc = amina_text($view['wr_3']);
	} else {
		$desc = amina_cut($view['wr_content'], 250); //요약글이 없으면, 본문 내용의 일부를 사용함
	}

	$icon = amina_array_icon($view['wr_5']);
	$preview_cnt = (int)$icon['po_img_cnt'];
	if($preview_cnt > 0) {
		$preview = array();		
		$preview = amina_thumb_img($view['file'], $view['wr_6'], $view['wr_content'], $preview_cnt, $view['wr_4'], $view['wr_8'], '');
		$preview_img = '';
		for($i=0;$i < count($preview);$i++) {
			$preview_img .= '<p class="img-space"><img src="'.$preview[$i].'" alt="" /></p>'."\n";
		}

		if($preview_img) $preview_img = amina_resize_content($preview_img, (int)$board['bo_image_width']);
	}

	$preview_skin_path = AMINA_PATH.'/skin/preview/'.$skin;
	$preview_skin_url = AMINA_URL.'/skin/preview/'.$skin;

	ob_start();
	include $preview_skin_path.'/preview.skin.php';
	$view_preview = ob_get_contents();
    ob_end_clean();

	return $view_preview;
}

//Poll
function amina_poll_skin($skin, $bo_table, $wr_id, $mb_id, $opt=false){
	global $g5, $board, $frame, $bo_it, $bo_linked, $bo_row;

	if(!$bo_table || !$wr_id) return;

	$poll = array();
	$poll = sql_fetch(" select * from {$g5['amina_poll']} where bo_table = '$bo_table' and wr_id = '$wr_id' limit 1 ");

	if(!$poll['poll_id']) return;

	$poll_subject = cut_hangul_last(get_text($poll['poll_subject']));
	$poll_status = '';

	$poll_endtime = strtotime($poll['poll_enddate']);
	if(G5_SERVER_TIME > $poll_endtime) $poll_status = 'end';

	if(!$poll_status) {
		if($poll['poll_level']) {
			if($mb_id) {
				$row = sql_fetch(" select poll_id from {$g5['amina_polllog']} where bo_table = '$bo_table' and wr_id = '$wr_id' and mb_id = '$mb_id' limit 1 ");
				if($row['poll_id']) $poll_status = 'done';
			} 
		} else {
			if($mb_id) {
				$poll_done = "and ( mb_id = '$mb_id' or poll_ip = '{$_SERVER['REMOTE_ADDR']}')";
			} else {
				$poll_done = "and poll_ip = '{$_SERVER['REMOTE_ADDR']}'";
			}
			$row = sql_fetch(" select poll_id from {$g5['amina_polllog']} where bo_table = '$bo_table' and wr_id = '$wr_id' $poll_done limit 1 ");
			if($row['poll_id']) $poll_status = 'done';
		}
	}

	$poll_skin_path = AMINA_PATH.'/skin/poll/'.$skin;
	$poll_skin_url = AMINA_URL.'/skin/poll/'.$skin;

	ob_start();
	if(!$opt) echo "<div id=\"view_poll".$wr_id."\">\n";
	include $poll_skin_path.'/poll.skin.php';
	if(!$opt) echo "</div>\n";
	$view_poll = ob_get_contents();
    ob_end_clean();

	return $view_poll;
}

//Related info
function amina_related_skin($skin, $bo_table, $it_id){
	global $g4, $g5, $config, $board, $board_skin_path, $board_skin_url, $frame;

	if(!$it_id) return;

	$is_related = $view_related = '';

	$related_skin_path = AMINA_PATH.'/skin/related/'.$skin;
	$related_skin_url = AMINA_URL.'/skin/related/'.$skin;

	if($bo_table) { //게시판 연동
		$bo = sql_fetch(" select * from {$g5['board_table']} where bo_table = '$bo_table' ");
		if($bo['bo_table']) {
			$tmp_write_table = $g5['write_prefix'] . $bo_table;
			$row = sql_fetch(" select * from $tmp_write_table where wr_id = '$it_id' limit 1");
			if($row['wr_id']) {
				$list = amina_get_list($row, $bo, $related_skin_url, 255);
				$is_related = 'board';
				$list['bo_subject'] = $bo['bo_subject'];
			}
		}
	} else { //영카트
		$it_img = G5_DATA_PATH."/item/".$it_id."_l1";
		if(file_exists(G5_LIB_PATH."/shop.lib.php") && file_exists($it_img)) { //상품이미지
			$it = amina_it_info($it_id);
			if($it['it_id']) {
				include_once(G5_LIB_PATH."/shop.lib.php");
				$is_related = 'youngcart';
				$it_thumb = G5_DATA_URL."/item/".$it_id."_l1";
			}
		}
	}

	if($is_related) {
		ob_start();
		include $related_skin_path.'/related.skin.php';
	    $view_related = ob_get_contents();
	    ob_end_clean();
	} 

	return $view_related;
}

// Comment Reset
function amina_cmt_list($row, $stx, $photo='56', $opt='') {
	global $g5, $config, $board, $amina, $member, $is_admin, $write_table, $write, $is_ip_view, $is_choice, $lurl, $surl, $bo_table, $wr_id, $frame, $go_url, $token, $cwin, $page, $qstr, $cmt_url, $is_sideview;

	$list = array();

	$list = $row;

	$list['comment_id'] = $row['wr_id'];

	//xp 및 모바일 아이콘
	$wr_5 = amina_array_icon($row['wr_5']);

	$list['level'] = $wr_5['level'];
	$list['mobile'] = $wr_5['mobile'];
	$list['choice'] = $wr_5['choice'];
	$list['choice_mb'] = $wr_5['choice_mb'];
	$list['post_cool'] = $wr_5['post_cool'];
	$list['datetime'] = date("Y.m.d H:i:s", strtotime($row['wr_datetime']));
	$list['level_icon'] = xp_icon($list['mb_id'], $list['level']);

	//Secret
	$list['is_secret'] = (strstr($row['wr_option'], "secret")) ? true : false;
	
	//Shingo
	$list['is_blind'] = ($row['wr_9'] == "lock" || $row['wr_9'] == "shingo") ? true : false;

	//Photo
	switch($amina['cmt_photo']) {
		case '1'	: $list['mb_photo'] = mb_photo($member['mb_id'], $row['mb_id'], $photo, $photo); break;
		case '2'	: $list['mb_photo'] = mb_photo($member['mb_id'], $row['mb_id'], $photo, $photo, "is"); break;
		default		: $list['mb_photo'] = ''; break;
	}
	
	//Cool & Bad
	if($amina['cmt_cool']) {
		switch($list['post_cool']) {
			case '<cool>'	: $list['cool_txt'] = '<span class="cmt-cool">'.$amina['cmt_cool_txt'].'</span>&nbsp; '; break;
			case '<bad>'	: $list['cool_txt'] = '<span class="cmt-bad">'.$amina['cmt_bad_txt'].'</span>&nbsp; '; break;
			default			: $list['cool_txt'] = ''; break;
		}
	}

	$list['name'] = $is_sideview ? amina_sideview($list['mb_id'], $list['wr_name'], $list['wr_email'], $list['wr_homepage']) : $list['name'];

	if ($is_admin || $is_ip_view) { 
		if (!$is_admin) $row['wr_ip'] = preg_replace("/([0-9]+).([0-9]+).([0-9]+).([0-9]+)/", G5_IP_DISPLAY, $row['wr_ip']); 
		$list['ip'] = ' ('.$row['wr_ip'].')'; 
	} else {
		$list['ip'] = '';
	}

	//SNS Icon
	if ($list['is_blind'] || $list['is_secret'] || $amina['cmt_sns'] == "none") { 
		$list['sns'] = '';
	} else {
		$clurl = $lurl.'#c_'.$row['wr_id'];
		$csurl = ($amina['use_surl'] == "1") ? $surl.'#c_'.$row['wr_id'] : $sulr;

		switch($opt) {
			case 'best'		: $sns_id = 'best_sns'.$row['wr_id']; break;
			case 'choice'	: $sns_id = 'choice_sns'.$row['wr_id']; break;
			default			: $sns_id = 'cmt_sns'.$row['wr_id']; break;
		}
		$list['sns'] = amina_sns($sns_id, $amina['cmt_sns'], '', $row['wr_content'], $clurl, $csurl, '', 'cmt');
	} 

	//Blind
	switch($row['wr_9']) {
		case 'lock'		: $list['blind_msg'] = ' 관리자가 블라인드 처리한 댓글입니다.'; break;
		case 'shingo'	: $list['blind_msg'] = ' 신고누적으로 블라인드 처리된 댓글입니다.'; break;
		default			: $list['blind_msg'] = ''; break;
	}

	//Best
	$list['is_best'] = ($amina['cmt_best'] > 0 && $row['wr_good'] >= $amina['cmt_best']) ? true : false;

	///대댓글의 비밀글을 원댓글쓴이에게도 보이기
	$is_pre_cmt = false;
	if($row['wr_comment_reply'] && $list['is_secret']) {
		$pre_cmt_char = substr($row['wr_comment_reply'],0,-1);
		$pre_cmt = sql_fetch(" select mb_id from {$write_table} where wr_parent = '{$wr_id}' and wr_is_comment = 1 and wr_comment = '{$row['wr_comment']}' and wr_comment_reply = '{$pre_cmt_char}' "); 
		if($member['mb_id'] && $pre_cmt['mb_id'] == $member['mb_id']) $is_pre_cmt = true;
	}

	//Content
	if(!$list['is_blind'] && (!$list['content'] || $is_pre_cmt)) {
	    $list['content'] = $list['content1']= "비밀글 입니다.";
	    if (!strstr($row['wr_option'], "secret") || $is_admin || $is_pre_cmt || ($write['mb_id']==$member['mb_id'] && $member['mb_id']) || ($row['mb_id']==$member['mb_id'] && $member['mb_id'])) {
	        $list['content1'] = $row['wr_content'];
		    $list['content'] = conv_content($row['wr_content'], 0, 'wr_content');
	        $list['content'] = search_font($stx, $list['content']);
	    }
	}

	$str = '';
	if(!$list['is_blind'] || $is_admin) {
	    $str = $list['content'];
	    if (!$list['is_secret'] || $is_admin || $is_pre_cmt || ($write['mb_id']==$member['mb_id'] && $member['mb_id']) || ($row['mb_id']==$member['mb_id'] && $member['mb_id'])) {
			$str = preg_replace("/\[\<a\s.*href\=\"(http|https|ftp|mms)\:\/\/([^[:space:]]+)\.(mp3|wma|wmv|asf|asx|mpg|mpeg)\".*\<\/a\>\]/i", "<script>doc_write(obj_movie('$1://$2.$3'));</script>", $str);
			if(G5_IS_MOBILE) {
				$str = preg_replace("/\[\<a\s*href\=\"(http|https|ftp)\:\/\/([^[:space:]]+)\.(gif|png|jpg|jpeg|bmp)\"\s*[^\>]*\>[^\s]*\<\/a\>\]/i", "<img src='$1://$2.$3' class='mimg' alt='' border='0'>", $str);
			} else {
				$str = preg_replace("/\[\<a\s*href\=\"(http|https|ftp)\:\/\/([^[:space:]]+)\.(gif|png|jpg|jpeg|bmp)\"\s*[^\>]*\>[^\s]*\<\/a\>\]/i", "<img src='$1://$2.$3' class='mimg' onclick='amina_img(\"$1://$2.$3\");' alt='' border='0'>", $str);
			}

			$str = amina_fa($str);
			$str = preg_replace("/{지도\:([^}]*)}/ie", "amina_google_map('\\1')", $str);
			$str = preg_replace("/{동영상\:([^}]*)}/ie", "amina_video_content('\\1','')", $str);
			$str = preg_replace("/{이모티콘\:([^}]*)}/ie", "amina_ticon('\\1','')", $str);
			$str = preg_replace("/\[soundcloud([^\]]*)\]/ie", "amina_soundcloud('\\1')", $str);

			if($amina['view_code']) $str = preg_replace_callback("/\[code\](.*)\[\/code\]/iUs", "amina_syntaxhighlighter", $str);
		}
		if ($list['is_secret']) $str = '<span class="cmt-secret">* '.$str.'</span>';
		if ($row['wr_trackback']) $str .= '<p>'.url_auto_link($row['wr_trackback']).'</p>';
	}

	$list['content'] = $str;

	//Link
	if($is_admin) {	
		$list['lock_link'] = "javascript:amina_shingo('".AMINA_URL."/blind.php?bo_table=".$bo_table."&wr_id=".$list['comment_id']."&act=lock','lock');";
		$list['unlock_link'] = "javascript:amina_shingo('".AMINA_URL."/blind.php?bo_table=".$bo_table."&wr_id=".$list['comment_id']."&act=unlock','unlock');";
	} else {
		$list['lock_link'] = "";
		$list['unlock_link'] = "";
	}

	$list['shingo_link'] = ($amina['shingo'] > 0 && $member['mb_id']) ? "javascript:amina_shingo('".AMINA_URL."/blind.php?bo_table=".$bo_table."&wr_id=".$list['comment_id']."','shingo');" : '';

	if(preg_match("/password\.php/i", $row['del_link'])) {
		$row['del_link'] = str_replace("./", G5_BBS_URL."/", $row['del_link']);
		$del_opt = '';
		if($frame && $go_url) {
			$del_opt = 1;
			$row['del_link'] = str_replace("&frame=1", "", $row['del_link']);
		}
		$list['del_link']  = "javascript:comment_delete('".$row['del_link']."','".$del_opt."');";
	} else {
		$del_link = AMINA_URL."/comment.php?w=cd&bo_table=".$bo_table."&comment_id=".$list['comment_id'];
		if($token) $del_link .= "&token=".$token;
		if($cwin) $del_link .= "&cwin=".$cwin;
		if($page) $del_link .= "&page=".$page;
		if($qstr) $del_link .= $qstr;
		if($go_url) $del_link .= "&go_url=".urlencode(urlencode($go_url));
		$list['del_link']  = "javascript:amina_cmt_del('".$del_link."','cmt_".$wr_id."','".$cmt_url."');";
	}

	$list['choice_link'] = (!$list['is_blind'] && $is_choice == "select" && ($write['mb_id'] != $list['mb_id'])) ? AMINA_URL."/choice.php?bo_table=".$bo_table."&wr_id=".$list['comment_id'] : '';

	if($amina['cmt_good']) {
		if($list['is_best']) {
			$good_opt = '&type=best';
		} else if($list['choice']) {
			$good_opt = '&type=choice';
		} else {
			$good_opt = '';
		}
		$list['good_link'] = $amina['cmt_good'] ? AMINA_URL.'/good.php?bo_table='.$bo_table.'&wr_id='.$list['comment_id'].'&good=good'.$good_opt.'&mode=c' : '';
	} else {
		$list['good_link'] = '';
	}

	return $list;
}

//Show Contents
function amina_view_contents($wr_content, $wr_file, $wr_6, $wr_opt, $width='640', $mobile='', $map_info='', $code='', $except='') {
	global $g5, $board, $bo_table, $board_skin_path, $board_skin_url, $amina;

	$board['img_location'] = $board['img_location'] ? $board['img_location'] : $wr_opt['img_location'];

	//Mobile
	if($mobile == "rss") $board['no_view_resize'] = true; 

	//출력제외
	$except = $except ? 1 : 0;

	//그누 이미지 보기 클래스 제거와 링크 타켓을 _blank로 수정
	$wr_content = str_replace(array("class=\"view_image\"", "<a "), array("class=\"view_image_no\"", "<a target=\"_blank\" "), $wr_content);

	//비디오 체크
	$file_attach = '';
	$cnt_video = count($wr_file['video']);
	for ($i=0; $i < $cnt_video; $i++) {
		$file_attach .= amina_jwplayer(G5_DATA_URL.'/file/'.$board['bo_table'].'/'.urlencode($wr_file['video'][$i]['file']))."\n";
		$file_attach .= '<div style="height:15px;"></div>'."\n";
	}

	//오디오 체크
	$cnt_audio = count($wr_file['audio']);
	for ($i=0; $i < $cnt_audio; $i++) {
		$file_attach .= amina_jwplayer(G5_DATA_URL.'/file/'.$board['bo_table'].'/'.urlencode($wr_file['audio'][$i]['file']))."\n";
		$file_attach .= '<div style="height:15px;"></div>'."\n";
	}

	$file_image = '';
	if($board['img_location'] == "insert" || $board['img_location'] == "hide") {
		$content = $wr_content;
	} else {
		$z = 0;
		$cnt_image = count($wr_file['image']);
		if($cnt_image > 0) {
			$img_css = $wr_opt['img_space'] ? '' : ' style="margin-bottom:15px;"';
			$file_image .= '<div class="attach-img">'."\n";
			for ($i=$except; $i < $cnt_image; $i++) {
				$z++;
				$file_image .= '<img src="'.G5_DATA_URL.'/file/'.$board['bo_table'].'/'.urlencode($wr_file['image'][$i]['file']).'" alt="'.$wr_file['image'][$i]['content'].'" '.$img_css.'>'."\n";
			}
			$file_image .= '</div>'."\n";
		}

		$content = '';
		if($file_image && $board['img_location'] != "bottom") $content .= $file_image.'<div style="height:15px;"></div>';
		$content .= $wr_content;
		if($file_image && $board['img_location'] == "bottom") $content .= '<div style="height:15px;"></div>'.$file_image;
	}

	$content = amina_resize_content($content, $width);
	$content = amina_fa($content);
	$content = preg_replace("/{지도\:([^}]*)}/ie", "amina_google_map('\\1')", $content); //Google Map
	$content = preg_replace("/{동영상\:([^}]*)}/ie", "amina_video_content('\\1','{$mobile}')", $content); //Video
	$content = preg_replace("/{이모티콘\:([^}]*)}/ie", "amina_ticon('\\1')", $content); //Emoticon
	$content = preg_replace("/\[soundcloud([^\]]*)\]/ie", "amina_soundcloud('\\1')", $content); //SoundCloud

	if($code) $content = preg_replace_callback("/\[code\](.*)\[\/code\]/iUs", "amina_syntaxhighlighter", $content); //Syntaxhighlighter

	//글내용 출력하기
	$view_content = $file_attach;

	if($wr_6) {
		$video = amina_array_video($wr_6);
		if($video['movie_url'] && !$video['movie_align']) {
			if($video['movie_sound'] == "soundcloud") {
				$view_content .= amina_soundcloud($video['movie_url']);
			} else {
				$view_content .= amina_video_content($video['movie_info'], $mobile);
			}
			$view_content .= '<div style="height:15px;"></div>'."\n";
		}
	}

	$view_content .= $content;

	if($wr_6) {
		if($video['movie_url'] && $video['movie_align']) {
			$view_content .= '<div style="height:15px;"></div>'."\n";
			if($video['movie_sound'] == "soundcloud") {
				$view_content .= amina_soundcloud($video['movie_url']);
			} else {
				$view_content .= amina_video_content($video['movie_info'], $mobile);
			}
		}
	}

	return $view_content;
}


// 한별아빠 수정사항 - 본문 썸네일 출력관련 부분만 별도 정리 - 함수충돌방지를 위해 각 함수명에 amina_ 붙임
// 프로그램 : 그누보드 불당팩 라이브러리 
// 개 발 자 : 아빠불당 (echo4me@gmail.com)
// 저 작 권 : GPL2
// 불당팩 : 이미지 resize (청춘불안정 : http://www.sir.co.kr/bbs/board.php?bo_table=cm_free&wr_id=306629)
function amina_resize($string) { 
    global $g5, $board;

    //print_r($board);

    // 전역변수를 받아들이기 때문에 설정값이 없으면, 기본으로 게시판의 폭을 지정. 게시판 폭도 없으면 기본으로 500
    $max_img_width = (int) $board['resize_img_width'];
    if ($max_img_width <= 0) {
        if ((int)$board['bo_image_width'] > 0)
            $max_img_width = (int)$board['bo_image_width'];
        else
            $max_img_width = 640;
    }
    
    // max_img_height에 값이 있는 경우는 crop을 허용 합니다.
    $max_img_height = (int)$board['resize_img_height'];
    $is_crop = false;
    if ($max_img_height > 0)
        $is_crop = true;

    // 실행할 때마다 image를 create할지 설정 (무조건 false)
    $is_create = false;
    
    // 이미지의 quality 값을 설정 (없으면, thumb의 기본값으로 90이 적용됨)
    $quality = (int) $board['resize_img_quality'];
    if ($quality <= 0)
        $quality = 90;

    // $water_mark 변수를 전달 받습니다
    $water_mark = $board['water_mark'];

    // $board[thumb_create]에 값이 있으면 무조건 썸네일을 생성 합니다.
    if ($board['thumb_create'])
        $thumb_create = 1;

    // 이미지 필터 - 기본으로 UnSharpMask
    if ($board['image_filter']) {
        $filter['type'] = $board['image_filter']['type'];
        $filter['arg1'] = $board['image_filter']['arg1'];
        $filter['arg2'] = $board['image_filter']['arg2'];
        $filter['arg3'] = $board['image_filter']['arg3'];
        $filter['arg4'] = $board['image_filter']['arg4'];
    } else {
        $filter['type'] = 99;
        $filter['arg1'] = 10;
        $filter['arg2'] = 1;
        $filter['arg3'] = 2;
    }

    // 변수를 setting
    $return = $string['0']; 
	$img = amina_value($return);

    // 실제 디렉토리 이름을 구하고 절대경로에서 잘라낼 글자수를 계산
    $real_dir = dirname($_SERVER['DOCUMENT_ROOT'] . '/nothing');
    $cut_len = strlen($real_dir);

    // 가끔씩 img의 파일이름이 깨어지는 경우가 있어서 decoding 해줍니다 (예: &#111;&#110; = on)
    $img['src'] = html_entity_decode($img['src']); 
	$img['src_href'] = $img['src'];

    // 이미지 파일의 경로를 설정 (외부? 내부? 내부인경우 절대경로? 상대경로?)
    if (preg_match("/^(http|https|ftp|telnet|news|mms)\:\/\//i", $img['src'])) {
        // 내 서버에 있는 이미지?
        //$img_src = @getimagesize($img['src']);
        if (preg_match('/' . $_SERVER['HTTP_HOST'] . '/', $img['src'], $matches)) {
            $url = parse_url($img['src']);
            $img['src'] = $url['path'];
            $thumb_path = '1';
        } else {
            $thumb_path = '';
        }
    } else {
        $thumb_path = '1';
    }

    if ($thumb_path) {
        $dir = dirname(amina_file_path($img['src']));
        $file = basename($img['src']);
        $img_path = $dir . '/' . $file;
        // 첨부파일의 이름은 urlencode로 들어가게 됩니다. 따라서, decode해줘야 합니다. (/bbs/write_update.php 참조)
        $img_path = urldecode($img_path);
        $img_src = @getimagesize($img_path);
        // 잊어버리지말고 여기도 urldecode 해줘야죠?
        $thumb_path = urldecode($img['src']);
    }

    // 이미지파일의 정보를 얻지 못했을 때
	if(preg_match("/\/(cheditor5|plugin|amina\/app|amina\/skin|amina\/misc|amina\/thema|amina\/img)\//i", $img['src'])) {
		$img_css = '';
		$img_big = false;
	} else {
		$img_css = (G5_IS_MOBILE || $board['is_print']) ? "class='mimg'" : "class='aimg'";
		$img_big = ($board['view_fancybox'] == "none" || $img['link']) ? false : true;
	}

	// 이미지팝업 삭제...
	$return = preg_replace('/name\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
    $return = preg_replace('/style\=\'cursor:pointer;\'/i', '', $return);
	$return = preg_replace('/onClick\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return);

	if (!$thumb_path) {
		if(G5_IS_MOBILE || $board['is_print']) {
			$return = preg_replace('/style\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
			$return = preg_replace('/class\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
			$return = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
			$return = preg_replace('/height\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
			$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "\\1 $img_css \\2 \\3", $return);
		} else {
			if((int)$img['width'] > $max_img_width) {
				if($max_img_width == "1") {
					$return = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
				} else {
					$return = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', 'width="' . $max_img_width . '"', $return); 
				}
				$return = preg_replace('/height\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
			}
			$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "\\1 $img_css \\2 \\3", $return);
			if($img_big) {
				if($board['view_fancybox']) {
					if($board['view_fancybox'] == 'lightbox') {
						$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "<a href=\"".$img['src_href']."\" data-lightbox=\"view-lightbox\">\\1 \\2 \\3</a>", $return);
					} else {
						$fbox_group = ($board['view_fancybox'] == 'fbox') ? '' : ' data-fancybox-group="'.$board['view_fancybox'].$board['wr_id'].'"';
						$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "<a class=\"".$board['view_fancybox']."\" href=\"".$img['src_href']."\"".$fbox_group.">\\1 \\2 \\3</a>", $return);
					}
				} else {
					//$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "\\1 onClick='amina_img(\"".$img['src']."\")' \\2 \\3", $return);
					$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "<a href=\"javascript:amina_img('".$img['src_href']."');\">\\1 \\2 \\3</a>", $return);
				}
			}
		}

		$return = preg_replace('/\/  \>/', '\/>', $return); 

		return $return;
    }

    // 이미지생성의 최소 넓이가 있으면, 이미지가 그 크기 이상일때만, 썸을 만들어야징.
    // 이거는 작은 아이콘 같은 것의 썸을 만들지 않게 하려고 하는거임
    if ($board['image_min'] && $img_src[0] < $board['image_min']) {
		$return = preg_replace('/\/  \>/', '\/>', $return); 
		return $return;
	}

    // 이미지 파일의 크기를 구해서
    $fsize = amina_filesize2bytes(filesize($img_path));

    // 이미지 파일의 전체 크기와 갯수 저장
    if ($board['bo_image_info']) {
        $g5['resize']['image_size'] = $g5['resize']['image_size'] + $fsize/1000;
        $g5['resize']['image_count'] = $g5['resize']['image_count'] + 1;
        $g5['resize']['image_file'][] = $img_path;
    }

    // 이미지생성의 최소 파일용량이 있으면, 이미지가 그 파일크기 이상일때만, 썸을 만들어야징.
    // 이거는 작은 아이콘 같은 것이나 효율적으로 줄어든 이미지의 썸을 만들지 않게 하려고 하는거임
    if ($board['image_min_kb']) {
        // 용량은 kb에서 byte로 바꿔서
        $min_kb = $board['image_min_kb']*1024;
        if ($fsize < $min_kb) {
			$return = preg_replace('/\/  \>/', '\/>', $return); 
			return $return;
        }
    }

	// 썸네일 생성여부
	if (!$board['no_view_resize'] && ((int)$img_src[0] > $max_img_width || $thumb_create) && $thumb_path) {
		$thumb_path = bthumbnail($thumb_path, $max_img_width,$max_img_height,$is_create,$is_crop,$quality, '', $water_mark, $filter);
		if(!G5_IS_MOBILE && !$board['is_print']) $return = preg_replace('/src\=(\'|\")?[^\s\'\"]+(\'|\")?/i', 'src="' . $thumb_path . '"', $return);
	}

	if(G5_IS_MOBILE || $board['is_print']) {
		$return = preg_replace('/style\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
		$return = preg_replace('/class\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
		$return = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
		$return = preg_replace('/height\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
		$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "\\1 $img_css \\2 \\3", $return);
	} else {
		if((int)$img['width'] > $max_img_width) {
			if($max_img_width == "1") {
				$return = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
			} else {
				$return = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', 'width="' . $max_img_width . '"', $return); 
			}
			$return = preg_replace('/height\=(\'|\")?[^\s\'\"]+(\'|\")?/i', '', $return); 
		} else {
			$width = (!$img['width'] && $img_src[0] > $max_img_width && $max_img_width > 1) ? 'width="'.$max_img_width.'"' : '';
		}

		$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "\\1 $img_css \\2 \\3", $return);

		if($img_big) {
			if($board['view_fancybox']) {
				if($board['view_fancybox'] == 'lightbox') {
					$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "<a href=\"".$img['src_href']."\" data-lightbox=\"view-lightbox\">\\1 \\2 \\3</a>", $return);
				} else {
					$fbox_group = ($board['view_fancybox'] == 'fbox') ? '' : ' data-fancybox-group="'.$board['view_fancybox'].$board['wr_id'].'"';
					$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "<a class=\"".$board['view_fancybox']."\" href=\"".$img['src_href']."\"".$fbox_group.">\\1 \\2 \\3</a>", $return);
				}
			} else {
				//$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "\\1 $width onClick='amina_img(\"".$img['src']."\", \"".$img_src[0]."\", \"".$img_src[1]."\")' \\2 \\3", $return);
				$return = preg_replace("/(\<img )([^\>]*)(\>)/i", "<a href=\"javascript:amina_img('".$img['src_href']."');\">\\1 \\2 \\3</a>", $return);
			}
		}
	}

	$return = preg_replace('/\/  \>/', '\/>', $return); 

    return $return; 
}

// $content                                   : resize할 img 태그가 있는 html
// $width         = $board[resize_img_width]  : 최대 이미지의 폭 (값이 없으면 $board[bo_img_width] 값을 씁니다
// $height        = $board[resize_img_height] : 최대 이미지의 높이 (이것이 지정되면 $is_crop = true가 됩니다) 값이 없으면, 비율대로 줄이고 crop 하지 않습니다.
// $quality       = $board[resize_img_quality]: 썸네일 이미지의 quality (없으면 기본값, 70%를 사용)
// $thumb_create  = $board[thumb_create]      : 이미지의 폭이 지정보다 작은경우에도 썸네일을 생성할지를 지정
// $image_window  = $board[image_window]      : 이미지를 누를때 팝업창을 띄울 것인지를 선택 (1: 팝업)
// $water_mark    = $board[water_mark]        : 워터마크
// $image_filter  = $board[image_filter]      : 이미지필터
// $image_min     = $board[image_min]         : 값이 있으면, $thumb_create=1이더라도 image_min 이상의 폭의 이미지에 대해서만, 썸을 만든다
// $image_min_kb  = $board[image_min_kb]      : 값이 있으면, $thumb_create=1이더라도 image_kb 이상의 이미지 용량에 대해서만, 썸을 만든다
function amina_resize_content($content, $width=0, $height=0, $quality=0, $thumb_create=0, $image_window=1, $water_mark='', $image_filter='', $image_min=0, $image_min_kb=0)
{
    global $g5, $board;

    if ($width > 0)
        $board['resize_img_width'] = (int)$width;
    else
        $board['resize_img_width'] = 0;

    if ($height > 0)
        $board['resize_img_height'] = (int)$height;
    else
        $board['resize_img_height'] = 0;

    if ($quality > 0)
        $board['resize_img_quality'] = (int)$quality;
    else
        $board['resize_img_quality'] = 90;

    if ($thumb_create)
        $board['thumb_create'] = 1;
    else
        $board['thumb_create'] = 0;

    if ($image_window)
        $board['image_window'] = 1;
    else
        $board['image_window'] = 0;

    if ($image_min)
        $board['image_min'] = $image_min;

    if ($image_min_kb)
        $board['image_min_kb'] = $image_min_kb;

    if ($water_mark)
        $board['water_mark'] = $water_mark;

    if ($image_filter)
        $board['image_filter'] = $image_filter;
    
    return preg_replace_callback('/\<img[^\<\>]*\>/i', 'amina_resize', $content);
}

// $content                                   : resize할 img 태그가 있는 html
// $image_min     = $board[image_min]         : 값이 있으면, $thumb_create=1이더라도 image_min 이상의 폭의 이미지에 대해서만, 썸을 만든다
// $image_min_kb  = $board[image_min_kb]      : 값이 있으면, $thumb_create=1이더라도 image_kb 이상의 이미지 용량에 대해서만, 썸을 만든다
// $quality       = $board[resize_img_quality]: 썸네일 이미지의 quality (없으면 기본값, 70%를 사용)
// $image_window  = $board[image_window]      : 이미지를 누를때 팝업창을 띄울 것인지를 선택 (1: 팝업)
function amina_resize_dica($content, $image_min=0, $image_min_kb=0, $quality=90, $image_window=1)
{
    global $g5, $board;

    $board['image_min'] = (int)$image_min;

    $board['image_min_kb'] = (int)$image_min_kb;

    $board['resize_img_quality'] = (int)$quality;

    $board['image_window'] = $image_window;

    return preg_replace_callback('/\<img[^\<\>]*\>/i', 'amina_resize', $content);
}

/** 
 * Converts human readable file size (e.g. 10 MB, 200.20 GB) into bytes. 
 * 
 * @param string $str 
 * @return int the result is in bytes 
 * @author Svetoslav Marinov 
 * @author http://slavi.biz 
 */ 

function amina_filesize2bytes($str) { 
    $bytes = 0; 

    $bytes_array = array( 
        'B' => 1, 
        'KB' => 1024, 
        'MB' => 1024 * 1024, 
        'GB' => 1024 * 1024 * 1024, 
        'TB' => 1024 * 1024 * 1024 * 1024, 
        'PB' => 1024 * 1024 * 1024 * 1024 * 1024, 
    ); 

    $bytes = floatval($str); 

    if (preg_match('#([KMGTP]?B)$#si', $str, $matches) && !empty($bytes_array[$matches[1]])) { 
        $bytes *= $bytes_array[$matches[1]]; 
    } 

    $bytes = intval(round($bytes, 2)); 

    return $bytes; 
} 

?>