/**
* @file widgeteditor.js
*
* @class WidgetPageEditor
*
* @bref 위젯페이지 에디터
* 
* @date 2014.01.09
*
* @author 권혁준(impactlife@naver.com)
*
* @copyright PLUGSYS.co.kr. & Kwon Hyuk-June. All rights reserved.
*
* @section MODIFYINFO
* 	- 없음/없음
*
* @section Example
*   - 없음
*/


/**
* @bref 생성자
* @param json options
* @return WidgetPageEditor
**/
var WidgetPageEditor = function(options){
	this.rowcnt = 0;
	this.options = { container: null, widget_manager_url : 'widget_list.php', widget_url : 'widget.php?wnum=', qstr : ''};
	$.extend(this.options, options);
	
	this.cur_col = null; //다이얼로그 오픈시 임시저장 컬럼 wrap id
	
	var ref = this;
	
	
	this.container = $(this.options.container);
	
	//결과를 json 으로 돌려줄때 임시 작업 컨테이너 생성
	this.resultContainer = $(document.createElement('div'));
	
	//위젯 선택 다이얼로그 생성
	this.widgetDialog = $(document.createElement('div'));
	this.widgetDialog.attr('id', 'bt_widget_dialog');
}

WidgetPageEditor.prototype.initEditMode = function(){
	var ref = this;
	this.widgetDialog.dialog({
		autoOpen:false,
		modal: true,
		width:700,
		height:600,
		open: function(event, ui){
			$(this).html('<iframe src="'+ref.options.widget_manager_url+'" style="width:100%;height:100%;overflow-x:hidden;border:0"></iframe>');
		}
	});
}

/**
* @bref 레이아웃 추가
* @param string type
**/
WidgetPageEditor.prototype.addLayout = function(type){

	var row = $(document.createElement('div'));
	this.container.append(row);
	row.addClass('bt_widget_row');
	
	this.addHeader(row, 'row');
	
	var rwrap = $(document.createElement('div'));
	row.append(rwrap);
	rwrap.addClass('bt_rwrap');

	if(type == 'bt_layout_1'){

		var col = null;
		var cwrap = null;
		for(var i=0;i<3;i++){
			this.createColumn(rwrap, 'bt_wl_col_4');
		}
		
	}else if(type == 'bt_layout_2'){		
		this.createColumn(rwrap, 'bt_wl_col_8');
		this.createColumn(rwrap, 'bt_wl_col_4');
		
	}else if(type == 'bt_layout_3'){		
		this.createColumn(rwrap, 'bt_wl_col_4');
		this.createColumn(rwrap, 'bt_wl_col_8');
		
	}else if(type == 'bt_layout_4'){		
		this.createColumn(rwrap, 'bt_wl_col_6');
		this.createColumn(rwrap, 'bt_wl_col_6');
		
	}else if(type == 'bt_layout_5'){		
		this.createColumn(rwrap, 'bt_wl_col_12');
	}
	
	rwrap.sortable(this.getSortOption({connectWith: rwrap, handle: '.bt_col_header'}));
	
	this.container.sortable(this.getSortOption({connectWith: this.container, handle: '.bt_row_header'}));
	
	//$('.bt_widget_col', row).sortable({connectWith: $('.bt_widget_col', row), handle: '.bt_col_header'});
	
	
	var userAgent = navigator.userAgent.toLowerCase();

	
/*	this.fixSortable($('.bt_cwrap', this.container));
	this.fixSortable($('.bt_rwrap', this.container));
	this.fixSortable(this.container);*/
	
	this.rowcnt++;
}

/**
* @bref 컬럼만들기
* @param Object row
* @param string col_class
**/
WidgetPageEditor.prototype.createColumn = function(row, col_class){
	var col = $(document.createElement('div'));
	row.append(col);
	col.addClass('bt_widget_col');
	col.addClass(col_class);
	
	this.addHeader(col, 'col');
	
	var cwrap = $(document.createElement('div'));
	col.append(cwrap);
	cwrap.addClass('bt_cwrap');
}

/**
* @bref 파이어폭스에서 sortable할때 offset 버그 fix
* http://forum.jquery.com/topic/sortable-offset-when-element-is-dragged-and-page-scrolled-down-ff
* @param Object ele
**/
WidgetPageEditor.prototype.getSortOption = function(options){

	var userAgent = navigator.userAgent.toLowerCase();
	if(userAgent.match(/firefox/)) {
		options = $.extend(options, {
			start: function(event, ui) {
		        wscrolltop = $(window).scrollTop();
		    },
		    sort: function(event, ui) {                   
		        ui.helper.css({'top' : ui.position.top + wscrolltop + 'px'});
		    }
		});
	}

	return options;
}

/**
* @bref 헤더 추가
* @param Object parent 부모 Element
* @param string type 행 or 열 or 위젯 [row|col|widget]
* @param boolean pre 앞에 넣을지 여부
* @return
**/
WidgetPageEditor.prototype.addHeader = function(parent, type, pre){
	var header = $(document.createElement('p'));
	if(pre) parent.prepend(header);
	else parent.append(header);
	
	header.addClass('bt_'+type+'_header');
	//header.addClass('ui-widget-header ui-corner-all');
	
	var btn = $(document.createElement('span'));
	if(type=='row'){
		btn.addClass('bt_btn_row_del atk-icon atk-icons-nobg atk-icon-basic-ex');
		btn.attr('title', 'Remove Row');
		btn.click(function(){
			parent.remove();
		});
	}else if(type=='col'){
		btn.addClass('bt_btn_col_add atk-icon atk-icons-nobg atk-icon-basic-plus');
		btn.attr('title', 'Add Widget');
		var ref = this;
		btn.click(function(){
			//찍은위치 저장
			ref.cur_col = $(this).parent().parent();
			
			//다이얼로그
			ref.widgetDialog.dialog('open');
		});
		
		
	}else if(type=='widget'){
		btn.addClass('bt_btn_widget_del atk-icon atk-icons-nobg atk-icon-basic-ex');
		btn.attr('title', 'Remove Widget');
		btn.click(function(){
			parent.remove();
		});
	}
	
	header.append(btn);
	//var ul = $(document.createElement('ul'));
}

/*WidgetPageEditor.prototype.winopen = function(url, wname, w, h, s, r){
	var l = screen.availWidth / 2 - w / 2;
	var t = screen.availHeight / 2 - h / 2;

	var str = 'left=' + l + ', top=' + t + ', width=' + w +
		', height=' + h + ', toolbar=no, location=no';

	if(s == true) s = 'yes';  //auto는 IE만 먹음
	else s = 'no';
	str += ", scrollbars=" + s;

	if(r == true) r = 'yes';
	else r = 'no';
	str += ', resizable=' + r;

	return window.open(url, wname, str);
}*/


/**
* @bref 위젯 추가
* @param string wnum 위젯번호
* @param string margin CSS Margin
* @param string padding CSS Padding
**/
WidgetPageEditor.prototype.addWidget = function(wnum, margin, padding, col){
	
	var widget = $(document.createElement('div'));
	var cwrap = $('.bt_cwrap', this.cur_col);
	cwrap.append(widget);
	widget.data('wnum', wnum);
	widget.addClass('bt_widget');
	widget.css('margin', margin);
	widget.css('padding', padding);
	
	this.addHeader(widget, 'widget');
	
	var div = $(document.createElement('div'));
	widget.append(div);
	
	var qstr = '';
	if(this.options.qstr != '' ) qstr = '&' + qstr;
	
	div.load(this.options.widget_url + wnum + qstr);
	
	var cover = $(document.createElement('div'));
	cover.css('z-index', 99);
	div.append(cover);
	
	
	this.widgetDialog.dialog('close');
	
	cwrap.sortable(this.getSortOption({connectWith: cwrap, handle: '.bt_widget_header'}));
}

/**
* @bref HTML 을 에디터 모드로
**/
WidgetPageEditor.prototype.changeEditorMode = function(){
	var ref = this;
	$('.bt_widget_row', this.container).each(function(i, ele){
		
		var row = $(ele);
		
		ref.addHeader(row, 'row', true);
		
		var rwrap = $('.bt_rwrap', row);
		
		rwrap.sortable(ref.getSortOption({connectWith: rwrap, handle: '.bt_col_header'}));
		
		$('.bt_widget_col', rwrap).each(function(i, ele){
			
			var col = $(ele);
			
			ref.addHeader(col, 'col', true);
			
			var cwrap = $('.bt_cwrap', col);
			
			cwrap.sortable(ref.getSortOption({connectWith: cwrap, handle: '.bt_widget_header'}));
			
			$('.bt_widget', cwrap).each(function(i, ele){
				
				var widget = $(ele);
				
				//위젯 번호를 구해서 data에 넣어준다
				widget.data('wnum', widget.text().replace('{{', '').replace('}}', '') );

				var qstr = '';
				if(ref.options.qstr != '' ) qstr = '&' + qstr;
				
				widget.load(ref.options.widget_url + widget.data('wnum') + qstr, function(){
					ref.addHeader(widget, 'widget', true);
				});
			});
			
			$('.bt_cwrap', col).sortable(ref.getSortOption({connectWith: $('.bt_cwrap', col), handle: '.bt_widget_header'}));
			
		});
		
	});
	
	this.container.sortable(this.getSortOption({connectWith: this.container, handle: '.bt_row_header'}));
	
/*	this.fixSortable($('.bt_cwrap', this.container));
	this.fixSortable($('.bt_rwrap', this.container));
	this.fixSortable(this.container);*/
}

/*
WidgetPageEditor.prototype.changeShowMode = function(){
	var ref = this;
	$('.bt_widget_row', this.container).each(function(i, ele){
		
		var row = $(ele);
		
		var rwrap = $('.bt_rwrap', row);
		
		$('.bt_widget_col', rwrap).each(function(i, ele){
			
			var col = $(ele);
			
			var cwrap = $('.bt_cwrap', col);
			
			var qstr = '';
			if(ref.options.qstr != '' ) qstr = '&' + ref.options.qstr;
		
			$('.bt_widget', cwrap).each(function(i, ele){
				var widget = $(ele);
				widget.data('wnum', widget.text());
				widget.load(ref.options.widget_url + widget.text() + qstr);
			});
			
		});
	});
}
*/

/**
* @bref 데이타용 HTML 로 변환 후 리턴
* @return string
**/
WidgetPageEditor.prototype.getHTML = function(){

	this.resultContainer.html(this.container.html());
	$('.bt_row_header', this.resultContainer).remove();
	$('.bt_col_header', this.resultContainer).remove();
	$('.bt_widget_header', this.resultContainer).remove();
	
	for(var i=0; i < $('.bt_widget', this.container).size();i++){
		
		var r_widget = $($('.bt_widget', this.resultContainer).get(i));
		var o_widget = $($('.bt_widget', this.container).get(i));
		
		r_widget.html('{{' + (o_widget.data('wnum')) + '}}');
	}
	
	$('.ui-sortable', this.resultContainer).removeClass('ui-sortable');
	
	//위젯이 하나라도 있어야 html을 리턴함
	if(i > 0){
		return this.resultContainer.html();
		
	//위젯이 없을때 공백으로 보내줌
	}else{
		//반드시 공백으로 보내준다(undefined 처리하기 싫음)
		return '';
	}
}