<?php
$sub_menu = "400200";
include_once("./_common.php");

auth_check($auth[$sub_menu], 'w');

$g5['title'] = '사이트메뉴관리';
$administrator = 1;
include_once(G5_ADMIN_PATH.'/admin.head.php');

$colspan=12;

//메뉴 탐색기 생성
$mm = Menu::getInstance();

//메뉴목록 구함
$list = $mm->getList('both');

//메뉴타입
$type_s = new SelectBox();
$type_s->add('group', '게시판그룹');
$type_s->add('board', '게시판');
$type_s->add('page', '페이지');
$type_s->add('link', '외부링크');

// PC용 레이아웃 스킨 옵션
$dir = BT_SKIN_PATH.'/layout';
$dirs = FileDir::getDirEntry($dir, 'd', 'php');
$layout_s = new SelectBox();
foreach($dirs as $key=>$val) $layout_s->add($val, $val);

// 모바일용 레이아웃 스킨 옵션
$dir = BT_MSKIN_PATH.'/layout';
$dirs = FileDir::getDirEntry($dir, 'd', 'php');
$mlayout_s = new SelectBox();
foreach($dirs as $key=>$val) $mlayout_s->add($val, $val);

//사이드바 옵션
$sql = "SELECT * FROM ".$bt['wpage_table']." WHERE wp_type='side' ORDER BY wp_id";
$result = $bdb->query($sql);
$sidebar_s = new SelectBox();
while($row = $bdb->fetch($result)){
	$sidebar_s->add($row['wp_id'], $row['wp_title']);
}

//링크타겟옵션 만들기
$target_s = new SelectBox();
$target_s->add('_self', '현재창');
$target_s->add('_blank', '새창');

//접근권한옵션 만들기
$perm_s = new SelectBox();
for($i=1;$i<=10;$i++) $perm_s->add($i, $i);

//접속기기 옵션 만들기
$device_s = new SelectBox();
$device_s->add('both', '모두');
$device_s->add('pc', 'PC');
$device_s->add('mobile', '모바일');
?>

<link rel="stylesheet" type="text/css" href="icons/atk-icons.css" />

<style type='text/css'>
.type_group{color:#808000}
.type_board{color:#777}
.type_page{color:#8080FF}
.type_link{color:#FC6727}

.td_skin{width:120px;text-align:center}
</style>

<script type="text/javascript">
<!--
function openNew(){
	
}

function openEditor(){
	var qstr = '';
	
	if(arguments[0]!=undefined && arguments[0].trim()!='') qstr = '?bm_pidx=' + arguments[0];
	if(arguments[1]!=undefined && arguments[1].trim()!='') qstr = '?bm_idx=' + arguments[1];
	
	var url = './menu_form.php' + qstr;
	Cmm.Win.open(url, 'wmenu', 600, 850, true, true);
}

function chkDel(bm_idx){
	if(!confirm('정말 삭제할까요?')) return;
	location.href='./menu_update.php?w=d&bm_idx=' + bm_idx;
}
//-->
</script>

<div class="local_ov01 local_ov">
    <?php echo $listall ?>
    생성된 메뉴수 <?php echo number_format(count($list)) ?>
</div>

<?php if ($is_admin == 'super') { ?>
<div class="btn_add01 btn_add">
    <a href="./menu_form.php" onclick="openEditor();return false;" id="mm_add">최상위 메뉴 추가</a>
</div>
<?php } ?>

<form name="fmenulist" id="fmenulist" action="./menu_update.php" onsubmit="return fmenulist_submit(this);" method="post">
<input type="hidden" name="w" value="mu">
<div class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> 목록</caption>
    <thead>
    <tr>
        <th scope="col" rowspan="2">
            <label for="chkall" class="sound_only">그룹 전체</label>
            <input type="checkbox" name="chkall" value="1" id="chkall" onclick="check_all(this.form)">
        </th>
        <th scope="col" rowspan="2">메뉴이름</th>
        <th scope="col" rowspan="2">메뉴타입</th>
        <th scope="col" rowspan="2">바로가기</th>
        <th scope="col" rowspan="2">링크타겟</th>
        <th scope="colgroup" colspan="2">스킨</th>
        <th scope="col" rowspan="2">사이드바</th>
        <th scope="col" rowspan="2">접근권한</th>
        <th scope="col" rowspan="2">접속기기</th>
        <th scope="col" rowspan="2">숨김</th>
        <th scope="col" rowspan="2">수정</th>
        <th scope="col" rowspan="2">삭제</th>
    </tr>
    <tr>
    	<th scope="col">PC</th>
    	<th scope="col">Mobile</th>
    </tr>
    </thead>
    <tbody>
	<?php
    for ($i=0;$i<count($list);$i++)
    {
    	$row = $list[$i];
    	
    	if($row['bm_type']=='group') $bm_type = "게시판그룹";
    	else if($row['bm_type']=='board') $bm_type = "게시판";
    	else if($row['bm_type']=='page') $bm_type = "페이지";
    	else if($row['bm_type']=='link') $bm_type = "외부링크";
    	
        $s_upd = '<a href="./menu_form.php?w=u&amp;bm_idx='.$row['bm_idx'].'" onclick="openEditor(\'\', \''.$row['bm_idx'].'\');return false">수정</a>';
        $s_del = '<a href="./menu_update.php?w=d&amp;bm_idx='.$row['bm_idx'].'" onclick="chkDel(\''.$row['bm_idx'].'\');return false">삭제</a>';
        
        //위로 버튼
        if($row['ulink']) $s_up = '<a href="./menu_update.php?w=up&amp;bm_idx='.$row['bm_idx'].'&amp;bm_pidx='.$row['bm_pidx'].'&amp;bm_step='.$row['bm_step'].'" class="atk-icon atk-icon-arrows-top atk-icons-nobg" title="위로이동"><span class="sound_only">위로 이동</span></a>';
        else $s_up = '<span class="atk-icon atk-icon-arrows-top atk-icons-nobg"></span>';
        
        //아래로 버튼
        if($row['dlink']) $s_dn = '<a href="./menu_update.php?w=dn&amp;bm_idx='.$row['bm_idx'].'&amp;bm_pidx='.$row['bm_pidx'].'&amp;bm_step='.$row['bm_step'].'" class="atk-icon atk-icon-arrows-bottom atk-icons-nobg" title="아래로이동"><span class="sound_only">아래로 이동</span></a>';
        else $s_dn = '<span class="atk-icon atk-icon-arrows-bottom atk-icons-nobg"></span>';
        
        //하위메뉴추가 버튼
        $s_add = '<a href="./menu_update.php?w=&amp;bm_pidx='.$row['bm_idx'].'" class="atk-icon atk-icon-basic-plus atk-icons-nobg" title="하위메뉴추가" onclick="popup_window(\'./menu_form.php?w=&amp;bm_pidx='.$row['bm_idx'].'\', \'wmenu\', \'width=550, height=700\');return false;"><span class="sound_only">하위메뉴추가</span></a>';

        $bg = 'bg'.($i%2);
        
        //SelectBox 들
        $target_s->selectedFromValue = $row['bm_target'];
        
        $layout_s->selectedFromValue = $row['bm_skin_layout'];
        
        $mlayout_s->selectedFromValue = $row['bm_skin_mlayout'];
        
        $sidebar_s->selectedFromValue = $row['bm_sidebar'];
        
        $perm_s->selectedFromValue = $row['bm_perm'];
        
        $device_s->selectedFromValue = $row['bm_device'];
        
        $padding_left = $row['bm_depth'] * 20 + 4;
        
        $alink = Menu::getMenuLink($row);
        
        if($row['bm_type']=='board' || $row['bm_type']=='page') $att = $row['bm_mid'];
        else if($row['bm_type']=='link') $att = '외부링크';
        else if($row['bm_type']=='group') $att = '그룹';
    ?>
    <tr>
    	<td class="td_chk">
            <input type="hidden" name="bm_idx[<?php echo $i ?>]" value="<?php echo $row['bm_idx'] ?>">
            <label for="chk_<?php echo $i; ?>" class="sound_only"><?php echo $row['gr_subject'] ?> 그룹</label>
            <input type="checkbox" name="chk[]" value="<?php echo $i ?>" id="chk_<?php echo $i ?>">
        </td>
        <td style="padding-left:<?=$padding_left?>px">
        	<label for="bm_name_<?php echo $i; ?>" class="sound_only">메뉴이름</label>
            <input type="text" name="bm_name[<?php echo $i ?>]" value="<?php echo get_text($row['bm_name']) ?>" id="bm_name_<?php echo $i ?>" size="15" maxlength="20" class="frm_input">
            <?=$s_up?><?=$s_dn?><?=$s_add?>
        </td>
        <td class="td_grid"><span class="type_<?=$row['bm_type']?>"><?=$bm_type?></span></td>
        <td class="td_grid"><span class="type_<?=$row['bm_mid']?>"><a href="<?php echo $alink?>" target="_blank"><?=$att?></a></span></td>
        <td class="td_grid">
        	<label for="bm_target_<?php echo $i; ?>" class="sound_only">타겟</label>
            <select name="bm_target[<?php echo $i ?>]"><?=$target_s->getOption()?></select>
        </td>
        <td class="td_grid">
        	<select name="bm_skin_layout[<?php echo $i ?>]"><?=$layout_s->getOption()?></select>
        </td>
        <td class="td_grid">
        	<select name="bm_skin_mlayout[<?php echo $i ?>]"><?=$mlayout_s->getOption()?></select>
        </td>
        <td class="td_grid">
        	<label for="bm_sidebar_<?php echo $i; ?>" class="sound_only">사이드바</label>
        	<select name="bm_sidebar[<?php echo $i ?>]"><?=$sidebar_s->getOption()?></select>
        </td>
        <td class="td_grid">
        	<label for="bm_perm_<?php echo $i; ?>" class="sound_only">접근권한</label>
        	<select name="bm_perm[<?php echo $i ?>]"><?=$perm_s->getOption()?></select>
        </td>
        <td class="td_grid">
        	<label for="bm_device_<?php echo $i?>" class="sound_only">접속기기</label>
        	<select name="bm_device[<?php echo $i?>]"><?php echo $device_s->getOption()?></select>
        </td>
        <td class="td_chk">
        	<label for="bm_hide_<?php echo $i?>" class="sound_only">숨김</label>
        	<input type="checkbox" name="bm_hide[<?php echo $i?>]" value="1" <?=$row['bm_hide'] ? 'checked="checked"' : '';?>>
        </td>
        <td class="td_grid">
        	<?=$s_upd?>
        </td>
        <td class="td_grid">
        	<?=$s_del?>
        </td>
    </tr>
	<?php
    }
    if ($i == 0)
        echo '<tr><td colspan="'.$colspan.'" class="empty_table">자료가 없습니다.</td></tr>';
    ?>
    </tbody>
	</table>
</div>

<div class="btn_list01 btn_list">
    <input type="submit" name="act_button" onclick="document.pressed=this.value" value="선택수정">
    <a href="./menu_form.php" onclick="openEditor();return false;" id="mm_add">최상위 메뉴 추가</a>
</div>

</form>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');