<?php
$sub_menu = "400500";
include_once('./_common.php');

if ($is_admin != 'super')
    alert('최고관리자만 접근 가능합니다.');
    
$token = get_token();

$sql_common = 'FROM '.$bt['popup_table'];

//===========================================================================
// 조건절 처리
//===========================================================================
$sql_search = " WHERE (1) ";
if ($stx) {
    $sql_search .= " AND ( ";
    switch ($sfl) {
        default :
            $sql_search .= " ({$sfl} LIKE '%{$stx}%') ";
            break;
    }
    $sql_search .= " ) ";
}

//===========================================================================
// 출력순서 처리
//===========================================================================
if (!$sst) {
    $sst  = "bp_regdate";
    $sod = "DESC";
}
$sql_order = " ORDER BY $sst $sod ";

//===========================================================================
// 레코드 개수 구함
//===========================================================================
$sql = " SELECT COUNT(*) AS cnt
            {$sql_common}
            {$sql_search}
            {$sql_order} ";
$total_count = $bdb->result($sql);

//===========================================================================
// 페이징 계산
//===========================================================================
$rows = $config['cf_page_rows'];
$total_page  = ceil($total_count / $rows);  // 전체 페이지 계산
$page = Str::binValue($_GET['page'], 1);
$from_record = ($page - 1) * $rows; // 시작 열을 구함

//===========================================================================
// 목록 쿼리
//===========================================================================
$sql = "SELECT * FROM ".$bt['popup_table'].$sql_search.$sql_order;
$result = $bdb->query($sql);

//===========================================================================
// 검색 SelectBox 옵션
//===========================================================================
$g5['title'] = '팝업관리';
$administrator = 1;
include_once(G5_ADMIN_PATH.'/admin.head.php');

function getFieldStr($field, $val){
	switch($field){
		case 'bp_type':
			if($val == 'image')	return "이미지형";
			else return "HTML형";
			break;
		
		case 'bp_show_subject':
			if($val == '1') return "제목보임";
			else return "제목숨김";
			break;
		
		case 'bp_show_closeopt':
			if($val == '1') return "사용함";
			else return "사용안함";
			break;
			
		case 'bp_target':
			if($val == '_blank') return '새창';
			else return '현재창';
			break;
		
		default:
	}
}
?>


<script type="text/javascript">
<!--
function delCheck(bp_idx){
	if(!confirm('삭제할까요?')) return;
	locaion.href = './popup_update.php?w=d&bp_idx=' + bp_idx + '&<?php echo $qstr?>';
}
//-->
</script>

<div class="local_ov01 local_ov">
    <?php echo $listall ?>
    팝업관리 <?php echo number_format($total_count) ?>건
</div>

<form name="fsearch" id="fsearch" class="local_sch01 local_sch" method="get">
<input type="hidden" name="sfl" value="bp_subject">
<label for="stx">제목<strong class="sound_only"> 필수</strong></label>
<input type="text" name="stx" value="<?php echo $stx ?>" id="stx" required class="required frm_input">
<input type="submit" value="검색" id="fsearch_submit" class="btn_submit">
</form>

<?php if ($is_admin == 'super') { ?>
<div class="btn_add01 btn_add">
    <a href="./popup_form.php" id="bp_add">팝업 추가</a>
</div>
<?php } ?>

<form name="fpopuplist" id="fpopuplist" method="post" action="./popup_update.php" onsubmit="return fpopuplist_submit(this);">
<input type="hidden" name="sst" value="<?php echo $sst ?>">
<input type="hidden" name="sod" value="<?php echo $sod ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type="hidden" name="token" value="<?php echo $token ?>">
<input type="hidden" name="w" value="md">

<div class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> 목록</caption>
    <thead>
    <tr>
        <th scope="col">
            <label for="chkall" class="sound_only">전체</label>
            <input type="checkbox" name="chkall" value="1" id="chkall" onclick="check_all(this.form)">
        </th>
        <th scope="col"><?php echo subject_sort_link('bp_subject') ?>제목</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_type') ?>구분</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_show_subject') ?>제목노출</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_show_closeopt') ?>닫기옵션</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_close_hour') ?>닫기시간</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_sdate') ?>시작일자</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_edate') ?>종료일자</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_url') ?>URL</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_target') ?>링크타겟</a></th>
        <th scope="col"><?php echo subject_sort_link('bp_hide') ?>숨김</a></th>
        <th scope="col">수정</th>
        <th scope="col">삭제</th>
    </tr>
    </thead>
    <tbody>
<?php for ($i=0; $row=sql_fetch_array($result); $i++){?>
	<tr>
		<td class="td_chk">
			<input type="hidden" name="bp_idx[<?php echo $i ?>]" value="<?php echo $row['bp_idx'] ?>">
            <label for="chk_<?php echo $i; ?>" class="sound_only">선택</label>
            <input type="checkbox" name="chk[]" value="<?php echo $i ?>" id="chk_<?php echo $i ?>">
		</td>
		<td class="td_subject"><?php echo $row['bp_subject']?></td>
		<td class="td_grid"><?php echo getFieldStr('bp_type', $row['bp_type'])?></td>
		<td class="td_grid"><?php echo getFieldStr('bp_show_subject', $row['bp_show_subject'])?></td>
		<td class="td_grid"><?php echo getFieldStr('bp_show_closeopt', $row['bp_show_closeopt'])?></td>
		<td class="td_grid"><?php echo Popup::getHourToDay($row['bp_close_hour'])?></td>
		<td class="td_datetime"><?php echo $row['bp_sdate']?></td>
		<td class="td_datetime"><?php echo $row['bp_edate']?></td>
		<td class="td_grid"><?php if($row['bp_type']=='image' && $row['bp_url']!=''){?><a href="<?php echo $row['bp_url']?>" target="_blank" alt="<?php echo $row['bp_url']?>" title="<?php echo $row['bp_url']?>">보기</a><?php }?></td>
		<td class="td_grid"><?php echo getFieldStr('bp_target', $row['bp_target'])?></td>
		<td class="td_grid"><?php echo $row['bp_hide']=='1' ? '숨김':''?></td>
		<td class="td_grid"><a href="./popup_form.php?bp_idx=<?php echo $row['bp_idx']?>&<?php echo $qstr?>">수정</a></td>
		<td class="td_grid"><a href="./popup_update.php?w=d&bp_idx=<?php echo $row['bp_idx']?>&<?php echo $qstr?>" onclick="delCheck('<?php echo $row['bp_idx']?>');return false">삭제</a></td>
	</tr>
<?php }?>
    </tbody>
	</table>
</div>

<div class="btn_list01 btn_list">
    <input type="submit" name="act_button" value="선택삭제" onclick="document.pressed=this.value">
</div>

</form>


<?php
$pagelist = get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, $_SERVER['PHP_SELF'].'?'.$qstr.'&amp;page=');
echo $pagelist;
?>


<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
