<?php
class BartConfig{
	
	private $db;
	private $table;
	private $config;
	
	public function __construct(){
		$this->db = DB::getInstance();
		$this->table = BT_PREFIX.'config';
	}
	
	public function getConfig($reflash=false){
		if(empty($config) || $reflash){
			$sql = "SELECT * FROM ".$this->table." LIMIT 1";
			$this->config = $this->db->fetch($sql);
			
			$data = array();
			$list = explode('|', $this->config['bc_alevel_data']);
			for($i=0;$i<count($list);$i++){
				$temp = explode('#', $list[$i]);
				$data[(string)$temp[0]] = $temp[1];
			}
			$this->config['alevel_data'] = $data;
		}
		return $this->config;
	}
	
	public static function getInstance(){
		static $inst;
		if(empty($inst)) $inst = new BartConfig();
		return $inst;
	}
}