<?php
class WidgetBuilder{
	
	private $data;
	private $wid;
	private $template;

	/**
	* @bref 생성자
	**/	
	public function __construct(){
		$this->data = array();
	}
	
	/**
	* @bref 위젯 아이디세팅(디렉토리 이름)
	* @param string $wid
	**/
	public function setId($wid){
		$this->wid = $wid;
	}
	
	/**
	* @bref 위젯별 설정값 세팅(템플릿에서 치환될 값 세팅)
	* @param string $key
	* @param string $val
	**/
	public function assign($key, $val){
		$key = $this->convert($key);
		$val = $this->convert($val);
		$this->data[$key] = $val;
	}
	
	/**
	* @bref php태그 제거
	* @param string $str
	* @return string
	**/
	private function convert($str){
		//preg_match('/![\w\x{1100}-\x{11FF}\x{3130}-\x{318F}\x{AC00}-\x{D7AF}]/u', $str, $mat);
		$str = str_replace('<?', '', $str);
		$str = str_replace('?>', '', $str);
		$str = str_replace('<%', '', $str);
		$str = str_replace('%>', '', $str);
		return $str;
	}

	/**
	* @bref 템플릿파일 세팅
	**/	
	public function setTemplate($filename){
		$filepath = BT_WIDGET_PATH.'/'.$this->wid.'/'.$filename;
		if(!is_file($filepath)) alert('템플릿파일이 존재하지 않습니다 - '.$filename);
		$this->template = @implode('', file($filepath));
	}
	
	/**
	* @bref 위젯 인스턴스 만들기
	**/
	public function build(){
		foreach($this->data as $key=>$val){
			$this->template = str_replace($key, $val, $this->template);
		}
		
		$dirname = date('YmdHis').sprintf('%03d', mt_rand(1, 999));

		FileDir::autoMkDir(BT_WINST_PATH.'/'.$dirname, 0707);
		$fp = fopen(BT_WINST_PATH.'/'.$dirname.'/widget.php', 'w');
		fwrite($fp, $this->template);
		fclose($fp);
	}
	
	/**
	* @bref 위젯컨테이너 페이지 빌드
	* @param string $html
	* @param string $page_id 확장자제외한 파일이름, 중복체크 안함(주의)
	* @return string 파일이름
	**/
	public function savePage($html, $page_name){
		
		//파일이름, 경로 만들기
		//$filename = date('YmdHis').sprintf('%03d', mt_rand(1, 999)).'.php';
		$filepath = BT_WPAGE_PATH.'/'.$page_name.'.php';
		
		//파일저장
		FileDir::autoMkDir(BT_WPAGE_PATH, 0707);
		$fp = fopen($filepath, 'w');
		fwrite($fp, $html);
		fclose($fp);
	}
	
	/**
	* @bref 사용자 뷰 모드로 변경
	* @param string $page_name
	* @return string
	**/
	public function getParsePage($page_name){
		
		$filepath = BT_WPAGE_PATH.'/'.$page_name.'.php';
		
		$html = '';
		if(is_file($filepath)){
			
			$html = file_get_contents($filepath);
			
			//위젯번호 찾기
			$pat = '/{{([0-9]+)}}/';
			preg_match_all($pat, $html, $matches);
			
			//위젯번호를 실제소스로 치환한다
			for($i=0;$i<count($matches[1]);$i++){
				ob_start();
				include(BT_WINST_PATH.'/'.$matches[1][$i].'/widget.php');
				$content = ob_get_contents();
				ob_end_clean();
				$html = str_replace('{{'.$matches[1][$i].'}}', $content, $html);
			}
		}
		
		return $html;
	}
	
	/**
	* @bref 위젯 컨테이너 페이지 삭제
	* @param string $page_name
	**/
	public function removePage($page_name){
		@unlink(BT_WPAGE_PATH.'/'.$page_name.'.php');
	}
	
	/**
	* @bref 위젯컨테이너 페이지 내용 리턴
	* @return string
	**/
	public function getSourcePage($page_name){

		$content = '';
		$filename = $page_name.'.php';
		if(is_file(BT_WPAGE_PATH.'/'.$filename)){
			ob_start();
			include_once(BT_WPAGE_PATH.'/'.$filename);
			$content = ob_get_contents();
			ob_end_clean();
		}
		return $content;
	}
	
	/**
	* @bref 싱글턴
	* @return WidgetBuilder
	**/
	public function getInstance(){
		static $inst;
		if(empty($inst)) $inst = new WidgetBuilder();
		return $inst;
	}
}