<?
/**
* @file EventDispatcher.php
*
* @class EventDispatcher
*
* @bref 이벤트 디스패처
*   - 이벤트 프로그램의 addEventListener 모방
*
* @date
*
* @author 권혁준(impactlife@naver.com)
*
* @copyright PLUGSYS.co.kr & Kwon Hyuk-June. All rights reserved.
*
* @section MODIFYINFO
* 	- 없음/없음
*
* @section Example
*   - 없음
*/

interface IEventDispatcher{
	
	public function addEventListener($eventname, $method, $object=null);
	public function dispatchEvent($eventname);
	public function existCallBack($eventname);
	
}

class EventDispatcher{

    private $starr = array();

    public function __construct(){}

    /**
    * @bref 메쏘드 또는 함수 등록
    **/
    public function addEventListener($eventname, $method, &$object=null){
        array_push($this->starr, array("eventname"=>(string)($eventname), "method"=>(string)$method, "object"=>$object));
    }

    /**
    * @bref 콜백 실행
    * @param string $eventname
    * @param mixed $arg1, ...
    **/
    public function dispatchEvent($eventname, $args=''){

        $args = func_get_args();
        array_shift($args); //첫번째 인자인 eventname는 args에서 제외시킨다

        for($i=0;$i<count($this->starr);$i++){
        	$eventname = (string)$eventname;
        	if($this->starr[$i]["eventname"]==$eventname){
        		if(is_object($this->starr[$i]["object"])){
        			call_user_method_array($this->starr[$i]["method"], $this->starr[$i]["object"], $args);
        		}else{
        			call_user_func_array($this->starr[$i]["method"], $args);
        		}
        	}
        }
    }

    /**
    * @bref 해당 콜백이 등록되어 있는지 검사
    **/
    public function existCallBack($eventname){

    	$eventname = (string)$eventname;
    	
    	for($i=0;$i<count($this->starr);$i++){
    		if($this->starr[$i]["eventname"]==$eventname && isset($this->starr[$i]["method"])){
    			return true;
    		}
    	}
    	return false;
    }
}