<?php
/**
* @file JsonUtil.php
*
* @class JsonUtil
*
* @bref JSON 출력 Utility
*  - 배열을 JSON으로 출력한다.
*  - 원래 소스가 아마도 행복한 고니님꺼였던가...기억이 잘 안남
*
* @date 2008
*
* @author 권혁준(impactlife@naver.com)
*
* @copyright PLUGSYS.co.kr & Kwon Hyuk-June. All rights reserved.
*
* @section MODIFYINFO
* 	- 없음/없음
*
* @section Example
*   - 없음
*/
class JsonUtil{
	public static function encode($data) {
		switch (gettype($data)) {
			case 'boolean':
				return $data?'true':'false';
			case 'integer':
			case 'double':
				return $data;
			case 'string':
				return '"'.strtr($data, array('\\'=>'\\\\','"'=>'\\"')).'"';
			case 'array':
				$rel = false;
				$key = array_keys($data);
				foreach ($key as $v){
					if (!is_int($v)){
						$rel = true;
						break;
					}
				}

				$arr = array();
				foreach ($data as $k=>$v) {
					$arr[] = ($rel?'"'.strtr($k, array('\\'=>'\\\\','"'=>'\\"')).'":':'').self::encode($v);
				}

				return $rel?'{'.join(',', $arr).'}':'['.join(',', $arr).']';
			default:
				return '""';
		}
	}
}