<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

/**
* @bref 사이트메뉴 출력
* @param string $skin 스킨
* @param int $depth 출력 깊이(0 부터시작)
* @return
**/
function bt_sidemenu($skin, $depth=1){
	
	global $bt, $config;

	$ms = Menu::getInstance();

	$bm_pidx = Str::binValue($bt['curpath'][0]['bm_idx'], 0);

	if($bm_pidx > 0){
		$list = $ms->getTreeList('pc', true, $bm_pidx);
	}else{
		$list = $ms->getTreeList('pc', true, '0', $depth);
	}
	
	$bm_idx = $bt['curmenu']['bm_idx'];
	
	$title = $bt['curpath'][0]['bm_name'];
	if($bm_pidx){
    	$title = $bt['curpath'][0]['bm_name'];
	}else{
		$titie =$config['cf_title'];
	}

	ob_start();
	include(BT_SKIN_PATH.'/sidemenu/'.$skin.'/sidemenu.skin.php');
	$content = ob_get_contents();
    ob_end_clean();
    
	return $content;
}

/**
* @bref 레벨변동시 쪽지 보내기 (AutoLevelUp 클래스 콜백함수)
* @param string $mb_id
* @param string $mode : up or down
* @param int $new_level : 업데이트된 레벨
* @param int $std_point : 기준 포인트
* @return
**/
function bt_sendLevelupMsg($mb_id, $mode, $new_level, $std_point){
	
	global $config, $g5;
	
	$bdb = DB::getInstance();
	
	// 쪽지 INSERT
	$tmp_row = sql_fetch(" select max(me_id) as max_me_id from {$g5['memo_table']} ");
    $me_id = $tmp_row['max_me_id'] + 1;
    
    if($mode=='up'){
		$memo = number_format($std_point)."포인트를 초과하여 레벨 ".$new_level."(으)로 승격되었습니다";
	}else{
		$memo = number_format($std_point)."포인트 이하로 떨어져 레벨 ".$new_level."(으)로 강등되었습니다";
	}
        
    $arr = array();
	$arr['me_id'] = $me_id;
	$arr['me_recv_mb_id'] = $mb_id;
	$arr['me_send_mb_id'] = $config['cf_admin'];
	$arr['me_send_datetime'] = G5_TIME_YMDHIS;
	$arr['me_memo'] = $memo;
	$bdb->insert($g5['memo_table'], $arr);

	// 실시간 쪽지 알림 기능
	$sql = "UPDATE ".$g5['member_table']." SET 
		mb_memo_call = '".$bdb->esc($config['cf_admin'])."'
		WHERE mb_id='".$bdb->esc($mb_id)."'";
	$bdb->query($sql);
}