<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//===========================================================================
// 상수정의
//===========================================================================
define('DS', DIRECTORY_SEPARATOR);

//DB TABLE PREFIX
define('BT_PREFIX', 'bt_');

//BART 빌더 경로
define('BT_DIR', 'bart');
define('BT_PATH', G5_PATH.'/'.BT_DIR);
define('BT_URL', G5_URL.'/'.BT_DIR);

//라이브러리 경로
define('BT_LIB_PATH', BT_PATH.'/libs');

//관리자 경로
define('BT_ADMIN_DIR', 'adm');
define('BT_ADMIN_PATH', BT_PATH.'/'.BT_ADMIN_DIR);
define('BT_ADMIN_URL', BT_URL.'/'.BT_ADMIN_DIR);

//모듈 경로
define('BT_MOD_DIR', 'modules');
define('BT_MOD_PATH', BT_PATH.'/'.BT_MOD_DIR);
define('BT_MOD_URL', BT_URL.'/'.BT_MOD_DIR);

//플러그인 경로
define('BT_PLG_DIR', 'plugins');
define('BT_PLG_PATH', BT_PATH.'/'.BT_PLG_DIR);
define('BT_PLG_URL', BT_URL.'/'.BT_PLG_DIR);

//위젯 경로
define('BT_WIDGET_DIR', 'widgets');
define('BT_WIDGET_PATH', BT_PATH.'/'.BT_WIDGET_DIR);
define('BT_WIDGET_URL', BT_URL.'/'.BT_WIDGET_DIR);

//위젯객체 경로
define('BT_WINST_DIR', 'winst');
define('BT_WINST_PATH', G5_DATA_PATH.'/'.BT_WINST_DIR);

//위젯캐시페이지 경로
define('BT_WPAGE_DIR', 'wpage');
define('BT_WPAGE_PATH', G5_DATA_PATH.'/'.BT_WPAGE_DIR);

define('BT_MOBILE_DIR', 'mobile');
define('BT_MOBILE_PATH', BT_PATH.'/'.BT_MOBILE_DIR);
define('BT_MOBILE_URL', BT_URL.'/'.BT_MOBILE_DIR);

//바트빌더 고유 스킨 경로
define('BT_SKIN_DIR', 'skin');
define('BT_SKIN_PATH', BT_PATH.'/'.BT_SKIN_DIR);
define('BT_SKIN_URL', BT_URL.'/'.BT_SKIN_DIR);

//바트빌더 고유 스킨 모바일 경로
define('BT_MSKIN_DIR', 'mobile/skin');
define('BT_MSKIN_PATH', BT_PATH.'/'.BT_MSKIN_DIR);
define('BT_MSKIN_URL', BT_URL.'/'.BT_MSKIN_DIR);

//기본위젯페이지명
define('BT_WPAGEINST_MAIN', '__BART_MAIN__');
define('BT_WPAGEINST_SIDE', '__BART_SIDEBAR__');

//바트빌더 홈페이지 주소
define('BT_HOMEPAGE_URL', 'http://dev.plugsys.co.kr');

//===========================================================================
// 디버그모드 or 릴리즈 모드
//===========================================================================
//디버그모드(true), 릴리즈모드(false)
define('BT_DEBUG', true);

if(BT_DEBUG) ini_set('display_errors', '1');
else ini_set('display_errors', '0');

//===========================================================================
// 오토로드 정의
//===========================================================================
include(BT_LIB_PATH.'/Loader.php');

//클래스 자동로드 프로시저 지정
Loader::autoloadSetup();

//BART라이브러리를 오토로드 대상으로 지정함
Loader::registAll(BT_LIB_PATH.'/classes');

//===========================================================================
// 에러핸들러 정의
//===========================================================================
set_error_handler(array(BTError::getInstance(), 'showError'));


//===========================================================================
// 테이블 정의
//===========================================================================
$bt = array();
$bt['config_table'] = BT_PREFIX.'config';
$bt['menu_table'] = BT_PREFIX.'menu';
$bt['page_table'] = BT_PREFIX.'page';
$bt['popup_table'] = BT_PREFIX.'popup';
$bt['wpage_table'] = BT_PREFIX.'widget_page';

//===========================================================================
// 디버그모드일때 DB클래스에도 적용시켜줌
//===========================================================================
/** @var DB **/ //IDE에서 DB 클래스를 인식못해서 주석 추가해 줌
if(BT_DEBUG) DB::getInstance()->setDebug(true);

//===========================================================================
// 기본 함수 로드
//===========================================================================
include_once(BT_LIB_PATH.'/functions/bt.common.lib.php');

//===========================================================================
// 메뉴 로드
//===========================================================================
$btmenu = Menu::getInstance();
if(G5_IS_MOBILE) $device = 'mobile';
else $device = 'pc';
$list = $btmenu->getTreeList($device, true, '0');

//===========================================================================
// 기본 인스턴스 생성
//===========================================================================
//바트 config 로드
$btcfg = BartConfig::getInstance()->getConfig();

//DB
$bdb = DB::getInstance();

//===========================================================================
// 현재위치 파악
//===========================================================================
if($bm_idx){
	$bt['curmenu'] = $btmenu->getWithIdx($bm_idx);
	$bt['curpath'] = $btmenu->getPath($bm_idx);
	
}else{
	if($bm_type && $bm_mid){
		$bt['curmenu'] = $btmenu->getWithMid($bm_type, $bm_mid);
		$bt['curpath'] = $btmenu->getPath($bt['curmenu']['bm_idx']);
	}else{
		if($bo_table){
			$bt['curmenu'] = $btmenu->getWithMid('board', $bo_table);
			$bt['curpath'] = $btmenu->getPath($bt['curmenu']['bm_idx']);
		}else if($bp_id){
			$bt['curmenu'] = $btmenu->getWithMid('page', $bp_id);
			$bt['curpath'] = $btmenu->getPath($bt['curmenu']['bm_idx']);
		}
	}
}
//타이틀
$cur_title = $bt['curpath'][count($bt['curpath'])-1]['bm_name'];

//현재위치
$cur_path = Menu::getPathString($bt['curpath']);

//===========================================================================
// 사이드메뉴 정의
//===========================================================================
if($bt['curmenu']){
	$bt['sidebar'] = 'side_'.$bt['curmenu']['bm_sidebar'];
}else{
	$bt['sidebar'] = BT_WPAGEINST_SIDE;
}

//===========================================================================
// 접근권한 체크
//===========================================================================
if($bt['curmenu']['bm_perm'] > $member['mb_level']){
	if(!$member['mb_id']){
		alert("접근 권한이 없습니다.\\n회원이시라면 로그인 후 이용해 보십시오.", G5_BBS_URL.'/login.php?'.$qstr.'&url='.urlencode($_SERVER['PHP_SELF'].'?bo_table='.$bo_table));
	}else{
		alert('회원님의 회원등급으로 접근할 수 없는 메뉴입니다');
	}
}


//===========================================================================
// 위젯용 qstr 만들기 : 본문에서 받은 파라미터를 위젯에게 그대로 보내 줌
//===========================================================================
/*$bt['qstr'] = '';
foreach($_REQUEST as $key => $val){
	$bt['qstr'] .= $key .'='.$val;
}*/