<?php
$sub_menu = "200300";
include_once('./_common.php');

if (!$config['cf_email_use'])
    alert(_t('환경설정에서 \'메일발송 사용\'에 체크하셔야 메일을 발송할 수 있습니다.'));

auth_check($auth[$sub_menu], 'r');

$sql = " select * from {$g5['mail_table']} where ma_id = '$ma_id' ";
$ma = sql_fetch($sql);
if (!$ma['ma_id'])
    alert(_t('보내실 내용을 선택하여 주십시오.'));

// 전체회원수
$sql = " select COUNT(*) as cnt from {$g5['member_table']} ";
$row = sql_fetch($sql);
$tot_cnt = $row['cnt'];

// 탈퇴대기회원수
$sql = " select COUNT(*) as cnt from {$g5['member_table']} where mb_leave_date <> '' ";
$row = sql_fetch($sql);
$finish_cnt = $row['cnt'];

$last_option = explode('||', $ma['ma_last_option']);
for ($i=0; $i<count($last_option); $i++) {
    $option = explode('=', $last_option[$i]);
    // 동적변수
    $var = $option[0];
    $$var = $option[1];
}

if (!isset($mb_id1)) $mb_id1 = 1;
if (!isset($mb_level_from)) $mb_level_from = 1;
if (!isset($mb_level_to)) $mb_level_to = 10;
if (!isset($mb_mailling)) $mb_mailling = 1;

$g5['title'] = _t('회원메일발송');
include_once('./admin.head.php');
?>

<div class="local_ov01 local_ov">
    <?php echo _t('전체회원'); ?> <?php echo number_format($tot_cnt) ?><?php echo _t('명').' , '._t('탈퇴대기회원'); ?> <?php echo number_format($finish_cnt) ?><?php echo _t('명').', '._t('정상회원'); ?> <?php echo number_format($tot_cnt - $finish_cnt) ?><?php echo _t('명').' '._t('중에서 메일 발송 대상 선택'); ?>
</div>

<form name="frmsendmailselectform" id="frmsendmailselectform" action="./mail_select_list.php" method="post" autocomplete="off">
<input type="hidden" name="ma_id" value="<?php echo $ma_id ?>">

<div class="tbl_frm01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> <?php echo _t('대상선택'); ?></caption>
    <tbody>
    <tr>
        <th scope="row"><?php echo _t('회원 ID'); ?></th>
        <td>
            <input type="radio" name="mb_id1" value="1" id="mb_id1_all" <?php echo $mb_id1?"checked":""; ?>> <label for="mb_id1_all"><?php echo _t('전체'); ?></label>
            <input type="radio" name="mb_id1" value="0" id="mb_id1_section" <?php echo !$mb_id1?"checked":""; ?>> <label for="mb_id1_section"><?php echo _t('구간'); ?></label>
            <input type="text" name="mb_id1_from" value="<?php echo $mb_id1_from ?>" id="mb_id1_from" title="<?php echo _t('시작구간'); ?>" class="frm_input"> <?php echo _t('에서'); ?>
            <input type="text" name="mb_id1_to" value="<?php echo $mb_id1_to ?>" id="mb_id1_to" title="<?php echo _t('종료구간'); ?>" class="frm_input"> <?php echo _t('까지'); ?>
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mb_email"><?php echo _t('E-mail'); ?></label></th>
        <td>
            <?php echo help(_t("메일 주소에 단어 포함")." ("._t("예")." : @".preg_replace('#^(www[^\.]*\.){1}#', '', $_SERVER['HTTP_HOST']).")") ?>
            <input type="text" name="mb_email" value="<?php echo $mb_email ?>" id="mb_email" class="frm_input" size="50">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mb_mailling"><?php echo _t('메일링'); ?></label></th>
        <td>
            <select name="mb_mailling" id="mb_mailling">
                <option value="1"><?php echo _t('수신동의한 회원만'); ?>
                <option value=""><?php echo _t('전체'); ?>
            </select>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php echo _t('권한'); ?></th>
        <td>
            <label for="mb_level_from" class="sound_only"><?php echo _t('최소권한'); ?></label>
            <select name="mb_level_from" id="mb_level_from">
            <?php for ($i=1; $i<=10; $i++) { ?>
                <option value="<?php echo $i ?>"><?php echo $i ?></option>
            <?php } ?>
            </select> <?php echo _t('에서'); ?>
            <label for="mb_level_to" class="sound_only"><?php echo _t('최대권한'); ?></label>
            <select name="mb_level_to" id="mb_level_to">
            <?php for ($i=1; $i<=10; $i++) { ?>
                <option value="<?php echo $i ?>"<?php echo $i==10 ? " selected" : ""; ?>><?php echo $i ?></option>
            <?php } ?>
            </select> <?php echo _t('까지'); ?>
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="gr_id"><?php echo _t('게시판그룹회원'); ?></label></th>
        <td>
            <select name="gr_id" id="gr_id">
                <option value=''><?php echo _t('전체'); ?></option>
                <?php
                $sql = " select gr_id, gr_subject from {$g5['group_table']} order by gr_subject ";
                $result = sql_query($sql);
                for ($i=0; $row=sql_fetch_array($result); $i++) {
                    echo '<option value="'.$row['gr_id'].'">'.$row['gr_subject'].'</option>';
                }
                ?>
            </select>
        </td>
    </tr>
    </tbody>
    </table>
</div>

<div class="btn_confirm01 btn_confirm">
    <input type="submit" value="<?php echo _t('확인'); ?>" class="btn_submit">
    <a href="./mail_list.php"><?php echo _t('목록'); ?> </a>
</div>
</form>

<?php
include_once('./admin.tail.php');
?>
