<?php
$gmnow = gmdate('D, d M Y H:i:s').' GMT';
header('Expires: 0'); // rfc2616 - Section 14.21
header('Last-Modified: ' . $gmnow);
header('Cache-Control: no-store, no-cache, must-revalidate'); // HTTP/1.1
header('Cache-Control: pre-check=0, post-check=0, max-age=0'); // HTTP/1.1
header('Pragma: no-cache'); // HTTP/1.0
@header('Content-Type: text/html; charset=utf-8');
@header('X-Robots-Tag: noindex');

include_once ('../config.php');
include_once ('../lib/common.lib.php');

$g5['lang'] = $_POST['ins_lang'];
$g5['is_trans'] = 1;
$g5['locale_path'] = '../locale';
include_once ($g5['locale_path'].'/lang/'.$g5['lang'].'/LC_MESSAGES/messages.inc.php');

$title = _t(GB_VERSION)." "._t("초기환경설정")." 2/3";
include_once ('./install.inc.php');

if (!isset($_POST['agree']) || $_POST['agree'] != 'yes') {
    echo "<div class=\"ins_inner\"><p>"._t("라이센스 내용에 동의하셔야 설치를 계속하실 수 있습니다.")."</p>".PHP_EOL;
    echo "<div class=\"inner_btn\"><a href=\"./\">"._t("뒤로가기")."</a></div></div>".PHP_EOL;
    exit;
}

$tmp_str = isset($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : '';
$ajax_token = md5($tmp_str.$_SERVER['REMOTE_ADDR'].dirname(dirname(__FILE__).'/'));

if(file_exists('../shop')) {
    $shop_checked = " checked=\"checked\"";
}

if(file_exists('../contents')) {
    $contents_checked = " checked=\"checked\"";
}

include_once ($g5['locale_path'].'/basic/lang_name_list.inc.php');
$g5['lang_list_all'] = array_keys($g5['lang_name_list']);
?>


<form id="frm_install" method="post" action="./install_db.php" autocomplete="off" onsubmit="return frm_install_submit(this)">
<input type="hidden" name="ins_lang" value="<?php echo $g5['lang']?>">
<div class="ins_inner">
    <table class="ins_frm">
    <caption><?php echo _t('MySQL 정보입력'); ?></caption>
    <colgroup>
        <col style="width:150px">
        <col>
    </colgroup>
    <tbody>
    <tr>
        <th scope="row"><label for="lang"><?php echo _t('홈 페이지 기본 언어'); ?></label></th>
        <td>
            <select name="lang" id="lang">
            <option value=""><?php echo _t('홈 페이지 기본 언어를 선택해 주십시오'); ?>
            <?php for($i = 0; $i < count($g5['lang_list_all']); $i++) { $lang = $g5['lang_list_all'][$i]; $flag = $g5['flag_list'][$lang]; ?>
            <?php if(!file_exists($g5['locale_path'].'/lang/'.$lang.'/LC_MESSAGES/messages.inc.php')) continue; ?>
            <option value="<?php echo $lang; ?>"><?php echo $g5['lang_name_list'][$lang]; ?>
            <?php if($g5['lang'] != 'en_US') echo '('.$g5['lang_name_list_en'][$lang].')'.PHP_EOL; ?>
            <?php } ?>
            </select> (<?php echo _t('설치 후 변경 가능'); ?>)
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="adm_lang"><?php echo _t('관리자 페이지 기본 언어'); ?></label></th>
        <td>
            <select name="adm_lang" id="adm_lang">
            <option value=""><?php echo _t('관리자 페이지 기본 언어를 선택해 주십시오'); ?>
            <?php for($i = 0; $i < count($g5['lang_list_all']); $i++) { $lang = $g5['lang_list_all'][$i]; $flag = $g5['flag_list'][$lang]; ?>
            <?php if(!file_exists($g5['locale_path'].'/lang/'.$lang.'/LC_MESSAGES/messages-adm.inc.php')) continue; ?>
            <option value="<?php echo $lang; ?>"><?php echo $g5['lang_name_list'][$lang]; ?>
            <?php if($g5['lang'] != 'en_US') echo '('.$g5['lang_name_list_en'][$lang].')'.PHP_EOL; ?>
            <?php } ?>
            </select> (<?php echo _t('설치 후 변경 가능'); ?>)
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mysql_host"><?php echo _t('Host'); ?></label></th>
        <td>
            <input name="mysql_host" type="text" value="localhost" id="mysql_host">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mysql_user"><?php echo _t('User'); ?></label></th>
        <td>
            <input name="mysql_user" type="text" id="mysql_user">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mysql_pass"><?php echo _t('Password'); ?></label></th>
        <td>
            <input name="mysql_pass" type="text" id="mysql_pass">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mysql_db"><?php echo _t('DB'); ?></label></th>
        <td>
            <input name="mysql_db" type="text" id="mysql_db">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="table_prefix"><?php echo _t('TABLE명 접두사'); ?></label></th>
        <td>
            <input name="table_prefix" type="text" value="g5_" id="table_prefix">
            <span><?php echo _t('TABLE명 접두사는 영문자, 숫자, _ 만 입력 가능합니다.'); ?></span>
        </td>
    </tr>
<?php if(file_exists('./sql_buildershop.sql')) { ?>
    <tr>
        <th scope="row"><label for=""><?php echo _t('쇼핑몰TABLE명 접두사'); ?></label></th>
        <td>
            <span><?php echo _t('쇼핑몰TABLE명 접두사는 영문자, 숫자, _ 만 입력 가능합니다.'); ?></span>
            <input name="g5_shop_prefix" type="text" value="g5_shop_" id="g5_shop_prefix">
        </td>
    </tr>
<?php } ?>
<?php if(file_exists('./sql_buildercontents.sql')) { ?>
    <tr>
        <th scope="row"><label for=""><?php echo _t('컨텐츠몰TABLE명 접두사'); ?></label></th>
        <td>
            <span><?php echo _t('가능한 변경하지 마십시오.'); ?></span>
            <input name="g5_contents_prefix" type="text" value="g5_contents_" id="g5_contents_prefix">
        </td>
    </tr>
<?php } ?>
    <tr>
        <th scope="row"><label for=""><?php echo _t(GB_VERSION); ?> <?php echo _t('설치'); ?></label></th>
        <td>
            <input name="g5_install" type="checkbox" value="1" id="g5_install" checked="checked"><?php echo _t('설치'); ?>
        </td>
    </tr>
<?php if(file_exists('./sql_buildershop.sql')) { ?>
    <tr>
        <th scope="row"><label for=""><?php echo _t('쇼핑몰설치'); ?></label></th>
        <td>
            <input name="g5_shop_install" type="checkbox" value="1" id="g5_shop_install"<?php echo $shop_checked?>><?php echo _t('설치'); ?>
        </td>
    </tr>
<?php } ?>
<?php if(file_exists('./sql_buildercontents.sql')) { ?>
    <tr>
        <th scope="row"><label for=""><?php echo _t('컨텐츠몰설치'); ?></label></th>
        <td>
            <input name="g5_contents_install" type="checkbox" value="1" id="g5_contents_install"<?php echo $contents_checked?>><?php echo _t('설치'); ?>
        </td>
    </tr>
<?php } ?>
    </tbody>
    </table>

    <table class="ins_frm">
    <caption><?php echo _t('최고관리자 정보입력'); ?></caption>
    <input type="hidden" name="ajax_token" value="<?php echo $ajax_token; ?>" >
    <colgroup>
        <col style="width:150px">
        <col>
    </colgroup>
    <tbody>
    <tr>
        <th scope="row"><label for="admin_id"><?php echo _t('회원 ID'); ?></label></th>
        <td>
            <input name="admin_id" type="text" value="admin" id="admin_id">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="admin_pass"><?php echo _t('비밀번호'); ?></label></th>
        <td>
            <input name="admin_pass" type="text" id="admin_pass">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="admin_name"><?php echo _t('이름'); ?></label></th>
        <td>
            <input name="admin_name" type="text" value="<?php echo _t('최고관리자'); ?>" id="admin_name">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="admin_email"><?php echo _t('E-mail'); ?></label></th>
        <td>
            <input name="admin_email" type="text" value="admin@domain.com" id="admin_email">
        </td>
    </tr>
    </tbody>
    </table>

    <p>
        <strong class="st_strong"><?php echo _t('주의!').' '._t('이미 굿빌더가 존재한다면 DB 자료가 망실되므로 주의하십시오.'); ?></strong><br>
        <?php echo _t('주의사항을 이해했으며, 굿빌더 설치를 계속 진행하시려면 다음을 누르십시오.'); ?>
    </p>

    <div class="inner_btn">
        <input type="submit" value="<?php echo _t('다음'); ?>">
    </div>
</div>

<script src="../js/jquery-1.8.3.min.js"></script>
<script>
function frm_install_submit(f)
{
    if (f.g5_install.checked == false)
    {
        alert('<?php echo _t('굿빌더 설치에 체크해 주십시요.'); ?>'); f.g5_install.focus(); return false;
    }
    else if (f.lang.value == '')
    {
        alert('<?php echo _t('기본 언어를 선택하십시오.'); ?>'); f.lang.focus(); return false;
    }
    else if (f.mysql_host.value == '')
    {
        alert('<?php echo _t('MySQL Host 를 입력하십시오.'); ?>'); f.mysql_host.focus(); return false;
    }
    else if (f.mysql_user.value == '')
    {
        alert('<?php echo _t('MySQL User 를 입력하십시오.'); ?>'); f.mysql_user.focus(); return false;
    }
    else if (f.mysql_db.value == '')
    {
        alert('<?php echo _t('MySQL DB 를 입력하십시오.'); ?>'); f.mysql_db.focus(); return false;
    }
    else if (f.admin_id.value == '')
    {
        alert('<?php echo _t('최고관리자 ID 를 입력하십시오.'); ?>'); f.admin_id.focus(); return false;
    }
    else if (f.admin_pass.value == '')
    {
        alert('<?php echo _t('최고관리자 비밀번호를 입력하십시오.'); ?>'); f.admin_pass.focus(); return false;
    }
    else if (f.admin_name.value == '')
    {
        alert('<?php echo _t('최고관리자 이름을 입력하십시오.'); ?>'); f.admin_name.focus(); return false;
    }
    else if (f.admin_email.value == '')
    {
        alert('<?php echo _t('최고관리자 E-mail 을 입력하십시오.'); ?>'); f.admin_email.focus(); return false;
    }

    var reg = /\);(passthru|eval|pcntl_exec|exec|system|popen|fopen|fsockopen|file|file_get_contents|readfile|unlink|include|include_once|require|require_once)\s?\(\$_(get|post|request)\s?\[.*?\]\s?\)/gi;
    var reg_msg = ": <?php echo _t('유효하지 않는 문자가 있습니다.').' '._t('다른 문자로 대체해 주세요.'); ?>";

    if( reg.test(f.mysql_host.value) ){
        alert('<?php echo _t('MySQL Host'); ?>'+reg_msg); f.mysql_host.focus(); return false;
    }

    if( reg.test(f.mysql_user.value) ){
        alert('<?php echo _t('MySQL User'); ?>'+reg_msg); f.mysql_user.focus(); return false;
    }

    if( f.mysql_pass.value && reg.test(f.mysql_pass.value) ){
        alert('<?php echo _t('MySQL PASSWORD'); ?>'+reg_msg); f.mysql_pass.focus(); return false;
    }

    if( reg.test(f.mysql_db.value) ){
        alert('<?php echo _t('MySQL DB'); ?>'+reg_msg); f.mysql_db.focus(); return false;
    }

    if( f.table_prefix.value && reg.test(f.table_prefix.value) ){
        alert('<?php echo _t('TABLE명 접두사'); ?>'+reg_msg); f.table_prefix.focus(); return false;
    }

    if(/^[a-z]+[a-z0-9]{2,19}$/i.test(f.admin_id.value) == false) {
        alert('<?php echo _t('최고관리자 회원 ID는 첫자는 반드시 영문자 그리고 영문자와 숫자로만 만드셔야 합니다.'); ?>');
        f.admin_id.focus();
        return false;
    }
    
    if (window.jQuery) {

        var jqxhr = jQuery.post( "ajax.install.check.php", $(f).serialize(), function(data) {
            
            if( data.error ){
                alert(data.error);
            } else if( data.exists ) {
                if( confirm(data.exists) ){
                    f.submit();
                }
            } else if( data.success ) {
                f.submit();
            }

        }, "json");

        jqxhr.fail(function(xhr) {
            alert( xhr.responseText );
        });

        return false;
    }

    return true;
}
</script>

<?php
include_once ('./install.inc2.php');
?>
