<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

//Naver Style
function new_paging($write_pages, $cur_page, $total_page, $url, $add="") {

		if(!$cur_page) $cur_page = 1;
		if(!$total_page) $total_page = 1;

		$str = '';

		if ($cur_page < 2) {
			//$str .= '<a class="direction" title="맨앞페이지"><span>‹‹</span><em>맨앞</em></a>';
		} else {
			$str .= '<a href="'.$url.'1'.$add.'" class="direction" title="맨앞페이지"><span>처음</span></a>';
		}

		$start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
        $end_page = $start_page + $write_pages - 1;

        if ($end_page >= $total_page) { 
			$end_page = $total_page;
		}

        if ($start_page > 1) { 
			$str .= '<a href="'.$url.($start_page-1).$add.'" class="direction" title="이전페이지"><span>이전</span></a>'; 
		} else {
			//$str .= '<a class="direction" title="이전페이지"><span>‹</span><em>이전</em></a>'; 
		}

        if ($total_page > 0){
                for ($k=$start_page;$k<=$end_page;$k++){
                        if ($cur_page != $k) {
		                    $str .= '<a href="'.$url.$k.$add.'">'.$k.'</a>';
                        } else {
	                        $str .= '<strong>'.$k.'</strong> ';
						}
                }
        }

        if ($total_page > $end_page) {
			$str .= '<a href="'.$url.($end_page+1).$add.'" class="direction" title="다음페이지"><span>다음</span></a>';
		} else {
			//$str .= '<a class="direction" title="다음페이지"><em>다음</em><span>›</span></a>';
		}

		if ($cur_page < $total_page) {
			$str .= '<a href="'.$url.($total_page).$add.'" class="direction" title="맨뒤페이지"><span>맨뒤</span></a>';
		} else {
			//$str .= '<a class="direction" title="맨뒤페이지"><em>맨뒤</em><span>››</span></a>';
		}

		return $str;
}

$colspan = 5;

?>

<link rel="stylesheet" href="<?php echo $new_skin_url; ?>/new.css">

<section id="at-new">
	<!-- 전체게시물 검색 시작 -->
	<div id="at-new-form">
		<form name="fnew" method="get">
		<?php echo $group_select ?>
		<select name="view" id="view">
		    <option value="">전체게시물
		    <option value="w">원글만
			<option value="c">댓글만
		</select>
		<input type="text" name="mb_id" value="<?php echo $mb_id ?>" id="mb_id" required placeholder="회원아이디">
	    <button type="submit"><i class="fa fa-search fa-lg"></i></button>
		</form>
		<script>
			document.getElementById("gr_id").value = "<?php echo $gr_id ?>";
		    document.getElementById("view").value = "<?php echo $view ?>";
		</script>
		<!-- } 전체게시물 검색 끝 -->
	</div>

	<!-- 전체게시물 목록 시작 { -->
	<form name="fnewlist" method="post" action="#" onsubmit="return fnew_submit(this);">
	<input type="hidden" name="sw"       value="move">
	<input type="hidden" name="view"     value="<?php echo $view; ?>">
	<input type="hidden" name="sfl"      value="<?php echo $sfl; ?>">
	<input type="hidden" name="stx"      value="<?php echo $stx; ?>">
	<input type="hidden" name="srows"    value="<?php echo $srows; ?>">
	<input type="hidden" name="page"     value="<?php echo $page; ?>">
	<input type="hidden" name="pressed"  value="">

	<?php if(G5_IS_MOBILE) { ?>
		<div class="at-new-head">
	        <?php if ($is_admin) { ?><input type="checkbox" id="all_chk"> <label for="all_chk"">전체선택</label><?php } ?>
		</div>
		<ul>
		<?php
		for ($i=0; $i<count($list); $i++) {
	        $num = $total_count - ($page - 1) * $page_rows - $i;
			$gr_subject = amina_text($list[$i]['gr_subject']);
			$bo_subject = amina_text($list[$i]['bo_subject']);
		    $wr_subject = amina_text($list[$i]['wr_subject']);
			$list[$i]['name'] = $is_sideview ? amina_sideview($list[$i]['mb_id'], $list[$i]['wr_name'], $list[$i]['wr_email'], $list[$i]['wr_homepage']) : $list[$i]['name'];
		?>
		<li>
			<strong>
			<?php if ($is_admin) { ?>
	            <label for="chk_bn_id_<?php echo $i; ?>" class="sound_only"><?php echo $num?>번</label>
		        <input type="checkbox" name="chk_bn_id[]" value="<?php echo $i; ?>">
			    <input type="hidden" name="bo_id[<?php echo $i; ?>]" value="<?php echo $list[$i]['bo_table']; ?>">
	            <input type="hidden" name="wr_id[<?php echo $i; ?>]" value="<?php echo $list[$i]['wr_id']; ?>">
		    <?php } ?>			
			<a href="<?php echo $list[$i]['href'] ?>"><?php echo $list[$i]['comment'] ? '<i class="fa fa-comments"></i> ' : ''; ?><?php echo $wr_subject ?></a>
			
			</strong>
			<p>
			    <i class="fa fa-user"></i> <?php echo $list[$i]['name'] ?>
				&nbsp;&nbsp;
			    <i class="fa fa-tag"></i> <a href="./board.php?bo_table=<?php echo $list[$i]['bo_table'] ?>"><?php echo $bo_subject ?></a>
				&nbsp;&nbsp;
				<i class="fa fa-th-large"></i> <a href="./new.php?gr_id=<?php echo $list[$i]['gr_id'] ?>"><?php echo $gr_subject ?></a>
				&nbsp;&nbsp;
				<i class="fa fa-clock-o"></i> <?php echo $list[$i]['datetime2'] ?>
			</p>
		</li>
		<?php }  ?>

		<?php if ($i == 0)
			echo '<li class="no-list">게시물이 없습니다.</li>';
		?>
		</ul>
	<?php } else { ?>
		<table>
		<thead>
		<tr>
        <?php if ($is_admin) { $colspan = 6; ?>
	        <th scope="col">
		        <label for="all_chk" class="sound_only">목록 전체</label>
	            <input type="checkbox" id="all_chk">
	        </th>
        <?php } ?>
			<th scope="col">그룹</th>
		    <th scope="col">게시판</th>
			<th scope="col">제목</th>
			<th scope="col">이름</th>
			<th scope="col">일시</th>
		</tr>
		</thead>
		<tbody>
		<?php
		for ($i=0; $i<count($list); $i++) {
	        $num = $total_count - ($page - 1) * $page_rows - $i;
			$gr_subject = amina_cut($list[$i]['gr_subject'], 10);
			$bo_subject = amina_cut($list[$i]['bo_subject'], 10);
		    $wr_subject = amina_cut($list[$i]['wr_subject'], 40);
			$list[$i]['name'] = $is_sideview ? amina_sideview($list[$i]['mb_id'], $list[$i]['wr_name'], $list[$i]['wr_email'], $list[$i]['wr_homepage']) : $list[$i]['name'];
		?>
		<tr>
		<?php if ($is_admin) { ?>
	        <td class="td-center">
	            <label for="chk_bn_id_<?php echo $i; ?>" class="sound_only"><?php echo $num?>번</label>
		        <input type="checkbox" name="chk_bn_id[]" value="<?php echo $i; ?>">
			    <input type="hidden" name="bo_id[<?php echo $i; ?>]" value="<?php echo $list[$i]['bo_table']; ?>">
	            <input type="hidden" name="wr_id[<?php echo $i; ?>]" value="<?php echo $list[$i]['wr_id']; ?>">
	        </td>
	    <?php } ?>
			<td class="td-center"><a href="./new.php?gr_id=<?php echo $list[$i]['gr_id'] ?>"><?php echo $gr_subject ?></a></td>
		    <td class="td-center"><a href="./board.php?bo_table=<?php echo $list[$i]['bo_table'] ?>"><?php echo $bo_subject ?></a></td>
			<td class="td-txt"><a href="<?php echo $list[$i]['href'] ?>"><?php echo $list[$i]['comment'] ? '<i class="fa fa-comments"></i> ' : ''; ?><?php echo $wr_subject ?></a></td>
		    <td class="td-center"><b><?php echo $list[$i]['name'] ?></b></td>
			<td class="td-num td-center"><?php echo $list[$i]['datetime2'] ?></td>
		</tr>
		<?php }  ?>

		<?php if ($i == 0)
			echo '<tr><td colspan="'.$colspan.'" class="no-list">게시물이 없습니다.</td></tr>';
		?>
		</tbody>
		</table>
	<?php } ?>

	<?php if ($is_admin) { ?>
		<p><button type="submit" onclick="document.pressed='선택삭제';"><i class="fa fa-times-circle fa-lg"></i> 선택삭제</button></p>
	<?php } ?>
	</form>

	<?php if ($is_admin) { ?>
	<script>
		$(function(){
		    $('#all_chk').click(function(){
			    $('[name="chk_bn_id[]"]').attr('checked', this.checked);
		    });
		});

		function fnew_submit(f) {
		    f.pressed.value = document.pressed;

		    var cnt = 0;
		    for (var i=0; i<f.length; i++) {
			    if (f.elements[i].name == "chk_bn_id[]" && f.elements[i].checked)
		        cnt++;
		    }

		    if (!cnt) {
			    alert(document.pressed+"할 게시물을 하나 이상 선택하세요.");
			    return false;
		    }

		    if (!confirm("선택한 게시물을 정말 "+document.pressed+" 하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다")) {
		        return false;
		    }

		    f.action = "<?php echo AMINA_URL;?>/new_delete.php";

		    return true;
		}
	</script>
	<?php } ?>
	<!-- } 전체게시물 목록 끝 -->

	<div class="paginate">
		<?php echo new_paging($page_rows, $page, $total_page, "?gr_id=$gr_id&view=$view&mb_id=$mb_id&page="); ?>
	</div>

</section>
