<?php
include_once('../common.php');


if (!$member['mb_id']) {
    alert('회원만 이용하실 수 있습니다.', G5_URL);
}

if (!$member['mb_open'] && $is_admin != 'super' && $member['mb_id'] != $mb_id) {
    alert('자신의 정보를 공개하지 않으면 다른분의 정보를 조회할 수 없습니다.\\n\\n정보공개 설정은 회원정보수정에서 하실 수 있습니다.', G5_URL);
}

$mb_id = isset($mb_id) ? $mb_id : '';

$mb = get_member($mb_id);

if (!$mb['mb_id']) {
    alert('회원정보가 존재하지 않습니다.\\n\\n탈퇴하였을 수 있습니다.');
}


if (!$mb['mb_open'] && $is_admin != 'super' && $member['mb_id'] != $mb_id) {
    alert('정보공개를 하지 않았습니다.', G5_URL);
}

$g5['title'] = $mb['mb_nick'].'님의 미니홈';
include_once(G5_BBS_PATH.'/_head.php');

$mb_nick = get_sideview($mb['mb_id'], get_text($mb['mb_nick']), $mb['mb_email'], $mb['mb_homepage'], $mb['mb_open']);

// 회원가입후 몇일째인지? + 1 은 당일을 포함한다는 뜻
$sql = " select (TO_DAYS('".G5_TIME_YMDHIS."') - TO_DAYS('{$mb['mb_datetime']}') + 1) as days ";
$row = sql_fetch($sql);
$mb_reg_after = $row['days'];

$mb_homepage = set_http(get_text(clean_xss_tags($mb['mb_homepage'])));
$mb_profile = $mb['mb_profile'] ? conv_content($mb['mb_profile'],0) : '소개 내용이 없습니다.';
$mb_signature = $mb['mb_signature'] ? conv_content($mb['mb_signature'],0) : '서명이 없습니다.';

// 최신글 함수(전체게시판)
function rb_latest_all($skin_dir='', $subject='', $pf='', $rows=10, $subject_len=40, $sub_table='', $cache_time=1, $options='')
{
    global $g5;

    if (!$skin_dir) $skin_dir = 'basic';
    if(!$options) $options_cache = 'basic'; else $options_cache = $options;
    $options_cache = str_replace(array(" ","'"), array("",""), $options_cache);

    $not_in = ""; 
    if($sub_table!=''){
    	foreach ($sub_table as $key => $val) {
    		$not_in .= "'$val',";
    		$not_cache .= "{$val}";
    	}
    }else{
    	$not_cache = 'basic';
    }
    $not_in .= "'1'";    
    

    if(preg_match('#^theme/(.+)$#', $skin_dir, $match)) {
        if (G5_IS_MOBILE) {
            $latest_skin_path = G5_THEME_MOBILE_PATH.'/'.G5_SKIN_DIR.'/latest/'.$match[1];
            if(!is_dir($latest_skin_path))
                $latest_skin_path = G5_THEME_PATH.'/'.G5_SKIN_DIR.'/latest/'.$match[1];
            $latest_skin_url = str_replace(G5_PATH, G5_URL, $latest_skin_path);
        } else {
            $latest_skin_path = G5_THEME_PATH.'/'.G5_SKIN_DIR.'/latest/'.$match[1];
            $latest_skin_url = str_replace(G5_PATH, G5_URL, $latest_skin_path);
        }
        $skin_dir = $match[1];
    } else {
        if(G5_IS_MOBILE) {
            $latest_skin_path = G5_MOBILE_PATH.'/'.G5_SKIN_DIR.'/latest/'.$skin_dir;
            $latest_skin_url  = G5_MOBILE_URL.'/'.G5_SKIN_DIR.'/latest/'.$skin_dir;
        } else {
            $latest_skin_path = G5_SKIN_PATH.'/latest/'.$skin_dir;
            $latest_skin_url  = G5_SKIN_URL.'/latest/'.$skin_dir;
        }
    }

    $cache_fwrite = false;
    if(G5_USE_CACHE) {
        $cache_file = G5_DATA_PATH."/cache/latest-all-{$skin_dir}-{$rows}-{$subject_len}-{$not_cache}-{$options_cache}-serial.php";

        if(!file_exists($cache_file)) {
            $cache_fwrite = true;
        } else {
            if($cache_time > 0) {
                $filetime = filemtime($cache_file);
                if($filetime && $filetime < (G5_SERVER_TIME - 3600 * $cache_time)) {
                    @unlink($cache_file);
                    $cache_fwrite = true;
                }
            }
            
            if(!$cache_fwrite) {
                try{
                    $file_contents = file_get_contents($cache_file);
                    $file_ex = explode("\n\n", $file_contents);
                    $caches = unserialize(base64_decode($file_ex[1]));

                    $list = (is_array($caches) && isset($caches['list'])) ? $caches['list'] : array();
                    $bo_table = (is_array($caches) && isset($caches['bo_table'])) ? $caches['bo_table'] : 'free';
                } catch(Exception $e){
                    $cache_fwrite = true;
                    $list = array();
                }
            }
        }
    }

    if(!G5_USE_CACHE || $cache_fwrite) {
    	
        $list = array();
        $board = array();
		$sql = " select * from {$g5['board_table']} where bo_table not in({$not_in})";
		$bo = sql_query($sql);
		
		$sql = " select * from (";
		$brow = sql_fetch_array($bo);
			
		$board[$brow['bo_table']] = $brow; 
		
		$sql_union .= "
					select
						*,
						'{$brow['bo_subject']}' bo_subject,
						'{$brow['bo_table']}' bo_table
					from {$g5['write_prefix']}{$brow['bo_table']}";
		
		for ($i=0; $brow = sql_fetch_array($bo); $i++) {
			$board[$brow['bo_table']] = $brow;
			$sql_union .= "
						union all
						select 
							*, 
							'{$brow['bo_subject']}' bo_subject, 
							'{$brow['bo_table']}' bo_table 
						from {$g5['write_prefix']}{$brow['bo_table']}";
		}
		
		$sql .= "{$sql_union}) X where mb_id = '{$options}' and wr_is_comment = 0 order by wr_datetime desc limit 0, {$rows}";
        $result = sql_query($sql);
        
		for ($i=0; $row = sql_fetch_array($result); $i++) {
            try {
                unset($row['wr_password']);     //패스워드 저장 안함( 아예 삭제 )
            } catch (Exception $e) {
            }
            
            $row['wr_email'] = '';              //이메일 저장 안함
            if (strstr($row['wr_option'], 'secret')){           // 비밀글일 경우 내용, 링크, 파일 저장 안함
                $row['wr_content'] = $row['wr_link1'] = $row['wr_link2'] = '';
                $row['file'] = array('count'=>0);
            }
            $row['wr_subject'] = "<span>".$row['bo_subject']."</span>".$row['wr_subject'];

            if($i==0) $bo_table = $row['bo_table'];
            	
            $list[$i] = get_list($row, $board[$row['bo_table']], $latest_skin_url, $subject_len);
        }

        if($cache_fwrite) {
            $handle = fopen($cache_file, 'w');
            $caches = array(
                'list' => $list,
                'bo_subject' => sql_escape_string($bo_subject),
            	'bo_table' => sql_escape_string($bo_table),
                );
            $cache_content = "<?php if (!defined('_GNUBOARD_')) exit; ?>\n\n";
            $cache_content .= base64_encode(serialize($caches));  //serialize

            fwrite($handle, $cache_content);
            fclose($handle);

            @chmod($cache_file, 0640);
        }
    }

       
    ob_start();
    include $latest_skin_path.'/latest.skin.php';
    $content = ob_get_contents();
    ob_end_clean();
    
    return $content;

}
include_once($member_skin_path.'/home.skin.php');

include_once(G5_BBS_PATH.'/_tail.php');
